package com.thebeastshop.pegasus.channelservice.adapter;

import javax.annotation.Resource;

import com.thebeastshop.commdata.service.CommAddressService;
import com.thebeastshop.commdata.vo.CommDistrictVO;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.thebeastshop.member.service.point.MemberPointService;
import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.member.vo.point.MemberPointVO;
import com.thebeastshop.pegasus.channelservice.vo.member.MemberProfileVO;
import com.thebeastshop.pegasus.channelservice.vo.member.MemberQueryVO;

@Service("weixinMemberAdapter")
public class MemberAdapter {
	@Resource
    private MemberPointService memberPointService;

	@Autowired
	CommAddressService commAddressService;

	/***
	 * 通用用户转换成官网接口
	 * @param opMemberVO
	 * @return
	 */
	public MemberQueryVO common2website(MemberVO opMemberVO){
		return common2website(opMemberVO, null);
	}
	
	/***
	 * 通用用户转换成官网接口
	 * @param opMemberVO
	 * @param loginType
	 * @return
	 */
	public MemberQueryVO common2website(MemberVO opMemberVO, Integer loginType){
		MemberPointVO memberPointVO = memberPointService.getMemberPointVO(opMemberVO.getId(), opMemberVO.getCode());
		MemberQueryVO memberVO=new MemberQueryVO();
		memberVO.setAvatar(opMemberVO.getAvatarUrl());
		memberVO.setConstellation(opMemberVO.getConstellation());
		memberVO.setCustLevel(opMemberVO.getMemberLevel());
		memberVO.setDegree(opMemberVO.getDegree());
		memberVO.setEmail(opMemberVO.getEmail());
		memberVO.setIdentityType(loginType);
		memberVO.setMagentoPhone(opMemberVO.getPhone());
		memberVO.setPoint(memberPointVO.getCommonMemberPointValid().doubleValue());
		memberVO.setHistoryPoint(memberPointVO.getExpirelevelMemberPoint().doubleValue());
		memberVO.setMobile(opMemberVO.getMobile());
		memberVO.setMemberId(opMemberVO.getId());
		memberVO.setProfession(opMemberVO.getJob());
		memberVO.setWeibo(opMemberVO.getAccountWeibo());
		memberVO.setWeixin(opMemberVO.getAccountWechat());
		MemberProfileVO profile=new MemberProfileVO();
		if(opMemberVO.getDistrictId()!=null&&opMemberVO.getDistrictId()>0){
			CommDistrictVO commonDistrict=commAddressService.findDistrictById(opMemberVO.getDistrictId().intValue());
			if(commonDistrict!=null){
				//FULL_NAME 全名，国家-省-市-区
			  String fullName=	commonDistrict.getFullName();
			  if(StringUtils.isNotBlank(fullName)){
				String []names=  fullName.split("-");
				if(names!=null&&names.length==4){
					profile.setProvince(names[1]);
					profile.setCity(names[2]);
					profile.setDistrict(names[3]);
				}
			  }
			}
		}
		profile.setName(opMemberVO.getNickName());
		profile.setStreet(opMemberVO.getAddress());
		profile.setTitle(opMemberVO.getTitle());
		profile.setZip(opMemberVO.getZipCode());
		profile.setBirthday(opMemberVO.getBirthday());
		memberVO.setProfile(profile);
		memberVO.setMemberCode(opMemberVO.getCode());
		memberVO.setNickName(opMemberVO.getNickName());
		return memberVO;
	}
}
