package com.thebeastshop.pegasus.channelservice.adapter;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import com.thebeastshop.wms.constant.PegasusConstants;
import com.thebeastshop.wms.sservice.SWhInvService;
import com.thebeastshop.wms.vo.WhWarehouseVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.thebeastshop.campaign.enums.DiscountTypeEnum;
import com.thebeastshop.commdata.service.ChannelQueryService;
import com.thebeastshop.commdata.vo.ChannelWarehouseVO;
import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.pegasus.channelservice.util.CampaignUtils;
import com.thebeastshop.pegasus.channelservice.vo.item.SyncItemDesc;
import com.thebeastshop.pegasus.channelservice.vo.item.SyncItemImage;
import com.thebeastshop.pegasus.channelservice.vo.item.SyncItemSubProd;
import com.thebeastshop.pegasus.channelservice.vo.item.SyncItemVO;
import com.thebeastshop.pegasus.merchandise.cond.PsProductCond;
import com.thebeastshop.pegasus.merchandise.service.McOpChannelService;
import com.thebeastshop.pegasus.merchandise.service.McPsProductService;
import com.thebeastshop.pegasus.merchandise.service.McPsSkuService;
import com.thebeastshop.pegasus.merchandise.service.McPsSpvService;
import com.thebeastshop.pegasus.merchandise.vo.OpChannelVO;
import com.thebeastshop.pegasus.merchandise.vo.PsCampaignVO;
import com.thebeastshop.pegasus.merchandise.vo.PsDynmContentVO;
import com.thebeastshop.pegasus.merchandise.vo.PsProductVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSkuCombinationVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSkuVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSpvVO;
import com.thebeastshop.pegasus.service.operation.PegasusChannelServiceFacade;
import com.thebeastshop.pegasus.service.operation.model.OpProduct;
import com.thebeastshop.pegasus.service.operation.model.OpSalesOrder;
import com.thebeastshop.pegasus.service.operation.model.OpSoPackageSku;


import com.thebeastshop.price.vo.PrsCampaignLimitVO;
import com.thebeastshop.price.vo.PrsProductPriceResultVO;
import com.thebeastshop.price.vo.PrsProductVO;
import com.thebeastshop.price.vo.PrsSkuVO;
import com.thebeastshop.price.vo.PrsSpvPriceResultVO;
import com.thebeastshop.price.vo.PrsSpvVO;
import com.thebeastshop.stock.service.SStockService;
import com.thebeastshop.stock.vo.SSkuStockVO;
import com.thebeastshop.support.vo.stock.StoreStockVO;

@Service("CommonItemAdpter")
public class ItemAdpter {
	private PegasusChannelServiceFacade pcInstance = PegasusChannelServiceFacade.getInstance();

	@Autowired
	private McPsProductService mcPsProductService;
	@Autowired
	private McPsSkuService mcPsSkuService;
	@Autowired
	private SStockService sStockService;
	@Autowired
	private McOpChannelService mcOpChannelService;
	@Autowired
	private ChannelQueryService channelQueryService;
	@Autowired
	private McPsSpvService mcPsSpvService;
	@Autowired
	private SWhInvService pwInstance;

	public String imageUrl(String imageUrl) {
		String url = imageUrl;
		if (!StringUtils.isBlank(imageUrl)) {

			if (imageUrl.indexOf("http://") >= 0) {
				url = imageUrl;
			} else {
				// url="http://oss.thebeastshop.com/"+imageUrl;
				url = "http://img.thebeastshop.com/" + imageUrl;
			}

		}

		return url;
	}

	/***
	 * 多张图片url，合并成一张url。使用逗号分隔
	 *
	 * @param imageUrls
	 * @return
	 */
	public String imageUrlString(List<String> imageUrls) {
		if (CollectionUtils.isEmpty(imageUrls)) {
			return null;
		}
		StringBuilder sb = new StringBuilder();
		for (String imageUrl : imageUrls) {
			if (imageUrl.indexOf("http://") >= 0) {
				sb.append(imageUrl).append(",");
			} else {
				// sb.append("http://oss.thebeastshop.com/"+imageUrl).append(",");
				sb.append("http://img.thebeastshop.com/" + imageUrl).append(",");
			}
		}

		return sb.toString();
	}

	/**
	 * 获取渠道可售prod的 可售skus 的 价格区间
	 *
	 * @param productVO
	 * @param chnCode
	 * @return 返回的list，list[0]--min,list[1]--max，如果为空，就代表这个prod下，没有sku（或者可售）
	 */
	public List<Double> findMinMaxListPriceFromProd(final PsProductVO productVO, final String chnCode) {
		List<String> skuCodes;
		if (StringUtils.isBlank(chnCode)) {
			skuCodes = productVO.getSkuCodes();
		} else {
			skuCodes = productVO.getCanSaleSku(chnCode);
		}
		final List<PsSkuVO> skuVOs = mcPsSkuService.findBySkuCodes(skuCodes);
		if (CollectionUtils.isEmpty(skuVOs)) {
			return Collections.emptyList();
		}
		Double min = skuVOs.get(0).getSalesPrice();
		Double max = skuVOs.get(0).getSalesPrice();
		for (final PsSkuVO skuVO : skuVOs) {
			if (min > skuVO.getSalesPrice()) {
				min = skuVO.getSalesPrice();
			}
			if (max < skuVO.getSalesPrice()) {
				max = skuVO.getSalesPrice();
			}
		}

		return Arrays.asList(min, max);
	}

	/***
	 * 官网商品同步接口
	 *
	 * @param psProductVOs
	 * @param channelCode
	 * @return 如果product对应的sku只有一个，则sku没有父sku，如果有多个。则有根据product，封装一个父的sku
	 */
	public List<SyncItemVO> common2item(List<PsProductVO> psProductVOs, String channelCode) {
		List<SyncItemVO> items = new ArrayList<SyncItemVO>();
		for (PsProductVO product : psProductVOs) {
			List<String> allSkuCodes = product.getSkuCodes();
			if (CollectionUtils.isNotEmpty(allSkuCodes)) {
				// 如果只有一个sku，则没有父sku，否则，封装一个父的sku
				if (allSkuCodes.size() == 1) {
					String skuCode = allSkuCodes.get(0);
					PsSkuVO skuVO = mcPsSkuService.findBySkuCode(skuCode);
					if (skuVO != null) {
						SyncItemVO item = subItem(product, skuVO, false, channelCode);
						// 设置手机端多张大图
						item.setWapDetailImages(imageUrlString(product.getPicDetailMuls()));
						items.add(item);
					}
				} else {
					// 有多个sku，即有子商品。需要根据product，封装一个父sku
					SyncItemVO parentItem = new SyncItemVO();
					parentItem.setDefaultCode(product.getCode());// parent
																	// sku的code就是新系统的product的code
					parentItem.setDeliveryCityIds(null);// 指定自送的配送城市 ,目前官网子维护
					parentItem.setDeliveryDates(null);// 指定配送天数，暂时不处理
					parentItem.setId(Long.valueOf(product.getId()));// 父sku的ID，对应product的ID
					parentItem.setImages(itemImages(product));// 设置父商品的图片。子商品图片为null
					// 网站单独不可见。 1可见。0 不可见. 父商品根据product设置，子商品默认都不可见
					/*
					 * if(CollectionUtils.isNotEmpty(product.getCanSeeSku(
					 * channelCode))&&product.getCanSeeSku(channelCode).contains
					 * (product.getCode())){ parentItem.setInvisible_on_web(1);
					 * }else{ parentItem.setInvisible_on_web(0); }
					 */
					parentItem.setInvisibleOnWeb(1);// 父sku默认可见
					parentItem.setIsFlower(0);// 官网弃用
					// 设置最大价格 只有包含多个sku的product才有价格区间
					List<Double> priceList = findMinMaxListPriceFromProd(product, channelCode);
					if (CollectionUtils.isNotEmpty(priceList)) {
						parentItem.setListPrice(priceList.get(0));
						parentItem.setMaxPrice(priceList.get(1));
						product.setListPrice(BigDecimal.valueOf(priceList.get(0)));// 将product的listprice，设置为最低价
					} else {
						parentItem.setListPrice(product.getListPrice().doubleValue());// 列表价格
					}
					parentItem.setProductZhName(product.getNameCn());// 中文名称
					parentItem.setProductEnName(product.getName());
					parentItem.setPickScope(getPickScope(product.getExpressType()));// 配送方式
					// parentItem.setPoint_change_enable(0);//是否可以使用积分
					// 积分抵扣规则，0不可抵扣1部分抵扣2全部抵扣 product不支持积分设置
					parentItem.setProdBrand(null);// 品牌信息,product 默认取第一个sku的品牌信息
					parentItem.setProductDescription(itemDesc(product));// 商品描述
					parentItem.setProductEnName(product.getName());// 英文名称
					parentItem.setRelatedProdIds(null);// 关联商品，暂时不处理
					parentItem.setRemarkEnable(1);// 是否可备注。在sku上。
													// product默认设置为不可备注 //
													// 官网销售时是否可以备注，0表示可以，1表示不可以
					parentItem.setSaleOk(getSaleOK(product, null, channelCode));// 是否上架
																				// 官网0是正常。1是下架
					parentItem.setShopIds(shopIds(product, channelCode));// 获取销售渠道
					parentItem.setSubProds(subprods(product));// 设置关联的子商品信息
					parentItem.setSubstituteProd(-1l);// 单个商品的。无parentId,默认为-1
					parentItem.setSubstituteType(product.getSkuCategoryDesc());// 关联的子商品的类型

					// parentItem.setSubstituteName(null);//子商品的具体“型号”值
					// 该产品是否可以VIP打折,官网 0表示可以打折,1表示不可以打折
					if (product.getAllowVipDiscount() == PegasusConstants.YES) {
						parentItem.setVipEnable(0);
						parentItem.setVipPrice(getLevelPrice(product.getListPrice(), 1).doubleValue());// vip价格
						parentItem.setVvipPrice(getLevelPrice(product.getListPrice(), 2).doubleValue());// vvip价格
					} else {
						parentItem.setVipEnable(1);
						parentItem.setVipPrice(product.getListPrice().doubleValue());// vip价格
						parentItem.setVvipPrice(product.getListPrice().doubleValue());// vvip价格
					}
					parentItem.setCategoryId(product.getCategoryId());

					// 封装子商品
					for (String skuCode : allSkuCodes) {
						PsSkuVO skuVO = mcPsSkuService.findBySkuCode(skuCode);
						if (skuVO != null) {
							SyncItemVO item = subItem(product, skuVO, true, channelCode);
							item.setSubstituteProd(parentItem.getId());
							items.add(item);
							// 设置父商品的品牌信息。取第一个sku的品牌信息
							if (skuCode.equals(allSkuCodes.get(0))) {
								parentItem.setProdBrand(getProdbrand(skuVO));
								parentItem.setCrossBorderFlag(skuVO.getCrossBorderFlag());// 是否跨境商品
								parentItem.setPlaceOfOrigin(skuVO.getPlaceOfOrigin());// 产地
								// 标签
								if (!CollectionUtils.isEmpty(skuVO.getSmallIconList())) {
									String listIcon = "";
									for (String icon : skuVO.getSmallIconList()) {

										listIcon += icon + ",";
									}
									parentItem.setListIcon(listIcon);
								}
								if (!CollectionUtils.isEmpty(skuVO.getLargeIconList())) {
									String detailIcon = "";
									for (String icon : skuVO.getLargeIconList()) {

										detailIcon += icon + ",";
									}
									parentItem.setDetailIcon(detailIcon);
								}
							}
						}
					}
					// 设置手机端多张大图
					parentItem.setWapDetailImages(imageUrlString(product.getPicDetailMuls()));
					items.add(parentItem);
				}
			}
		}
		return items;
	}

	/***
	 * //根据sku，封装item,只封装子sku和无父sku的商品
	 *
	 * @param product
	 * @param skuVO
	 * @param multiple
	 * @param channelCode
	 * @return
	 */
	private SyncItemVO subItem(PsProductVO product, PsSkuVO skuVO, boolean multiple, String channelCode) {
		SyncItemVO item = new SyncItemVO();
		item.setDefaultCode(skuVO.getSkuCode());// skuCode
		item.setDeliveryCityIds(null);// 指定自送城市,目前默认不处理
		item.setDeliveryDates(null);// 指定配送天数 目前默认不处理
		item.setId(skuVO.getSkuId());// id
		item.setCrossBorderFlag(skuVO.getCrossBorderFlag());// 设置是否跨境通
		item.setPlaceOfOrigin(skuVO.getPlaceOfOrigin());// 产地
		// if(!multiple){//子商品无需设置图片
		item.setImages(itemImages(product));// 设置图片
		// }

		// 标签
		if (!CollectionUtils.isEmpty(skuVO.getSmallIconList())) {
			String listIcon = "";
			for (String icon : skuVO.getSmallIconList()) {

				listIcon += icon + ",";
			}
			item.setListIcon(listIcon);
		}
		if (!CollectionUtils.isEmpty(skuVO.getLargeIconList())) {
			String detailIcon = "";
			for (String icon : skuVO.getLargeIconList()) {

				detailIcon += icon + ",";
			}
			item.setDetailIcon(detailIcon);
		}
		// 网站单独不可见。 1可见。0 不可见
		// 如果是子商品。直接设为不可见
		if (multiple) {
			item.setInvisibleOnWeb(0);
		} else {
			if (CollectionUtils.isNotEmpty(product.getCanSeeSku(channelCode))
					&& product.getCanSeeSku(channelCode).contains(skuVO.getSkuCode())) {
				item.setInvisibleOnWeb(1);
			} else {
				item.setInvisibleOnWeb(0);
			}
		}
		item.setIsFlower(0);// 官网不不处理，字段作废
		item.setListPrice(skuVO.getSalesPrice());// 列表价,对外展示的价格
		item.setProductZhName(product.getNameCn());// 中文名称
		item.setProductEnName(product.getName());// 英文名称
		item.setPickScope(getPickScope(product.getExpressType()));// 根据快递方式，获取配送方式
		// 是否可以使用积分 积分抵扣规则，0不可抵扣1部分抵扣2全部抵扣
		item.setPointChangeEnable(skuVO.getPointDeductRule());// 积分兑换规则,官网已经修改boolean
																// 为 Integer
		item.setPointPrice(skuVO.getPointDuductPrice().doubleValue());// 积分价格
		item.setPointValue(skuVO.getPointDeductRule().doubleValue());// 积分分值
		item.setProdBrand(getProdbrand(skuVO));// 获取品牌信息
		if (!multiple) {
			item.setProductDescription(itemDesc(product));// 获取商品描述
		}
		item.setRelatedProdIds(null);// 关联产品。目前没有维护
		// 销售时是否可以备注，官网0表示可以，1表示不可以
		if (PegasusConstants.YES == skuVO.getCanRemark()) {
			item.setRemarkEnable(0);
		} else {
			item.setRemarkEnable(1);
		}
		item.setSaleOk(getSaleOK(product, skuVO, channelCode));// 是否下架
																// 官网0是正常。1是下架
		item.setShopIds(shopIds(product, channelCode));// shopIds，官网固定设置为18
		item.setSubProds(null);// 非父SKu无子商品
		item.setSubstituteProd(-1l);// 单个商品的。无parentId,默认为-1
		item.setSubstituteType(null);// 单个商品或子商品。无需设置子类型
		// 当为子商品的时候，设置子商品的型号值
		if (multiple) {
			item.setSubstituteName(skuVO.getSkuCateName());// 子商品的具体“型号”值
		}
		// 该产品是否可以VIP打折,官网 0表示可以打折,1表示不可以打折
		if (product.getAllowVipDiscount() == PegasusConstants.YES) {
			item.setVipEnable(0);
			item.setVipPrice(getLevelPrice(BigDecimal.valueOf(skuVO.getSalesPrice()), 1).doubleValue());// vip价格
			item.setVvipPrice(getLevelPrice(BigDecimal.valueOf(skuVO.getSalesPrice()), 2).doubleValue());// vvip价格
		} else {
			item.setVipEnable(1);
			item.setVipPrice(skuVO.getSalesPrice());// vip价格
			item.setVvipPrice(skuVO.getSalesPrice());// vvip价格
		}

		// 添加商品分类
		item.setCategoryId(skuVO.getCategoryId());
		item.setSkuEnName(skuVO.getSkuName());
		item.setSkuZhName(skuVO.getSkuNameCN());
		// item.setCategoryName(skuVO.getCategoryName());
		return item;
	}

	/**
	 * 根据等级取得相应的折扣
	 * @param price
	 * @param leavl
	 * @return BigDecimal
	 */
	public static BigDecimal getLevelPrice(BigDecimal price, int leavl) {

		BigDecimal discountPrice=price;
		if (discountPrice == null) {

			return new BigDecimal(0);
		}

		// vip
		if (leavl == 1) {
			discountPrice= price.multiply(new BigDecimal(0.95));
			// vvip
		} else if (leavl == 2 || leavl==3) {

			discountPrice= price.multiply(new BigDecimal(0.9));
		}
		discountPrice=discountPrice.setScale(2, RoundingMode.HALF_UP);
		return discountPrice;
	}

	/***
	 * 设置商品图片- 列表图，缩略图，详情图
	 *
	 * @param psProductVO
	 * @return
	 */
	private List<SyncItemImage> itemImages(PsProductVO psProductVO) {
		// 产品图片
		List<SyncItemImage> images = new ArrayList<SyncItemImage>();
		// 网站列表图片
		SyncItemImage itemImage = new SyncItemImage();
		itemImage.setCode("NEW_SITE_LIST_IMG");
		itemImage.setFullUrl(imageUrl(psProductVO.getPicList()));
		images.add(itemImage);
		// 网站详情大图
		itemImage = new SyncItemImage();
		itemImage.setCode("NEW_SITE_CONTENT_IMG");
		itemImage.setFullUrl(imageUrl(psProductVO.getPicDetail()));
		images.add(itemImage);
		// 网站推荐商品图
		itemImage = new SyncItemImage();
		itemImage.setCode("NEW_SITE_RECOMMEND_IMG");
		itemImage.setFullUrl(imageUrl(psProductVO.getPicThumb()));
		images.add(itemImage);
		return images;
	}

	/***
	 * 获取支持的配送方式
	 *
	 * @param deliveryType
	 * @return
	 */
	private String getPickScope(Integer deliveryType) {
		if (OpProduct.EP_TYPE_SELF == deliveryType) {
			return "SELF";
		} else if (OpProduct.EP_TYPE_FED == deliveryType) {
			return "FEDEX24";
		}
		return null;
	}

	/***
	 * 获取品牌信息
	 *
	 * @param skuVO
	 * @return
	 */
	private String[] getProdbrand(PsSkuVO skuVO) {
		String[] prod_brand = new String[2];
		if (skuVO.getBrandId() != null && StringUtils.isNotBlank(skuVO.getBrandNameCN())) {
			prod_brand[0] = String.valueOf(skuVO.getBrandId());
			prod_brand[1] = skuVO.getBrandNameCN();
			return prod_brand;
		}

		return null;
	}

	/***
	 * 获取商品描述
	 *
	 * @param psProductVO
	 * @return
	 */
	private List<SyncItemDesc> itemDesc(PsProductVO psProductVO) {

		List<PsDynmContentVO> listDynmContent = psProductVO.getDynmContents();

		if (CollectionUtils.isNotEmpty(listDynmContent)) {
			List<SyncItemDesc> product_description = new ArrayList<SyncItemDesc>();
			for (PsDynmContentVO entity : listDynmContent) {
				SyncItemDesc itemDescVO = new SyncItemDesc();
				// 描述内容
				itemDescVO.setContent(entity.getContent());
				// 描述类型名称
				itemDescVO.setNameEn(entity.getTitleEn());
				// 描述类型英文名称
				itemDescVO.setNameZn(entity.getTitleCn());
				// 排序
				itemDescVO.setOrder(entity.getSort());
				// 描述类型对应的magento的字段
				itemDescVO.setMagentoField(entity.getContentType());

				product_description.add(itemDescVO);
			}

			return product_description;
		}
		return null;
	}

	/***
	 * 获取saleOK,官网0是正常。1是下架
	 *
	 * @param psProductVO
	 * @param channelCode
	 * @return
	 */
	private int getSaleOK(PsProductVO psProductVO, PsSkuVO skuVO, String channelCode) {
		List<String> onShelfChnCodes = psProductVO.getOnShelfChnCodes();
		if (CollectionUtils.isEmpty(onShelfChnCodes)) {
			return 1;// 不在上架渠道列表
		}
		if (CollectionUtils.isNotEmpty(onShelfChnCodes)) {
			if (skuVO == null) {
				if (!onShelfChnCodes.contains(channelCode)) {
					return 1;
				}
			} else {
				if (!onShelfChnCodes.contains(channelCode)
						|| !psProductVO.getCanSaleSku(channelCode).contains(skuVO.getSkuCode())) {
					return 1;
				}
			}

		}
		return 0;
	}

	/***
	 * 获取shopids，如果是官网可售，返回18
	 *
	 * @param psProductVO
	 * @param channelCode
	 * @return
	 */
	private String[] shopIds(PsProductVO psProductVO, String channelCode) {

		List<String> channelCodes = psProductVO.getChnSaleChnCodes();

		if (CollectionUtils.isNotEmpty(channelCodes)) {

			// 如果不是官网渠道直接把渠道编码返回
			if (!"CHN2018".equals(channelCode)) {
				String[] array = new String[channelCodes.size()];

				return channelCodes.toArray(array);
			} else {
				return new String[] { "18" };
			}

		}

		return null;

	}

	/***
	 * 封装父商品关联的子商品
	 *
	 * @param product
	 * @return
	 */
	private List<SyncItemSubProd> subprods(PsProductVO product) {
		List<String> skuCodes = product.getSkuCodes();
		if (CollectionUtils.isNotEmpty(skuCodes)) {
			List<SyncItemSubProd> sub_prods = new ArrayList<SyncItemSubProd>();
			for (String skuCode : skuCodes) {
				PsSkuVO skuVO = mcPsSkuService.findBySkuCode(skuCode);
				if (skuVO != null) {
					SyncItemSubProd subProd = new SyncItemSubProd();
					subProd.setProductTmplId(Long.valueOf(skuVO.getSkuId()));
					subProd.setId(Long.valueOf(skuVO.getSkuId()));
					subProd.setDefaultCode(skuVO.getSkuCode());
					subProd.setSubstituteName(skuVO.getSkuCateName());
					sub_prods.add(subProd);
				}
			}
			return sub_prods;
		}

		return null;
	}

	/**
	 * 根据订单号取得所有prod
	 *
	 * @param orderCode
	 * @return
	 */
	public List<String> getProductCodes(String orderCode, String channelCode) {

		List<String> prods = new ArrayList<>();
		OpSalesOrder order = pcInstance.getOrderByCode(orderCode, channelCode);
		if (order == null) {
			return prods;
		}

		// 取出所有sku
		List<OpSoPackageSku> skus = pcInstance.getSkusByOrderId(order.getId());

		if (CollectionUtils.isNotEmpty(skus)) {
			// 遍历sku,取出prodcode
			for (OpSoPackageSku sku : skus) {

				if (sku.getProductId() == null) {
					PsProductVO productVO = mcPsProductService.findProdBySkuCode(sku.getSkuCode());
					prods.add(productVO.getCode());
				} else {
					PsProductCond cond = new PsProductCond();
					cond.setChannelCode(channelCode);
					cond.setId(String.valueOf(sku.getProductId()));
					List<PsProductVO> productVOs = mcPsProductService.findByCond(cond);
					if (CollectionUtils.isNotEmpty(productVOs)) {
						PsProductVO productVO = productVOs.get(0);
						prods.add(productVO.getCode());
					}
				}

			}

		}
		return prods;
	}

	/**
	 * 获取SPV线下所有渠道库存
	 * 
	 * @Methods Name getOffLineSpvAlltock
	 * @Create In 2018-2-6 By Xiang.Gao
	 * @param spvId
	 * @param channelCode
	 * @return List<StoreStockVO>
	 */
	/*public List<StoreStockVO> getOffLineSpvAlltock(Long spvId, String channelCode) {
		List<StoreStockVO> list = Lists.newArrayList();
		PsSpvVO psSpvVO = mcPsSpvService.findBySpvId(spvId);
		if (psSpvVO == null) {
			return list;
		}
		List<OpChannelVO> channelVOs = mcOpChannelService.getIPOSChannels();
		if (CollectionUtils.isEmpty(channelVOs)) {
			return list;
		}
		// 关联仓
		List<ChannelWarehouseVO> channelWarehouseList = channelQueryService.getWarehouseByCode(channelCode);
		Map<String, WhWarehouseVO> warehouseMap = Maps.newHashMap();
		if (CollectionUtils.isNotEmpty(channelWarehouseList)) {
			List<String> warehouseCodes = Lists.newArrayList();
			for (ChannelWarehouseVO channelWarehouse : channelWarehouseList) {
				warehouseCodes.add(channelWarehouse.getCode());
			}
			warehouseMap = pwInstance.findWarehouseMapByCodes(warehouseCodes);
		}
		// 非组合商品
		if (CollectionUtils.isEmpty(psSpvVO.getSkuCombinationList())) {
			Map<String, SSkuStockVO> stockMap = sStockService.getSkuStocksInAllWarehouses(psSpvVO.getSkuCode());
			if (stockMap == null) {
				return list;
			}
			// 线下配送仓库存
			for (ChannelWarehouseVO channelWarehouse : channelWarehouseList) {
				String warehouseCode = channelWarehouse.getCode();
				WhWarehouseVO warehouse = warehouseMap.get(warehouseCode);
				SSkuStockVO skuStock = stockMap.get(warehouseCode);
				if (skuStock == null || warehouse == null || skuStock.getCanUseQuantity() == null
						|| skuStock.getCanUseQuantity() < 1) {
					continue;
				}
				list.add(new StoreStockVO(channelCode, warehouse.getName(), skuStock.getCanUseQuantity()));
			}
			// 添加渠道库存
			for (OpChannelVO opChannelVO : channelVOs) {
				String warehouseCode = opChannelVO.getWarehouseForSales();
				SSkuStockVO skuStock = stockMap.get(warehouseCode);
				if (skuStock == null || skuStock.getCanUseQuantity() == null || skuStock.getCanUseQuantity() < 1) {
					continue;
				}
				if (opChannelVO.getCode().equals(channelCode)) {
					list.add(0, new StoreStockVO(opChannelVO.getCode(), opChannelVO.getName(),
							skuStock.getCanUseQuantity()));
				} else {
					list.add(new StoreStockVO(opChannelVO.getCode(), opChannelVO.getName(),
							skuStock.getCanUseQuantity()));
				}
			}
			// 组合商品
		} else {
			// 获取spv 下skuCode集合
			List<PsSkuCombinationVO> combinationList = psSpvVO.getSkuCombinationList();
			List<String> skuCodes = Lists.newArrayList();
			for (PsSkuCombinationVO psSkuCombination : combinationList) {
				skuCodes.add(psSkuCombination.getSubSkuCode());
			}
			// 查询SKU库存
			Map<String, Map<String, SSkuStockVO>> skuStockMap = sStockService.getSkuStocksInAllWarehouses(skuCodes);
			if (skuStockMap == null) {
				return list;
			}
			// 线下配送仓库存
			for (ChannelWarehouseVO warehouseVO : channelWarehouseList) {
				String warehouseCode = warehouseVO.getCode();
				int spvMinStockNum = getCanCombinationNum(combinationList, warehouseCode, skuStockMap);
				if (spvMinStockNum != 0) {
					WhWarehouseVO warehouse = warehouseMap.get(warehouseCode);
					list.add(new StoreStockVO(channelCode, warehouse.getName(), spvMinStockNum));
				}
			}
			// 添加渠道库存
			for (OpChannelVO opChannelVO : channelVOs) {
				String warehouseCode = opChannelVO.getWarehouseForSales();
				int spvMinStockNum = getCanCombinationNum(combinationList, warehouseCode, skuStockMap);
				if (spvMinStockNum != 0) {
					if (opChannelVO.getCode().equals(channelCode)) {
						list.add(0, new StoreStockVO(opChannelVO.getCode(), opChannelVO.getName(), spvMinStockNum));
					} else {
						list.add(new StoreStockVO(opChannelVO.getCode(), opChannelVO.getName(), spvMinStockNum));
					}
				}
			}
		}
		return list;
	}*/

	/**
	 * 获取组合商品库存
	 * 
	 * @Methods Name getCanCombinationNum
	 * @Create In 2018-2-7 By Xiang.Gao
	 * @param combinationList
	 * @param warehouseCode
	 * @param skuStockMap
	 * @return int
	 */
	private int getCanCombinationNum(List<PsSkuCombinationVO> combinationList, String warehouseCode,
			Map<String, Map<String, SSkuStockVO>> skuStockMap) {
		int spvMinStockNum = 0;
		for (PsSkuCombinationVO psSkuCombination : combinationList) {
			Map<String, SSkuStockVO> subStockMap = skuStockMap.get(psSkuCombination.getSubSkuCode());
			if (subStockMap == null) {
				return 0;
			}
			SSkuStockVO skuStockVO = subStockMap.get(warehouseCode);
			if (skuStockVO == null || skuStockVO.getCanUseQuantity() == null || skuStockVO.getCanUseQuantity() < 1) {
				return 0;
			}
			// 可组合数
			int combinationQty = skuStockVO.getCanUseQuantity() / psSkuCombination.getQuantity();
			if (combinationQty < spvMinStockNum || spvMinStockNum == 0) {
				spvMinStockNum = combinationQty;
			}
		}
		return spvMinStockNum;
	}

	// /**
	// * 库存占用与释放
	// * @param WhInvOccupy
	// * @return 成功，失败
	// */
	// public boolean occupy(WareHouseVO wareHouseVO)throws Exception{
	//
	// // 是否存在商品
	// if(CollectionUtils.isNotEmpty(wareHouseVO.getWhInvOccupyVO())){
	// List<WhInvOccupy> whInvOccupyList = new ArrayList<>();
	// WhInvOccupy whInvOccupy=null;
	// for(WhInvOccupyVO whInvOccupyVO:wareHouseVO.getWhInvOccupyVO()){
	// whInvOccupy = new WhInvOccupy();
	// whInvOccupy.setId(whInvOccupyVO.getId());
	// if(whInvOccupyVO.getIsReleased()==null){
	// whInvOccupy.setIsReleased(0);
	// }
	// if(whInvOccupyVO.getOccupyTime()==null){
	// whInvOccupy.setOccupyTime(new Date());
	// }
	// if(whInvOccupyVO.getOccupyType()==null){
	// whInvOccupy.setOccupyType(WhInvOccupy.TYPE_SALES_OUT);
	// }
	// if(StringUtils.isBlank(whInvOccupyVO.getWarehouseCode())){
	// whInvOccupy.setWarehouseCode("WH020600010102");
	// }
	//
	// whInvOccupy.setSkuCode(whInvOccupyVO.getSkuCode());
	// whInvOccupy.setQuantity(whInvOccupyVO.getQuantity());
	// whInvOccupy.setReferenceCode(whInvOccupyVO.getReferenceCode());
	// whInvOccupyList.add(whInvOccupy);
	// }
	//
	// // 占用库存
	// if(wareHouseVO.getType()==0){
	//
	// PegasusWarehouseServiceFacade.getInstance().occupy(whInvOccupyList);
	//
	// //释放库存
	// }else{
	// PegasusWarehouseServiceFacade.getInstance().releaseOccupy(whInvOccupyList);
	// }
	//
	// }
	//
	// return true;
	// }

	// 组装商品价格查询条件
	public PrsProductVO assembleProduct(PsProductVO prod, List<PsSkuVO> skus, MemberVO member) {
		PrsProductVO product = new PrsProductVO();
		product.setAllowVipDiscount(false);
		if (null != prod.getAllowVipDiscount() && prod.getAllowVipDiscount() == 1) {
			product.setAllowVipDiscount(true);
		}

		product.setUseBirthdayDiscount(false);
		if (member!=null && member.isInBdayDiscountTime()) {
			if (null != prod.getAllowBdDiscount() && prod.getAllowBdDiscount() == 1) {
				product.setUseBirthdayDiscount(true);
			}
		}
		product.setCategoryId(prod.getCategoryId());
		product.setCrossBorderFlag(prod.getCrossBorderFlag());
		product.setHasSpecialDiscount(null != prod.getIsDiscount() && prod.getIsDiscount() == 1 ? true : false);
		product.setIsCustomize(false);
		if (null != skus && skus.size() > 0) {
			for (PsSkuVO sku : skus) {
				if (null != sku.getCanCustomize() && sku.getCanCustomize() == 1) {
					product.setIsCustomize(true);
					break;
				}
			}
		}
		product.setProductCode(prod.getCategoryCode());
		product.setProductId(Long.parseLong(prod.getId()));
		product.setProductName(prod.getNameCn());
		product.setNewbieGift(BooleanUtils.toBooleanObject(prod.getIsBirthday()));
		List<PrsSpvVO> spvs = new ArrayList<PrsSpvVO>();

		List<PsSpvVO> psSpvs = prod.getSpvList();
		if (CollectionUtils.isNotEmpty(psSpvs)) {
			for (PsSpvVO psSpv : psSpvs) {
				PrsSpvVO spv = new PrsSpvVO();
				List<PsCampaignVO> psAdvanceCampaignList = Lists.newArrayList();
				if (CollectionUtils.isNotEmpty(psSpv.getAdvanceCampaignList())) {
					psAdvanceCampaignList.addAll(psSpv.getAdvanceCampaignList());
				}
				if (null != prod.getPsAdvanceCampaignVO()
						&& CollectionUtils.isNotEmpty(prod.getPsAdvanceCampaignVO().getAdvanceCampaignList())) {
					psAdvanceCampaignList.addAll(prod.getPsAdvanceCampaignVO().getAdvanceCampaignList());
				}
				spv.setAdvanceCampaignList(PrsCampaignConvert.convertList4PsCampaignVO(psAdvanceCampaignList));

				List<PsCampaignVO> psCampaignList = Lists.newArrayList();
				if (CollectionUtils.isNotEmpty(psSpv.getCampaignList())) {
					psCampaignList.addAll(psSpv.getCampaignList());
				}
				if (CollectionUtils.isNotEmpty(prod.getCampaignList())) {
					psCampaignList.addAll(prod.getCampaignList());
				}

				spv.setCampaignList(PrsCampaignConvert.convertList4PsCampaignVO(psCampaignList));
				spv.setMinAmount(psSpv.getMinAmount());
				spv.setProductCode(prod.getCode());
				spv.setProductId(Long.parseLong(prod.getId()));
				spv.setProductName(prod.getNameCn());
				spv.setSalesPrice(psSpv.getSalesPrice());
				spv.setOriginalPrice(psSpv.getOriginalPrice());
				spv.setCombination(psSpv.getCombined());
				spv.setSpvId(psSpv.getSpvId());
				List<PrsSkuVO> skuVOList = new ArrayList<PrsSkuVO>();
				if (null != skus) {
					for (PsSkuVO psSku : skus) {
						PrsSkuVO sku = new PrsSkuVO(spv.getSpvId(), psSku.getSkuCode(), psSku.getSkuNameCN(),
								BigDecimal.valueOf(psSku.getSalesPrice()), 1);
						skuVOList.add(sku);
					}
				}
				spv.setSkuVOList(skuVOList);

				spvs.add(spv);
			}
		} else {
			return null;
		}

		product.setSpvVOList(spvs);

		product.setUseBirthdayDiscount(false);
		if (member != null && member.isInBdayDiscountTime()) {
			if (null != prod.getAllowBdDiscount() && prod.getAllowBdDiscount() == 1) {
				product.setUseBirthdayDiscount(true);
			}
		}
		return product;
	}

	/*
	 * 批量获取PsSkuVO信息
	 */
	public Map<String, List<PsSkuVO>> GetSkusByProducts(List<PsProductVO> products) {
		Map<String, List<PsSkuVO>> map = new HashMap<String, List<PsSkuVO>>();
		if (CollectionUtils.isEmpty(products)) {

			return map;
		}

		Map<String, String> mapSkus = new HashMap<String, String>();
		for (PsProductVO product : products) {
			if (product == null || product.getSkuCodes() == null || product.getSkuCodes().size() <= 0) {

				continue;
			}
			List<String> productSkuCodeList = product.getSkuCodes();
			if (CollectionUtils.isEmpty(productSkuCodeList)) {

				continue;
			}
			for (String skuItem : productSkuCodeList) {
				if (skuItem == null || skuItem.length() <= 0) {

					continue;
				}
				mapSkus.put(skuItem, skuItem);
			}
		}
		List<String> skuList = new ArrayList<String>();
		for (Map.Entry<String, String> entry : mapSkus.entrySet()) {
			skuList.add(entry.getKey());
		}
		if (skuList.size() <= 0) {

			return map;
		}
		List<PsSkuVO> skus = mcPsSkuService.findBySkuCodes(skuList);
		if (skus == null || skus.size() <= 0) {

			return map;
		}

		Map<String, PsSkuVO> skuMap = new HashMap<String, PsSkuVO>();
		for (PsSkuVO psSkuItem : skus) {
			skuMap.put(psSkuItem.getSkuCode(), psSkuItem);
		}

		// 组装skuu
		for (PsProductVO product : products) {
			if (product == null || product.getSkuCodes() == null || product.getSkuCodes().size() <= 0) {

				continue;
			}
			List<String> productSkuCodeList = product.getSkuCodes();
			if (CollectionUtils.isEmpty(productSkuCodeList)) {

				continue;
			}

			List<PsSkuVO> psSkuVOList = new ArrayList<PsSkuVO>();
			for (String skuItem : productSkuCodeList) {
				if (skuItem == null || skuItem.length() <= 0) {

					continue;
				}
				PsSkuVO psSkuVOItem = skuMap.get(skuItem);
				if (psSkuVOItem == null) {

					continue;
				}
				psSkuVOList.add(psSkuVOItem);
			}
			map.put(product.getId(), psSkuVOList);
		}
		return map;
	}
	
	/**
	   * 商品列表获取价格计算活动限量
	   * 列表页都取活动配置限量，不考虑实时限量信息
	   * @param prods
	   * @return
	   */
	  public List<PrsCampaignLimitVO> getPrsCampLimit4ProdsList(List<PsProductVO> prods) {
	    List<PrsCampaignLimitVO> targets = Lists.newArrayList();
	    if (CollectionUtils.isNotEmpty(prods)) {
	      for (PsProductVO prod : prods) {
	        if (CollectionUtils.isNotEmpty(prod.getSpvList())) {
	          for (PsSpvVO psSpvVO : prod.getSpvList()) {
	            List<PsCampaignVO> camps = CampaignUtils.getCampaignsByDiscountType(psSpvVO.getCampaignList(),
	                DiscountTypeEnum.PRICE_DISCOUNT);
	            if (CollectionUtils.isNotEmpty(camps)) {
	              for (PsCampaignVO camp : camps) {
	                Integer limitAmount = camp.getLimitAmount();
	                if(null == limitAmount) limitAmount = 0;
	                if(limitAmount.compareTo(-1)==0)limitAmount = 9999;
	                PrsCampaignLimitVO campLimit = new PrsCampaignLimitVO();
	                campLimit.setSpvId(psSpvVO.getSpvId());
	                campLimit.setAvailCnt(limitAmount);
	                campLimit.setCampaignId(camp.getId());
	                targets.add(campLimit);
	              }
	            }
	          }
	        }
	      }
	    }
	    return targets;
	  }
	  
	  // spv价格组装并升序排序
	  public Map<Long, BigDecimal> combineSpvPrice(PrsProductPriceResultVO priceVo) {

	    Map<Long, BigDecimal> spvPriceMap = new HashMap<Long, BigDecimal>();

	    if (CollectionUtils.isNotEmpty(priceVo.getSpvPriceResultVOs())) {
	      List<PrsSpvPriceResultVO> result = priceVo.getSpvPriceResultVOs();
	      for (PrsSpvPriceResultVO re : result) {
	        spvPriceMap.put(re.getSpvId(), re.getDiscountPrice());
	      }
	    }

	    List<Map.Entry<Long, BigDecimal>> list = new ArrayList<Map.Entry<Long, BigDecimal>>(spvPriceMap.entrySet());
	    Collections.sort(list, new Comparator<Map.Entry<Long, BigDecimal>>() {
	      // 升序排序
	      public int compare(Entry<Long, BigDecimal> o1, Entry<Long, BigDecimal> o2) {
	        return o1.getValue().compareTo(o2.getValue());
	      }
	    });

	    return spvPriceMap;
	  }
}