package com.thebeastshop.pegasus.channelservice.adapter;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.thebeastshop.common.enums.AccessWayEnum;
import com.thebeastshop.common.enums.MemberLevelEnum;
import com.thebeastshop.kit.prop.PropConstants;
import com.thebeastshop.kit.redis.util.RedisClient;
import com.thebeastshop.pegasus.channelservice.controller.product.ProductController;
import com.thebeastshop.pegasus.merchandise.cond.PsMatchCampaignCond;
import com.thebeastshop.pegasus.merchandise.service.McOpChannelService;
import com.thebeastshop.pegasus.merchandise.service.McOpProdDynmcontDetailsService;
import com.thebeastshop.pegasus.merchandise.service.McPsProductService;
import com.thebeastshop.pegasus.merchandise.service.McPsSkuService;
import com.thebeastshop.pegasus.merchandise.vo.OpChannelVO;
import com.thebeastshop.pegasus.merchandise.vo.PsProductVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSkuVO;
import com.thebeastshop.support.util.JsonUtil;

@Service("CommonAdapter")
public class CommonAdapter {
	private Logger logger = LoggerFactory.getLogger(ProductController.class);

	private final String RUSH_LIST = "rush_list";

	@Resource
	private RedisClient redisClient;
	@Autowired
	private McOpProdDynmcontDetailsService mcOpProdDynmcontDetailsService;

	@Autowired
	private McOpChannelService mcOpChannelService;

	@Autowired
	private McPsProductService mcPsProductService;

	@Autowired
	private McPsSkuService mcPsSkuService;

	/**
	 * 生成legacy缓存 Key
	 *
	 */
	public String buildLegacyKey(String proudctCode) {

		return "merch_legacy_" + proudctCode;
	}

	/**
	 * 生成details缓存 Key
	 *
	 */
	public String buildDetailKey(String proudctCode) {

		return "merch_detail_" + proudctCode;
	}

	/**
	 * 生成product缓存 Key
	 *
	 */
	public String buildProductKey(Integer memberLevel, String proudctCode) {

		return "merch_product_" + memberLevel.toString() + "_" + proudctCode;
	}

	/**
	 * 生成channel缓存 Key
	 *
	 */
	public String buildChannelKey(String channelCode) {

		return "merch_channel_" + channelCode;
	}

	/**
	 * 生成price缓存 Key
	 *
	 */
	public String buildPriceKey(Integer memberLevel, String proudctCode) {

		return "merch_price_" + memberLevel.toString() + "_" + proudctCode;
	}

	/**
	 * 生成sku缓存 Key
	 *
	 */
	public String buildSkuKey(String code) {
		return "merch_sku_" + code;
	}

	/**
	 * 开关
	 *
	 * @param times
	 * @return
	 */
	public Boolean on_off(String start, String end) {
		Boolean state = false;
		Date startTime = new Date();
		Date endTime = new Date();
		DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

		Date now = new Date();

		try {
			startTime = dateFormat.parse(start);
			endTime = dateFormat.parse(end);
			if (now.after(startTime) && now.before(endTime)) {
				state = true;
			}
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		logger.info("缓存开关状态：state={}", state);
		return state;
	}

	/**
	 * 线上判断
	 *
	 * @param times
	 * @return
	 */
	public Boolean isOnline(String channelCode) {
		Boolean state = false;
		if (StringUtils.isNoneBlank(channelCode) && ("CHN2049".equals(channelCode) || "CHN2077".equals(channelCode)
				|| "CHN2078".equals(channelCode) || "CHN2018".equals(channelCode)))
			state = true;

		logger.info("线上开关状态：state={}", state);
		return state;
	}

	/**
	 * 推redis
	 *
	 * @param times
	 * @return
	 */
	public void push() {
		logger.info("更新所有缓存");
		List<String> rushList = JsonUtil.toList(PropConstants.getProperties(RUSH_LIST), String.class);
		if (CollectionUtils.isNotEmpty(rushList)) {
			List<String> skucodes = new ArrayList<String>();
			for (String product : rushList) {
				PsProductVO ps = pushProduct(product, MemberLevelEnum.NORMAL);
				pushLegacy(product);
				skucodes.addAll(ps.getSkuCodes());
			}
			pushChannel();
			pushSku(skucodes);

		}

	}

	/**
	 * product缓存更新
	 *
	 * @param times
	 * @return
	 */
	public Boolean pushLegacy(String productCode) {
		logger.info("更新legacy缓存 productCode={}", productCode);
		Boolean state = !mcOpProdDynmcontDetailsService.IsEditByProdCode(productCode);
		redisClient.putCache(buildLegacyKey(productCode), state);
		return state;
	}

	/**
	 * product缓存更新
	 *
	 * @param times
	 * @return
	 */
	public PsProductVO pushProduct(String productCode, MemberLevelEnum memberLevel) {
		logger.info("更新product缓存 productCode={},memberLevel={}", productCode, memberLevel);
		PsMatchCampaignCond cond = new PsMatchCampaignCond();
		cond.setMatchCampaign(true);
		cond.setChannelCode("CHN2049");
		cond.setAccessWay(AccessWayEnum.APP.getCode());
		cond.setMemberLevel(MemberLevelEnum.NORMAL.getCode());
		cond.setDiscount(MemberLevelEnum.NORMAL.getLevelAmountCondition());
		cond.setBdDiscount(BigDecimal.ONE);
		PsProductVO product0 = mcPsProductService.getProductDetailByCode("CHN2049", productCode, cond);
		redisClient.putCache(buildProductKey(MemberLevelEnum.NORMAL.getCode(), productCode), product0);

		cond.setMemberLevel(MemberLevelEnum.VIP.getCode());
		cond.setDiscount(MemberLevelEnum.VIP.getLevelAmountCondition());
		PsProductVO product1 = mcPsProductService.getProductDetailByCode("CHN2049", productCode, cond);
		redisClient.putCache(buildProductKey(MemberLevelEnum.VIP.getCode(), productCode), product1);

		cond.setMemberLevel(MemberLevelEnum.VIP2.getCode());
		cond.setDiscount(MemberLevelEnum.VIP2.getLevelAmountCondition());
		PsProductVO product2 = mcPsProductService.getProductDetailByCode("CHN2049", productCode, cond);
		redisClient.putCache(buildProductKey(MemberLevelEnum.VIP2.getCode(), productCode), product2);

		cond.setMemberLevel(MemberLevelEnum.VIP3.getCode());
		cond.setDiscount(MemberLevelEnum.VIP3.getLevelAmountCondition());
		PsProductVO product3 = mcPsProductService.getProductDetailByCode("CHN2049", productCode, cond);
		redisClient.putCache(buildProductKey(MemberLevelEnum.VIP3.getCode(), productCode), product3);

		cond.setMemberLevel(MemberLevelEnum.VIP4.getCode());
		cond.setDiscount(MemberLevelEnum.VIP4.getLevelAmountCondition());
		PsProductVO product4 = mcPsProductService.getProductDetailByCode("CHN2049", productCode, cond);
		redisClient.putCache(buildProductKey(MemberLevelEnum.VIP4.getCode(), productCode), product4);

		switch (memberLevel.getCode()) {
		case -1:
			return product0;
		case 0:
			return product1;
		case 1:
			return product2;
		case 2:
			return product3;
		case 3:
			return product4;
		default:
			return product0;
		}
	}

	/**
	 * channel缓存更新
	 *
	 * @param times
	 * @return
	 */
	public void pushChannel() {
		logger.info("更新channel缓存");
		List<String> codes = new ArrayList<String>();
		codes.add("CHN2049");
		codes.add("CHN2018");
		codes.add("CHN2077");
		codes.add("CHN2078");
		List<OpChannelVO> opChannels = mcOpChannelService.findByCode(codes);
		if (CollectionUtils.isNotEmpty(opChannels)) {
			for (OpChannelVO opChannel : opChannels) {
				redisClient.putCache(buildChannelKey(opChannel.getCode()), opChannel);
			}
		}

	}

	/**
	 * sku缓存更新
	 *
	 * @param times
	 * @return
	 */
	public List<PsSkuVO> pushSku(List<String> codes) {
		logger.info("更新skus缓存 skucodes={}", codes);
		List<PsSkuVO> skus = mcPsSkuService.findBySkuCodes(codes);
		if (CollectionUtils.isNotEmpty(skus)) {
			for (PsSkuVO sku : skus) {
				redisClient.putCache(buildSkuKey(sku.getSkuCode()), sku);
			}
		}
		return skus;
	}

}
