package com.thebeastshop.pegasus.channelservice.adapter;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.thebeastshop.campaign.enums.DiscountTypeEnum;
import com.thebeastshop.campaign.enums.MemberTypeEnum;
import com.thebeastshop.campaign.service.CampaignLimitService;
import com.thebeastshop.campaign.vo.CampaignStreamVO;
import com.thebeastshop.campaign.vo.LimitCheckResultVO;
import com.thebeastshop.cart.ProductPack;
import com.thebeastshop.cart.enums.CartPackSourceEnum;
import com.thebeastshop.cart.resp.CartCustomization;
import com.thebeastshop.cart.resp.CartProductPack;
import com.thebeastshop.cart.support.ScDeliveryVO;
import com.thebeastshop.commdata.service.CommAddressService;
import com.thebeastshop.commdata.vo.CommDistrictVO;
import com.thebeastshop.common.RespCallback;
import com.thebeastshop.common.ServiceResp;
import com.thebeastshop.common.enums.AccessWayEnum;
import com.thebeastshop.common.enums.MemberLevelEnum;
import com.thebeastshop.common.utils.DateUtil;
import com.thebeastshop.kit.prop.PropConstants;
import com.thebeastshop.delivery.dto.DeliveryInfoDTO;
import com.thebeastshop.delivery.vo.DateUnitVO;
import com.thebeastshop.delivery.vo.DeliveryInfoVO;
import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.message.service.EmailSendService;
import com.thebeastshop.message.vo.EmailVO;
import com.thebeastshop.pcs.sservice.SPrdcJobService;
import com.thebeastshop.pegasus.channelservice.adapter.exchange.ExchangeProductGoodsDetailAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.logistics.LogisticsAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.product.SpvAdapter;
import com.thebeastshop.pegasus.channelservice.constants.ErrorCode;
import com.thebeastshop.pegasus.channelservice.exception.ChannelException;
import com.thebeastshop.pegasus.channelservice.model.CalculateProductPackDTO;
import com.thebeastshop.pegasus.channelservice.model.PriceResult;
import com.thebeastshop.pegasus.channelservice.model.PriceStep;
import com.thebeastshop.pegasus.channelservice.service.PriceService;
import com.thebeastshop.pegasus.channelservice.util.ConstUtil;
import com.thebeastshop.pegasus.channelservice.vo.address.AddressVO;
import com.thebeastshop.pegasus.channelservice.vo.order.*;
import com.thebeastshop.pegasus.component.campaign.Campaign;
import com.thebeastshop.pegasus.component.campaign.CampaignResult;
import com.thebeastshop.pegasus.component.campaign.ProductScope;
import com.thebeastshop.pegasus.component.discount.DiscountType;
import com.thebeastshop.pegasus.merchandise.cond.PsMatchCampaignCond;
import com.thebeastshop.pegasus.merchandise.cond.PsProductCond;
import com.thebeastshop.pegasus.merchandise.service.McPcsSkuCategoryService;
import com.thebeastshop.pegasus.merchandise.service.McPsProductService;
import com.thebeastshop.pegasus.merchandise.service.McPsSkuService;
import com.thebeastshop.pegasus.merchandise.service.McPsSpvService;
import com.thebeastshop.pegasus.merchandise.vo.*;
import com.thebeastshop.pegasus.service.operation.PegasusOperationServiceFacade;
import com.thebeastshop.pegasus.service.operation.channelvo.*;
import com.thebeastshop.pegasus.service.operation.model.*;
import com.thebeastshop.price.enums.PrsPriceTypeEnum;
import com.thebeastshop.price.vo.PrsAdditionalPackVO;
import com.thebeastshop.price.vo.PrsCampaignVO;
import com.thebeastshop.price.vo.PrsPriceStepVO;
import com.thebeastshop.price.vo.PrsSpvPriceStepVO;
import com.thebeastshop.stock.service.SGroupbuyStockService;
import com.thebeastshop.stock.vo.SGroupbuyStockVO;
import com.thebeastshop.stock.vo.SPresaleSaleInvVO;
import com.thebeastshop.stock.vo.SPresaleVO;
import com.thebeastshop.support.enums.CartPackSource;
import com.thebeastshop.support.enums.OrderBusinessType;
import com.thebeastshop.support.enums.PriceType;
import com.thebeastshop.support.vo.product.SpvVO;
import com.thebeastshop.wms.constant.PegasusConstants;
import com.thebeastshop.wms.vo.WhAllotRcdVO;
import com.thebeastshop.wms.vo.WhRecipeInvVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.Map.Entry;

@Service("ComOrderAdapter")
public class ComOrderAdapter {

	private final static Logger logger = LoggerFactory.getLogger(ComOrderAdapter.class);

	/**
	 * 做一个缓存机制 首单
	 */

	@Autowired
	private McPsProductService mcPsProductService;

	// @Autowired
	// private McOpChannelService mcOpChannelService;

	@Autowired
	private McPsSpvService mcPsSpvService;

	@Autowired
	private McPsSkuService mcPsSkuService;

	private PegasusOperationServiceFacade poInstance = PegasusOperationServiceFacade.getInstance();

	@Autowired
	private SpvAdapter spvAdapter;

	@Autowired
	private PriceService priceService;

	@Autowired
	private McPcsSkuCategoryService mcPcsSkuCategoryService;

	@Autowired
	private CampaignLimitService campaignLimitService;

	@Autowired
	private LogisticsAdapter logisticsAdapter;

	@Autowired
	private SGroupbuyStockService groupbuyStockService;

	@Autowired
	private EmailSendService emailSendService;

	@Autowired
	private SPrdcJobService sPrdcJobService;

	@Autowired
	private CommAddressService commAddressService;

	@Autowired
	private ExchangeProductGoodsDetailAdapter exchangeProductGoodsDetailAdapter;



	/***
	 * 外部订单为通用订单对象
	 */
	public OpSalesOrderVO orderWebsite2Common(final OrderCreateVO orderCreateVO, AccessWayEnum accessWay,
			MemberVO member, OpChannelVO opChannel, Map<String, SPresaleVO> sPresaleMap,
			Map<String, SPresaleSaleInvVO> sPresaleSaleInvMap) {

		// 订单VO
		final OpSalesOrderVO opSalesOrderVO = new OpSalesOrderVO();
		opSalesOrderVO.setDeviceId(orderCreateVO.getDeviceId());
		opSalesOrderVO.setServiceFeeAmount(BigDecimal.ZERO);
		opSalesOrderVO.setCarriage(BigDecimal.ZERO);
		opSalesOrderVO.setCustomizationAmount(BigDecimal.ZERO);
		opSalesOrderVO.setCustomizationDiscount(BigDecimal.ZERO);
		opSalesOrderVO.setCrossFree(BigDecimal.ZERO);
		opSalesOrderVO.setLimitFee(BigDecimal.ZERO);
		opSalesOrderVO.setUtmSource(orderCreateVO.getUtmSource());
		opSalesOrderVO.setBirthFlowerUse(orderCreateVO.isBirthFlowerUse());
		opSalesOrderVO.setCreateOperatorId(orderCreateVO.getCreateOperatorId());
		opSalesOrderVO.setCreateOperatorName(orderCreateVO.getCreateOperatorName());
		// opSalesOrderVO.setOrderType(orderCreateVO.getOrderType());
		opSalesOrderVO.setTradeNo(orderCreateVO.getTradeNo());
		opSalesOrderVO.setTbsClient(orderCreateVO.getTbsClient());
		opSalesOrderVO.setTbsUSource(orderCreateVO.getTbsUSource());
		opSalesOrderVO.setPlatForm(orderCreateVO.getPlatForm());
		if (orderCreateVO.getMarketVip() != null) {
			opSalesOrderVO.setActivityId(orderCreateVO.getMarketVip().getActivityId());
			opSalesOrderVO.setVipCardNo(orderCreateVO.getMarketVip().getVipCardNo());
		}

		// 如果不存在操作员，判断是不是小程序引导过来的
		if (opSalesOrderVO.getCreateOperatorId() == null || opSalesOrderVO.getCreateOperatorId() <= 0) {
			if (StringUtils.isNotBlank(opSalesOrderVO.getTbsUSource())) {

				String[] args = opSalesOrderVO.getTbsUSource().split("_");
				// 线下导流
				if ("xxdl".equals(args[0])) {
					OpSales opSales = poInstance.findSaleById(Long.valueOf(args[1]));
					if (opSales != null) {
						opSalesOrderVO.setCreateOperatorId(opSales.getId());
						opSalesOrderVO.setCreateOperatorName(opSales.getSalesName());
					}

				}

			}

		}

		// NORMAL("01", "普通订单")
		if (orderCreateVO.getOrderBusinessType() == null
				|| OrderBusinessType.NORMAL.getCode().equals(orderCreateVO.getOrderBusinessType())) {

			opSalesOrderVO.setOrderTypeEnum(OrderTypeEnum.ORDERTYPE_0);

		} else if (OrderBusinessType.MONTHLY_FLOWER.getCode().equals(orderCreateVO.getOrderBusinessType().getCode())) {
			opSalesOrderVO.setOrderTypeEnum(OrderTypeEnum.ORDERTYPE_1);

		} else if (OrderBusinessType.CUSTOMIZE.getCode().equals(orderCreateVO.getOrderBusinessType().getCode())) {
			opSalesOrderVO.setOrderTypeEnum(OrderTypeEnum.ORDERTYPE_4);

		} else if (OrderBusinessType.RECIPE_CUSTOMIZE.getCode()
				.equals(orderCreateVO.getOrderBusinessType().getCode())) {
			opSalesOrderVO.setOrderTypeEnum(OrderTypeEnum.ORDERTYPE_5);

		} else if (OrderBusinessType.SPD.getCode().equals(orderCreateVO.getOrderBusinessType().getCode())) {
			opSalesOrderVO.setOrderTypeEnum(OrderTypeEnum.ORDERTYPE_6);

		} else if (OrderBusinessType.JBR.getCode().equals(orderCreateVO.getOrderBusinessType().getCode())) {
			opSalesOrderVO.setOrderTypeEnum(OrderTypeEnum.ORDERTYPE_8);

		} else if (OrderBusinessType.GROUPON.getCode().equals(orderCreateVO.getOrderBusinessType().getCode())) {
			opSalesOrderVO.setOrderTypeEnum(OrderTypeEnum.ORDERTYPE_10);

		} else if (OrderBusinessType.EXCHANGE.getCode().equals(orderCreateVO.getOrderBusinessType().getCode())) {
			opSalesOrderVO.setOrderTypeEnum(OrderTypeEnum.ORDERTYPE_9);

		} else if (OrderBusinessType.DEPOSIT.getCode().equals(orderCreateVO.getOrderBusinessType().getCode())) {
			opSalesOrderVO.setOrderTypeEnum(OrderTypeEnum.ORDERTYPE_11);
		} else if (OrderBusinessType.FINAL.getCode().equals(orderCreateVO.getOrderBusinessType().getCode())) {
			opSalesOrderVO.setOrderTypeEnum(OrderTypeEnum.ORDERTYPE_12);
		} else if (OrderBusinessType.CLASSROOM.getCode().equals(orderCreateVO.getOrderBusinessType().getCode())) {
			opSalesOrderVO.setOrderTypeEnum(OrderTypeEnum.ORDERTYPE_13);
		} else {
			opSalesOrderVO.setOrderTypeEnum(OrderTypeEnum.ORDERTYPE_0);
		}

		opSalesOrderVO.setGroupbuy(orderCreateVO.isGroupbuy());
		opSalesOrderVO.setCode(orderCreateVO.getOrderCode());
		opSalesOrderVO.setPaymentType(orderCreateVO.getPaymentType());
		opSalesOrderVO.setTradeNo(orderCreateVO.getTradeNo());
		opSalesOrderVO.setPointOnLineDeduction(BigDecimal.ZERO);
		// 设置各项费用
		if (CollectionUtils.isNotEmpty(orderCreateVO.getPriceStepVOs())) {
			BigDecimal customizationDiscount = BigDecimal.ZERO;
			for (PrsPriceStepVO step : orderCreateVO.getPriceStepVOs()) {

				// 海淘运费或 运费
				if (PrsPriceTypeEnum.POSTAGE.getCode().equals(step.getPriceType().getCode())
						|| PrsPriceTypeEnum.POSTAGE_FREE.getCode().equals(step.getPriceType().getCode())
						|| PrsPriceTypeEnum.POINTS_EXCHANGE_FREE.getCode().equals(step.getPriceType().getCode())
						|| PrsPriceTypeEnum.REMOTE_AREA_DELIVERY.getCode().equals(step.getPriceType().getCode())) {
					opSalesOrderVO.setCarriage(opSalesOrderVO.getCarriage().add(step.getPriceChange()));
					// 限时送达运费
				} else if (PrsPriceTypeEnum.OVERSEAS.getCode().equals(step.getPriceType().getCode())
						|| PrsPriceTypeEnum.OVERSEA_FREE.getCode().equals(step.getPriceType().getCode())) {
					opSalesOrderVO.setCrossFree(opSalesOrderVO.getCrossFree().add(step.getPriceChange()));
				} else if (step.getPriceType().getCode() == PrsPriceTypeEnum.TIME.getCode()) {
					opSalesOrderVO.setLimitFee(opSalesOrderVO.getLimitFee().add(step.getPriceChange()));
					// 定制费用
				} else if (PrsPriceTypeEnum.CUSTOMIZE.getCode().equals(step.getPriceType().getCode())
						|| PrsPriceTypeEnum.CUSTOMIZE_FREE.getCode().equals(step.getPriceType().getCode())) {
					if (step.getPriceChange().doubleValue() < 0) {
						customizationDiscount = customizationDiscount.add(step.getPriceChange());
					} else {
						opSalesOrderVO.setCustomizationAmount(
								opSalesOrderVO.getCustomizationAmount().add(step.getPriceChange()));
					}

					// 积分抵扣的金额
				} else if (PrsPriceTypeEnum.POINTS_EXCHANGE.getCode().equals(step.getPriceType().getCode())) {
					// opSalesOrderVO.setPointOnLineDeduction(BigDecimal.ZERO.subtract(step.getPriceChange()));
				}

				if (PrsPriceTypeEnum.INTEREST_MEM_POSTAGE_FREE.getCode().equals(step.getPriceType().getCode())
						|| PrsPriceTypeEnum.INTEREST_PRD_POSTAGE_FREE.getCode().equals(step.getPriceType().getCode())) {
					if (orderCreateVO.getCrossBorderFlag() != null && orderCreateVO.getCrossBorderFlag() == 1) {

						opSalesOrderVO.setCrossFree(opSalesOrderVO.getCrossFree().add(step.getPriceChange()));

					} else {
						opSalesOrderVO.setCarriage(opSalesOrderVO.getCarriage().add(step.getPriceChange()));
					}
				}

			}

			opSalesOrderVO.setCustomizationDiscount((BigDecimal.ZERO.subtract(customizationDiscount)));

		}

		opSalesOrderVO.setUseBdayDiscount(orderCreateVO.isUseBdayDiscount());
		// 设置权益Id
		if (orderCreateVO.getInterestsVO() != null) {
			opSalesOrderVO.setInterestsId(String.valueOf(orderCreateVO.getInterestsVO().getId()));
		}

		// APP下载来源
		opSalesOrderVO.setDownloadSource(orderCreateVO.getDownloadSource());

		// 包裹VO
		final List<OpSoPackageVO> opSoPackageVOs = new ArrayList<>();
		// 设置第三方渠道 cps
		if (null != orderCreateVO.getCpsInfo()
				&& StringUtils.isNotBlank(orderCreateVO.getCpsInfo().getCpsChannelName())) {
			opSalesOrderVO.setCpsInfo(orderCreateVO.getCpsInfo());
		}
		// 官网默认是一个包裹
		final OpSoPackageVO opSoPackage = new OpSoPackageVO();
		// 包裹地址信息
		final OpSoPackageDeliveryInfoVO opSoPackageDeliveryInfoVO = new OpSoPackageDeliveryInfoVO();
		// 包裹sku信息
		final List<OpSoPackageSkuVO> opSoPackageSkuVOs = new ArrayList<>();
		// OpMemberVO memberVo=null;
		// final MemberVO memberVo =
		// memberQueryService.getById(orderCreateVO.getCustomerId());
		// 配送仓
		// if (opChannel != null) {

		if (StringUtils.isNotBlank(orderCreateVO.getWarehouseForSales())) {
			opSoPackage.setDispatchWarehouseCode(orderCreateVO.getWarehouseForSales());
		} else {
			opSoPackage.setDispatchWarehouseCode(opChannel.getWarehouseForSales());
		}

		// }

		// orderPreCheck(orderCreateVO.getChannelCode(), orderCreateVO,
		// opChannel);// 下单之前的预判
		// 校验价格
		// 校验库存
		// 校验是否下架
		opSalesOrderVO.setActualPayFee(orderCreateVO.getActualPayFee());
		// 订单来源渠道编码
		opSalesOrderVO.setChannelCode(orderCreateVO.getChannelCode());
		// 会员id
		if (member != null) {
			opSalesOrderVO.setMemberId(member.getId());
			// 会员code
			opSalesOrderVO.setMemberCode(member.getCode());
		}

		// 卡片类型，0不需要1空白2代写
		opSoPackage.setCardType(orderCreateVO.getNoteCard());
		// 卡片内容
		opSoPackage.setCardContent(orderCreateVO.getNoteCardMessage());
		opSoPackage.setCardTo(orderCreateVO.getNoteCardTo());
		opSoPackage.setCardFrom(orderCreateVO.getNoteCardFrom());
		// 配送方式
		opSoPackage.setDeliveryType(orderCreateVO.getDeliveryType());
		// 限时配送
		opSoPackage.setLimitDeliveryTimeDesc(orderCreateVO.getLimitedHour());

		// ztq 20160505 身份证信息保存 start
		final Integer crossBorderFlag = orderCreateVO.getCrossBorderFlag();
		if (crossBorderFlag != null && crossBorderFlag != OrderCreateVO.CROSS_BOARDER_FLAG_NOT_OVERSEA) {

			// opSalesOrderVO.setCrossFree(orderCreateVO.getCrossFree());
			opSalesOrderVO.setCrossBorderFlag(orderCreateVO.getCrossBorderFlag());
			if (orderCreateVO.getIdCardVO() != null) {

				final OpIdCardVO opIdCardVO = new OpIdCardVO();

				opIdCardVO.setBackCardPhoto(orderCreateVO.getIdCardVO().getBackCardPhoto());
				opIdCardVO.setFrontCardPhoto(orderCreateVO.getIdCardVO().getFrontCardPhoto());
				opIdCardVO.setIdNumber(orderCreateVO.getIdCardVO().getIdNumber());
				opIdCardVO.setName(orderCreateVO.getIdCardVO().getName());
				opIdCardVO.setAuditStatus(orderCreateVO.getIdCardVO().getAuditStatus());
				opIdCardVO.setId(orderCreateVO.getIdCardVO().getId());
				opIdCardVO.setImgStatus(orderCreateVO.getIdCardVO().getImgStatus());
				opSalesOrderVO.setOpIdCardVO(opIdCardVO);
			}
		} else {
			opSalesOrderVO.setCrossBorderFlag(OrderCreateVO.CROSS_BOARDER_FLAG_NOT_OVERSEA);
			opSalesOrderVO.setCrossFree(BigDecimal.ZERO);
		}
		// ztq 20160505 身份证信息保存 end

		// 预期发货时间
		// 内部备注
		opSalesOrderVO.setInnerRemark(orderCreateVO.getInnerRemark());
		// 设置订单来源 refer
		opSalesOrderVO.setRefer(orderCreateVO.getRefer());
		opSalesOrderVO.setIsForceAudit(PegasusConstants.NO);

		final Map<String, Boolean> deliveryTypes = new HashMap<>();

		List<PsSkuVO> skuVOs = new ArrayList<>();
		Map<String, Integer> skuCountMap = new HashMap<>();
		// 设置包裹
		setOpSoPackages(orderCreateVO, deliveryTypes, opSoPackageSkuVOs, member, opSalesOrderVO, opChannel, accessWay,
				skuVOs, skuCountMap);

		// 发票是否随同货物发送，0否1是
		opSalesOrderVO.setIsInvoiceInSamePackage(OpSalesOrder.IS_INVOICE_IN_SAME_PACKAGE_FALSE);

		// @auhtor lijing start
		// 是否需要发票
		opSalesOrderVO.setNeedInvoice(orderCreateVO.getNeedInvoice());
		if (orderCreateVO.getIsInvoiceInSamePackage() == null) {
			opSalesOrderVO.setIsInvoiceInSamePackage(OpSalesOrder.IS_INVOICE_IN_SAME_PACKAGE_FALSE);
		} else {
			opSalesOrderVO.setIsInvoiceInSamePackage(orderCreateVO.getIsInvoiceInSamePackage());
		}
		// 判断发票是否同货物发送
		// 设置发票
		if (orderCreateVO.getNeedInvoice() != null
				&& orderCreateVO.getNeedInvoice() == OrderCreateVO.NEED_INVOICE_TRUE) {
			logger.info("设置发票 orderCreateVO.getSoInvoiceInfoVO={}", orderCreateVO.getSoInvoiceInfoVO());
			final OpSoInvoiceInfoVO1 opSoInvoiceInfo = new OpSoInvoiceInfoVO1();
			final SoInvoiceInfoVO soInvoiceInfoVO = orderCreateVO.getSoInvoiceInfoVO();
			if (soInvoiceInfoVO != null) {
				logger.info("设置发票 ");
				opSoInvoiceInfo.setInnerRemark(soInvoiceInfoVO.getInnerRemark());
				opSoInvoiceInfo.setAddress(soInvoiceInfoVO.getAddress());
				opSoInvoiceInfo.setDistrictId(soInvoiceInfoVO.getDistrictId());
				opSoInvoiceInfo.setInvoiceType(soInvoiceInfoVO.getInvoiceType());
				opSoInvoiceInfo.setInvoiceTitle(soInvoiceInfoVO.getInvoiceTitle());
				opSoInvoiceInfo.setInvoiceAmount(soInvoiceInfoVO.getInvoiceAmount());
				opSoInvoiceInfo.setReceiver(soInvoiceInfoVO.getReceiver());
				opSoInvoiceInfo.setReceiverPhone(soInvoiceInfoVO.getReceiverPhone());
				opSoInvoiceInfo.setInvoiceStatus(soInvoiceInfoVO.getInvoiceStatus());
				opSoInvoiceInfo.setApplyTime(soInvoiceInfoVO.getApplyTime());
				opSoInvoiceInfo.setApplyOperatorId(soInvoiceInfoVO.getApplyOperatorId());
				opSoInvoiceInfo.setApplyOperatorName(soInvoiceInfoVO.getApplyOperatorName());
				opSoInvoiceInfo.setIsEmergency(soInvoiceInfoVO.getIsEmergency());
				opSalesOrderVO.setSoInvoiceInfoVO(opSoInvoiceInfo);
			}
		}
		// @auhtor lijing end

		// 是否审单,有两种不同的运输方式或者有自送的。需要审单
		// deliveryTypes.size() > 1 ||

		// 积分兑换活动特殊处理，发货时间统一为
		if (OrderBusinessType.EXCHANGE.equals(orderCreateVO.getOrderBusinessType())) {
			Date deliveryDate = exchangeProductGoodsDetailAdapter.getExchangeDeliveryDate();

			if (deliveryDate == null) {
				deliveryDate = DateUtil.addDay(new Date(), 2);
			}
			opSoPackage.setPlanedDeliveryDate(deliveryDate);
		} else {
			// 期望收货时间
			if (StringUtils.isNotBlank(orderCreateVO.getDeliveryDate())) {

				opSoPackage.setExpectReceiveDate(
						DateUtil.parse(orderCreateVO.getDeliveryDate(), DateUtil.DEFAULT_DATE_FORMAT));
				boolean errorDate = true;
				boolean canDate = false;
				if (opChannel.getChannelType() != null && opChannel.getChannelType() == 2) {
					// Deliverable deliverable = null;
					DeliveryInfoVO deliveryInfoVO = null;
					try {
						// -----------------------

						DeliveryInfoDTO dto = new DeliveryInfoDTO();
						dto.setDistrictId(orderCreateVO.getDeliveryAddress().getDistrictId().intValue());
						dto.setSkuCountMap(skuCountMap);

						deliveryInfoVO = logisticsAdapter.getDeliverables(dto);
						// deliverable =
						// deliverableService.getDeliverable(orderCreateVO.getDeliveryAddress().getId(),
						// skuVOs);

					} catch (Exception e) {
						errorDate = false;
						canDate = true;
						logger.error("创建订单，验证配送日期异常，" + e.getMessage());

						// 异常通知邮件
						List<String> toAddressList = new ArrayList<>();
						toAddressList.add("tianqi.zhang@thebeastshop.com");
						EmailVO emailVO = new EmailVO();
						emailVO.setSubject("获取商品异常");
						emailVO.setToAddressList(toAddressList);
						String pegasus_channel_service = PropConstants.getProperties("pegasus_channel_service", "test");
						StringBuilder sb = new StringBuilder();
						sb.append("setDistrictId:")
								.append(orderCreateVO.getDeliveryAddress().getDistrictId().intValue())
								.append(",skuCountMap").append(skuCountMap.toString()).append("########")
								.append(pegasus_channel_service);

						emailVO.setContent(sb.toString());
						emailSendService.send(emailVO);
					}

					if (errorDate) {
						if (deliveryInfoVO != null
								&& CollectionUtils.isNotEmpty(deliveryInfoVO.getDeliverableDates())) {

							for (DateUnitVO dd : deliveryInfoVO.getDeliverableDates()) {

								if (orderCreateVO.getDeliveryDate().equals(dd.getTextDisplay())) {

									if (!dd.getAvailable()) {
										throw new ChannelException(ErrorCode.PARAMS_ILLEGAL.getCode(),
												"当前（" + orderCreateVO.getDeliveryDate() + "）配送日期不可送，请重新选择！");
									}
									canDate = true;
									break;
								}

							}

						} else {
							throw new ChannelException(ErrorCode.PARAMS_ILLEGAL.getCode(),
									"当前（" + orderCreateVO.getDeliveryDate() + "）配送日期不可送，请重新选择！");
						}
					}

					if (canDate == true) {
						opSoPackage.setExpectReceiveDate(
								DateUtil.parse(orderCreateVO.getDeliveryDate(), DateUtil.DEFAULT_DATE_FORMAT));

						Date planedDeliveryDate = DateUtil.addDay(opSoPackage.getExpectReceiveDate(), -1);

						opSoPackage.setPlanedDeliveryDate(planedDeliveryDate);

					} else {
						throw new ChannelException(ErrorCode.PARAMS_ILLEGAL.getCode(),
								"当前（" + orderCreateVO.getDeliveryDate() + "）配送日期不可送，请重新选择！");
					}
				}

			} else {

				if (opChannel.getChannelType() != null && opChannel.getChannelType() == 2) {
					if ((deliveryTypes.get("SELF") != null && deliveryTypes.get("SELF"))
							|| (deliveryTypes.get("FEDX24") != null && deliveryTypes.get("FEDX24"))) {

						throw new ChannelException(ErrorCode.PARAMS_ILLEGAL.getCode(), "存在特殊配送商品，配送日期不能为空！");

					}

				}

				Calendar c = Calendar.getInstance();

				int hour = c.get(Calendar.HOUR_OF_DAY);

				int minute = c.get(Calendar.MINUTE);

				if (hour > 16 || (hour == 16 && minute > 0)) {
					opSoPackage.setPlanedDeliveryDate(DateUtil.addDay(new Date(), 1));

				} else {
					opSoPackage.setPlanedDeliveryDate(new Date());
				}

			}
		}

		// 设置配送信息的快递方式，当只有一种配送方式时，设置
		if (deliveryTypes.size() == 1) {
			if (deliveryTypes.get("SELF") != null && deliveryTypes.get("SELF")) {
				opSoPackageDeliveryInfoVO.setExpressType(OpSoPackageDeliveryInfo.EXPRESS_TYPE_SHOP);
			} else if (deliveryTypes.get("FEDX24") != null && deliveryTypes.get("FEDX24")) {
				opSoPackageDeliveryInfoVO.setExpressType(OpSoPackageDeliveryInfo.EXPRESS_TYPE_FEDEX);
			} else if (deliveryTypes.get("SF_AIR") != null && deliveryTypes.get("SF_AIR")) {
				opSoPackageDeliveryInfoVO.setExpressType(OpSoPackageDeliveryInfo.EXPRESS_TYPE_SF_AIR);
			} else if (deliveryTypes.get("SF_LAND") != null && deliveryTypes.get("SF_LAND")) {
				opSoPackageDeliveryInfoVO.setExpressType(OpSoPackageDeliveryInfo.EXPRESS_TYPE_SF_LAND);
			} else if (deliveryTypes.get("YTO") != null && deliveryTypes.get("YTO")) {
				opSoPackageDeliveryInfoVO.setExpressType(OpSoPackageDeliveryInfo.EXPRESS_TYPE_YTO);
			} else if (deliveryTypes.get("DEPPON") != null && deliveryTypes.get("DEPPON")) {
				opSoPackageDeliveryInfoVO.setExpressType(OpSoPackageDeliveryInfo.EXPRESS_TYPE_DEPPON);
			} else if (deliveryTypes.get("ZT") != null && deliveryTypes.get("ZT")) {
				opSoPackageDeliveryInfoVO.setExpressType(OpSoPackageDeliveryInfo.EXPRESS_TYPE_ZT);
			}
		}

		opSoPackage.setOpSoPackageSkuVOs(opSoPackageSkuVOs);
		opSoPackageVOs.add(opSoPackage);

		if (orderCreateVO.getDeliveryAddress() != null) {
			// 设置配送地址
			final AddressVO address = orderCreateVO.getDeliveryAddress();
			// 详细地址
			opSoPackageDeliveryInfoVO.setAddress(address.getStreet());
			// 环线
			opSoPackageDeliveryInfoVO.setCircuitDesc(address.getCircuit());
			// 公司名称
			opSoPackageDeliveryInfoVO.setCompanyName(address.getCompanyName());
			// 收货的区县ID
			opSoPackageDeliveryInfoVO.setDistrictId(address.getDistrictId());
			// 收件人
			opSoPackageDeliveryInfoVO.setReceiver(address.getName());
			// 邮编
			opSoPackageDeliveryInfoVO.setZipCode(address.getZip());
			// 称谓
			opSoPackageDeliveryInfoVO.setTitle(address.getMagentoTitle());
			// 收件人电话
			opSoPackageDeliveryInfoVO.setReceiverPhone(address.getPhone());
			opSoPackageDeliveryInfoVO.setOpenId(address.getOpenId());
			// 设置包裹配送信息
			opSoPackage.setOpSoPackageDeliveryInfoVO(opSoPackageDeliveryInfoVO);
		}

		// 设置订单关联包裹
		opSalesOrderVO.setOpSoPackageVOs(opSoPackageVOs);

		// 服务费
		// opSalesOrderVO.setServiceFeeAmount(BigDecimal.valueOf(orderCreateVO.getServiceFee()));

		// 用户备注
		opSalesOrderVO.setRemark(orderCreateVO.getNote());
		// 订单类型，1渠道销售单2渠道退货单3渠道换货单4集团订单11礼品订单12样品订单
		opSalesOrderVO.setSalesOrderType(OpSalesOrder.ORDER_TYPE_SALES);

		// if (!StringUtils.isBlank(orderCreateVO.getCouponCode())) {
		// COUPON编码
		opSalesOrderVO.setCouponCode(orderCreateVO.getCouponCode());

		// 礼品卡金额
		if (CollectionUtils.isNotEmpty(orderCreateVO.getOpSalesOrderGiftCardVOs())) {

			StringBuilder builder = new StringBuilder();
			BigDecimal totail = BigDecimal.ZERO;

			for (OpSalesOrderGiftCardVO vo : orderCreateVO.getOpSalesOrderGiftCardVOs()) {
				totail = totail.add(vo.getGiftCardValue());
				builder.append("no:" + vo.getGiftCardNo());
				builder.append("&fee:" + vo.getGiftCardValue().multiply(BigDecimal.valueOf(100)));
				builder.append("|");
			}

			logger.info("礼品卡内容：" + builder.toString());
			logger.info("礼品卡消费金额：" + totail);
			opSalesOrderVO.setOpSalesOrderGiftCardVOs(orderCreateVO.getOpSalesOrderGiftCardVOs());
			
			if(orderCreateVO.getOpSalesOrderGiftCardVOs().size() < 8){
				opSalesOrderVO.setGiftCardDesc(builder.toString());
			}
			
			opSalesOrderVO.setGiftCardAmount(totail);

		} else {
			opSalesOrderVO.setGiftCardAmount(BigDecimal.ZERO);
		}

		// 头折扣
		if (orderCreateVO.getOtherDiscount() != null) {
			opSalesOrderVO.setDiscountOnHead(BigDecimal.valueOf(orderCreateVO.getOtherDiscount()));
		} else {
			opSalesOrderVO.setDiscountOnHead(BigDecimal.ZERO);
		}

		// 是否匿名
		opSalesOrderVO.setIsAnonymous(
				orderCreateVO.getAnonymous() ? OpSalesOrder.IS_ANONYMOUS_TRUE : OpSalesOrder.IS_ANONYMOUS_FALSE);

		opSalesOrderVO.setStockDistinguish(orderCreateVO.getStockDistinguish());
		// 预售拆包裹
		final List<OpSoPackageVO> splitPackages = splitPackage2(opSalesOrderVO, opChannel, sPresaleMap,
				sPresaleSaleInvMap, opSalesOrderVO.getOpSoPackageVOs().get(0));
		if (CollectionUtils.isNotEmpty(splitPackages)) {
			opSalesOrderVO.setOpSoPackageVOs(splitPackages);
		}

		return opSalesOrderVO;
	}

	/***
	 * 外部订单为通用订单对象
	 */
	public OpSalesOrderVO orderWebsite2CommonIPOS(final OrderCreateVO orderCreateVO, AccessWayEnum accessWay,
			MemberVO member, OpChannelVO opChannel, Map<String, SPresaleVO> sPresaleMap,
			Map<String, SPresaleSaleInvVO> sPresaleSaleInvMap) {

		// 订单VO
		final OpSalesOrderVO opSalesOrderVO = new OpSalesOrderVO();
		opSalesOrderVO.setDeviceId(orderCreateVO.getDeviceId());
		opSalesOrderVO.setServiceFeeAmount(BigDecimal.ZERO);
		opSalesOrderVO.setCarriage(BigDecimal.ZERO);
		opSalesOrderVO.setCustomizationAmount(BigDecimal.ZERO);
		opSalesOrderVO.setCustomizationDiscount(BigDecimal.ZERO);
		opSalesOrderVO.setCrossFree(BigDecimal.ZERO);
		opSalesOrderVO.setLimitFee(BigDecimal.ZERO);
		opSalesOrderVO.setUtmSource(orderCreateVO.getUtmSource());
		opSalesOrderVO.setBirthFlowerUse(orderCreateVO.isBirthFlowerUse());
		opSalesOrderVO.setCreateOperatorId(orderCreateVO.getCreateOperatorId());
		opSalesOrderVO.setCreateOperatorName(orderCreateVO.getCreateOperatorName());
		// opSalesOrderVO.setOrderType(orderCreateVO.getOrderType());
		opSalesOrderVO.setTradeNo(orderCreateVO.getTradeNo());
		opSalesOrderVO.setTbsClient(orderCreateVO.getTbsClient());
		opSalesOrderVO.setTbsUSource(orderCreateVO.getTbsUSource());
		opSalesOrderVO.setPlatForm(orderCreateVO.getPlatForm());
		if (orderCreateVO.getMarketVip() != null) {
			opSalesOrderVO.setActivityId(orderCreateVO.getMarketVip().getActivityId());
			opSalesOrderVO.setVipCardNo(orderCreateVO.getMarketVip().getVipCardNo());
		}

		// 如果不存在操作员，判断是不是小程序引导过来的
		if (opSalesOrderVO.getCreateOperatorId() == null || opSalesOrderVO.getCreateOperatorId() <= 0) {
			if (StringUtils.isNotBlank(opSalesOrderVO.getTbsUSource())) {

				String[] args = opSalesOrderVO.getTbsUSource().split("_");
				// 线下导流
				if ("xxdl".equals(args[0])) {
					OpSales opSales = poInstance.findSaleById(Long.valueOf(args[1]));
					if (opSales != null) {
						opSalesOrderVO.setCreateOperatorId(opSales.getId());
						opSalesOrderVO.setCreateOperatorName(opSales.getSalesName());
					}

				}

			}

		}

		// NORMAL("01", "普通订单")
		if (orderCreateVO.getOrderBusinessType() == null
				|| OrderBusinessType.NORMAL.getCode().equals(orderCreateVO.getOrderBusinessType())) {

			opSalesOrderVO.setOrderTypeEnum(OrderTypeEnum.ORDERTYPE_0);

		} else if (OrderBusinessType.MONTHLY_FLOWER.getCode().equals(orderCreateVO.getOrderBusinessType().getCode())) {
			opSalesOrderVO.setOrderTypeEnum(OrderTypeEnum.ORDERTYPE_1);

		} else if (OrderBusinessType.CUSTOMIZE.getCode().equals(orderCreateVO.getOrderBusinessType().getCode())) {
			opSalesOrderVO.setOrderTypeEnum(OrderTypeEnum.ORDERTYPE_4);

		} else if (OrderBusinessType.RECIPE_CUSTOMIZE.getCode()
				.equals(orderCreateVO.getOrderBusinessType().getCode())) {
			opSalesOrderVO.setOrderTypeEnum(OrderTypeEnum.ORDERTYPE_5);

		} else if (OrderBusinessType.SPD.getCode().equals(orderCreateVO.getOrderBusinessType().getCode())) {
			opSalesOrderVO.setOrderTypeEnum(OrderTypeEnum.ORDERTYPE_6);

		} else if (OrderBusinessType.JBR.getCode().equals(orderCreateVO.getOrderBusinessType().getCode())) {
			opSalesOrderVO.setOrderTypeEnum(OrderTypeEnum.ORDERTYPE_8);

		} else if (OrderBusinessType.GROUPON.getCode().equals(orderCreateVO.getOrderBusinessType().getCode())) {
			opSalesOrderVO.setOrderTypeEnum(OrderTypeEnum.ORDERTYPE_10);

		} else if (OrderBusinessType.EXCHANGE.getCode().equals(orderCreateVO.getOrderBusinessType().getCode())) {
			opSalesOrderVO.setOrderTypeEnum(OrderTypeEnum.ORDERTYPE_9);

		} else if (OrderBusinessType.DEPOSIT.getCode().equals(orderCreateVO.getOrderBusinessType().getCode())) {
			opSalesOrderVO.setOrderTypeEnum(OrderTypeEnum.ORDERTYPE_11);
		} else if (OrderBusinessType.FINAL.getCode().equals(orderCreateVO.getOrderBusinessType().getCode())) {
			opSalesOrderVO.setOrderTypeEnum(OrderTypeEnum.ORDERTYPE_12);
		} else {
			opSalesOrderVO.setOrderTypeEnum(OrderTypeEnum.ORDERTYPE_0);
		}

		opSalesOrderVO.setGroupbuy(orderCreateVO.isGroupbuy());
		opSalesOrderVO.setCode(orderCreateVO.getOrderCode());
		opSalesOrderVO.setPaymentType(orderCreateVO.getPaymentType());
		opSalesOrderVO.setTradeNo(orderCreateVO.getTradeNo());
		opSalesOrderVO.setPointOnLineDeduction(BigDecimal.ZERO);
		// 设置各项费用
		if (CollectionUtils.isNotEmpty(orderCreateVO.getPriceStepVOs())) {
			BigDecimal customizationDiscount = BigDecimal.ZERO;
			for (PrsPriceStepVO step : orderCreateVO.getPriceStepVOs()) {
				// 运费
				if (PriceType.POSTAGE.id.equals(step.getPriceType().getCode())
						|| PriceType.POSTAGE_FREE.id.equals(step.getPriceType().getCode())
						|| PriceType.POINTS_EXCHANGE_FREE.id.equals(step.getPriceType().getCode())
						|| PriceType.REMOTE_AREA_DELIVERY.id.equals(step.getPriceType().getCode())
						|| PriceType.POSTAGE_LOCAL.id.equals(step.getPriceType().getCode())
						|| PriceType.POSTAGE_STORE.id.equals(step.getPriceType().getCode())
						|| PriceType.POSTAGE_STORE_FREE.id.equals(step.getPriceType().getCode())) {
					opSalesOrderVO.setCarriage(opSalesOrderVO.getCarriage().add(step.getPriceChange()));
					// 海淘运费
				} else if (PriceType.OVERSEAS.id.equals(step.getPriceType().getCode())
						|| PriceType.OVERSEA_FREE.id.equals(step.getPriceType().getCode())) {
					opSalesOrderVO.setCrossFree(opSalesOrderVO.getCrossFree().add(step.getPriceChange()));
				} else if (PrsPriceTypeEnum.OVERSEAS.getCode().equals(step.getPriceType().getCode())
						|| PrsPriceTypeEnum.OVERSEA_FREE.getCode().equals(step.getPriceType().getCode())) {
					opSalesOrderVO.setCrossFree(opSalesOrderVO.getCrossFree().add(step.getPriceChange()));
				} else if (step.getPriceType().getCode() == PrsPriceTypeEnum.TIME.getCode()) {
					opSalesOrderVO.setLimitFee(opSalesOrderVO.getLimitFee().add(step.getPriceChange()));
					// 定制费用
				} else if (PrsPriceTypeEnum.CUSTOMIZE.getCode().equals(step.getPriceType().getCode())
						|| PrsPriceTypeEnum.CUSTOMIZE_FREE.getCode().equals(step.getPriceType().getCode())) {
					if (step.getPriceChange().doubleValue() < 0) {
						customizationDiscount = customizationDiscount.add(step.getPriceChange());
					} else {
						opSalesOrderVO.setCustomizationAmount(
								opSalesOrderVO.getCustomizationAmount().add(step.getPriceChange()));
					}

					// 积分抵扣的金额
				} else if (PrsPriceTypeEnum.POINTS_EXCHANGE.getCode().equals(step.getPriceType().getCode())) {
					opSalesOrderVO.setPointOnLineDeduction(BigDecimal.ZERO.subtract(step.getPriceChange()));
				}

				if (PrsPriceTypeEnum.INTEREST_MEM_POSTAGE_FREE.getCode().equals(step.getPriceType().getCode())
						|| PrsPriceTypeEnum.INTEREST_PRD_POSTAGE_FREE.getCode().equals(step.getPriceType().getCode())) {
					if (orderCreateVO.getCrossBorderFlag() != null && orderCreateVO.getCrossBorderFlag() == 1) {

						opSalesOrderVO.setCrossFree(opSalesOrderVO.getCrossFree().add(step.getPriceChange()));

					} else {
						opSalesOrderVO.setCarriage(opSalesOrderVO.getCarriage().add(step.getPriceChange()));
					}
				}

			}

			opSalesOrderVO.setCustomizationDiscount((BigDecimal.ZERO.subtract(customizationDiscount)));

		}

		opSalesOrderVO.setUseBdayDiscount(orderCreateVO.isUseBdayDiscount());
		// 设置权益Id
		if (orderCreateVO.getInterestsVO() != null) {
			opSalesOrderVO.setInterestsId(String.valueOf(orderCreateVO.getInterestsVO().getId()));
		}

		// APP下载来源
		opSalesOrderVO.setDownloadSource(orderCreateVO.getDownloadSource());

		// 包裹VO
		final List<OpSoPackageVO> opSoPackageVOs = new ArrayList<>();
		// 设置第三方渠道 cps
		if (null != orderCreateVO.getCpsInfo()
				&& StringUtils.isNotBlank(orderCreateVO.getCpsInfo().getCpsChannelName())) {
			opSalesOrderVO.setCpsInfo(orderCreateVO.getCpsInfo());
		}

		// 包裹地址信息
		final OpSoPackageDeliveryInfoVO opSoPackageDeliveryInfoVO = new OpSoPackageDeliveryInfoVO();
		// 包裹sku信息
		final List<OpSoPackageSkuVO> opSoPackageSkuVOs = new ArrayList<>();

		// 校验价格
		// 校验库存
		// 校验是否下架
		opSalesOrderVO.setActualPayFee(orderCreateVO.getActualPayFee());
		// 订单来源渠道编码
		opSalesOrderVO.setChannelCode(orderCreateVO.getChannelCode());
		// 会员id
		if (member != null) {
			opSalesOrderVO.setMemberId(member.getId());
			// 会员code
			opSalesOrderVO.setMemberCode(member.getCode());
		}

		// ztq 20160505 身份证信息保存 start
		final Integer crossBorderFlag = orderCreateVO.getCrossBorderFlag();
		if (crossBorderFlag != null && crossBorderFlag != OrderCreateVO.CROSS_BOARDER_FLAG_NOT_OVERSEA) {

			// opSalesOrderVO.setCrossFree(orderCreateVO.getCrossFree());
			opSalesOrderVO.setCrossBorderFlag(orderCreateVO.getCrossBorderFlag());
			if (orderCreateVO.getIdCardVO() != null) {

				final OpIdCardVO opIdCardVO = new OpIdCardVO();

				opIdCardVO.setBackCardPhoto(orderCreateVO.getIdCardVO().getBackCardPhoto());
				opIdCardVO.setFrontCardPhoto(orderCreateVO.getIdCardVO().getFrontCardPhoto());
				opIdCardVO.setIdNumber(orderCreateVO.getIdCardVO().getIdNumber());
				opIdCardVO.setName(orderCreateVO.getIdCardVO().getName());
				opIdCardVO.setAuditStatus(orderCreateVO.getIdCardVO().getAuditStatus());
				opIdCardVO.setImgStatus(orderCreateVO.getIdCardVO().getImgStatus());
				opIdCardVO.setId(orderCreateVO.getIdCardVO().getId());
				opSalesOrderVO.setOpIdCardVO(opIdCardVO);
			}
		} else {
			opSalesOrderVO.setCrossBorderFlag(OrderCreateVO.CROSS_BOARDER_FLAG_NOT_OVERSEA);
			opSalesOrderVO.setCrossFree(BigDecimal.ZERO);
		}
		// ztq 20160505 身份证信息保存 end

		// 预期发货时间
		// 内部备注
		opSalesOrderVO.setInnerRemark(orderCreateVO.getInnerRemark());
		// 设置订单来源 refer
		opSalesOrderVO.setRefer(orderCreateVO.getRefer());
		opSalesOrderVO.setIsForceAudit(PegasusConstants.NO);

		final Map<String, Boolean> deliveryTypes = new HashMap<>();

		List<PsSkuVO> skuVOs = new ArrayList<>();
		Map<String, Integer> skuCountMap = new HashMap<>();

		Map<String, List<OpSoPackageSkuVO>> packageSkusMap = new HashMap<>();
		// 设置包裹
		setOpSoPackagesIPOS(orderCreateVO, deliveryTypes, opSoPackageSkuVOs, member, opSalesOrderVO, opChannel,
				accessWay, skuVOs, skuCountMap, packageSkusMap);

		// 发票是否随同货物发送，0否1是
		opSalesOrderVO.setIsInvoiceInSamePackage(OpSalesOrder.IS_INVOICE_IN_SAME_PACKAGE_FALSE);

		// @auhtor lijing start
		// 是否需要发票
		opSalesOrderVO.setNeedInvoice(orderCreateVO.getNeedInvoice());
		if (orderCreateVO.getIsInvoiceInSamePackage() == null) {
			opSalesOrderVO.setIsInvoiceInSamePackage(OpSalesOrder.IS_INVOICE_IN_SAME_PACKAGE_FALSE);
		} else {
			opSalesOrderVO.setIsInvoiceInSamePackage(orderCreateVO.getIsInvoiceInSamePackage());
		}
		// 判断发票是否同货物发送
		// 设置发票
		if (orderCreateVO.getNeedInvoice() != null
				&& orderCreateVO.getNeedInvoice() == OrderCreateVO.NEED_INVOICE_TRUE) {
			logger.info("设置发票 orderCreateVO.getSoInvoiceInfoVO={}", orderCreateVO.getSoInvoiceInfoVO());
			final OpSoInvoiceInfoVO1 opSoInvoiceInfo = new OpSoInvoiceInfoVO1();
			final SoInvoiceInfoVO soInvoiceInfoVO = orderCreateVO.getSoInvoiceInfoVO();
			if (soInvoiceInfoVO != null) {
				logger.info("设置发票 ");
				opSoInvoiceInfo.setInnerRemark(soInvoiceInfoVO.getInnerRemark());
				opSoInvoiceInfo.setAddress(soInvoiceInfoVO.getAddress());
				opSoInvoiceInfo.setDistrictId(soInvoiceInfoVO.getDistrictId());
				opSoInvoiceInfo.setInvoiceType(soInvoiceInfoVO.getInvoiceType());
				opSoInvoiceInfo.setInvoiceTitle(soInvoiceInfoVO.getInvoiceTitle());
				opSoInvoiceInfo.setInvoiceAmount(soInvoiceInfoVO.getInvoiceAmount());
				opSoInvoiceInfo.setReceiver(soInvoiceInfoVO.getReceiver());
				opSoInvoiceInfo.setReceiverPhone(soInvoiceInfoVO.getReceiverPhone());
				opSoInvoiceInfo.setInvoiceStatus(soInvoiceInfoVO.getInvoiceStatus());
				opSoInvoiceInfo.setApplyTime(soInvoiceInfoVO.getApplyTime());
				opSoInvoiceInfo.setApplyOperatorId(soInvoiceInfoVO.getApplyOperatorId());
				opSoInvoiceInfo.setApplyOperatorName(soInvoiceInfoVO.getApplyOperatorName());
				opSoInvoiceInfo.setIsEmergency(soInvoiceInfoVO.getIsEmergency());
				opSalesOrderVO.setSoInvoiceInfoVO(opSoInvoiceInfo);
			}
		}

		// 设置配送信息的快递方式，当只有一种配送方式时，设置
		if (deliveryTypes.size() == 1) {
			if (deliveryTypes.get("SELF") != null && deliveryTypes.get("SELF")) {
				opSoPackageDeliveryInfoVO.setExpressType(OpSoPackageDeliveryInfo.EXPRESS_TYPE_SHOP);
			} else if (deliveryTypes.get("FEDX24") != null && deliveryTypes.get("FEDX24")) {
				opSoPackageDeliveryInfoVO.setExpressType(OpSoPackageDeliveryInfo.EXPRESS_TYPE_FEDEX);
			} else if (deliveryTypes.get("SF_AIR") != null && deliveryTypes.get("SF_AIR")) {
				opSoPackageDeliveryInfoVO.setExpressType(OpSoPackageDeliveryInfo.EXPRESS_TYPE_SF_AIR);
			} else if (deliveryTypes.get("SF_LAND") != null && deliveryTypes.get("SF_LAND")) {
				opSoPackageDeliveryInfoVO.setExpressType(OpSoPackageDeliveryInfo.EXPRESS_TYPE_SF_LAND);
			} else if (deliveryTypes.get("YTO") != null && deliveryTypes.get("YTO")) {
				opSoPackageDeliveryInfoVO.setExpressType(OpSoPackageDeliveryInfo.EXPRESS_TYPE_YTO);
			} else if (deliveryTypes.get("DEPPON") != null && deliveryTypes.get("DEPPON")) {
				opSoPackageDeliveryInfoVO.setExpressType(OpSoPackageDeliveryInfo.EXPRESS_TYPE_DEPPON);
			} else if (deliveryTypes.get("ZT") != null && deliveryTypes.get("ZT")) {
				opSoPackageDeliveryInfoVO.setExpressType(OpSoPackageDeliveryInfo.EXPRESS_TYPE_ZT);
			}
		}

		if (orderCreateVO.getDeliveryAddress() != null) {
			// 设置配送地址
			final AddressVO address = orderCreateVO.getDeliveryAddress();
			// 详细地址
			opSoPackageDeliveryInfoVO.setAddress(address.getStreet());
			// 环线
			opSoPackageDeliveryInfoVO.setCircuitDesc(address.getCircuit());
			// 公司名称
			opSoPackageDeliveryInfoVO.setCompanyName(address.getCompanyName());
			// 收货的区县ID
			opSoPackageDeliveryInfoVO.setDistrictId(address.getDistrictId());
			// 收件人
			opSoPackageDeliveryInfoVO.setReceiver(address.getName());
			// 邮编
			opSoPackageDeliveryInfoVO.setZipCode(address.getZip());
			// 称谓
			opSoPackageDeliveryInfoVO.setTitle(address.getMagentoTitle());
			// 收件人电话
			opSoPackageDeliveryInfoVO.setReceiverPhone(address.getPhone());
			opSoPackageDeliveryInfoVO.setOpenId(address.getOpenId());

		}

		// 服务费
		// opSalesOrderVO.setServiceFeeAmount(BigDecimal.valueOf(orderCreateVO.getServiceFee()));

		// 用户备注
		opSalesOrderVO.setRemark(orderCreateVO.getNote());
		// 订单类型，1渠道销售单2渠道退货单3渠道换货单4集团订单11礼品订单12样品订单
		opSalesOrderVO.setSalesOrderType(OpSalesOrder.ORDER_TYPE_SALES);

		opSalesOrderVO.setCouponCode(orderCreateVO.getCouponCode());

		// 礼品卡金额
		if (CollectionUtils.isNotEmpty(orderCreateVO.getOpSalesOrderGiftCardVOs())) {

			StringBuilder builder = new StringBuilder();
			BigDecimal totail = BigDecimal.ZERO;

			for (OpSalesOrderGiftCardVO vo : orderCreateVO.getOpSalesOrderGiftCardVOs()) {
				totail = totail.add(vo.getGiftCardValue());
				builder.append("no:" + vo.getGiftCardNo());
				builder.append("&fee:" + vo.getGiftCardValue().multiply(BigDecimal.valueOf(100)));
				builder.append("|");
			}

			logger.info("礼品卡内容：" + builder.toString());
			logger.info("礼品卡消费金额：" + totail);
			opSalesOrderVO.setOpSalesOrderGiftCardVOs(orderCreateVO.getOpSalesOrderGiftCardVOs());
			opSalesOrderVO.setGiftCardDesc(builder.toString());
			opSalesOrderVO.setGiftCardAmount(totail);

		} else {
			opSalesOrderVO.setGiftCardAmount(BigDecimal.ZERO);
		}

		// 头折扣
		if (orderCreateVO.getOtherDiscount() != null) {
			opSalesOrderVO.setDiscountOnHead(BigDecimal.valueOf(orderCreateVO.getOtherDiscount()));
		} else {
			opSalesOrderVO.setDiscountOnHead(BigDecimal.ZERO);
		}

		// 是否匿名
		opSalesOrderVO.setIsAnonymous(
				orderCreateVO.getAnonymous() ? OpSalesOrder.IS_ANONYMOUS_TRUE : OpSalesOrder.IS_ANONYMOUS_FALSE);

		// opSalesOrderVO.setStockDistinguish(orderCreateVO.getStockDistinguish());

		List<OpSoPackageVO> splitPackages = new ArrayList<>();
		Date planedDeliveryDate = new Date();
		if (packageSkusMap.size() > 0) {

			Calendar c = Calendar.getInstance();

			int hour = c.get(Calendar.HOUR_OF_DAY);

			int minute = c.get(Calendar.MINUTE);

			if (hour > 16 || (hour == 16 && minute > 0)) {
				planedDeliveryDate = DateUtil.addDay(new Date(), 1);

			}
			for (List<OpSoPackageSkuVO> beans : packageSkusMap.values()) {
				// 创建一个包裹
				OpSoPackageVO opSoPackage = new OpSoPackageVO();
				// 卡片类型，0不需要1空白2代写
				opSoPackage.setCardType(orderCreateVO.getNoteCard());
				// 卡片内容
				opSoPackage.setCardContent(orderCreateVO.getNoteCardMessage());
				opSoPackage.setCardTo(orderCreateVO.getNoteCardTo());
				opSoPackage.setCardFrom(orderCreateVO.getNoteCardFrom());
				// 配送方式
				opSoPackage.setDeliveryType(beans.get(0).getDeliveryType());
				// 限时配送
				opSoPackage.setLimitDeliveryTimeDesc(orderCreateVO.getLimitedHour());
				opSoPackage.setOpSoPackageSkuVOs(beans);
				// 设置包裹配送信息
				opSoPackage.setOpSoPackageDeliveryInfoVO(opSoPackageDeliveryInfoVO);

				if (beans.get(0).getDeliveryDate() != null) {
					opSoPackage.setExpectReceiveDate(beans.get(0).getDeliveryDate());
				}

				opSoPackage.setPlanedDeliveryDate(planedDeliveryDate);

				opSoPackage.setDispatchWarehouseCode(beans.get(0).getWarehouseCode());

				// 商品拆包裹
				splitPackages
						.addAll(splitPackage2(opSalesOrderVO, opChannel, sPresaleMap, sPresaleSaleInvMap, opSoPackage));

				opSoPackageVOs.add(opSoPackage);
			}

		}

		// 设置订单关联包裹
		opSalesOrderVO.setOpSoPackageVOs(opSoPackageVOs);

		if (CollectionUtils.isNotEmpty(splitPackages)) {
			opSalesOrderVO.setOpSoPackageVOs(splitPackages);
		}

		return opSalesOrderVO;
	}

	private boolean setOpSoPackages(OrderCreateVO orderCreateVO, Map<String, Boolean> deliveryTypes,
			List<OpSoPackageSkuVO> opSoPackageSkuVOs, MemberVO member, OpSalesOrderVO opSalesOrderVO,
			final OpChannelVO opChannel, AccessWayEnum accessWay, List<PsSkuVO> psSkuVOs,
			Map<String, Integer> skuCountMap) {

		// 抢购
		List<CampaignStreamVO> panicVos = Lists.newArrayList();
		// 换购或买赠
		// List<CampaignStreamVO> vos = Lists.newArrayList();
		Map<String, CampaignStreamVO> voMap = Maps.newHashMap();
		
		List<CampaignStreamVO> priceDiscountVos = Lists.newArrayList();

		// 统计生日优惠金额
		Map<Long, BigDecimal> birthdayDisMap = new HashMap<>();
		// 统计优惠卷金额
		Map<Long, BigDecimal> couponDisMap = new HashMap<>();

		Map<Long, BigDecimal> couponDisMap2 = new HashMap<>();

		if (member != null && StringUtils.isNotBlank(orderCreateVO.getPresentCards())) {
			member.setMemberLevel(0);
		}

		Map<String, PrsCampaignVO> campaingnMap = getSpvCampaignVO(orderCreateVO.getSpvSteps(),
				orderCreateVO.getPriceStepVOs(), birthdayDisMap, couponDisMap, couponDisMap2);

		// 避免循环调用一次性取出
		List<Long> spvIds = new ArrayList<>();

		List<String> prodIds = new ArrayList<>();

		List<String> skuCodes = new ArrayList<>();
		// 设置需要处理的限量商品
		Map<String, OpLimitSkuVO> redisOpLimitSkuVOMaps = new HashMap<>();

		Map<String, OpLimitSkuVO> opLimitSkuVOMap = new HashMap<>();

		// 判断是否有根据城市限量的商品
		String cityLimitSkus = PropConstants.getProperties("cityLimitSkus", "");
		// 存在需要判断地区库存的商品
		if (StringUtils.isNotBlank(cityLimitSkus) && orderCreateVO.getDeliveryAddress() != null
				&& orderCreateVO.getDeliveryAddress().getDistrictId() != null) {

			List<OpLimitSkuVO> opLimitSkuVOs = JSON.parseArray(cityLimitSkus, OpLimitSkuVO.class);
			if (CollectionUtils.isNotEmpty(opLimitSkuVOs)) {
				// 根据渠道查询商品
				CommDistrictVO district = commAddressService.findDistrictById(orderCreateVO.getDeliveryAddress().getDistrictId().intValue());

				if (district != null) {
					for (OpLimitSkuVO bean : opLimitSkuVOs) {

						if (bean.getCity() != null) {
							if (bean.getCity().equals(String.valueOf(district.getCityId()))) {
								bean.setName(district.getFullName());
								opLimitSkuVOMap.put(bean.getSkuCode(), bean);

							}
						}

					}
				}

			}

		}

		// 定制商品
		List<String> customizationSkus = new ArrayList<>();
		for (CartProductPack ppVO : orderCreateVO.getPacks()) {

			if (ppVO.getSpvId() != null) {
				if (!spvIds.contains(ppVO.getSpvId())) {
					spvIds.add(ppVO.getSpvId());
				}
			}

			if (ppVO.getSpv().getCombined()) {

				if (CollectionUtils.isNotEmpty(ppVO.getSpv().getSkuCombinationList())) {

					// 取出所有skuCode
					for (PsSkuCombinationVO bean : ppVO.getSpv().getSkuCombinationList()) {
						if (opChannel.getChannelType() != null && opChannel.getChannelType() == 2) {
							if (opLimitSkuVOMap.size() > 0) {

								OpLimitSkuVO opLimitSkuVo = opLimitSkuVOMap.get(bean.getSubSkuCode());
								if (opLimitSkuVo != null) {
									// 如果购买数大买总数量
									if (bean.getQuantity() > opLimitSkuVo.getTotalQuantity()) {
										throw new ChannelException(ErrorCode.PARAMS_ILLEGAL.getCode(),
												opLimitSkuVo.getName() + '的' + bean.getSubSkuCode() + "库存不足。");
									}

									opLimitSkuVo.setQuantity(bean.getQuantity());

									OpLimitSkuVO redisOpLimitSkuVO = redisOpLimitSkuVOMaps.get(bean.getSubSkuCode());

									if (redisOpLimitSkuVO != null) {
										redisOpLimitSkuVO
												.setQuantity(redisOpLimitSkuVO.getQuantity() + bean.getQuantity());
									} else {

										opLimitSkuVo.setRedisKey(
												"limit_" + opLimitSkuVo.getCity() + "_" + opLimitSkuVo.getSkuCode());
										redisOpLimitSkuVOMaps.put(bean.getSubSkuCode(), opLimitSkuVo);
									}

								}

							}
						}

						if (bean.getSubSkuCode() != null) {
							if (!skuCodes.contains(bean.getSubSkuCode())) {
								skuCodes.add(bean.getSubSkuCode());
								if (ppVO.getProduct().getExpressType() == 1
										|| ppVO.getProduct().getExpressType() == 2) {
									skuCountMap.put(bean.getSubSkuCode(), bean.getQuantity());
								}

							}
						}

					}

				}

			} else {
				if (opChannel.getChannelType() != null && opChannel.getChannelType() == 2) {
					if (opLimitSkuVOMap.size() > 0) {

						OpLimitSkuVO opLimitSkuVo = opLimitSkuVOMap.get(ppVO.getSpv().getSkuCode());
						if (opLimitSkuVo != null) {
							// 如果购买数大买总数量
							if (ppVO.getCount() > opLimitSkuVo.getTotalQuantity()) {
								throw new ChannelException(ErrorCode.PARAMS_ILLEGAL.getCode(),
										opLimitSkuVo.getName() + '的' + ppVO.getSpv().getSkuCode() + "库存不足。");
							}

							opLimitSkuVo.setQuantity(ppVO.getCount());

							OpLimitSkuVO redisOpLimitSkuVO = redisOpLimitSkuVOMaps.get(ppVO.getSpv().getSkuCode());

							if (redisOpLimitSkuVO != null) {
								redisOpLimitSkuVO.setQuantity(redisOpLimitSkuVO.getQuantity() + ppVO.getCount());
							} else {

								opLimitSkuVo.setRedisKey(
										"limit_" + opLimitSkuVo.getCity() + "_" + opLimitSkuVo.getSkuCode());
								redisOpLimitSkuVOMaps.put(ppVO.getSpv().getSkuCode(), opLimitSkuVo);
							}

						}

					}
				}

				if (ppVO.getSpv().getSkuCode() != null) {
					if (!skuCodes.contains(ppVO.getSpv().getSkuCode())) {
						skuCodes.add(ppVO.getSpv().getSkuCode());
						if (ppVO.getProduct().getExpressType() == 1 || ppVO.getProduct().getExpressType() == 2) {
							skuCountMap.put(ppVO.getSpv().getSkuCode(), ppVO.getCount());
						}

					}

				}
			}

		}

		// 设置需要操作redis的对像值
		opSalesOrderVO.setRedisOpLimitSkuVOMaps(redisOpLimitSkuVOMaps);

		int mbmLevel = -1;
		if (member != null) {
			mbmLevel = member.getMemberLevel();
		}

		// 价格计算
		PsMatchCampaignCond cond = new PsMatchCampaignCond();
		cond.setAccessWay(accessWay.getCode());
		cond.setMemberLevel(mbmLevel);
		MemberLevelEnum memberLevel = MemberLevelEnum.getEnumByCode(mbmLevel);
		cond.setDiscount(memberLevel.getLevelAmountCondition());
		cond.setMatchCampaign(true);
		cond.setChannelCode(opChannel.getCode());

		Map<Long, PsSpvVO> psSpvVOMap = mcPsSpvService.mapBySpvIds(spvIds, cond);
		Map<String, PsSkuVO> psSkuVOMap = new HashMap<>();
		Map<String, PsProductVO> prodMap = new HashMap<>();
		if (psSpvVOMap != null) {
			for (PsSpvVO spv : psSpvVOMap.values()) {
				if (spv.getProductId() != null) {
					if (!prodIds.contains(spv.getProductId().toString())) {
						prodIds.add(spv.getProductId().toString());
					}

				}

			}

			PsProductCond prodCond = new PsProductCond();
			prodCond.setChannelCode(opChannel.getCode());
			prodCond.setIds(prodIds);
			prodCond.setPagenum(prodIds.size());
			List<PsProductVO> prods = mcPsProductService.findByCond(prodCond);
			if (CollectionUtils.isNotEmpty(prods)) {
				for (PsProductVO psProd : prods) {
					prodMap.put(psProd.getId(), psProd);
				}

			}

		}
		List<PsSkuVO> skuVOs = mcPsSkuService.findBySkuCodes(skuCodes);

		if (CollectionUtils.isNotEmpty(skuVOs)) {

			psSkuVOs.addAll(skuVOs);
			for (PsSkuVO vo : skuVOs) {
				psSkuVOMap.put(vo.getSkuCode(), vo);

				// 来单制作并且是定制商品
				if (vo.getIsJit() != null && vo.getIsJit() == 1 && vo.getCanCustomize() != null
						&& vo.getCanCustomize() == 1) {
					customizationSkus.add(vo.getSkuCode());
				}

			}
		}
		Map<String, WhRecipeInvVO> whReipeInvVOMaps = new HashMap<>();
		if (customizationSkus.size() > 0) {
			whReipeInvVOMaps.putAll(
					sPrdcJobService.caculateRecipeAmountForAssemble(customizationSkus, opChannel.getWarehouseForSales()));
		}

		BigDecimal customizePrice = opSalesOrderVO.getCustomizationAmount()
				.subtract(opSalesOrderVO.getCustomizationDiscount());

		Map<Long, List<CartProductPack>> giftMap = orderCreateVO.getGiftPackMap();

		Map<Long, String> addiblePacks = orderCreateVO.getAddiblePacks();

		Map<Long, PrsSpvPriceStepVO> discountTypeSpvPriceStepMap = new HashMap<>();
		Map<Long, PrsSpvPriceStepVO> pointSpvPriceStepMap = new HashMap<>();
		// 从价格步骤取得积分
		spvPriceStepMap(orderCreateVO.getSpvSteps(), pointSpvPriceStepMap,discountTypeSpvPriceStepMap);
		// 配送方式，判断是否需要强制审单
		for (final CartProductPack ppVO : orderCreateVO.getPacks()) {
			final OpSoPackageSkuVO packageSku = new OpSoPackageSkuVO();

			if (CartPackSource.GIFT.id.equals(ppVO.getSource().getCode())) {
				// 判断是不是没有主品
				logger.info("赠品spvId:" + ppVO.getSpvId());
				continue;

			} else if (ppVO.getSpv().getCombined()) {
				// combinationProd(opSoPackageSkuVOs, opSalesOrderVO, opChannel,
				// deliveryTypes, ppVO, birthdayDisMap,
				// couponDisMap, voMap, couponDisMap2, psSkuVOMap, giftMap,
				// campaingnMap, null, orderCreateVO);

				combinationProd(opSoPackageSkuVOs, opSalesOrderVO, opChannel, orderCreateVO.getChannelCode(),
						deliveryTypes, ppVO, birthdayDisMap, couponDisMap, voMap, couponDisMap2, psSkuVOMap, giftMap,
						campaingnMap);

				continue;
				// 如果是赠品
			} else {
				String skuCode = ppVO.getSpv().getSkuCode();

				int discountType = 0;

				PsSpvVO psSpvVO = psSpvVOMap.get(ppVO.getSpvId());

				if (psSpvVO == null) {
					throw new ChannelException(ErrorCode.PARAMS_ILLEGAL.getCode(), "商品spvId查不到商品：" + ppVO.getSpvId());
				}

				PsProductVO productVO = prodMap.get(psSpvVO.getProductId().toString());
				if (productVO == null) {
					throw new ChannelException(ErrorCode.PARAMS_ILLEGAL.getCode(),
							"商品prodId查不到商品：" + psSpvVO.getProductId());
				}
				PsSkuVO skuVO = psSkuVOMap.get(skuCode);

				if (ppVO.getSource() != null) {
					logger.info("该商品相关信息：source:" + ppVO.getSource().getName());
				}

				if (ppVO.getSource().getCode() != CartPackSource.ADDIBLE.getId()
						&& !CartPackSource.BENEFIT.id.equals(ppVO.getSource().getCode())) {

					if (CollectionUtils.isEmpty(productVO.getChnCanSaleSKu())
							|| !productVO.getCanSaleSku(orderCreateVO.getChannelCode()).contains(skuCode)) {
						throw new ChannelException(ErrorCode.ITEM_OFFSHELF.getCode(), "商品不可售 " + skuCode);
					}
				}

				logger.info("检查限量商品开始------------>");
				// 抢购不支付组合商品
				if (CollectionUtils.isNotEmpty(psSpvVO.getCampaignList())) {

					for (PsCampaignVO campaign : psSpvVO.getCampaignList()) {
						if (campaign.getDiscountTypeId() == DiscountType.PANIC_BUY.getId()) {
							// 判断当前抢购商品是否限购
							if (campaign.getLimitAmount() != null && campaign.getLimitAmount() > 0) {
								// 一次购买
								if (ppVO.getCount() > campaign.getLimitAmount()) {
									throw new ChannelException(ErrorCode.ITEM_OUTOF_QUANTITY.getCode(),
											skuVO.getSkuNameCN() + ",超过单个用户抢购数量，只允许购买：" + campaign.getLimitAmount());
								}
							}
							// if (campaign.getPanicBuyAmount() != null &&
							// campaign.getPanicBuyAmount() == -1) {
							// panicBuy = false;
							// } else {
							discountType = DiscountType.PANIC_BUY.getId();
							// packageSku.setPanicBuyCode(campaign.getCode());
							packageSku.setCampignCode(campaign.getCode());
							packageSku.setDiscountType(discountType);

							// 判断当前抢购商品是否限购
							if (campaign.getLimitAmount() != null && campaign.getLimitAmount() > 0) {

								if (member != null) {
									CampaignStreamVO vo = new CampaignStreamVO();
									vo.setCampaignCode(packageSku.getCampignCode());
									vo.setMemberCode(member.getCode());

									vo.setSkuCode(skuCode);
									final ServiceResp<Integer> rlt = campaignLimitService.getPanicPerUserLeftAmount(vo);
									rlt.checkError(new RespCallback() {
										@Override
										public void call(String arg0, String arg1, Map<String, Object> arg2) {
											throw new ChannelException(ErrorCode.ITEM_OUTOF_QUANTITY.getCode(),
													rlt.getRespMsg());
										}
									});

									if (rlt.getBean() == null || ppVO.getCount() > rlt.getBean()) {
										throw new ChannelException(ErrorCode.ITEM_OUTOF_QUANTITY.getCode(),
												skuVO.getSkuNameCN() + "超过单个用户购买数量，只允许购买：" + rlt.getBean());
									}
								}

								packageSku.setLimitAmount(campaign.getLimitAmount());
								packageSku.setStartTime(
										DateUtil.format(campaign.getStartTime(), DateUtil.DEFAULT_DATETIME_FORMAT));
								packageSku.setExpireTime(
										DateUtil.format(campaign.getExpireTime(), DateUtil.DEFAULT_DATETIME_FORMAT));
								// packageSku.setPanicBuyAmount(campaign.getPanicBuyAmount());
							}
							// }

							break;
							// 拼团活动
						} else if (campaign.getDiscountTypeId() == DiscountTypeEnum.GROUP_BUY.getId()) {
							packageSku.setCampignCode(campaign.getCode());
							packageSku.setDiscountType(discountType);
							// 评团设为8类型
							packageSku.setSourceId(OpSoPackageSku.SOURCEID_GROUP);

						}else if (DiscountTypeEnum.PRICE_DISCOUNT.getId().equals(campaign.getDiscountTypeId()) && MemberTypeEnum.NEW_MEMBER.getCode().equalsIgnoreCase(campaign.getMemberType())){
							
							PrsSpvPriceStepVO pspStep = discountTypeSpvPriceStepMap.get(ppVO.getSpvId());
							logger.info("折扣限量商品sku ：:" +skuCode);
							
							if(pspStep !=null){
								if(DiscountTypeEnum.PRICE_DISCOUNT.getId().equals(pspStep.getDiscountType().getId())){
									CampaignStreamVO campaignStreamVO = new CampaignStreamVO();
									campaignStreamVO.setCampaignCode(campaign.getCode());
									
									if(member != null){
										campaignStreamVO.setMemberCode(member.getCode());
									}
									
									campaignStreamVO.setProductCode(productVO.getCode());
									campaignStreamVO.setSkuCode(skuCode);
									campaignStreamVO.setQuantity(ppVO.getCount());
									priceDiscountVos.add(campaignStreamVO);
									
									packageSku.setCampignCode(campaign.getCode());
									packageSku.setDiscountType(DiscountType.OFF.getId());
								}
								
							}
							
						}
					}

				}

				// 判断是否是权益商品
				if (CartPackSource.BENEFIT.id.equals(ppVO.getSource().getCode())) {
					// packageSku.setInterestId(ppVO.getSourceBindVal());
					// if (interestMap != null) {
					packageSku.setCampignCode(ppVO.getSourceBindVal());
					// }

					packageSku.setSourceId(ppVO.getSource().getCode());
					// 0普通商品，1赠品，2权益商品
					packageSku.setIsGift(2);

					if (ppVO.getSpv().getSalesPrice() == null) {
						ppVO.getSpv().setSalesPrice(BigDecimal.ZERO);
					}

					if (ppVO.getSpv().getDiscountPrice() == null) {
						ppVO.getSpv().setDiscountPrice(BigDecimal.ZERO);
					}
					final BigDecimal unitDiscount = ppVO.getSpv().getSalesPrice()
							.subtract(ppVO.getSpv().getDiscountPrice());
					packageSku.setUnitDiscount(unitDiscount);

					// 折扣后金额
					packageSku.setUnitAmountAfterDiscount(ppVO.getSpv().getDiscountPrice());

					// final BigDecimal unitDiscount =
					// ppVO.getSpv().getSalesPrice().subtract(BigDecimal.ZERO);
					// packageSku.setUnitDiscount(unitDiscount);

					// 折扣后金额
					// packageSku.setUnitAmountAfterDiscount(BigDecimal.ZERO);

				} else {
					packageSku.setIsGift(0);// 底层暂不支持赠品

					if (ppVO.getSpv().getSalesPrice() == null) {
						ppVO.getSpv().setSalesPrice(BigDecimal.ZERO);
					}

					if (ppVO.getSpv().getDiscountPrice() == null) {
						ppVO.getSpv().setDiscountPrice(BigDecimal.ZERO);
					}
					final BigDecimal unitDiscount = ppVO.getSpv().getSalesPrice()
							.subtract(ppVO.getSpv().getDiscountPrice());
					packageSku.setUnitDiscount(unitDiscount);

					// 折扣后金额
					packageSku.setUnitAmountAfterDiscount(ppVO.getSpv().getDiscountPrice());
				}

				if (ppVO.getSpvId() == null) {
					PsSpvVO spvVo = mcPsSpvService.findSpvBySkuCode(productVO.getCode(), packageSku.getSkuCode());
					if (spvVo != null) {
						packageSku.setSpvId(spvVo.getSpvId());
					}

				} else {
					packageSku.setSpvId(ppVO.getSpvId());
				}

				if (packageSku.getSourceId() == null) {
					packageSku.setSourceId(ppVO.getSource().getCode());
				}

				packageSku.setProductCode(productVO.getCode());

				if (skuVO.getSalesPrice().compareTo(ppVO.getSpv().getSalesPrice().doubleValue()) != 0) {
					throw new ChannelException(ErrorCode.ITEM_PRICE_CHANGE.getCode(),
							ErrorCode.ITEM_PRICE_CHANGE.getMesage() + ": " + skuVO.getSkuCode() + " "
									+ skuVO.getSkuNameCN() + ": " + skuVO.getSalesPrice());
				}

				if ((skuVO.getIsJit() == null || PegasusConstants.NO == skuVO.getIsJit())
						&& CartPackSource.RAW.id.equals(ppVO.getSource().getCode())) {

					if (StringUtils.isNotEmpty(packageSku.getCampignCode())
							&& discountType == DiscountType.PANIC_BUY.getId()) {

						CampaignStreamVO vo = new CampaignStreamVO();
						vo.setCampaignCode(packageSku.getCampignCode());
						if (member != null) {
							vo.setMemberCode(member.getCode());
						}
						vo.setQuantity(ppVO.getCount());
						vo.setSkuCode(skuCode);
						panicVos.add(vo);

					}

				} else {

					// 判断是否是定制配方商品
					if (skuVO.getCanCustomize() != null && skuVO.getCanCustomize() == 1
							&& opChannel.getChannelType() != 1) {
						packageSku.setCustomizeType(skuVO.getCustomizeType());
						WhRecipeInvVO whRecipeInvVO = whReipeInvVOMaps.get(skuVO.getSkuCode());
						if (whRecipeInvVO != null && whRecipeInvVO.isRecipeExist() == true) {
							packageSku.setRecipeExist(whRecipeInvVO.isRecipeExist());
							if (whRecipeInvVO.getCanUseInv() < ppVO.getCount()) {
								logger.info("购买数量：{},实际数量：{}", ppVO.getCount(), whRecipeInvVO.getCanUseInv());
								throw new ChannelException(ErrorCode.ITEM_OUTOF_QUANTITY.getCode(),
										ErrorCode.ITEM_OUTOF_QUANTITY.getMesage() + ": " + skuVO.getSkuCode() + " "
												+ skuVO.getSkuNameCN());

							}

						}

					}

				}

				// JIT商品不校验库存
				packageSku.setWhetherLogistics(skuVO.getWhetherLogistics());
				packageSku.setWhetherVirtual(skuVO.getWhetherVirtual());

				packageSku.setWeight(skuVO.getWeight());
				packageSku.setTaxNo(skuVO.getTaxNo());

				packageSku.setClearanceWay(skuVO.getClearanceWay());
				// 跨境购标注 0普通１跨境购
				packageSku.setCrossBorderFlag(skuVO.getCrossBorderFlag());

				packageSku.setAddBy(OpSoPackageSku.ADDBY_MEMBER);// 默认会员添加
				packageSku.setSkuCode(skuVO.getSkuCode());

				// skuName
				packageSku.setNameCn(skuVO.getSkuNameCN());

				packageSku.setBrandId(skuVO.getBrandId());
				// packageSku.setCategroyId(skuVO.getCategoryId());

				// packageSku.setMainSkuCode(detail.getMainSkuId());
				packageSku.setIsJit(skuVO.getIsJit());// 是否来单制作
				packageSku.setQuantity(ppVO.getCount());// 数量
				// 商品分类
				packageSku.setCategoryId(skuVO.getCategoryId());

				if (skuVO.getCategoryId() != null) {

					if (opSalesOrderVO.getCategoryIds() != null) {

						if (!opSalesOrderVO.getCategoryIds().contains(skuVO.getCategoryId().intValue())) {
							opSalesOrderVO.getCategoryIds().add(skuVO.getCategoryId().intValue());

						}

					} else {

						List<Integer> categoryIds = new ArrayList<>();
						categoryIds.add(skuVO.getCategoryId().intValue());
						opSalesOrderVO.setCategoryIds(categoryIds);
					}

				}

				// 代销
				packageSku.setWhetherConsignment(skuVO.getWhetherConsignment());
				// 判断是否包含两种以上配送方式，如果是，则需要强制审单
				final int expressType = productVO.getExpressType();
				packageSku.setExpressType(expressType);
				if (OpProduct.EP_TYPE_SELF == expressType) {
					deliveryTypes.put("SELF", true);
				} else if (OpProduct.EP_TYPE_FED == expressType) {
					deliveryTypes.put("FEDX24", true);
				} else if (OpProduct.EP_TYPE_Sf_AIR == expressType) {
					deliveryTypes.put("SF_AIR", true);
				} else if (OpProduct.EP_TYPE_Sf_LAND == expressType) {
					deliveryTypes.put("SF_LAND", true);
				} else if (OpProduct.EP_TYPE_YTO == expressType) {// 圆通
					deliveryTypes.put("YTO", true);
				} else if (OpProduct.EP_TYPE_DEPPON == expressType) {
					deliveryTypes.put("DEPPON", true);
				} else if (OpProduct.EP_TYPE_ZT == expressType) {
					deliveryTypes.put("ZT", true);
				}

				PrsSpvPriceStepVO prsSpvPriceStepVO = pointSpvPriceStepMap.get(ppVO.getSpv().getSpvId());
				if (opSalesOrderVO.getPointOnLine() == null) {
					opSalesOrderVO.setPointOnLine(BigDecimal.ZERO);
				}
				if (prsSpvPriceStepVO != null) {

					packageSku.setUnitPoint(new BigDecimal(prsSpvPriceStepVO.getPoints()));

					packageSku.setUnitPointDeduction(prsSpvPriceStepVO.getSpvSavedPrice());

					packageSku.setTotalPoint(
							new BigDecimal(prsSpvPriceStepVO.getPoints()).multiply(new BigDecimal(ppVO.getCount())));
					packageSku.setTotalPointDeduction(
							packageSku.getUnitPointDeduction().multiply(new BigDecimal(ppVO.getCount())));

					BigDecimal pointLine = opSalesOrderVO.getPointOnLine().add(packageSku.getTotalPoint());
					opSalesOrderVO.setPointOnLine(pointLine);
					opSalesOrderVO.setPointOnLineDeduction(
							opSalesOrderVO.getPointOnLineDeduction().add(packageSku.getTotalPointDeduction()));
				}

				packageSku.setUnitPrice(ppVO.getSpv().getSalesPrice());
				// if (orderCreateVO.getExchangeMap() != null) {
				// Integer point =
				// orderCreateVO.getExchangeMap().get(ppVO.getSpv().getSpvId());
				//
				// if (point != null) {
				// packageSku.setUnitPoint(new BigDecimal(point));
				// packageSku.setUnitPointDeduction(new
				// BigDecimal(point).divide(new BigDecimal(100)).setScale(2));
				// packageSku.setTotalPoint(new BigDecimal(point).multiply(new
				// BigDecimal(ppVO.getCount())));
				// packageSku.setTotalPointDeduction(
				// packageSku.getTotalPoint().divide(new
				// BigDecimal(100)).setScale(2));
				// BigDecimal pointLine =
				// opSalesOrderVO.getPointOnLine().add(packageSku.getTotalPoint());
				// opSalesOrderVO.setPointOnLine(pointLine);
				// opSalesOrderVO.setPointOnLineDeduction(pointLine.divide(new
				// BigDecimal(100)).setScale(2));
				// }
				//
				// }

				if (packageSku.getUnitAmountAfterDiscount() == null) {
					packageSku.setUnitAmountAfterDiscount(BigDecimal.ZERO);
				}

				if (giftMap != null && CollectionUtils.isNotEmpty(giftMap.get(ppVO.getSpvId()))) {

					setGifts(opSoPackageSkuVOs, giftMap.get(ppVO.getSpvId()), packageSku,
							orderCreateVO.getChannelCode(), deliveryTypes, opChannel, opSalesOrderVO, voMap,
							campaingnMap);
					giftMap.remove(ppVO.getSpvId());
				}

				// 定制费
				if (customizePrice.doubleValue() > 0 && skuVO.getCanCustomize() != null
						&& skuVO.getCanCustomize() == 1) {
					packageSku.setCustomizePrice(skuVO.getCustomizationPrice());
				}

				// 定制内容
				if (CollectionUtils.isNotEmpty(ppVO.getCustomizeList())) {
					List<OpSoPackageSkuCustomizeVO> ctList = new ArrayList<>();

					for (CartCustomization cct : ppVO.getCustomizeList()) {
						OpSoPackageSkuCustomizeVO ctVO = new OpSoPackageSkuCustomizeVO();
						ctVO.setCustomDimensionValue(cct.getCustomDimensionValue());
						ctVO.setCustomDimensionName(cct.getCustomDimensionName());
						ctVO.setCustomDimensionId(cct.getCustomDimensionId());
						ctList.add(ctVO);
					}

					packageSku.setCustomizeList(ctList);
				}

				if (birthdayDisMap.get(ppVO.getSpvId()) != null) {
					// 设置生日折扣
					packageSku.setShareBirthdayDiscount(
							birthdayDisMap.get(ppVO.getSpvId()).multiply(BigDecimal.valueOf(packageSku.getQuantity())));
					opSalesOrderVO.setBirthdayDiscountAmount(
							opSalesOrderVO.getBirthdayDiscountAmount().add(packageSku.getShareBirthdayDiscount()));
					birthdayDisMap.remove(ppVO.getSpvId());

				}

				// 设置优惠卷折扣
				if (couponDisMap.get(ppVO.getSpvId()) != null) {
					packageSku.setShareCouponDiscount(
							couponDisMap.get(ppVO.getSpvId()).multiply(BigDecimal.valueOf(packageSku.getQuantity())));
					opSalesOrderVO.setCouponDiscountAmount(
							opSalesOrderVO.getCouponDiscountAmount().add(packageSku.getShareCouponDiscount()));
					couponDisMap.remove(ppVO.getSpvId());
				} else {
					if (couponDisMap2.get(ppVO.getSpvId()) != null) {
						packageSku.setShareCouponDiscount(couponDisMap2.get(ppVO.getSpvId())
								.multiply(BigDecimal.valueOf(packageSku.getQuantity())));
						opSalesOrderVO.setCouponDiscountAmount(
								opSalesOrderVO.getCouponDiscountAmount().add(packageSku.getShareCouponDiscount()));
						couponDisMap2.remove(ppVO.getSpvId());
					}

				}

				if (skuVO.getDeliveryPeriod() != null) {
					packageSku.setDeliveryPeriod(skuVO.getDeliveryPeriod());
				} else {
					packageSku.setDeliveryPeriod(1);
				}

				// 如果是换购验证数量
				if (CartPackSource.ADDIBLE.getId().equals(ppVO.getSource().getCode())) {

					String campignCode = addiblePacks.get(ppVO.getSpvId());
					if (StringUtils.isBlank(campignCode)) {
						logger.error("换购活动code未取到，spvId：" + ppVO.getSpvId());
					} else {
						packageSku.setCampignCode(campignCode);
						String key = packageSku.getCampignCode() + productVO.getCode();

						if (voMap.get(key) == null) {

							CampaignStreamVO vo = new CampaignStreamVO();
							vo.setCampaignCode(packageSku.getCampignCode());
							if (member != null) {
								vo.setMemberCode(member.getCode());
							}

							vo.setQuantity(packageSku.getQuantity());
							vo.setSkuCode(skuCode);

							vo.setProductCode(productVO.getCode());

							voMap.put(key, vo);
						}
					}

				}

			}

			opSoPackageSkuVOs.add(packageSku);
		}

		// 抢购库存验证
		if (panicVos.size() > 0) {
			ServiceResp<Map<String, LimitCheckResultVO>> serviceResp = campaignLimitService
					.checkPanicBuyAmountLimit(panicVos);
			if (serviceResp.isFailure()) {
				throw new ChannelException(ErrorCode.DEFAULT_EXCEPTION.getCode(), serviceResp.getRespMsg());
			}

			if (serviceResp.getBean().size() > 0) {

				for (LimitCheckResultVO limitCheckResultVO : serviceResp.getBean().values()) {

					if (limitCheckResultVO.getLimitStatus()) {

						PsSkuVO skuVO = psSkuVOMap.get(limitCheckResultVO.getCode());
						String skuName = "";

						if (skuVO != null) {
							skuName = skuVO.getSkuNameCN();
						}

						throw new ChannelException(ErrorCode.ITEM_OUTOF_QUANTITY.getCode(), "商品已超限购,商品名称:" + skuName);
					}

					if (limitCheckResultVO.getPanicStatus()) {
						PsSkuVO skuVO = psSkuVOMap.get(limitCheckResultVO.getCode());
						String skuName = "";

						if (skuVO != null) {
							skuName = skuVO.getSkuNameCN();
						}
						throw new ChannelException(ErrorCode.ITEM_OUTOF_QUANTITY.getCode(), "抢购库存不足,商品名称:" + skuName);
					}

				}

				opSalesOrderVO.setPanicVos(panicVos);

			}
		}

		// 换购，买赠，限量验证
		if (voMap.size() > 0) {

			List<CampaignStreamVO> vos = new ArrayList<>();
			vos.addAll(voMap.values());
			logger.info("换购，买赠，限量验证参数:" + vos.toString());
			ServiceResp<Map<String, Boolean>> serviceResp = campaignLimitService.checkCspAmountLimit(vos);
			if (serviceResp.isFailure()) {
				throw new ChannelException(ErrorCode.DEFAULT_EXCEPTION.getCode(), serviceResp.getRespMsg());
			}

			if (serviceResp.getBean().size() > 0) {

				for (String code : serviceResp.getBean().keySet()) {

					if (serviceResp.getBean().get(code)) {

						CampaignStreamVO vo = voMap.get(code);

						PsProductVO prodVO = mcPsProductService.findProdByCode(vo.getProductCode());

						String prodName = "";

						if (prodVO != null) {
							prodName = prodVO.getNameCn();
						}

						throw new ChannelException(ErrorCode.ITEM_OUTOF_QUANTITY.getCode(), "商品已超上限,商品名称:" + prodName);
					}

				}

				opSalesOrderVO.setVos(vos);

			}
		}
		
		// 折扣限量活动
		if(priceDiscountVos.size()>0){
			
			
			ServiceResp<Map<String, LimitCheckResultVO>> serviceResp = campaignLimitService.checkPriceDiscountBuyAmountLimit(priceDiscountVos);
			
			if (serviceResp.isFailure()) {
				throw new ChannelException(ErrorCode.DEFAULT_EXCEPTION.getCode(), serviceResp.getRespMsg());
			}
			
			Map<String, LimitCheckResultVO> map = serviceResp.getBean();
			
			for(String key:map.keySet()){
				
				
				LimitCheckResultVO limitCheckResultVO = map.get(key);
				if(limitCheckResultVO.getLimitStatus()){
					
					PsSkuVO skuVO = psSkuVOMap.get(limitCheckResultVO.getCode());

					String prodName = "";

					if (skuVO != null) {
						prodName = skuVO.getSkuNameCN();
					}
					throw new ChannelException(ErrorCode.ITEM_OUTOF_QUANTITY.getCode(), "商品已超上限,商品名称:" + prodName);
				}
				
				if(limitCheckResultVO.getPanicStatus()){
					PsSkuVO skuVO = psSkuVOMap.get(limitCheckResultVO.getCode());

					String prodName = "";

					if (skuVO != null) {
						prodName =skuVO.getSkuNameCN();
					}
					throw new ChannelException(ErrorCode.ITEM_OUTOF_QUANTITY.getCode(), "商品总量已超上限,商品名称:" + prodName);
				}
				
				
			}
			
			opSalesOrderVO.setPriceDiscountVos(priceDiscountVos);
			
		}

		// 拼团订单
		if (opSalesOrderVO.getOrderTypeEnum() != null
				&& OrderTypeEnum.ORDERTYPE_10.getCode() == opSalesOrderVO.getOrderTypeEnum().getCode()) {

			opSalesOrderVO.setsGroupbuyParterOccupyDTO(orderCreateVO.getsGroupbuyParterOccupyDTO());
			opSalesOrderVO.setsGroupbuyOwnerOccupyDTO(orderCreateVO.getsGroupbuyOwnerOccupyDTO());
		}

		if (orderCreateVO.getActualPayPoint() != null && orderCreateVO.getActualPayPoint().doubleValue() >0) {
			if (orderCreateVO.getActualPayPoint() != null
					&& orderCreateVO.getActualPayPoint().compareTo(opSalesOrderVO.getPointOnLine()) != 0) {
				throw new ChannelException(ErrorCode.LACKOF_POINT.getCode(), "商品积分支付有误,需支付="
						+ orderCreateVO.getActualPayPoint() + ",实示付=" + opSalesOrderVO.getPointOnLine());

			}
		}

		return true;

	}

	private boolean setOpSoPackagesIPOS(OrderCreateVO orderCreateVO, Map<String, Boolean> deliveryTypes,
			List<OpSoPackageSkuVO> opSoPackageSkuVOs, MemberVO member, OpSalesOrderVO opSalesOrderVO,
			final OpChannelVO opChannel, AccessWayEnum accessWay, List<PsSkuVO> psSkuVOs,
			Map<String, Integer> skuCountMap, Map<String, List<OpSoPackageSkuVO>> packageSkusMap) {

		// 抢购
		List<CampaignStreamVO> panicVos = Lists.newArrayList();
		// 换购或买赠
		// List<CampaignStreamVO> vos = Lists.newArrayList();
		Map<String, CampaignStreamVO> voMap = Maps.newHashMap();

		// 统计生日优惠金额
		Map<Long, BigDecimal> birthdayDisMap = new HashMap<>();
		// 统计优惠卷金额
		Map<Long, BigDecimal> couponDisMap = new HashMap<>();

		Map<Long, BigDecimal> couponDisMap2 = new HashMap<>();
		// 商品prod
		// Map<String, PsProductVO> prodMap = new HashMap<>();
		// Member member = new Member();
		// member.setId(memberVo.getId());
		// member.setBirthday(memberVo.getBirthday());
		if (member != null && StringUtils.isNotBlank(orderCreateVO.getPresentCards())) {
			member.setMemberLevel(0);
		}

		// OrderCampaignVO orderCampaignVO = getOrderCampaign(orderCreateVO,
		// member, opChannel,
		// accessWay,birthdayDisMap,couponDisMap,couponDisMap2);

		Map<String, PrsCampaignVO> campaingnMap = getSpvCampaignVO(orderCreateVO.getSpvSteps(),
				orderCreateVO.getPriceStepVOs(), birthdayDisMap, couponDisMap, couponDisMap2);

		// 避免循环调用一次性取出
		List<Long> spvIds = new ArrayList<>();

		List<String> prodIds = new ArrayList<>();

		List<String> skuCodes = new ArrayList<>();
		// 设置需要处理的限量商品
		Map<String, OpLimitSkuVO> redisOpLimitSkuVOMaps = new HashMap<>();

		Map<String, OpLimitSkuVO> opLimitSkuVOMap = new HashMap<>();

		// 判断是否有根据城市限量的商品
		String cityLimitSkus = PropConstants.getProperties("cityLimitSkus", "");
		// 存在需要判断地区库存的商品
		if (StringUtils.isNotBlank(cityLimitSkus) && orderCreateVO.getDeliveryAddress() != null
				&& orderCreateVO.getDeliveryAddress().getDistrictId() != null) {

			List<OpLimitSkuVO> opLimitSkuVOs = JSON.parseArray(cityLimitSkus, OpLimitSkuVO.class);
			if (CollectionUtils.isNotEmpty(opLimitSkuVOs)) {
				// 根据渠道查询商品
				CommDistrictVO district = commAddressService.findDistrictById(orderCreateVO.getDeliveryAddress().getDistrictId().intValue());

				if (district != null) {
					for (OpLimitSkuVO bean : opLimitSkuVOs) {

						if (bean.getCity() != null) {
							if (bean.getCity().equals(String.valueOf(district.getCityId()))) {
								bean.setName(district.getFullName());
								opLimitSkuVOMap.put(bean.getSkuCode(), bean);

							}
						}

					}
				}

			}

		}

		// 定制商品
		List<String> customizationSkus = new ArrayList<>();
		for (CartProductPack ppVO : orderCreateVO.getPacks()) {

			if (ppVO.getSpvId() != null) {
				if (!spvIds.contains(ppVO.getSpvId())) {
					spvIds.add(ppVO.getSpvId());
				}
			}

			if (ppVO.getSpv().getCombined()) {

				if (CollectionUtils.isNotEmpty(ppVO.getSpv().getSkuCombinationList())) {

					// 取出所有skuCode
					for (PsSkuCombinationVO bean : ppVO.getSpv().getSkuCombinationList()) {
						if (opChannel.getChannelType() != null && opChannel.getChannelType() == 2) {
							if (opLimitSkuVOMap.size() > 0) {

								OpLimitSkuVO opLimitSkuVo = opLimitSkuVOMap.get(bean.getSubSkuCode());
								if (opLimitSkuVo != null) {
									// 如果购买数大买总数量
									if (bean.getQuantity() > opLimitSkuVo.getTotalQuantity()) {
										throw new ChannelException(ErrorCode.PARAMS_ILLEGAL.getCode(),
												opLimitSkuVo.getName() + '的' + bean.getSubSkuCode() + "库存不足。");
									}

									opLimitSkuVo.setQuantity(bean.getQuantity());

									OpLimitSkuVO redisOpLimitSkuVO = redisOpLimitSkuVOMaps.get(bean.getSubSkuCode());

									if (redisOpLimitSkuVO != null) {
										redisOpLimitSkuVO
												.setQuantity(redisOpLimitSkuVO.getQuantity() + bean.getQuantity());
									} else {

										opLimitSkuVo.setRedisKey(
												"limit_" + opLimitSkuVo.getCity() + "_" + opLimitSkuVo.getSkuCode());
										redisOpLimitSkuVOMaps.put(bean.getSubSkuCode(), opLimitSkuVo);
									}

								}

							}
						}

						if (bean.getSubSkuCode() != null) {
							if (!skuCodes.contains(bean.getSubSkuCode())) {
								skuCodes.add(bean.getSubSkuCode());
								if (ppVO.getProduct().getExpressType() == 1
										|| ppVO.getProduct().getExpressType() == 2) {
									skuCountMap.put(bean.getSubSkuCode(), bean.getQuantity());
								}

							}
						}

					}

				}

			} else {
				if (opChannel.getChannelType() != null && opChannel.getChannelType() == 2) {
					if (opLimitSkuVOMap.size() > 0) {

						OpLimitSkuVO opLimitSkuVo = opLimitSkuVOMap.get(ppVO.getSpv().getSkuCode());
						if (opLimitSkuVo != null) {
							// 如果购买数大买总数量
							if (ppVO.getCount() > opLimitSkuVo.getTotalQuantity()) {
								throw new ChannelException(ErrorCode.PARAMS_ILLEGAL.getCode(),
										opLimitSkuVo.getName() + '的' + ppVO.getSpv().getSkuCode() + "库存不足。");
							}

							opLimitSkuVo.setQuantity(ppVO.getCount());

							OpLimitSkuVO redisOpLimitSkuVO = redisOpLimitSkuVOMaps.get(ppVO.getSpv().getSkuCode());

							if (redisOpLimitSkuVO != null) {
								redisOpLimitSkuVO.setQuantity(redisOpLimitSkuVO.getQuantity() + ppVO.getCount());
							} else {

								opLimitSkuVo.setRedisKey(
										"limit_" + opLimitSkuVo.getCity() + "_" + opLimitSkuVo.getSkuCode());
								redisOpLimitSkuVOMaps.put(ppVO.getSpv().getSkuCode(), opLimitSkuVo);
							}

						}

					}
				}

				if (ppVO.getSpv().getSkuCode() != null) {
					if (!skuCodes.contains(ppVO.getSpv().getSkuCode())) {
						skuCodes.add(ppVO.getSpv().getSkuCode());
						if (ppVO.getProduct().getExpressType() == 1 || ppVO.getProduct().getExpressType() == 2) {
							skuCountMap.put(ppVO.getSpv().getSkuCode(), ppVO.getCount());
						}

					}

				}
			}

		}

		// 设置需要操作redis的对像值
		opSalesOrderVO.setRedisOpLimitSkuVOMaps(redisOpLimitSkuVOMaps);

		int mbmLevel = -1;
		if (member != null) {
			mbmLevel = member.getMemberLevel();
		}

		// 价格计算
		PsMatchCampaignCond cond = new PsMatchCampaignCond();
		cond.setAccessWay(accessWay.getCode());
		cond.setMemberLevel(mbmLevel);
		MemberLevelEnum memberLevel = MemberLevelEnum.getEnumByCode(mbmLevel);
		cond.setDiscount(memberLevel.getLevelAmountCondition());
		cond.setMatchCampaign(true);
		cond.setChannelCode(opChannel.getCode());

		Map<Long, PsSpvVO> psSpvVOMap = mcPsSpvService.mapBySpvIds(spvIds, cond);
		Map<String, PsSkuVO> psSkuVOMap = new HashMap<>();
		Map<String, PsProductVO> prodMap = new HashMap<>();
		if (psSpvVOMap != null) {
			for (PsSpvVO spv : psSpvVOMap.values()) {
				if (spv.getProductId() != null) {
					if (!prodIds.contains(spv.getProductId().toString())) {
						prodIds.add(spv.getProductId().toString());
					}

				}

			}

			PsProductCond prodCond = new PsProductCond();
			prodCond.setChannelCode(opChannel.getCode());
			prodCond.setIds(prodIds);
			prodCond.setPagenum(prodIds.size());
			List<PsProductVO> prods = mcPsProductService.findByCond(prodCond);
			if (CollectionUtils.isNotEmpty(prods)) {
				for (PsProductVO psProd : prods) {
					prodMap.put(psProd.getId(), psProd);
				}

			}

		}
		List<PsSkuVO> skuVOs = mcPsSkuService.findBySkuCodes(skuCodes);

		if (CollectionUtils.isNotEmpty(skuVOs)) {

			psSkuVOs.addAll(skuVOs);
			for (PsSkuVO vo : skuVOs) {
				psSkuVOMap.put(vo.getSkuCode(), vo);

				// 来单制作并且是定制商品
				if (vo.getIsJit() != null && vo.getIsJit() == 1 && vo.getCanCustomize() != null
						&& vo.getCanCustomize() == 1) {
					customizationSkus.add(vo.getSkuCode());
				}

				// 需要根据地区判断库存的商品
				// if(ConstUtils.SKUCODE_101170953.equals(vo.getSkuCode()) ||
				// ConstUtils.SKUCODE_101170133.equals(vo.getSkuCode())){
				// //bool = true;
				// }

			}
		}
		Map<String, WhRecipeInvVO> whReipeInvVOMaps = new HashMap<>();
		if (customizationSkus.size() > 0) {
			whReipeInvVOMaps.putAll(
					sPrdcJobService.caculateRecipeAmountForAssemble(customizationSkus, opChannel.getWarehouseForSales()));
		}

		BigDecimal customizePrice = opSalesOrderVO.getCustomizationAmount()
				.subtract(opSalesOrderVO.getCustomizationDiscount());

		Map<Long, List<CartProductPack>> giftMap = orderCreateVO.getGiftPackMap();

		Map<Long, String> addiblePacks = orderCreateVO.getAddiblePacks();

		Map<Long, PrsSpvPriceStepVO> pointSpvPriceStepMap = new HashMap<>();
		
		Map<Long, PrsSpvPriceStepVO> spvPriceStepMap = new HashMap<>();
		// 从价格步骤取得积分
		spvPriceStepMap(orderCreateVO.getSpvSteps(),pointSpvPriceStepMap ,spvPriceStepMap);
		// 配送方式，判断是否需要强制审单
		for (final CartProductPack ppVO : orderCreateVO.getPacks()) {
			final OpSoPackageSkuVO packageSku = new OpSoPackageSkuVO();

			// 抢购是否否限购：true:是，否false
			// boolean panicBuy = true;

			if (CartPackSource.GIFT.id.equals(ppVO.getSource().getCode())) {
				// 判断是不是没有主品
				logger.info("赠品spvId:" + ppVO.getSource().getCode());

				List<CartProductPack> giftPack = new ArrayList<>();
				giftPack.add(ppVO);

				setGiftsIPOS(opSoPackageSkuVOs, ppVO.getSpvId(), null, deliveryTypes, opChannel, opSalesOrderVO, voMap,
						campaingnMap, packageSkusMap, orderCreateVO, giftPack);

			} else if (ppVO.getSpv().getCombined()) {
				combinationProdIPOS(opSoPackageSkuVOs, opSalesOrderVO, opChannel, deliveryTypes, ppVO, birthdayDisMap,
						couponDisMap, voMap, couponDisMap2, psSkuVOMap, giftMap, campaingnMap, packageSkusMap,
						orderCreateVO);

				continue;
				// 如果是赠品
			} else {
				String skuCode = ppVO.getSpv().getSkuCode();

				int discountType = 0;

				PsSpvVO psSpvVO = psSpvVOMap.get(ppVO.getSpvId());

				if (psSpvVO == null) {
					throw new ChannelException(ErrorCode.PARAMS_ILLEGAL.getCode(), "商品spvId查不到商品：" + ppVO.getSpvId());
				}

				PsProductVO productVO = prodMap.get(psSpvVO.getProductId().toString());
				if (productVO == null) {
					throw new ChannelException(ErrorCode.PARAMS_ILLEGAL.getCode(),
							"商品prodId查不到商品：" + psSpvVO.getProductId());
				}
				PsSkuVO skuVO = psSkuVOMap.get(skuCode);

				if (ppVO.getSource() != null) {
					logger.info("该商品相关信息：source:" + ppVO.getSource().getName());
				}

				if (ppVO.getSource() != CartPackSourceEnum.ADDIBLE
						&& !CartPackSource.BENEFIT.id.equals(ppVO.getSource().getCode())) {

					if (CollectionUtils.isEmpty(productVO.getChnCanSaleSKu())
							|| !productVO.getCanSaleSku(orderCreateVO.getChannelCode()).contains(skuCode)) {
						throw new ChannelException(ErrorCode.ITEM_OFFSHELF.getCode(), "商品不可售 " + skuCode);
					}
				}

				// 抢购不支付组合商品
				if (CollectionUtils.isNotEmpty(psSpvVO.getCampaignList())) {

					for (PsCampaignVO campaign : psSpvVO.getCampaignList()) {
						if (campaign.getDiscountTypeId() == DiscountType.PANIC_BUY.getId()) {
							// 判断当前抢购商品是否限购
							if (campaign.getLimitAmount() != null && campaign.getLimitAmount() > 0) {
								// 一次购买
								if (ppVO.getCount() > campaign.getLimitAmount()) {
									throw new ChannelException(ErrorCode.ITEM_OUTOF_QUANTITY.getCode(),
											skuVO.getSkuNameCN() + ",超过单个用户抢购数量，只允许购买：" + campaign.getLimitAmount());
								}
							}
							// if (campaign.getPanicBuyAmount() != null &&
							// campaign.getPanicBuyAmount() == -1) {
							// panicBuy = false;
							// } else {
							discountType = DiscountType.PANIC_BUY.getId();
							// packageSku.setPanicBuyCode(campaign.getCode());
							packageSku.setCampignCode(campaign.getCode());
							packageSku.setDiscountType(discountType);

							// 判断当前抢购商品是否限购
							if (campaign.getLimitAmount() != null && campaign.getLimitAmount() > 0) {

								if (member != null) {
									CampaignStreamVO vo = new CampaignStreamVO();
									vo.setCampaignCode(packageSku.getCampignCode());
									vo.setMemberCode(member.getCode());

									vo.setSkuCode(skuCode);
									final ServiceResp<Integer> rlt = campaignLimitService.getPanicPerUserLeftAmount(vo);
									rlt.checkError(new RespCallback() {
										@Override
										public void call(String arg0, String arg1, Map<String, Object> arg2) {
											throw new ChannelException(ErrorCode.ITEM_OUTOF_QUANTITY.getCode(),
													rlt.getRespMsg());
										}
									});

									if (rlt.getBean() == null || ppVO.getCount() > rlt.getBean()) {
										throw new ChannelException(ErrorCode.ITEM_OUTOF_QUANTITY.getCode(),
												skuVO.getSkuNameCN() + "超过单个用户购买数量，只允许购买：" + rlt.getBean());
									}
								}

								packageSku.setLimitAmount(campaign.getLimitAmount());
								packageSku.setStartTime(
										DateUtil.format(campaign.getStartTime(), DateUtil.DEFAULT_DATETIME_FORMAT));
								packageSku.setExpireTime(
										DateUtil.format(campaign.getExpireTime(), DateUtil.DEFAULT_DATETIME_FORMAT));
								// packageSku.setPanicBuyAmount(campaign.getPanicBuyAmount());
							}
							// }

							break;
							// 拼团活动
						} else if (campaign.getDiscountTypeId() == DiscountTypeEnum.GROUP_BUY.getId()) {
							packageSku.setCampignCode(campaign.getCode());
							packageSku.setDiscountType(discountType);
							// 评团设为8类型
							packageSku.setSourceId(OpSoPackageSku.SOURCEID_GROUP);

						}
					}

				}

				// 判断是否是权益商品
				if (CartPackSource.BENEFIT.id.equals(ppVO.getSource().getCode())) {
					// packageSku.setInterestId(ppVO.getSourceBindVal());
					// if (interestMap != null) {
					packageSku.setCampignCode(ppVO.getSourceBindVal());
					// }

					packageSku.setSourceId(ppVO.getSource().getCode());
					// 0普通商品，1赠品，2权益商品
					packageSku.setIsGift(2);

					if (ppVO.getSpv().getSalesPrice() == null) {
						ppVO.getSpv().setSalesPrice(BigDecimal.ZERO);
					}

					if (ppVO.getSpv().getDiscountPrice() == null) {
						ppVO.getSpv().setDiscountPrice(BigDecimal.ZERO);
					}
					final BigDecimal unitDiscount = ppVO.getSpv().getSalesPrice()
							.subtract(ppVO.getSpv().getDiscountPrice());
					packageSku.setUnitDiscount(unitDiscount);

					// 折扣后金额
					packageSku.setUnitAmountAfterDiscount(ppVO.getSpv().getDiscountPrice());

				} else {
					packageSku.setIsGift(0);// 底层暂不支持赠品

					if (ppVO.getSpv().getSalesPrice() == null) {
						ppVO.getSpv().setSalesPrice(BigDecimal.ZERO);
					}

					if (ppVO.getSpv().getDiscountPrice() == null) {
						ppVO.getSpv().setDiscountPrice(BigDecimal.ZERO);
					}
					final BigDecimal unitDiscount = ppVO.getSpv().getSalesPrice()
							.subtract(ppVO.getSpv().getDiscountPrice());
					packageSku.setUnitDiscount(unitDiscount);

					// 折扣后金额
					packageSku.setUnitAmountAfterDiscount(ppVO.getSpv().getDiscountPrice());
				}

				if (ppVO.getSpvId() == null) {
					PsSpvVO spvVo = mcPsSpvService.findSpvBySkuCode(productVO.getCode(), packageSku.getSkuCode());
					if (spvVo != null) {
						packageSku.setSpvId(spvVo.getSpvId());
					}

				} else {
					packageSku.setSpvId(ppVO.getSpvId());
				}

				if (packageSku.getSourceId() == null) {
					packageSku.setSourceId(ppVO.getSource().getCode());
				}

				packageSku.setProductCode(productVO.getCode());

				if (skuVO.getSalesPrice().compareTo(ppVO.getSpv().getSalesPrice().doubleValue()) != 0) {
					throw new ChannelException(ErrorCode.ITEM_PRICE_CHANGE.getCode(),
							ErrorCode.ITEM_PRICE_CHANGE.getMesage() + ": " + skuVO.getSkuCode() + " "
									+ skuVO.getSkuNameCN() + ": " + skuVO.getSalesPrice());
				}

				if ((skuVO.getIsJit() == null || PegasusConstants.NO == skuVO.getIsJit())
						&& !CartPackSource.BENEFIT.id.equals(ppVO.getSource().getCode())) {

					if (StringUtils.isNotEmpty(packageSku.getCampignCode())
							&& discountType == DiscountType.PANIC_BUY.getId()) {

						CampaignStreamVO vo = new CampaignStreamVO();
						vo.setCampaignCode(packageSku.getCampignCode());
						if (member != null) {
							vo.setMemberCode(member.getCode());
						}
						vo.setQuantity(ppVO.getCount());
						vo.setSkuCode(skuCode);
						panicVos.add(vo);

					}

				} else {

					// 判断是否是定制配方商品
					if (skuVO.getCanCustomize() != null && skuVO.getCanCustomize() == 1
							&& opChannel.getChannelType() != 1) {
						packageSku.setCustomizeType(skuVO.getCustomizeType());
						WhRecipeInvVO whRecipeInvVO = whReipeInvVOMaps.get(skuVO.getSkuCode());
						if (whRecipeInvVO != null && whRecipeInvVO.isRecipeExist() == true) {
							packageSku.setRecipeExist(whRecipeInvVO.isRecipeExist());
							if (whRecipeInvVO.getCanUseInv() < ppVO.getCount()) {
								logger.info("购买数量：{},实际数量：{}", ppVO.getCount(), whRecipeInvVO.getCanUseInv());
								throw new ChannelException(ErrorCode.ITEM_OUTOF_QUANTITY.getCode(),
										ErrorCode.ITEM_OUTOF_QUANTITY.getMesage() + ": " + skuVO.getSkuCode() + " "
												+ skuVO.getSkuNameCN());

							}

						}

					}

				}

				// JIT商品不校验库存
				packageSku.setWhetherLogistics(skuVO.getWhetherLogistics());
				packageSku.setWhetherVirtual(skuVO.getWhetherVirtual());

				packageSku.setWeight(skuVO.getWeight());
				packageSku.setTaxNo(skuVO.getTaxNo());

				packageSku.setClearanceWay(skuVO.getClearanceWay());
				// 跨境购标注 0普通１跨境购
				packageSku.setCrossBorderFlag(skuVO.getCrossBorderFlag());

				packageSku.setAddBy(OpSoPackageSku.ADDBY_MEMBER);// 默认会员添加
				packageSku.setSkuCode(skuVO.getSkuCode());

				// skuName
				packageSku.setNameCn(skuVO.getSkuNameCN());

				packageSku.setBrandId(skuVO.getBrandId());
				// packageSku.setCategroyId(skuVO.getCategoryId());

				// packageSku.setMainSkuCode(detail.getMainSkuId());
				packageSku.setIsJit(skuVO.getIsJit());// 是否来单制作
				packageSku.setQuantity(ppVO.getCount());// 数量
				// 商品分类
				packageSku.setCategoryId(skuVO.getCategoryId());

				if (skuVO.getCategoryId() != null) {

					if (opSalesOrderVO.getCategoryIds() != null) {

						if (!opSalesOrderVO.getCategoryIds().contains(skuVO.getCategoryId().intValue())) {
							opSalesOrderVO.getCategoryIds().add(skuVO.getCategoryId().intValue());

						}

					} else {

						List<Integer> categoryIds = new ArrayList<>();
						categoryIds.add(skuVO.getCategoryId().intValue());
						opSalesOrderVO.setCategoryIds(categoryIds);
					}

				}

				// 代销
				packageSku.setWhetherConsignment(skuVO.getWhetherConsignment());
				// 判断是否包含两种以上配送方式，如果是，则需要强制审单
				final int expressType = productVO.getExpressType();
				packageSku.setExpressType(expressType);
				if (OpProduct.EP_TYPE_SELF == expressType) {
					deliveryTypes.put("SELF", true);
				} else if (OpProduct.EP_TYPE_FED == expressType) {
					deliveryTypes.put("FEDX24", true);
				} else if (OpProduct.EP_TYPE_Sf_AIR == expressType) {
					deliveryTypes.put("SF_AIR", true);
				} else if (OpProduct.EP_TYPE_Sf_LAND == expressType) {
					deliveryTypes.put("SF_LAND", true);
				} else if (OpProduct.EP_TYPE_YTO == expressType) {// 圆通
					deliveryTypes.put("YTO", true);
				} else if (OpProduct.EP_TYPE_DEPPON == expressType) {
					deliveryTypes.put("DEPPON", true);
				} else if (OpProduct.EP_TYPE_ZT == expressType) {
					deliveryTypes.put("ZT", true);
				}

				if (opSalesOrderVO.getPointOnLine() == null) {
					opSalesOrderVO.setPointOnLine(BigDecimal.ZERO);
				}

				packageSku.setUnitPrice(ppVO.getSpv().getSalesPrice());
				// if (orderCreateVO.getExchangeMap() != null) {
				// Integer point =
				// orderCreateVO.getExchangeMap().get(ppVO.getSpv().getSpvId());
				//
				// if (point != null) {
				// packageSku.setUnitPoint(new BigDecimal(point));
				// packageSku.setUnitPointDeduction(new
				// BigDecimal(point).divide(new BigDecimal(100)).setScale(2));
				// packageSku.setTotalPoint(new BigDecimal(point).multiply(new
				// BigDecimal(ppVO.getCount())));
				// packageSku.setTotalPointDeduction(
				// packageSku.getTotalPoint().divide(new
				// BigDecimal(100)).setScale(2));
				// BigDecimal pointLine =
				// opSalesOrderVO.getPointOnLine().add(packageSku.getTotalPoint());
				// opSalesOrderVO.setPointOnLine(pointLine);
				// opSalesOrderVO.setPointOnLineDeduction(pointLine.divide(new
				// BigDecimal(100)).setScale(2));
				// }
				//
				// }
				PrsSpvPriceStepVO prsSpvPriceStepVO = pointSpvPriceStepMap.get(ppVO.getSpv().getSpvId());
				if (prsSpvPriceStepVO != null) {

					packageSku.setUnitPoint(new BigDecimal(prsSpvPriceStepVO.getPoints()));

					packageSku.setUnitPointDeduction(prsSpvPriceStepVO.getSpvSavedPrice());

					packageSku.setTotalPoint(
							new BigDecimal(prsSpvPriceStepVO.getPoints()).multiply(new BigDecimal(ppVO.getCount())));
					packageSku.setTotalPointDeduction(
							packageSku.getUnitPointDeduction().multiply(new BigDecimal(ppVO.getCount())));

					BigDecimal pointLine = opSalesOrderVO.getPointOnLine().add(packageSku.getTotalPoint());
					opSalesOrderVO.setPointOnLine(pointLine);
					opSalesOrderVO.setPointOnLineDeduction(
							opSalesOrderVO.getPointOnLineDeduction().add(packageSku.getTotalPointDeduction()));
				}

				if (packageSku.getUnitAmountAfterDiscount() == null) {
					packageSku.setUnitAmountAfterDiscount(BigDecimal.ZERO);
				}

				// 定制费
				if (customizePrice.doubleValue() > 0 && skuVO.getCanCustomize() != null
						&& skuVO.getCanCustomize() == 1) {
					packageSku.setCustomizePrice(skuVO.getCustomizationPrice());
				}

				// 定制内容
				if (CollectionUtils.isNotEmpty(ppVO.getCustomizeList())) {
					List<OpSoPackageSkuCustomizeVO> ctList = new ArrayList<>();

					for (CartCustomization cct : ppVO.getCustomizeList()) {
						OpSoPackageSkuCustomizeVO ctVO = new OpSoPackageSkuCustomizeVO();
						ctVO.setCustomDimensionValue(cct.getCustomDimensionValue());
						ctVO.setCustomDimensionName(cct.getCustomDimensionName());
						ctVO.setCustomDimensionId(cct.getCustomDimensionId());
						ctList.add(ctVO);
					}

					packageSku.setCustomizeList(ctList);
				}

				if (birthdayDisMap.get(ppVO.getSpvId()) != null) {
					// 设置生日折扣
					packageSku.setShareBirthdayDiscount(
							birthdayDisMap.get(ppVO.getSpvId()).multiply(BigDecimal.valueOf(packageSku.getQuantity())));
					opSalesOrderVO.setBirthdayDiscountAmount(
							opSalesOrderVO.getBirthdayDiscountAmount().add(packageSku.getShareBirthdayDiscount()));
					birthdayDisMap.remove(ppVO.getSpvId());

				}

				// 设置优惠卷折扣
				if (couponDisMap.get(ppVO.getSpvId()) != null) {
					packageSku.setShareCouponDiscount(
							couponDisMap.get(ppVO.getSpvId()).multiply(BigDecimal.valueOf(packageSku.getQuantity())));
					opSalesOrderVO.setCouponDiscountAmount(
							opSalesOrderVO.getCouponDiscountAmount().add(packageSku.getShareCouponDiscount()));
					couponDisMap.remove(ppVO.getSpvId());
				} else {
					if (couponDisMap2.get(ppVO.getSpvId()) != null) {
						packageSku.setShareCouponDiscount(couponDisMap2.get(ppVO.getSpvId())
								.multiply(BigDecimal.valueOf(packageSku.getQuantity())));
						opSalesOrderVO.setCouponDiscountAmount(
								opSalesOrderVO.getCouponDiscountAmount().add(packageSku.getShareCouponDiscount()));
						couponDisMap2.remove(ppVO.getSpvId());
					}

				}

				if (skuVO.getDeliveryPeriod() != null) {
					packageSku.setDeliveryPeriod(skuVO.getDeliveryPeriod());
				} else {
					packageSku.setDeliveryPeriod(1);
				}

				// 如果是换购验证数量
				if (CartPackSource.ADDIBLE.getId().equals(ppVO.getSource().getCode())) {

					String campignCode = addiblePacks.get(ppVO.getSpvId());
					if (StringUtils.isBlank(campignCode)) {
						logger.error("换购活动code未取到，spvId：" + ppVO.getSpvId());
					} else {
						packageSku.setCampignCode(campignCode);
						String key = packageSku.getCampignCode() + productVO.getCode();

						if (voMap.get(key) == null) {

							CampaignStreamVO vo = new CampaignStreamVO();
							vo.setCampaignCode(packageSku.getCampignCode());
							if (member != null) {
								vo.setMemberCode(member.getCode());
							}

							vo.setQuantity(packageSku.getQuantity());
							vo.setSkuCode(skuCode);

							vo.setProductCode(productVO.getCode());

							voMap.put(key, vo);
						}
					}

				}

				if (CollectionUtils.isNotEmpty(ppVO.getDeliverys())) {

					for (ScDeliveryVO vo : ppVO.getDeliverys()) {

						OpSoPackageSkuVO pSku = new OpSoPackageSkuVO();

						BeanUtils.copyProperties(packageSku, pSku);

						// 因同一个spv被分隔成多个，所以赠品要每次清空
						pSku.setGifts(new ArrayList<>());

						pSku.setQuantity(vo.getCount());

						if (vo.getType() == com.thebeastshop.pegasus.channelservice.util.ConstUtil.deliveryType_1) {

							if (CollectionUtils.isNotEmpty(ppVO.getGiftPacks())) {

								boolean isRemove = setGiftsIPOS(opSoPackageSkuVOs, ppVO.getSpvId(), pSku, deliveryTypes,
										opChannel, opSalesOrderVO, voMap, campaingnMap, packageSkusMap, orderCreateVO,
										ppVO.getGiftPacks());

								if (isRemove) {
									giftMap.remove(ppVO.getSpvId());
								}

							}

							// 设置配送方式
							pSku.setDeliveryType(com.thebeastshop.pegasus.channelservice.util.ConstUtil.deliveryType_1);

							String key = ppVO.getSpvId() + skuCode + pSku.getDeliveryType() + vo.getCount();
							// 设置仓库
							pSku.setWarehouseCode(orderCreateVO.getSkuWarehouseMap().get(key));

							if (orderCreateVO.getSkuPresaleWarehouseMap() != null) {

								// 判断是否有预售
								SPresaleVO sPresaleVO = orderCreateVO.getSkuPresaleWarehouseMap().get(key);
								if (sPresaleVO != null) {

									pSku.setPresaleId(sPresaleVO.getId());
									pSku.setPresaleStatus(OpSoPackageSku.PRESALES_STATUS_WAIT);
									// skuVO.setDispatchWarehouseCode(sPresaleVO.getDispatchWarehouseCode());//
									// 冗余发货仓字段
									pSku.setsPresaleVO(sPresaleVO);// 冗余整个预售对象VO
								}

							}

						} else {
							if (CollectionUtils.isNotEmpty(ppVO.getGiftPacks())) {

								boolean isRemove = setGiftsIPOS(opSoPackageSkuVOs, ppVO.getSpvId(), pSku, deliveryTypes,
										opChannel, opSalesOrderVO, voMap, campaingnMap, packageSkusMap, orderCreateVO,
										ppVO.getGiftPacks());

								if (isRemove) {
									// giftMap.remove(ppVO.getSpvId());
									ppVO.setGiftPacks(null);
								}

							}

							// 设置配送方式
							pSku.setDeliveryType(com.thebeastshop.pegasus.channelservice.util.ConstUtil.deliveryType_0);

							// 设置仓库
							pSku.setWarehouseCode(orderCreateVO.getSkuWarehouseMap()
									.get(ppVO.getSpvId() + skuCode + pSku.getDeliveryType() + vo.getCount()));

						}

						String key = pSku.getWarehouseCode() + pSku.getDeliveryType();
						// 设置配送日期
						if (vo.getDate() != null) {
							pSku.setDeliveryDate(vo.getDate());
							key = key + vo.getDate().getTime();
						}

						List<OpSoPackageSkuVO> packageSkus = packageSkusMap.get(key);
						if (packageSkus != null) {
							boolean bool =true;
							for(OpSoPackageSkuVO sku:packageSkus){
								if (sku.getSkuCode().equals(pSku.getSkuCode()) && sku.getSourceId().equals(pSku.getSourceId())) {
									packageSkus.add(pSku);

									packageSkusMap.put(key, packageSkus);
									bool = false;
									break;
								}
							}
							
							if (bool) {
								packageSkus.add(pSku);

								packageSkusMap.put(key, packageSkus);
							}

						} else {
							packageSkus = new ArrayList<>();
							packageSkus.add(pSku);
							packageSkusMap.put(key, packageSkus);
						}

					}

				}

				// opSoPackageSkuVOs.add(packageSku);

			}

		}

		// 抢购库存验证
		if (panicVos.size() > 0)

		{
			ServiceResp<Map<String, LimitCheckResultVO>> serviceResp = campaignLimitService
					.checkPanicBuyAmountLimit(panicVos);
			if (serviceResp.isFailure()) {
				throw new ChannelException(ErrorCode.DEFAULT_EXCEPTION.getCode(), serviceResp.getRespMsg());
			}

			if (serviceResp.getBean().size() > 0) {

				for (LimitCheckResultVO limitCheckResultVO : serviceResp.getBean().values()) {

					if (limitCheckResultVO.getLimitStatus()) {

						PsSkuVO skuVO = psSkuVOMap.get(limitCheckResultVO.getCode());
						String skuName = "";

						if (skuVO != null) {
							skuName = skuVO.getSkuNameCN();
						}

						throw new ChannelException(ErrorCode.ITEM_OUTOF_QUANTITY.getCode(), "商品已超限购,商品名称:" + skuName);
					}

					if (limitCheckResultVO.getPanicStatus()) {
						PsSkuVO skuVO = psSkuVOMap.get(limitCheckResultVO.getCode());
						String skuName = "";

						if (skuVO != null) {
							skuName = skuVO.getSkuNameCN();
						}
						throw new ChannelException(ErrorCode.ITEM_OUTOF_QUANTITY.getCode(), "抢购库存不足,商品名称:" + skuName);
					}

				}

				opSalesOrderVO.setPanicVos(panicVos);

			}
		}

		// 换购，买赠，限量验证
		if (voMap.size() > 0) {

			List<CampaignStreamVO> vos = new ArrayList<>();
			vos.addAll(voMap.values());
			logger.info("换购，买赠，限量验证参数:" + vos.toString());
			ServiceResp<Map<String, Boolean>> serviceResp = campaignLimitService.checkCspAmountLimit(vos);
			if (serviceResp.isFailure()) {
				throw new ChannelException(ErrorCode.DEFAULT_EXCEPTION.getCode(), serviceResp.getRespMsg());
			}

			if (serviceResp.getBean().size() > 0) {

				for (String code : serviceResp.getBean().keySet()) {

					if (serviceResp.getBean().get(code)) {

						CampaignStreamVO vo = voMap.get(code);

						PsProductVO prodVO = mcPsProductService.findProdByCode(vo.getProductCode());

						String prodName = "";

						if (prodVO != null) {
							prodName = prodVO.getNameCn();
						}

						throw new ChannelException(ErrorCode.ITEM_OUTOF_QUANTITY.getCode(), "商品已超上线,商品名称:" + prodName);
					}

				}

				opSalesOrderVO.setVos(vos);

			}
		}

		// 拼团订单

		if (opSalesOrderVO.getOrderTypeEnum() != null
				&& OrderTypeEnum.ORDERTYPE_10.getCode() == opSalesOrderVO.getOrderTypeEnum().getCode()) {

			opSalesOrderVO.setsGroupbuyParterOccupyDTO(orderCreateVO.getsGroupbuyParterOccupyDTO());
			opSalesOrderVO.setsGroupbuyOwnerOccupyDTO(orderCreateVO.getsGroupbuyOwnerOccupyDTO());
		}

		return true;

	}

	// private void groupProd(List<OpSoPackageSkuVO> opSoPackageSkuVOs,
	// OpSalesOrderVO opSalesOrderVO,
	// final OpChannelVO opChannel, String channelCode, Map<String, Boolean>
	// deliveryTypes,
	// OrderProductPackVO ppVO, PsSpvVO psSpvVO, Map<Long, BigDecimal>
	// birthdayDisMap,
	// Map<Long, BigDecimal> couponDisMap, Map<String, CampaignStreamVO> voMap,
	// Map<Long, BigDecimal> couponDisMap2, Map<String, PsSkuVO> psSkuVOMap,
	// Map<String, PsProductVO> prodMap) {
	// int count = 0;
	// OpSoPackageSkuVO packageSku = null;
	// // 判断是否包含两种以上配送方式，如果是，则需要强制审单
	// int expressType = 0;
	// PsProductVO productVO = prodMap.get(psSpvVO.getProductId().toString());
	//
	// // 商品原始总价
	// BigDecimal totalPrice = BigDecimal.ZERO;
	//
	// // 设置组合商品信息
	// setCombinationInfo(ppVO, opSalesOrderVO);
	//
	// List<PsSkuVO> skuList = new ArrayList<>();
	// Map<String, Integer> quantityMap = new HashMap<>();
	//
	// // PsProductCond cond = new PsProductCond();
	// // cond.setId(String.valueOf(psSpvVO.getProductId()));
	// // List<PsProductVO> productVOs = mcPsProductService.findByCond(cond);
	//
	// if (productVO == null) {
	// throw new ChannelException(ErrorCode.PARAMS_ILLEGAL.getCode(),
	// "组合商品prodId查不到商品：" + psSpvVO.getProductId());
	// }
	//
	// // 判断是否包含两种以上配送方式，如果是，则需要强制审单
	// expressType = productVO.getExpressType();
	//
	// if (OpProduct.EP_TYPE_SELF == expressType) {
	// deliveryTypes.put("SELF", true);
	// } else if (OpProduct.EP_TYPE_FED == expressType) {
	// deliveryTypes.put("FEDX24", true);
	// } else if (OpProduct.EP_TYPE_Sf_AIR == expressType) {
	// deliveryTypes.put("SF_AIR", true);
	// } else if (OpProduct.EP_TYPE_Sf_LAND == expressType) {
	// deliveryTypes.put("SF_LAND", true);
	// } else if (OpProduct.EP_TYPE_YTO == expressType) {// 圆通
	// deliveryTypes.put("YTO", true);
	// } else if (OpProduct.EP_TYPE_DEPPON == expressType) {
	// deliveryTypes.put("DEPPON", true);
	// } else if (OpProduct.EP_TYPE_ZT == expressType) {
	// deliveryTypes.put("ZT", true);
	// }
	//
	// Integer skuQuantitys = 0;
	//
	// // 存放组合sku的起售数量
	// Map<String, Integer> skuCombinationMap = new HashMap<>();
	//
	// // 取得所有商品原始总金额
	// for (PsSkuCombinationVO psSKUComVo : psSpvVO.getSkuCombinationList()) {
	//
	// PsSkuVO skuVO = psSkuVOMap.get(psSKUComVo.getSubSkuCode());
	//
	// if (skuVO == null) {
	//
	// throw new ChannelException(ErrorCode.DATA_NOT_FOUND.getCode(),
	// "组合商品sku不存在： " + psSKUComVo.getSubSkuCode());
	// }
	//
	// // 包裹数量乘以最小绑定数量乘以sku数量
	// skuQuantitys = ppVO.getCount() * psSpvVO.getMinAmount() *
	// psSKUComVo.getQuantity();
	// quantityMap.put(psSKUComVo.getSubSkuCode(), skuQuantitys);
	// skuList.add(skuVO);
	// totalPrice = totalPrice
	// .add(BigDecimal.valueOf(skuVO.getSalesPrice()).multiply(BigDecimal.valueOf(skuQuantitys)));
	// skuCombinationMap.put(psSKUComVo.getSubSkuCode(),
	// psSKUComVo.getQuantity());
	//
	// }
	//
	// // 原始价格
	// BigDecimal combinationDiscount = totalPrice
	// .subtract(ppVO.getSpv().getPrice().multiply(BigDecimal.valueOf(ppVO.getCount().intValue())));
	//
	// BigDecimal recondCombinationDiscount = BigDecimal.ZERO;
	// for (PsSkuVO skuVO : skuList) {
	// packageSku = new OpSoPackageSkuVO();
	// packageSku.setExpressType(expressType);
	//
	// if (ppVO.getSource() != null) {
	// packageSku.setSourceId(ppVO.getSource().getId());
	// }
	//
	// if (null == productVO ||
	// CollectionUtils.isEmpty(productVO.getChnCanSaleSKu())
	// || !productVO.getCanSaleSku(channelCode).contains(skuVO.getSkuCode())) {
	// throw new ChannelException(ErrorCode.ITEM_OFFSHELF.getCode(), "组合商品已下架 "
	// + skuVO.getSkuCode());
	// }
	//
	// // if (opSalesOrderVO.getIsForceAudit() == null ||
	// // opSalesOrderVO.getIsForceAudit() != 1) {
	// //
	// // if(skuVO.getCanCustomize() == null){
	// // skuVO.setCanCustomize(0);
	// // }
	// //
	// // // 来单制作，且不是代销也不是定制的情况下强制审单
	// // if (1 == skuVO.getIsJit() && skuVO.getWhetherConsignment() !=
	// // null && skuVO.getWhetherConsignment() == 0 &&
	// // skuVO.getCanCustomize()!=1) {
	// // opSalesOrderVO.setIsForceAudit(PegasusConstants.YES);
	// // }
	// //
	// // }
	// //
	// // // 官网/wap这里有3个高单价的永生花盒，因为scm配送方式选项里面没有“自送“并且我们订单不支持备注，
	// // // 所以针对单价高于5000元的花盒，希望改为客服强制审单
	// // if (ConstUtil.forceAuditSkus.contains(skuVO.getSkuCode())) {
	// // opSalesOrderVO.setIsForceAudit(PegasusConstants.YES);
	// // }
	//
	// // if(opSalesOrderVO.getIsForceAudit() == PegasusConstants.NO &&
	// // opChannel.getChannelType()!=null &&
	// // opChannel.getChannelType()==2){
	// // setIsForceAudit(opSalesOrderVO,skuVO);
	// // }
	//
	// Integer skuQuantity = quantityMap.get(skuVO.getSkuCode());
	// if (skuQuantity == null || skuQuantity < 1) {
	// skuQuantity = 1;
	// }
	//
	// packageSku.setWhetherLogistics(skuVO.getWhetherLogistics());
	// packageSku.setWhetherVirtual(skuVO.getWhetherVirtual());
	// packageSku.setSpvId(psSpvVO.getSpvId());
	// packageSku.setProductId(Long.valueOf(productVO.getId()));
	// packageSku.setProductCode(productVO.getCode());
	// packageSku.setExpressType(expressType);
	// packageSku.setUnitPoint(BigDecimal.ZERO);
	// packageSku.setUnitPointDeduction(BigDecimal.ZERO);
	// packageSku.setWeight(skuVO.getWeight());
	// packageSku.setTaxNo(skuVO.getTaxNo());
	//
	// packageSku.setClearanceWay(skuVO.getClearanceWay());
	// // 跨境购标注 0普通１跨境购
	// packageSku.setCrossBorderFlag(skuVO.getCrossBorderFlag());
	//
	// packageSku.setAddBy(OpSoPackageSku.ADDBY_MEMBER);// 默认会员添加
	// packageSku.setSkuCode(skuVO.getSkuCode());
	//
	// packageSku.setNameCn(skuVO.getSkuNameCN());
	// packageSku.setBrandId(skuVO.getBrandId());
	//
	// packageSku.setIsJit(skuVO.getIsJit());// 是否来单制作
	// packageSku.setQuantity(skuQuantity);// 数量
	// // 商品分类
	// packageSku.setCategoryId(skuVO.getCategoryId());
	//
	// // 代销
	// packageSku.setWhetherConsignment(skuVO.getWhetherConsignment());
	//
	// BigDecimal discountPrice = BigDecimal.valueOf(skuVO.getSalesPrice());
	//
	// if (count == skuList.size() - 1) {
	//
	// if (combinationDiscount.doubleValue() > 0) {
	// BigDecimal skuDiscount =
	// combinationDiscount.subtract(recondCombinationDiscount);
	// if (skuQuantity > 1) {
	// skuDiscount = skuDiscount.divide(BigDecimal.valueOf(skuQuantity), 2,
	// RoundingMode.HALF_UP);
	// }
	//
	// discountPrice = discountPrice.subtract(skuDiscount);
	//
	// packageSku.setUnitDiscount(skuDiscount);
	// }
	//
	// } else {
	//
	// if (combinationDiscount.doubleValue() > 0) {
	// BigDecimal skuDiscount =
	// discountPrice.multiply(combinationDiscount).divide(totalPrice, 2,
	// RoundingMode.HALF_UP);
	//
	// discountPrice = discountPrice.subtract(skuDiscount);
	//
	// recondCombinationDiscount = recondCombinationDiscount
	// .add(skuDiscount.multiply(BigDecimal.valueOf(skuQuantity)));
	//
	// packageSku.setUnitDiscount(skuDiscount);
	// }
	//
	// }
	// if (packageSku.getUnitDiscount() == null) {
	// packageSku.setUnitDiscount(BigDecimal.ZERO);
	// }
	//
	// // 折扣后金额
	// packageSku.setUnitAmountAfterDiscount(discountPrice);
	//
	// // 特价
	// packageSku.setDiscountPrice(BigDecimal.ZERO);
	//
	// packageSku.setUnitPrice(new BigDecimal(skuVO.getSalesPrice()));
	// // 是否赠品，0否1是
	// packageSku.setIsGift(0);// 底层暂不支持赠品
	//
	// if (!CollectionUtils.isEmpty(ppVO.getGifts()) && count == 0) {
	// setIsGift2(opSoPackageSkuVOs, ppVO.getGifts(), packageSku, channelCode,
	// deliveryTypes, opChannel,
	// opSalesOrderVO, voMap);
	// }
	// if (birthdayDisMap.get(ppVO.getSpv().getId()) != null) {
	// Integer skuCombinationQuantity =
	// skuCombinationMap.get(packageSku.getSkuCode());
	// if (skuCombinationQuantity == null) {
	// skuCombinationQuantity = 1;
	// }
	// // 设置生日折扣
	// packageSku.setShareBirthdayDiscount(birthdayDisMap.get(ppVO.getSpv().getId())
	// .multiply(BigDecimal.valueOf(packageSku.getQuantity() /
	// skuCombinationQuantity)));
	// opSalesOrderVO.setBirthdayDiscountAmount(
	// opSalesOrderVO.getBirthdayDiscountAmount().add(packageSku.getShareBirthdayDiscount()));
	// birthdayDisMap.remove(ppVO.getSpv().getId());
	// }
	// // 设置优惠卷折扣
	// if (couponDisMap.get(ppVO.getSpv().getId()) != null) {
	//
	// Integer skuCombinationQuantity =
	// skuCombinationMap.get(packageSku.getSkuCode());
	// if (skuCombinationQuantity == null) {
	// skuCombinationQuantity = 1;
	// }
	//
	// packageSku.setShareCouponDiscount(couponDisMap.get(ppVO.getSpv().getId())
	// .multiply(BigDecimal.valueOf(packageSku.getQuantity() /
	// skuCombinationQuantity)));
	// opSalesOrderVO.setCouponDiscountAmount(
	// opSalesOrderVO.getCouponDiscountAmount().add(packageSku.getShareCouponDiscount()));
	// couponDisMap.remove(ppVO.getSpv().getId());
	// } else {
	//
	// if (couponDisMap2.get(ppVO.getSpv().getId()) != null) {
	//
	// Integer skuCombinationQuantity =
	// skuCombinationMap.get(packageSku.getSkuCode());
	// if (skuCombinationQuantity == null) {
	// skuCombinationQuantity = 1;
	// }
	//
	// packageSku.setShareCouponDiscount(couponDisMap2.get(ppVO.getSpv().getId())
	// .multiply(BigDecimal.valueOf(packageSku.getQuantity() /
	// skuCombinationQuantity)));
	// opSalesOrderVO.setCouponDiscountAmount(
	// opSalesOrderVO.getCouponDiscountAmount().add(packageSku.getShareCouponDiscount()));
	// couponDisMap2.remove(ppVO.getSpv().getId());
	// }
	//
	// }
	//
	// if (skuVO.getDeliveryPeriod() != null) {
	// packageSku.setDeliveryPeriod(skuVO.getDeliveryPeriod());
	// } else {
	// packageSku.setDeliveryPeriod(7);
	// }
	// count++;
	// opSoPackageSkuVOs.add(packageSku);
	//
	// }
	//
	// }

	// private void combinationProd(List<OpSoPackageSkuVO> opSoPackageSkuVOs,
	// OpSalesOrderVO opSalesOrderVO,
	// final OpChannelVO opChannel, Map<String, Boolean> deliveryTypes,
	// CartProductPack ppVO,
	// Map<Long, BigDecimal> birthdayDisMap, Map<Long, BigDecimal> couponDisMap,
	// Map<String, CampaignStreamVO> voMap, Map<Long, BigDecimal> couponDisMap2,
	// Map<String, PsSkuVO> psSkuVOMap,
	// Map<Long, List<CartProductPack>> giftMap, Map<String, PrsCampaignVO>
	// campaingnMap,
	// Map<String, List<OpSoPackageSkuVO>> packageSkusMap, OrderCreateVO
	// orderCreateVO) {
	// int count = 0;
	// OpSoPackageSkuVO packageSku = null;
	// // 判断是否包含两种以上配送方式，如果是，则需要强制审单
	// int expressType = 0;
	// PsProductVO productVO = ppVO.getProduct();
	//
	// // 商品原始总价
	// BigDecimal totalPrice = BigDecimal.ZERO;
	//
	// // 设置组合商品信息
	// setCombinationPordInfo(ppVO, opSalesOrderVO);
	//
	// List<PsSkuVO> skuList = new ArrayList<>();
	// Map<String, Integer> quantityMap = new HashMap<>();
	//
	// // PsProductCond cond = new PsProductCond();
	// // cond.setId(String.valueOf(psSpvVO.getProductId()));
	// // List<PsProductVO> productVOs = mcPsProductService.findByCond(cond);
	//
	// if (productVO == null) {
	// throw new ChannelException(ErrorCode.PARAMS_ILLEGAL.getCode(),
	// "组合商品prodId查不到商品：" + ppVO.getProductId());
	// }
	//
	// // 判断是否包含两种以上配送方式，如果是，则需要强制审单
	// expressType = productVO.getExpressType();
	//
	// if (OpProduct.EP_TYPE_SELF == expressType) {
	// deliveryTypes.put("SELF", true);
	// } else if (OpProduct.EP_TYPE_FED == expressType) {
	// deliveryTypes.put("FEDX24", true);
	// } else if (OpProduct.EP_TYPE_Sf_AIR == expressType) {
	// deliveryTypes.put("SF_AIR", true);
	// } else if (OpProduct.EP_TYPE_Sf_LAND == expressType) {
	// deliveryTypes.put("SF_LAND", true);
	// } else if (OpProduct.EP_TYPE_YTO == expressType) {// 圆通
	// deliveryTypes.put("YTO", true);
	// } else if (OpProduct.EP_TYPE_DEPPON == expressType) {
	// deliveryTypes.put("DEPPON", true);
	// } else if (OpProduct.EP_TYPE_ZT == expressType) {
	// deliveryTypes.put("ZT", true);
	// }
	//
	// Integer skuQuantitys = 0;
	//
	// // 存放组合sku的起售数量
	// Map<String, Integer> skuCombinationMap = new HashMap<>();
	//
	// // 取得所有商品原始总金额
	// for (PsSkuCombinationVO psSKUComVo :
	// ppVO.getSpv().getSkuCombinationList()) {
	//
	// PsSkuVO skuVO = psSkuVOMap.get(psSKUComVo.getSubSkuCode());
	//
	// if (skuVO == null) {
	//
	// throw new ChannelException(ErrorCode.DATA_NOT_FOUND.getCode(),
	// "组合商品sku不存在： " + psSKUComVo.getSubSkuCode());
	// }
	//
	// // 包裹数量乘以最小绑定数量乘以sku数量
	// skuQuantitys = ppVO.getCount() * ppVO.getSpv().getMinAmount() *
	// psSKUComVo.getQuantity();
	// quantityMap.put(psSKUComVo.getSubSkuCode(), skuQuantitys);
	// skuList.add(skuVO);
	// totalPrice = totalPrice
	// .add(BigDecimal.valueOf(skuVO.getSalesPrice()).multiply(BigDecimal.valueOf(skuQuantitys)));
	// skuCombinationMap.put(psSKUComVo.getSubSkuCode(),
	// psSKUComVo.getQuantity());
	//
	// }
	//
	// BigDecimal combinationDiscount = totalPrice
	// .subtract(ppVO.getSpv().getDiscountPrice().multiply(BigDecimal.valueOf(ppVO.getCount())));
	//
	// BigDecimal recondCombinationDiscount = BigDecimal.ZERO;
	// for (PsSkuVO skuVO : skuList) {
	// packageSku = new OpSoPackageSkuVO();
	// packageSku.setCombination(true);
	// packageSku.setExpressType(expressType);
	//
	// if (ppVO.getSource() != null) {
	// packageSku.setSourceId(ppVO.getSource().getId());
	// }
	//
	// if (null == productVO ||
	// CollectionUtils.isEmpty(productVO.getChnCanSaleSKu())
	// ||
	// !productVO.getCanSaleSku(orderCreateVO.getChannelCode()).contains(skuVO.getSkuCode()))
	// {
	// throw new ChannelException(ErrorCode.ITEM_OFFSHELF.getCode(), "组合商品已下架 "
	// + skuVO.getSkuCode());
	// }
	//
	// Integer skuQuantity = quantityMap.get(skuVO.getSkuCode());
	// if (skuQuantity == null || skuQuantity < 1) {
	// skuQuantity = 1;
	// }
	//
	// packageSku.setWhetherLogistics(skuVO.getWhetherLogistics());
	// packageSku.setWhetherVirtual(skuVO.getWhetherVirtual());
	// packageSku.setSpvId(ppVO.getSpv().getSpvId());
	// packageSku.setProductId(Long.valueOf(productVO.getId()));
	// packageSku.setProductCode(productVO.getCode());
	// packageSku.setExpressType(expressType);
	// packageSku.setUnitPoint(BigDecimal.ZERO);
	// packageSku.setUnitPointDeduction(BigDecimal.ZERO);
	// packageSku.setWeight(skuVO.getWeight());
	// packageSku.setTaxNo(skuVO.getTaxNo());
	//
	// packageSku.setClearanceWay(skuVO.getClearanceWay());
	// // 跨境购标注 0普通１跨境购
	// packageSku.setCrossBorderFlag(skuVO.getCrossBorderFlag());
	//
	// packageSku.setAddBy(OpSoPackageSku.ADDBY_MEMBER);// 默认会员添加
	// packageSku.setSkuCode(skuVO.getSkuCode());
	//
	// packageSku.setNameCn(skuVO.getSkuNameCN());
	// packageSku.setBrandId(skuVO.getBrandId());
	//
	// packageSku.setIsJit(skuVO.getIsJit());// 是否来单制作
	// packageSku.setQuantity(skuQuantity);// 数量
	// // 商品分类
	// packageSku.setCategoryId(skuVO.getCategoryId());
	//
	// if (skuVO.getCategoryId() != null) {
	//
	// if (opSalesOrderVO.getCategoryIds() != null) {
	//
	// if
	// (!opSalesOrderVO.getCategoryIds().contains(skuVO.getCategoryId().intValue()))
	// {
	// opSalesOrderVO.getCategoryIds().add(skuVO.getCategoryId().intValue());
	//
	// }
	//
	// } else {
	//
	// List<Integer> categoryIds = new ArrayList<>();
	// categoryIds.add(skuVO.getCategoryId().intValue());
	// opSalesOrderVO.setCategoryIds(categoryIds);
	// }
	//
	// }
	// // 代销
	// packageSku.setWhetherConsignment(skuVO.getWhetherConsignment());
	//
	// BigDecimal discountPrice = BigDecimal.valueOf(skuVO.getSalesPrice());
	//
	// if (count == skuList.size() - 1) {
	//
	// if (combinationDiscount.doubleValue() > 0) {
	// BigDecimal skuDiscount =
	// combinationDiscount.subtract(recondCombinationDiscount);
	// if (skuQuantity > 1) {
	// skuDiscount = skuDiscount.divide(BigDecimal.valueOf(skuQuantity), 2,
	// RoundingMode.HALF_UP);
	// }
	//
	// discountPrice = discountPrice.subtract(skuDiscount);
	//
	// packageSku.setUnitDiscount(skuDiscount);
	// }
	//
	// } else {
	//
	// if (combinationDiscount.doubleValue() > 0) {
	// BigDecimal skuDiscount =
	// discountPrice.multiply(combinationDiscount).divide(totalPrice, 2,
	// RoundingMode.HALF_UP);
	//
	// discountPrice = discountPrice.subtract(skuDiscount);
	//
	// recondCombinationDiscount = recondCombinationDiscount
	// .add(skuDiscount.multiply(BigDecimal.valueOf(skuQuantity)));
	//
	// packageSku.setUnitDiscount(skuDiscount);
	// }
	//
	// }
	// if (packageSku.getUnitDiscount() == null) {
	// packageSku.setUnitDiscount(BigDecimal.ZERO);
	// }
	//
	// // 折扣后金额
	// packageSku.setUnitAmountAfterDiscount(discountPrice);
	//
	// // 特价
	// packageSku.setDiscountPrice(BigDecimal.ZERO);
	//
	// packageSku.setUnitPrice(new BigDecimal(skuVO.getSalesPrice()));
	// // 是否赠品，0否1是
	// packageSku.setIsGift(0);// 底层暂不支持赠品
	//
	// if (birthdayDisMap.get(ppVO.getSpvId()) != null) {
	// Integer skuCombinationQuantity =
	// skuCombinationMap.get(packageSku.getSkuCode());
	// if (skuCombinationQuantity == null) {
	// skuCombinationQuantity = 1;
	// }
	// // 设置生日折扣
	// packageSku.setShareBirthdayDiscount(birthdayDisMap.get(ppVO.getSpvId())
	// .multiply(BigDecimal.valueOf(packageSku.getQuantity() /
	// skuCombinationQuantity)));
	// opSalesOrderVO.setBirthdayDiscountAmount(
	// opSalesOrderVO.getBirthdayDiscountAmount().add(packageSku.getShareBirthdayDiscount()));
	// birthdayDisMap.remove(ppVO.getSpvId());
	// }
	// // 设置优惠卷折扣
	// if (couponDisMap.get(ppVO.getSpvId()) != null) {
	//
	// Integer skuCombinationQuantity =
	// skuCombinationMap.get(packageSku.getSkuCode());
	// if (skuCombinationQuantity == null) {
	// skuCombinationQuantity = 1;
	// }
	//
	// packageSku.setShareCouponDiscount(couponDisMap.get(ppVO.getSpvId())
	// .multiply(BigDecimal.valueOf(packageSku.getQuantity() /
	// skuCombinationQuantity)));
	// opSalesOrderVO.setCouponDiscountAmount(
	// opSalesOrderVO.getCouponDiscountAmount().add(packageSku.getShareCouponDiscount()));
	// couponDisMap.remove(ppVO.getSpvId());
	// } else {
	//
	// if (couponDisMap2.get(ppVO.getSpvId()) != null) {
	//
	// Integer skuCombinationQuantity =
	// skuCombinationMap.get(packageSku.getSkuCode());
	// if (skuCombinationQuantity == null) {
	// skuCombinationQuantity = 1;
	// }
	//
	// packageSku.setShareCouponDiscount(couponDisMap2.get(ppVO.getSpvId())
	// .multiply(BigDecimal.valueOf(packageSku.getQuantity() /
	// skuCombinationQuantity)));
	// opSalesOrderVO.setCouponDiscountAmount(
	// opSalesOrderVO.getCouponDiscountAmount().add(packageSku.getShareCouponDiscount()));
	// couponDisMap2.remove(ppVO.getSpvId());
	// }
	//
	// }
	//
	// if (skuVO.getDeliveryPeriod() != null) {
	// packageSku.setDeliveryPeriod(skuVO.getDeliveryPeriod());
	// } else {
	// packageSku.setDeliveryPeriod(7);
	// }
	//
	// if (orderCreateVO.getSkuWarehouseMap() != null &&
	// CollectionUtils.isNotEmpty(ppVO.getDeliverys())) {
	//
	// // // 设置配送方式
	// // packageSku.setDeliveryType(ppVO.getDelivery().getDeliveryType());
	// // // 设置仓库
	// // packageSku.setWarehouseCode(
	// // skuWarehouseMap.get(ppVO.getSpvId() + skuVO.getSkuCode() +
	// // ppVO.getDelivery().getStoreCount()));
	// //
	// // String key = packageSku.getWarehouseCode() +
	// // ppVO.getDelivery().getDeliveryType();
	// // // 设置配送日期
	// // if (ppVO.getDelivery().getDeliveryDate() != null) {
	// // packageSku.setDeliveryDate(ppVO.getDelivery().getDeliveryDate());
	// // key = key + ppVO.getDelivery().getDeliveryDate().getTime();
	// // }
	// //
	// // if (packageSkusMap != null) {
	// // List<OpSoPackageSkuVO> packageSkus = packageSkusMap.get(key);
	// // if (packageSkus != null) {
	// //
	// // packageSkus.add(packageSku);
	// //
	// // packageSkusMap.put(key, packageSkus);
	// //
	// // } else {
	// // packageSkus = new ArrayList<>();
	// // packageSkus.add(packageSku);
	// // packageSkusMap.put(key, packageSkus);
	// // }
	// // }
	//
	// for (DeliveryVO vo : ppVO.getDeliverys()) {
	//
	// OpSoPackageSkuVO pSku = new OpSoPackageSkuVO();
	//
	// BeanUtils.copyProperties(packageSku, pSku);
	//
	// pSku.setGifts(new ArrayList<>());
	//
	// if (giftMap != null &&
	// CollectionUtils.isNotEmpty(giftMap.get(ppVO.getSpvId()))) {
	// setGifts(opSoPackageSkuVOs, giftMap.get(ppVO.getSpvId()), packageSku,
	// orderCreateVO.getChannelCode(), deliveryTypes, opChannel, opSalesOrderVO,
	// voMap,
	// campaingnMap);
	// giftMap.remove(ppVO.getSpvId());
	// }
	//
	// pSku.setQuantity(vo.getCount());
	// if (vo.getType() ==
	// com.thebeastshop.pegasus.channelservice.util.ConstUtil.deliveryType_1) {
	// // 设置配送方式
	// pSku.setDeliveryType(com.thebeastshop.pegasus.channelservice.util.ConstUtil.deliveryType_1);
	//
	// String key = ppVO.getSpvId() + skuVO.getSkuCode() +
	// pSku.getDeliveryType() + vo.getCount();
	// // 设置仓库
	// pSku.setWarehouseCode(orderCreateVO.getSkuWarehouseMap().get(key));
	//
	// if (orderCreateVO.getSkuPresaleWarehouseMap() != null) {
	//
	// // 判断是否有预售
	// SPresaleVO sPresaleVO =
	// orderCreateVO.getSkuPresaleWarehouseMap().get(key);
	// if (sPresaleVO != null) {
	//
	// pSku.setPresaleId(sPresaleVO.getId());
	// pSku.setPresaleStatus(OpSoPackageSku.PRESALES_STATUS_WAIT);
	// //
	// skuVO.setDispatchWarehouseCode(sPresaleVO.getDispatchWarehouseCode());//
	// // 冗余发货仓字段
	// pSku.setsPresaleVO(sPresaleVO);// 冗余整个预售对象VO
	// }
	//
	// }
	// } else {
	//
	// // 设置配送方式
	// pSku.setDeliveryType(com.thebeastshop.pegasus.channelservice.util.ConstUtil.deliveryType_0);
	//
	// // 设置仓库
	// pSku.setWarehouseCode(orderCreateVO.getSkuWarehouseMap()
	// .get(ppVO.getSpvId() + skuVO.getSkuCode() + pSku.getDeliveryType() +
	// vo.getCount()));
	//
	// }
	//
	// String key = ppVO.getSource().getId() + pSku.getWarehouseCode() +
	// pSku.getDeliveryType();
	// // 设置配送日期
	// if (vo.getDate() != null) {
	// pSku.setDeliveryDate(vo.getDate());
	// key = key + vo.getDate().getTime();
	// }
	//
	// List<OpSoPackageSkuVO> packageSkus = packageSkusMap.get(key);
	// if (packageSkus != null) {
	//
	// packageSkus.add(pSku);
	//
	// packageSkusMap.put(key, packageSkus);
	//
	// } else {
	// packageSkus = new ArrayList<>();
	// packageSkus.add(pSku);
	// packageSkusMap.put(key, packageSkus);
	// }
	//
	// }
	//
	// }
	//
	// count++;
	// opSoPackageSkuVOs.add(packageSku);
	//
	// }
	//
	// }

	private void combinationProd(List<OpSoPackageSkuVO> opSoPackageSkuVOs, OpSalesOrderVO opSalesOrderVO,
			final OpChannelVO opChannel, String channelCode, Map<String, Boolean> deliveryTypes, CartProductPack ppVO,
			Map<Long, BigDecimal> birthdayDisMap, Map<Long, BigDecimal> couponDisMap,
			Map<String, CampaignStreamVO> voMap, Map<Long, BigDecimal> couponDisMap2, Map<String, PsSkuVO> psSkuVOMap,
			Map<Long, List<CartProductPack>> giftMap, Map<String, PrsCampaignVO> campaingnMap) {
		int count = 0;
		OpSoPackageSkuVO packageSku = null;
		// 判断是否包含两种以上配送方式，如果是，则需要强制审单
		int expressType = 0;
		PsProductVO productVO = ppVO.getProduct();

		// 商品原始总价
		BigDecimal totalPrice = BigDecimal.ZERO;

		// 设置组合商品信息
		setCombinationPordInfo(ppVO, opSalesOrderVO);

		List<PsSkuVO> skuList = new ArrayList<>();
		Map<String, Integer> quantityMap = new HashMap<>();

		// PsProductCond cond = new PsProductCond();
		// cond.setId(String.valueOf(psSpvVO.getProductId()));
		// List<PsProductVO> productVOs = mcPsProductService.findByCond(cond);

		if (productVO == null) {
			throw new ChannelException(ErrorCode.PARAMS_ILLEGAL.getCode(), "组合商品prodId查不到商品：" + ppVO.getProductId());
		}

		// 判断是否包含两种以上配送方式，如果是，则需要强制审单
		expressType = productVO.getExpressType();

		if (OpProduct.EP_TYPE_SELF == expressType) {
			deliveryTypes.put("SELF", true);
		} else if (OpProduct.EP_TYPE_FED == expressType) {
			deliveryTypes.put("FEDX24", true);
		} else if (OpProduct.EP_TYPE_Sf_AIR == expressType) {
			deliveryTypes.put("SF_AIR", true);
		} else if (OpProduct.EP_TYPE_Sf_LAND == expressType) {
			deliveryTypes.put("SF_LAND", true);
		} else if (OpProduct.EP_TYPE_YTO == expressType) {// 圆通
			deliveryTypes.put("YTO", true);
		} else if (OpProduct.EP_TYPE_DEPPON == expressType) {
			deliveryTypes.put("DEPPON", true);
		} else if (OpProduct.EP_TYPE_ZT == expressType) {
			deliveryTypes.put("ZT", true);
		}

		Integer skuQuantitys = 0;

		// 存放组合sku的起售数量
		Map<String, Integer> skuCombinationMap = new HashMap<>();

		// 取得所有商品原始总金额
		for (PsSkuCombinationVO psSKUComVo : ppVO.getSpv().getSkuCombinationList()) {

			PsSkuVO skuVO = psSkuVOMap.get(psSKUComVo.getSubSkuCode());

			if (skuVO == null) {

				throw new ChannelException(ErrorCode.DATA_NOT_FOUND.getCode(),
						"组合商品sku不存在： " + psSKUComVo.getSubSkuCode());
			}

			// 包裹数量乘以最小绑定数量乘以sku数量
			skuQuantitys = ppVO.getCount() * ppVO.getSpv().getMinAmount() * psSKUComVo.getQuantity();
			quantityMap.put(psSKUComVo.getSubSkuCode(), skuQuantitys);
			skuList.add(skuVO);
			totalPrice = totalPrice
					.add(BigDecimal.valueOf(skuVO.getSalesPrice()).multiply(BigDecimal.valueOf(skuQuantitys)));
			skuCombinationMap.put(psSKUComVo.getSubSkuCode(), psSKUComVo.getQuantity());

		}

		BigDecimal combinationDiscount = totalPrice
				.subtract(ppVO.getSpv().getDiscountPrice().multiply(BigDecimal.valueOf(ppVO.getCount())));

		BigDecimal recondCombinationDiscount = BigDecimal.ZERO;
		for (PsSkuVO skuVO : skuList) {
			packageSku = new OpSoPackageSkuVO();
			packageSku.setCombination(true);
			packageSku.setExpressType(expressType);

			if (ppVO.getSource() != null) {
				packageSku.setSourceId(ppVO.getSource().getCode());
			}

			if (null == productVO || CollectionUtils.isEmpty(productVO.getChnCanSaleSKu())
					|| !productVO.getCanSaleSku(channelCode).contains(skuVO.getSkuCode())) {
				throw new ChannelException(ErrorCode.ITEM_OFFSHELF.getCode(), "组合商品已下架 " + skuVO.getSkuCode());
			}

			// if (opSalesOrderVO.getIsForceAudit() == null ||
			// opSalesOrderVO.getIsForceAudit() != 1) {
			//
			// if(skuVO.getCanCustomize() == null){
			// skuVO.setCanCustomize(0);
			// }
			//
			// // 来单制作，且不是代销也不是定制的情况下强制审单
			// if (1 == skuVO.getIsJit() && skuVO.getWhetherConsignment() !=
			// null && skuVO.getWhetherConsignment() == 0 &&
			// skuVO.getCanCustomize()!=1) {
			// opSalesOrderVO.setIsForceAudit(PegasusConstants.YES);
			// }
			//
			// }
			//
			// // 官网/wap这里有3个高单价的永生花盒，因为scm配送方式选项里面没有“自送“并且我们订单不支持备注，
			// // 所以针对单价高于5000元的花盒，希望改为客服强制审单
			// if (ConstUtil.forceAuditSkus.contains(skuVO.getSkuCode())) {
			// opSalesOrderVO.setIsForceAudit(PegasusConstants.YES);
			// }

			// if (opSalesOrderVO.getIsForceAudit() == PegasusConstants.NO &&
			// opChannel.getChannelType() != null
			// && opChannel.getChannelType() == 2) {
			// setIsForceAudit(opSalesOrderVO, skuVO);
			// }

			Integer skuQuantity = quantityMap.get(skuVO.getSkuCode());
			if (skuQuantity == null || skuQuantity < 1) {
				skuQuantity = 1;
			}
			// if(packageSku.){
			// BigDecimal pointLine =
			// opSalesOrderVO.getPointOnLine().add(packageSku.getUnitPoint());
			// opSalesOrderVO.setPointOnLine(pointLine);
			// }
			packageSku.setWhetherLogistics(skuVO.getWhetherLogistics());
			packageSku.setWhetherVirtual(skuVO.getWhetherVirtual());
			packageSku.setSpvId(ppVO.getSpv().getSpvId());
			packageSku.setProductId(Long.valueOf(productVO.getId()));
			packageSku.setProductCode(productVO.getCode());
			packageSku.setExpressType(expressType);
			packageSku.setUnitPoint(BigDecimal.ZERO);
			packageSku.setUnitPointDeduction(BigDecimal.ZERO);
			packageSku.setWeight(skuVO.getWeight());
			packageSku.setTaxNo(skuVO.getTaxNo());

			packageSku.setClearanceWay(skuVO.getClearanceWay());
			// 跨境购标注 0普通１跨境购
			packageSku.setCrossBorderFlag(skuVO.getCrossBorderFlag());

			packageSku.setAddBy(OpSoPackageSku.ADDBY_MEMBER);// 默认会员添加
			packageSku.setSkuCode(skuVO.getSkuCode());

			packageSku.setNameCn(skuVO.getSkuNameCN());
			packageSku.setBrandId(skuVO.getBrandId());

			packageSku.setIsJit(skuVO.getIsJit());// 是否来单制作
			packageSku.setQuantity(skuQuantity);// 数量
			// 商品分类
			packageSku.setCategoryId(skuVO.getCategoryId());

			if (skuVO.getCategoryId() != null) {

				if (opSalesOrderVO.getCategoryIds() != null) {

					if (!opSalesOrderVO.getCategoryIds().contains(skuVO.getCategoryId().intValue())) {
						opSalesOrderVO.getCategoryIds().add(skuVO.getCategoryId().intValue());

					}

				} else {

					List<Integer> categoryIds = new ArrayList<>();
					categoryIds.add(skuVO.getCategoryId().intValue());
					opSalesOrderVO.setCategoryIds(categoryIds);
				}

			}
			// 代销
			packageSku.setWhetherConsignment(skuVO.getWhetherConsignment());

			BigDecimal discountPrice = BigDecimal.valueOf(skuVO.getSalesPrice());

			if (count == skuList.size() - 1) {

				if (combinationDiscount.doubleValue() > 0) {
					BigDecimal skuDiscount = combinationDiscount.subtract(recondCombinationDiscount);
					if (skuQuantity > 1) {
						skuDiscount = skuDiscount.divide(BigDecimal.valueOf(skuQuantity), 2, RoundingMode.HALF_UP);
					}

					discountPrice = discountPrice.subtract(skuDiscount);

					packageSku.setUnitDiscount(skuDiscount);
				}

			} else {

				if (combinationDiscount.doubleValue() > 0) {
					BigDecimal skuDiscount = discountPrice.multiply(combinationDiscount).divide(totalPrice, 2,
							RoundingMode.HALF_UP);

					discountPrice = discountPrice.subtract(skuDiscount);

					recondCombinationDiscount = recondCombinationDiscount
							.add(skuDiscount.multiply(BigDecimal.valueOf(skuQuantity)));

					packageSku.setUnitDiscount(skuDiscount);
				}

			}
			if (packageSku.getUnitDiscount() == null) {
				packageSku.setUnitDiscount(BigDecimal.ZERO);
			}

			// 折扣后金额
			packageSku.setUnitAmountAfterDiscount(discountPrice);

			// 特价
			packageSku.setDiscountPrice(BigDecimal.ZERO);

			packageSku.setUnitPrice(new BigDecimal(skuVO.getSalesPrice()));
			// 是否赠品，0否1是
			packageSku.setIsGift(0);// 底层暂不支持赠品

			if (giftMap != null && CollectionUtils.isNotEmpty(giftMap.get(ppVO.getSpvId()))) {
				setGifts(opSoPackageSkuVOs, giftMap.get(ppVO.getSpvId()), packageSku, channelCode, deliveryTypes,
						opChannel, opSalesOrderVO, voMap, campaingnMap);
				giftMap.remove(ppVO.getSpvId());
			}
			if (birthdayDisMap.get(ppVO.getSpvId()) != null) {
				Integer skuCombinationQuantity = skuCombinationMap.get(packageSku.getSkuCode());
				if (skuCombinationQuantity == null) {
					skuCombinationQuantity = 1;
				}
				// 设置生日折扣
				packageSku.setShareBirthdayDiscount(birthdayDisMap.get(ppVO.getSpvId())
						.multiply(BigDecimal.valueOf(packageSku.getQuantity() / skuCombinationQuantity)));
				opSalesOrderVO.setBirthdayDiscountAmount(
						opSalesOrderVO.getBirthdayDiscountAmount().add(packageSku.getShareBirthdayDiscount()));
				birthdayDisMap.remove(ppVO.getSpvId());
			}
			// 设置优惠卷折扣
			if (couponDisMap.get(ppVO.getSpvId()) != null) {

				Integer skuCombinationQuantity = skuCombinationMap.get(packageSku.getSkuCode());
				if (skuCombinationQuantity == null) {
					skuCombinationQuantity = 1;
				}

				packageSku.setShareCouponDiscount(couponDisMap.get(ppVO.getSpvId())
						.multiply(BigDecimal.valueOf(packageSku.getQuantity() / skuCombinationQuantity)));
				opSalesOrderVO.setCouponDiscountAmount(
						opSalesOrderVO.getCouponDiscountAmount().add(packageSku.getShareCouponDiscount()));
				couponDisMap.remove(ppVO.getSpvId());
			} else {

				if (couponDisMap2.get(ppVO.getSpvId()) != null) {

					Integer skuCombinationQuantity = skuCombinationMap.get(packageSku.getSkuCode());
					if (skuCombinationQuantity == null) {
						skuCombinationQuantity = 1;
					}

					packageSku.setShareCouponDiscount(couponDisMap2.get(ppVO.getSpvId())
							.multiply(BigDecimal.valueOf(packageSku.getQuantity() / skuCombinationQuantity)));
					opSalesOrderVO.setCouponDiscountAmount(
							opSalesOrderVO.getCouponDiscountAmount().add(packageSku.getShareCouponDiscount()));
					couponDisMap2.remove(ppVO.getSpvId());
				}

			}

			if (skuVO.getDeliveryPeriod() != null) {
				packageSku.setDeliveryPeriod(skuVO.getDeliveryPeriod());
			} else {
				packageSku.setDeliveryPeriod(7);
			}
			count++;
			opSoPackageSkuVOs.add(packageSku);

		}

	}

	private void combinationProdIPOS(List<OpSoPackageSkuVO> opSoPackageSkuVOs, OpSalesOrderVO opSalesOrderVO,
			final OpChannelVO opChannel, Map<String, Boolean> deliveryTypes, CartProductPack ppVO,
			Map<Long, BigDecimal> birthdayDisMap, Map<Long, BigDecimal> couponDisMap,
			Map<String, CampaignStreamVO> voMap, Map<Long, BigDecimal> couponDisMap2, Map<String, PsSkuVO> psSkuVOMap,
			Map<Long, List<CartProductPack>> giftMap, Map<String, PrsCampaignVO> campaingnMap,
			Map<String, List<OpSoPackageSkuVO>> packageSkusMap, OrderCreateVO orderCreateVO) {
		int count = 0;
		OpSoPackageSkuVO packageSku = null;
		// 判断是否包含两种以上配送方式，如果是，则需要强制审单
		int expressType = 0;
		PsProductVO productVO = ppVO.getProduct();

		// 商品原始总价
		BigDecimal totalPrice = BigDecimal.ZERO;

		// 设置组合商品信息
		setCombinationPordInfo(ppVO, opSalesOrderVO);

		List<PsSkuVO> skuList = new ArrayList<>();
		Map<String, Integer> quantityMap = new HashMap<>();

		// PsProductCond cond = new PsProductCond();
		// cond.setId(String.valueOf(psSpvVO.getProductId()));
		// List<PsProductVO> productVOs = mcPsProductService.findByCond(cond);

		if (productVO == null) {
			throw new ChannelException(ErrorCode.PARAMS_ILLEGAL.getCode(), "组合商品prodId查不到商品：" + ppVO.getProductId());
		}

		// 判断是否包含两种以上配送方式，如果是，则需要强制审单
		expressType = productVO.getExpressType();

		if (OpProduct.EP_TYPE_SELF == expressType) {
			deliveryTypes.put("SELF", true);
		} else if (OpProduct.EP_TYPE_FED == expressType) {
			deliveryTypes.put("FEDX24", true);
		} else if (OpProduct.EP_TYPE_Sf_AIR == expressType) {
			deliveryTypes.put("SF_AIR", true);
		} else if (OpProduct.EP_TYPE_Sf_LAND == expressType) {
			deliveryTypes.put("SF_LAND", true);
		} else if (OpProduct.EP_TYPE_YTO == expressType) {// 圆通
			deliveryTypes.put("YTO", true);
		} else if (OpProduct.EP_TYPE_DEPPON == expressType) {
			deliveryTypes.put("DEPPON", true);
		} else if (OpProduct.EP_TYPE_ZT == expressType) {
			deliveryTypes.put("ZT", true);
		}

		Integer skuQuantitys = 0;

		// 存放组合sku的起售数量
		Map<String, Integer> skuCombinationMap = new HashMap<>();

		// 取得所有商品原始总金额
		for (PsSkuCombinationVO psSKUComVo : ppVO.getSpv().getSkuCombinationList()) {

			PsSkuVO skuVO = psSkuVOMap.get(psSKUComVo.getSubSkuCode());

			if (skuVO == null) {

				throw new ChannelException(ErrorCode.DATA_NOT_FOUND.getCode(),
						"组合商品sku不存在： " + psSKUComVo.getSubSkuCode());
			}

			// 最小绑定数量乘以sku数量
			skuQuantitys = ppVO.getCount() * ppVO.getSpv().getMinAmount() * psSKUComVo.getQuantity();
			quantityMap.put(psSKUComVo.getSubSkuCode(), skuQuantitys);
			skuList.add(skuVO);
			totalPrice = totalPrice
					.add(BigDecimal.valueOf(skuVO.getSalesPrice()).multiply(BigDecimal.valueOf(skuQuantitys)));
			skuCombinationMap.put(psSKUComVo.getSubSkuCode(), psSKUComVo.getQuantity());

		}

		BigDecimal combinationDiscount = totalPrice
				.subtract(ppVO.getSpv().getDiscountPrice().multiply(BigDecimal.valueOf(ppVO.getCount())));

		BigDecimal recondCombinationDiscount = BigDecimal.ZERO;
		for (PsSkuVO skuVO : skuList) {
			packageSku = new OpSoPackageSkuVO();
			packageSku.setCombination(true);
			packageSku.setExpressType(expressType);

			if (ppVO.getSource() != null) {
				packageSku.setSourceId(ppVO.getSource().getCode());
			}

			if (null == productVO || CollectionUtils.isEmpty(productVO.getChnCanSaleSKu())
					|| !productVO.getCanSaleSku(orderCreateVO.getChannelCode()).contains(skuVO.getSkuCode())) {
				throw new ChannelException(ErrorCode.ITEM_OFFSHELF.getCode(), "组合商品已下架 " + skuVO.getSkuCode());
			}

			Integer skuQuantity = quantityMap.get(skuVO.getSkuCode());
			if (skuQuantity == null || skuQuantity < 1) {
				skuQuantity = 1;
			}

			packageSku.setWhetherLogistics(skuVO.getWhetherLogistics());
			packageSku.setWhetherVirtual(skuVO.getWhetherVirtual());
			packageSku.setSpvId(ppVO.getSpv().getSpvId());
			packageSku.setProductId(Long.valueOf(productVO.getId()));
			packageSku.setProductCode(productVO.getCode());
			packageSku.setExpressType(expressType);
			packageSku.setUnitPoint(BigDecimal.ZERO);
			packageSku.setUnitPointDeduction(BigDecimal.ZERO);
			packageSku.setWeight(skuVO.getWeight());
			packageSku.setTaxNo(skuVO.getTaxNo());

			packageSku.setClearanceWay(skuVO.getClearanceWay());
			// 跨境购标注 0普通１跨境购
			packageSku.setCrossBorderFlag(skuVO.getCrossBorderFlag());

			packageSku.setAddBy(OpSoPackageSku.ADDBY_MEMBER);// 默认会员添加
			packageSku.setSkuCode(skuVO.getSkuCode());

			packageSku.setNameCn(skuVO.getSkuNameCN());
			packageSku.setBrandId(skuVO.getBrandId());

			packageSku.setIsJit(skuVO.getIsJit());// 是否来单制作
			packageSku.setQuantity(skuQuantity);// 数量
			// 商品分类
			packageSku.setCategoryId(skuVO.getCategoryId());

			if (skuVO.getCategoryId() != null) {

				if (opSalesOrderVO.getCategoryIds() != null) {

					if (!opSalesOrderVO.getCategoryIds().contains(skuVO.getCategoryId().intValue())) {
						opSalesOrderVO.getCategoryIds().add(skuVO.getCategoryId().intValue());

					}

				} else {

					List<Integer> categoryIds = new ArrayList<>();
					categoryIds.add(skuVO.getCategoryId().intValue());
					opSalesOrderVO.setCategoryIds(categoryIds);
				}

			}
			// 代销
			packageSku.setWhetherConsignment(skuVO.getWhetherConsignment());

			BigDecimal discountPrice = BigDecimal.valueOf(skuVO.getSalesPrice());

			if (count == skuList.size() - 1) {

				if (combinationDiscount.doubleValue() > 0) {
					BigDecimal skuDiscount = combinationDiscount.subtract(recondCombinationDiscount);
					if (skuQuantity > 1) {
						skuDiscount = skuDiscount.divide(BigDecimal.valueOf(skuQuantity), 2, RoundingMode.HALF_UP);
					}

					discountPrice = discountPrice.subtract(skuDiscount);

					packageSku.setUnitDiscount(skuDiscount);
				}

			} else {

				if (combinationDiscount.doubleValue() > 0) {
					BigDecimal skuDiscount = discountPrice.multiply(combinationDiscount).divide(totalPrice, 2,
							RoundingMode.HALF_UP);

					discountPrice = discountPrice.subtract(skuDiscount);

					recondCombinationDiscount = recondCombinationDiscount
							.add(skuDiscount.multiply(BigDecimal.valueOf(skuQuantity)));

					packageSku.setUnitDiscount(skuDiscount);
				}

			}
			if (packageSku.getUnitDiscount() == null) {
				packageSku.setUnitDiscount(BigDecimal.ZERO);
			}

			// 折扣后金额
			packageSku.setUnitAmountAfterDiscount(discountPrice);

			// 特价
			packageSku.setDiscountPrice(BigDecimal.ZERO);

			packageSku.setUnitPrice(new BigDecimal(skuVO.getSalesPrice()));
			// 是否赠品，0否1是
			packageSku.setIsGift(0);// 底层暂不支持赠品

			if (birthdayDisMap.get(ppVO.getSpvId()) != null) {
				Integer skuCombinationQuantity = skuCombinationMap.get(packageSku.getSkuCode());
				if (skuCombinationQuantity == null) {
					skuCombinationQuantity = 1;
				}
				// 设置生日折扣
				packageSku.setShareBirthdayDiscount(birthdayDisMap.get(ppVO.getSpvId())
						.multiply(BigDecimal.valueOf(packageSku.getQuantity() / skuCombinationQuantity)));
				opSalesOrderVO.setBirthdayDiscountAmount(
						opSalesOrderVO.getBirthdayDiscountAmount().add(packageSku.getShareBirthdayDiscount()));
				birthdayDisMap.remove(ppVO.getSpvId());
			}
			// 设置优惠卷折扣
			if (couponDisMap.get(ppVO.getSpvId()) != null) {

				Integer skuCombinationQuantity = skuCombinationMap.get(packageSku.getSkuCode());
				if (skuCombinationQuantity == null) {
					skuCombinationQuantity = 1;
				}

				packageSku.setShareCouponDiscount(couponDisMap.get(ppVO.getSpvId())
						.multiply(BigDecimal.valueOf(packageSku.getQuantity() / skuCombinationQuantity)));
				opSalesOrderVO.setCouponDiscountAmount(
						opSalesOrderVO.getCouponDiscountAmount().add(packageSku.getShareCouponDiscount()));
				couponDisMap.remove(ppVO.getSpvId());
			} else {

				if (couponDisMap2.get(ppVO.getSpvId()) != null) {

					Integer skuCombinationQuantity = skuCombinationMap.get(packageSku.getSkuCode());
					if (skuCombinationQuantity == null) {
						skuCombinationQuantity = 1;
					}

					packageSku.setShareCouponDiscount(couponDisMap2.get(ppVO.getSpvId())
							.multiply(BigDecimal.valueOf(packageSku.getQuantity() / skuCombinationQuantity)));
					opSalesOrderVO.setCouponDiscountAmount(
							opSalesOrderVO.getCouponDiscountAmount().add(packageSku.getShareCouponDiscount()));
					couponDisMap2.remove(ppVO.getSpvId());
				}

			}

			if (skuVO.getDeliveryPeriod() != null) {
				packageSku.setDeliveryPeriod(skuVO.getDeliveryPeriod());
			} else {
				packageSku.setDeliveryPeriod(7);
			}

			if (orderCreateVO.getSkuWarehouseMap() != null && CollectionUtils.isNotEmpty(ppVO.getDeliverys())) {

				// // 设置配送方式
				// packageSku.setDeliveryType(ppVO.getDelivery().getDeliveryType());
				// // 设置仓库
				// packageSku.setWarehouseCode(
				// skuWarehouseMap.get(ppVO.getSpvId() + skuVO.getSkuCode() +
				// ppVO.getDelivery().getStoreCount()));
				//
				// String key = packageSku.getWarehouseCode() +
				// ppVO.getDelivery().getDeliveryType();
				// // 设置配送日期
				// if (ppVO.getDelivery().getDeliveryDate() != null) {
				// packageSku.setDeliveryDate(ppVO.getDelivery().getDeliveryDate());
				// key = key + ppVO.getDelivery().getDeliveryDate().getTime();
				// }
				//
				// if (packageSkusMap != null) {
				// List<OpSoPackageSkuVO> packageSkus = packageSkusMap.get(key);
				// if (packageSkus != null) {
				//
				// packageSkus.add(packageSku);
				//
				// packageSkusMap.put(key, packageSkus);
				//
				// } else {
				// packageSkus = new ArrayList<>();
				// packageSkus.add(packageSku);
				// packageSkusMap.put(key, packageSkus);
				// }
				// }

				for (ScDeliveryVO vo : ppVO.getDeliverys()) {

					OpSoPackageSkuVO pSku = new OpSoPackageSkuVO();

					BeanUtils.copyProperties(packageSku, pSku);

					pSku.setGifts(new ArrayList<>());

					if (CollectionUtils.isNotEmpty(ppVO.getGiftPacks())) {

						setGiftsIPOS(opSoPackageSkuVOs, ppVO.getSpvId(), pSku, deliveryTypes, opChannel, opSalesOrderVO,
								voMap, campaingnMap, packageSkusMap, orderCreateVO, ppVO.getGiftPacks());
						ppVO.setGiftPacks(null);
					}

					Integer skuCombinationQuantity = skuCombinationMap.get(packageSku.getSkuCode());
					if (skuCombinationQuantity == null) {
						skuCombinationQuantity = 1;
					}
					// 要乘以最小购买数
					pSku.setQuantity(vo.getCount() * skuCombinationQuantity);
					if (vo.getType() == com.thebeastshop.pegasus.channelservice.util.ConstUtil.deliveryType_1) {
						// 设置配送方式
						pSku.setDeliveryType(com.thebeastshop.pegasus.channelservice.util.ConstUtil.deliveryType_1);

						String key = ppVO.getSpvId() + skuVO.getSkuCode() + pSku.getDeliveryType() + vo.getCount();
						// 设置仓库
						pSku.setWarehouseCode(orderCreateVO.getSkuWarehouseMap().get(key));

						if (orderCreateVO.getSkuPresaleWarehouseMap() != null) {

							// 判断是否有预售
							SPresaleVO sPresaleVO = orderCreateVO.getSkuPresaleWarehouseMap().get(key);
							if (sPresaleVO != null) {

								pSku.setPresaleId(sPresaleVO.getId());
								pSku.setPresaleStatus(OpSoPackageSku.PRESALES_STATUS_WAIT);
								// skuVO.setDispatchWarehouseCode(sPresaleVO.getDispatchWarehouseCode());//
								// 冗余发货仓字段
								pSku.setsPresaleVO(sPresaleVO);// 冗余整个预售对象VO
							}

						}
					} else {

						// 设置配送方式
						pSku.setDeliveryType(com.thebeastshop.pegasus.channelservice.util.ConstUtil.deliveryType_0);

						// 设置仓库
						pSku.setWarehouseCode(orderCreateVO.getSkuWarehouseMap()
								.get(ppVO.getSpvId() + skuVO.getSkuCode() + pSku.getDeliveryType() + vo.getCount()));

					}

					String key = pSku.getWarehouseCode() + pSku.getDeliveryType();
					// 设置配送日期
					if (vo.getDate() != null) {
						pSku.setDeliveryDate(vo.getDate());
						key = key + vo.getDate().getTime();
					}

					List<OpSoPackageSkuVO> packageSkus = packageSkusMap.get(key);
					
					boolean bool =true;
					
					if (packageSkus != null) {
						
						for(OpSoPackageSkuVO sku:packageSkus){
							if (sku.getSkuCode().equals(pSku.getSkuCode()) && sku.getSourceId().equals(pSku.getSourceId())) {
								packageSkus.add(pSku);

								packageSkusMap.put(key, packageSkus);
								bool = false;
								break;
							}

						}
						
						if (bool) {
							packageSkus.add(pSku);

							packageSkusMap.put(key, packageSkus);
						}
							

					} else {
						packageSkus = new ArrayList<>();
						packageSkus.add(pSku);
						packageSkusMap.put(key, packageSkus);
					}

				}

			}

			count++;
			opSoPackageSkuVOs.add(packageSku);

		}

	}

	private void setCombinationPordInfo(CartProductPack ppVO, OpSalesOrderVO opSalesOrderVO) {
		if (null != ppVO) {
			if (null != opSalesOrderVO.getSalesOrderCombinations()) {
				OpSalesOrderCombination opSalesOrderCombination = new OpSalesOrderCombination();
				opSalesOrderCombination.setSpvId(ppVO.getSpvId());
				opSalesOrderCombination.setQuantity(ppVO.getCount());
				opSalesOrderVO.getSalesOrderCombinations().add(opSalesOrderCombination);
			} else {
				List<OpSalesOrderCombination> opSalesOrderCombinations = new ArrayList<>();
				OpSalesOrderCombination opSalesOrderCombination = new OpSalesOrderCombination();
				opSalesOrderCombination.setSpvId(ppVO.getSpvId());
				opSalesOrderCombination.setQuantity(ppVO.getCount());
				opSalesOrderCombinations.add(opSalesOrderCombination);
				opSalesOrderVO.setSalesOrderCombinations(opSalesOrderCombinations);
			}
		}
	}

	private void setGifts(List<OpSoPackageSkuVO> opSoPackageSkuVOs, List<CartProductPack> getZhengPin,
			OpSoPackageSkuVO mainPackageSku, String channelCode, Map<String, Boolean> deliveryTypes,
			final OpChannelVO opChannel, OpSalesOrderVO opSalesOrderVO, Map<String, CampaignStreamVO> voMap,
			Map<String, PrsCampaignVO> campaingnMap) {
		// String interestId = null;
		String campignCode = "";

		for (CartProductPack ppvo : getZhengPin) {

			if (ppvo.getCount() <= 0) {
				logger.info(ppvo.getSpv().getProductName() + "为赠品，数量为：0");
				continue;
			}
			PsProductVO productVO = ppvo.getProduct();
			logger.info("setGifts--赠品spvId:" + ppvo.getSpvId() + ",是否是组合商品Combined:" + ppvo.getSpv().getCombined()
					+ ",name:" + productVO.getNameCn());
			// PsSpvVO psSpvVO =
			// mcPsSpvService.findBySpvId(ppvo.getSpv().getId());
			if (ppvo.getSpv() != null && ppvo.getSpv().getCombined()) {
				setCombinationPordInfo(ppvo, opSalesOrderVO);
			}

			List<String> skuCodes = new ArrayList<>();

			if (ppvo.getSpv().getCombined()) {

				if (CollectionUtils.isNotEmpty(ppvo.getSpv().getSkuCombinationList())) {

					// 取出所有skuCode
					for (PsSkuCombinationVO bean : ppvo.getSpv().getSkuCombinationList()) {

						if (bean.getSubSkuCode() != null) {
							if (!skuCodes.contains(bean.getSubSkuCode())) {
								skuCodes.add(bean.getSubSkuCode());

							}
						}

					}

				}

			} else {

				if (ppvo.getSpv().getSkuCode() != null) {
					if (!skuCodes.contains(ppvo.getSpv().getSkuCode())) {
						skuCodes.add(ppvo.getSpv().getSkuCode());

					}
				}

			}

			for (String skuCode : skuCodes) {

				final OpSoPackageSkuVO packageSku = new OpSoPackageSkuVO();

				if (ppvo.getSource() != null) {
					// 判断是否是权益商品
					if (CartPackSource.BENEFIT.id.equals(ppvo.getSource().getCode())) {

						campignCode = ppvo.getSourceBindVal();

					} else if (CartPackSource.GIFT.id.equals(ppvo.getSource().getCode())) {

						if (campaingnMap != null) {
							PrsCampaignVO campaingnVO = campaingnMap
									.get(productVO.getId() + "" + mainPackageSku.getSpvId());
							// 设置活动属性
							if (campaingnVO != null) {

								// 找到赠品活动，取到它的活动code
								if (DiscountType.GIFT.getId().equals(campaingnVO.getDiscountTypeId())) {

									campignCode = campaingnVO.getCode();
									String key = campignCode + productVO.getCode();
									if (voMap.get(key) == null) {
										CampaignStreamVO vo = new CampaignStreamVO();
										vo.setCampaignCode(campignCode);
										vo.setMemberCode(opSalesOrderVO.getMemberCode());
										vo.setQuantity(ppvo.getCount());
										vo.setSkuCode(skuCode);
										vo.setProductCode(productVO.getCode());

										voMap.put(key, vo);
									}

								}
							}
						}

					}
				}

				// productVO = mcPsProductService.findProdBySkuCode(skuCode);

				final PsSkuVO skuVO = mcPsSkuService.findBySkuCode(skuCode);

				packageSku.setWhetherLogistics(skuVO.getWhetherLogistics());
				packageSku.setWhetherVirtual(skuVO.getWhetherVirtual());
				packageSku.setSourceId(ppvo.getSource().getCode());
				packageSku.setUnitPoint(BigDecimal.ZERO);
				packageSku.setUnitPointDeduction(BigDecimal.ZERO);
				packageSku.setWeight(skuVO.getWeight());
				packageSku.setTaxNo(skuVO.getTaxNo());
				packageSku.setClearanceWay(skuVO.getClearanceWay());
				// 跨境购标注 0普通１跨境购
				packageSku.setCrossBorderFlag(skuVO.getCrossBorderFlag());

				packageSku.setAddBy(OpSoPackageSku.ADDBY_MEMBER);// 默认会员添加
				packageSku.setSkuCode(skuVO.getSkuCode());
				packageSku.setNameCn(skuVO.getSkuNameCN());
				packageSku.setBrandId(skuVO.getBrandId());
				// packageSku.setCategroyId(skuVO.getCategoryId());

				packageSku.setMainSkuCode(mainPackageSku.getSkuCode());
				packageSku.setIsJit(skuVO.getIsJit());// 是否来单制作
				packageSku.setQuantity(ppvo.getCount());// 数量
				// 商品分类
				packageSku.setCategoryId(skuVO.getCategoryId());

				// 代销
				packageSku.setWhetherConsignment(skuVO.getWhetherConsignment());

				if (productVO != null) {

					packageSku.setProductCode(productVO.getCode());
					// 判断是否包含两种以上配送方式，如果是，则需要强制审单
					final int expressType = productVO.getExpressType();
					packageSku.setExpressType(expressType);
					if (OpProduct.EP_TYPE_SELF == expressType) {
						deliveryTypes.put("SELF", true);
					} else if (OpProduct.EP_TYPE_FED == expressType) {
						deliveryTypes.put("FEDX24", true);
					} else if (OpProduct.EP_TYPE_Sf_AIR == expressType) {
						deliveryTypes.put("SF_AIR", true);
					} else if (OpProduct.EP_TYPE_Sf_LAND == expressType) {
						deliveryTypes.put("SF_LAND", true);
					} else if (OpProduct.EP_TYPE_YTO == expressType) {// 圆通
						deliveryTypes.put("YTO", true);
					} else if (OpProduct.EP_TYPE_DEPPON == expressType) {
						deliveryTypes.put("DEPPON", true);
					} else if (OpProduct.EP_TYPE_DEPPON == expressType) {
						deliveryTypes.put("ZT", true);
					}
				}

				packageSku.setUnitDiscount(BigDecimal.ZERO);

				// 折扣后金额
				packageSku.setUnitAmountAfterDiscount(BigDecimal.ZERO);

				// 特价
				packageSku.setDiscountPrice(BigDecimal.ZERO);

				packageSku.setUnitPrice(BigDecimal.ZERO);
				packageSku.setCampignCode(campignCode);
				// 是否赠品，0否1是
				if (packageSku.getSourceId() == CartPackSource.BENEFIT.id) {

					// 是否赠品，0否1是
					packageSku.setIsGift(2);
				} else {
					// 是否赠品，0否1是
					packageSku.setIsGift(1);
				}
				packageSku.setSpvId(ppvo.getSpvId());
				packageSku.setDispatchWarehouseCode(opChannel.getWarehouseForSales());

				if (productVO.getCombined()) {
					packageSku.setProductId(Long.valueOf(productVO.getId()));
				}
				if (skuVO.getDeliveryPeriod() != null) {
					packageSku.setDeliveryPeriod(skuVO.getDeliveryPeriod());
				} else {
					packageSku.setDeliveryPeriod(7);
				}

				// opSoPackageSkuVOs.add(packageSku);
				mainPackageSku.getGifts().add(packageSku);

			}

		}

	}

	private boolean setGiftsIPOS(List<OpSoPackageSkuVO> opSoPackageSkuVOs, Long spvId, OpSoPackageSkuVO mainPackageSku,
			Map<String, Boolean> deliveryTypes, final OpChannelVO opChannel, OpSalesOrderVO opSalesOrderVO,
			Map<String, CampaignStreamVO> voMap, Map<String, PrsCampaignVO> campaingnMap,
			Map<String, List<OpSoPackageSkuVO>> packageSkusMap, OrderCreateVO orderCreateVO,
			List<CartProductPack> gifts) {

		boolean isRemove = false;
		// String interestId = null;
		String campignCode = "";

		for (CartProductPack ppvo : gifts) {

			if (ppvo.getCount() <= 0) {
				logger.info(ppvo.getSpv().getProductName() + "为赠品，数量为：0");
				continue;
			}
			PsProductVO productVO = ppvo.getProduct();
			logger.info("setGifts--赠品spvId:" + ppvo.getSpvId() + ",是否是组合商品Combined:" + ppvo.getSpv().getCombined()
					+ ",name:" + productVO.getNameCn());
			// PsSpvVO psSpvVO =
			// mcPsSpvService.findBySpvId(ppvo.getSpv().getId());
			if (ppvo.getSpv() != null && ppvo.getSpv().getCombined()) {
				setCombinationPordInfo(ppvo, opSalesOrderVO);
			}

			List<String> skuCodes = new ArrayList<>();

			if (ppvo.getSpv().getCombined()) {

				if (CollectionUtils.isNotEmpty(ppvo.getSpv().getSkuCombinationList())) {

					// 取出所有skuCode
					for (PsSkuCombinationVO bean : ppvo.getSpv().getSkuCombinationList()) {

						if (bean.getSubSkuCode() != null) {
							if (!skuCodes.contains(bean.getSubSkuCode())) {
								skuCodes.add(bean.getSubSkuCode());

							}
						}

					}

				}

			} else {

				if (ppvo.getSpv().getSkuCode() != null) {
					if (!skuCodes.contains(ppvo.getSpv().getSkuCode())) {
						skuCodes.add(ppvo.getSpv().getSkuCode());

					}
				}

			}

			for (String skuCode : skuCodes) {

				final OpSoPackageSkuVO packageSku = new OpSoPackageSkuVO();

				if (ppvo.getSource() != null) {
					// 判断是否是权益商品
					if (CartPackSource.BENEFIT.id.equals(ppvo.getSource().getCode())) {

						campignCode = ppvo.getSourceBindVal();

					} else if (CartPackSource.GIFT.id.equals(ppvo.getSource().getCode())) {

						if (campaingnMap != null) {
							PrsCampaignVO campaingnVO = null;
							if (mainPackageSku == null) {
								campaingnVO = campaingnMap.get(productVO.getId());
							} else {

								campaingnVO = campaingnMap.get(productVO.getId() + "" + mainPackageSku.getSpvId());
							}

							// 设置活动属性
							if (campaingnVO != null) {

								// 找到赠品活动，取到它的活动code
								if (DiscountType.GIFT.getId().equals(campaingnVO.getDiscountTypeId())) {

									campignCode = campaingnVO.getCode();
									String key = campignCode + productVO.getCode();
									if (voMap.get(key) == null) {
										CampaignStreamVO vo = new CampaignStreamVO();
										vo.setCampaignCode(campignCode);
										vo.setMemberCode(opSalesOrderVO.getMemberCode());
										vo.setQuantity(ppvo.getCount());
										vo.setSkuCode(skuCode);
										vo.setProductCode(productVO.getCode());

										voMap.put(key, vo);
									}

								}
							}
						}

					}
				}

				// productVO = mcPsProductService.findProdBySkuCode(skuCode);

				final PsSkuVO skuVO = mcPsSkuService.findBySkuCode(skuCode);

				packageSku.setWhetherLogistics(skuVO.getWhetherLogistics());
				packageSku.setWhetherVirtual(skuVO.getWhetherVirtual());
				packageSku.setSourceId(ppvo.getSource().getCode());
				packageSku.setUnitPoint(BigDecimal.ZERO);
				packageSku.setUnitPointDeduction(BigDecimal.ZERO);
				packageSku.setWeight(skuVO.getWeight());
				packageSku.setTaxNo(skuVO.getTaxNo());
				packageSku.setClearanceWay(skuVO.getClearanceWay());
				// 跨境购标注 0普通１跨境购
				packageSku.setCrossBorderFlag(skuVO.getCrossBorderFlag());

				packageSku.setAddBy(OpSoPackageSku.ADDBY_MEMBER);// 默认会员添加
				packageSku.setSkuCode(skuVO.getSkuCode());
				packageSku.setNameCn(skuVO.getSkuNameCN());
				packageSku.setBrandId(skuVO.getBrandId());
				// packageSku.setCategroyId(skuVO.getCategoryId());

				packageSku.setIsJit(skuVO.getIsJit());// 是否来单制作
				packageSku.setQuantity(ppvo.getCount());// 数量
				// 商品分类
				packageSku.setCategoryId(skuVO.getCategoryId());

				// 代销
				packageSku.setWhetherConsignment(skuVO.getWhetherConsignment());

				if (productVO != null) {

					packageSku.setProductCode(productVO.getCode());
					// 判断是否包含两种以上配送方式，如果是，则需要强制审单
					final int expressType = productVO.getExpressType();
					packageSku.setExpressType(expressType);
					if (OpProduct.EP_TYPE_SELF == expressType) {
						deliveryTypes.put("SELF", true);
					} else if (OpProduct.EP_TYPE_FED == expressType) {
						deliveryTypes.put("FEDX24", true);
					} else if (OpProduct.EP_TYPE_Sf_AIR == expressType) {
						deliveryTypes.put("SF_AIR", true);
					} else if (OpProduct.EP_TYPE_Sf_LAND == expressType) {
						deliveryTypes.put("SF_LAND", true);
					} else if (OpProduct.EP_TYPE_YTO == expressType) {// 圆通
						deliveryTypes.put("YTO", true);
					} else if (OpProduct.EP_TYPE_DEPPON == expressType) {
						deliveryTypes.put("DEPPON", true);
					} else if (OpProduct.EP_TYPE_DEPPON == expressType) {
						deliveryTypes.put("ZT", true);
					}
				}

				packageSku.setUnitDiscount(BigDecimal.ZERO);

				// 折扣后金额
				packageSku.setUnitAmountAfterDiscount(BigDecimal.ZERO);

				// 特价
				packageSku.setDiscountPrice(BigDecimal.ZERO);

				packageSku.setUnitPrice(BigDecimal.ZERO);
				packageSku.setCampignCode(campignCode);
				// 是否赠品，0否1是
				if (packageSku.getSourceId() == CartPackSource.BENEFIT.id) {

					// 是否赠品，0否1是
					packageSku.setIsGift(2);
				} else {
					// 是否赠品，0否1是
					packageSku.setIsGift(1);
				}
				packageSku.setSpvId(ppvo.getSpvId());
				packageSku.setDispatchWarehouseCode(opChannel.getWarehouseForSales());

				if (productVO.getCombined()) {
					packageSku.setProductId(Long.valueOf(productVO.getId()));
				}
				if (skuVO.getDeliveryPeriod() != null) {
					packageSku.setDeliveryPeriod(skuVO.getDeliveryPeriod());
				} else {
					packageSku.setDeliveryPeriod(7);
				}

				// opSoPackageSkuVOs.add(packageSku);

				if (mainPackageSku != null) {
					packageSku.setMainSkuCode(mainPackageSku.getSkuCode());
				}

				if (CollectionUtils.isNotEmpty(ppvo.getDeliverys()) && orderCreateVO.getSkuWarehouseMap() != null
						&& packageSkusMap != null) {

					for (ScDeliveryVO vo : ppvo.getDeliverys()) {

						OpSoPackageSkuVO pSku = new OpSoPackageSkuVO();

						BeanUtils.copyProperties(packageSku, pSku);

						if (vo.getType() == com.thebeastshop.pegasus.channelservice.util.ConstUtil.deliveryType_1) {

							// if(deliveryType !=
							// com.thebeastshop.pegasus.channelservice.util.ConstUtil.deliveryType_1){
							// continue;
							// }

							pSku.setQuantity(vo.getCount());

							if (ppvo.getCount() - vo.getCount() <= 0) {

								isRemove = true;
							} else {
								ppvo.setCount(ppvo.getCount() - vo.getCount());
							}
							// 设置配送方式
							pSku.setDeliveryType(com.thebeastshop.pegasus.channelservice.util.ConstUtil.deliveryType_1);

							String key = ppvo.getSpvId() + skuCode + pSku.getDeliveryType() + vo.getCount();
							// 设置仓库
							pSku.setWarehouseCode(orderCreateVO.getSkuWarehouseMap().get(key));

							if (orderCreateVO.getSkuPresaleWarehouseMap() != null) {

								// 判断是否有预售
								SPresaleVO sPresaleVO = orderCreateVO.getSkuPresaleWarehouseMap().get(key);
								if (sPresaleVO != null) {

									pSku.setPresaleId(sPresaleVO.getId());
									pSku.setPresaleStatus(OpSoPackageSku.PRESALES_STATUS_WAIT);
									// skuVO.setDispatchWarehouseCode(sPresaleVO.getDispatchWarehouseCode());//
									// 冗余发货仓字段
									pSku.setsPresaleVO(sPresaleVO);// 冗余整个预售对象VO
								}

							}

						} else {

							// if(deliveryType !=
							// com.thebeastshop.pegasus.channelservice.util.ConstUtil.deliveryType_0){
							// continue;
							// }
							pSku.setQuantity(vo.getCount());

							if (ppvo.getCount() - vo.getCount() <= 0) {

								isRemove = true;
							} else {
								ppvo.setCount(ppvo.getCount() - vo.getCount());
							}
							// 设置配送方式
							pSku.setDeliveryType(com.thebeastshop.pegasus.channelservice.util.ConstUtil.deliveryType_0);

							// 设置仓库
							pSku.setWarehouseCode(orderCreateVO.getSkuWarehouseMap()
									.get(ppvo.getSpvId() + skuCode + pSku.getDeliveryType() + vo.getCount()));

						}

						String key =  pSku.getWarehouseCode() + pSku.getDeliveryType();
						// 设置配送日期
						if (vo.getDate() != null) {
							pSku.setDeliveryDate(vo.getDate());
							key = key + vo.getDate().getTime();
						}

						List<OpSoPackageSkuVO> packageSkus = packageSkusMap.get(key);
						if (packageSkus != null) {

							boolean bool = true;
							for (OpSoPackageSkuVO sku : packageSkus) {

								if (sku.getSkuCode().equals(pSku.getSkuCode()) && sku.getSourceId().equals(pSku.getSourceId())) {
									sku.setQuantity(sku.getQuantity() + pSku.getQuantity());
									bool = false;
									break;
								}

							}

							if (bool) {
								packageSkus.add(pSku);

								packageSkusMap.put(key, packageSkus);
							}

						} else {
							packageSkus = new ArrayList<>();
							packageSkus.add(pSku);
							packageSkusMap.put(key, packageSkus);
						}

						// mainPackageSku.getGifts().add(packageSku);
					}

				}

			}

			// giftMap.put(spvId, value);

		}

		return isRemove;

	}
	// private BigDecimal getCouponFee(Long userId, List<CartProductPack>
	// sourcePacks, long couponId) {
	// // 初始值
	// BigDecimal couponFee = BigDecimal.ZERO;
	// MemberVO member = new MemberVO();
	// member.setId(userId);
	//
	// if (CollectionUtils.isEmpty(sourcePacks)) {
	//
	// return couponFee;
	// }
	//
	// CpCouponVO couponVO =
	// cpCouponService.getCouponWithAllById(Long.valueOf(couponId));
	// if
	// (couponVO.getCouponSample().getCouponTypeId().equals(CpCouponTypeEnum.CHEAPEN_LINE.getId()))
	// {
	// try {
	// CpFullCutPriceVO fullCutCoupon = (CpFullCutPriceVO)
	// couponVO.getCouponSample().getCouponContent();
	// couponFee = fullCutCoupon.getCutPrice();
	// } catch (Exception ex) {
	// Map map = couponVO.getCouponSample().getCouponContentMap();
	// if (map.get("cutPrice") instanceof Integer) {
	// Integer fee = (Integer) map.get("cutPrice");
	// couponFee = new BigDecimal(fee);
	// } else if (map.get("cutPrice") instanceof BigDecimal) {
	// couponFee = (BigDecimal) map.get("cutPrice");
	// } else {
	// Double fee = (Double) map.get("cutPrice");
	// couponFee = new BigDecimal(fee);
	// logger.info("couponFee=" + couponFee);
	// }
	// }
	// }
	//
	// return couponFee;
	// }

	/**
	 * 获取订单活动信息
	 *
	 * 购物车商品包
	 * 
	 * @param member
	 *            会员
	 * @param accessWay
	 *            来源
	 * @return
	 */
	public OrderCampaignVO getOrderCampaign(OrderCreateVO orderCreateVO, MemberVO member, OpChannelVO opChannel,
			AccessWayEnum accessWay, Map<Long, BigDecimal> birthdayDisMap, Map<Long, BigDecimal> couponDisMap,
			Map<Long, BigDecimal> couponDisMap2) {
		OrderCampaignVO OrderCampaignVO = new OrderCampaignVO();

		if (CollectionUtils.isNotEmpty(orderCreateVO.getPacks())) {
			Map<Long, CartProductPack> spvAddiblePackMap = Maps.newHashMap();// spv和加价购map
			Map<Long, CartProductPack> spvGiftPackMap = Maps.newHashMap();// spv和赠品map
			Map<Long, CartProductPack> spvBenefitPackMap = Maps.newHashMap();// spv和权益商品map
			List<CartProductPack> changeAddiblePacks = Lists.newArrayList();// 修改规格的加价购
			List<CartProductPack> changeGiftPacks = Lists.newArrayList();// 修改规格的赠品

			Boolean changeGiftPackFlg = false;

			List<ProductPackVO> interestPacks = new ArrayList<>();
			List<ProductPackVO> giftPacks = new ArrayList<>();
			Iterator<CartProductPack> iterator = orderCreateVO.getPacks().iterator();
			while (iterator.hasNext()) {
				CartProductPack pack = iterator.next();
				if (null != pack) {
					if (CartPackSourceEnum.ADDIBLE.equals(pack.getSource())) {
						changeAddiblePacks.add(pack);
						spvAddiblePackMap.put(pack.getSpvId(), pack);
						iterator.remove();
					} else if (CartPackSourceEnum.GIFT.equals(pack.getSource())) {
						changeGiftPacks.add(pack);
						spvGiftPackMap.put(pack.getSpvId(), pack);
						ProductPackVO vo = new ProductPackVO();

						BeanUtils.copyProperties(pack, vo);
						giftPacks.add(vo);
						iterator.remove();
					} else if (CartPackSourceEnum.BENEFIT.equals(pack.getSource())) {
						spvBenefitPackMap.put(pack.getSpvId(), pack);

						ProductPackVO vo = new ProductPackVO();

						BeanUtils.copyProperties(pack, vo);
						interestPacks.add(vo);
					}
				}
			}

			// 价格计算
			CalculateProductPackDTO dto = new CalculateProductPackDTO();
			dto.setAccessWay(accessWay);
			dto.setOpChannel(opChannel);
			if (member != null) {
				dto.setMember(member);
			}

			if (StringUtils.isNotBlank(orderCreateVO.getCouponCode())) {
				dto.setCouponId(Long.valueOf(orderCreateVO.getCouponCode()));
			}

			dto.setPacks(orderCreateVO.getPacks());

			dto.setBirthday(orderCreateVO.isUseBdayDiscount());

			PriceResult priceResult = priceService.calculateProductPackPrice(dto);
			// PriceResult priceResult = orderCreateVO.getPriceResult();

			List<PriceStep> steps = priceResult.getSteps();
			if (CollectionUtils.isNotEmpty(steps)) {

				for (PriceStep step : steps) {
					if (PriceType.BIRTHDAY.id == step.getPriceType().getId()) {

						for (ProductPack pack : step.getFinalPackPrice().keySet()) {

							BigDecimal originalPrice = step.getOriginalPackPrice().get(pack);
							BigDecimal finalPrice = step.getFinalPackPrice().get(pack);

							birthdayDisMap.put(pack.getSpvId(), originalPrice.subtract(finalPrice));
						}
					} else if (PriceType.COUPON.id == step.getPriceType().getId()) {
						for (ProductPack pack : step.getFinalPackPrice().keySet()) {

							BigDecimal originalPrice = step.getOriginalPackPrice().get(pack);
							BigDecimal finalPrice = step.getFinalPackPrice().get(pack);

							if (couponDisMap.get(pack.getSpvId()) == null) {
								couponDisMap.put(pack.getSpvId(), originalPrice.subtract(finalPrice));
							} else {
								couponDisMap2.put(pack.getSpvId(), originalPrice.subtract(finalPrice));
							}

						}
					}

				}

			}

			List<CampaignResult> campaignResults = priceResult.getCampaignResults();

			final List<ProductPackVO> addiblePacks = new ArrayList<>();// 加价购的商品包

			Map<Long, Collection<ProductPackVO>> giftProduct = new HashMap<>(); // 赠品

			if (campaignResults != null && !campaignResults.isEmpty()) {
				// logger.info("campaignResults={}", campaignResults);
				for (int i = 0, size = campaignResults.size(); i < size; i++) {
					final CampaignResult campaignResult = campaignResults.get(i);
					final ProductScope productScope = campaignResult.getProductScope();
					final DiscountType discountType = campaignResult.getDiscountType();
					Collection<ProductPack> productPacks = campaignResult.getAdditionalPacks();

					Collection<ProductPackVO> additionalPackVOs = new ArrayList<>();

					/** 加一个逻辑 给官网下单使用,把赠品放进去start */
					if (discountType == DiscountType.GIFT) {

						changeGiftPackFlg = true;
						additionalPackVOs = handleGiftPacks(productPacks, changeGiftPacks,
								campaignResult.getCampaign());
						Collection<ProductPack> masterProduct = campaignResult.getParticipatingPacks();// 这是主品
						if (productScope == ProductScope.SINGLE) {// 单品活动
							if (CollectionUtils.isNotEmpty(masterProduct)) {
								int count = additionalPackVOs.size();
								int balance = additionalPackVOs.size();
								int per = count / masterProduct.size();
								Iterator<ProductPackVO> iterator2 = additionalPackVOs.iterator();
								Iterator<ProductPack> iterator3 = masterProduct.iterator();
								while (iterator3.hasNext()) {
									ProductPack productPack = iterator3.next();
									if (null != productPack) {
										List<ProductPackVO> temp = Lists
												.newArrayListWithExpectedSize(additionalPackVOs.size());
										if (iterator3.hasNext()) {
											for (int j = 0; j < per; j++) {
												temp.add(iterator2.next());
												iterator2.remove();
											}
										} else {
											for (int j = 0; j < balance; j++) {
												temp.add(iterator2.next());
												iterator2.remove();
											}
										}

										Collection<ProductPackVO> gifts = giftProduct.get(productPack.getSpvId());
										if (CollectionUtils.isNotEmpty(gifts)) {

											gifts.addAll(temp);
											giftProduct.put(productPack.getSpvId(), gifts);// 添加
										} else {
											giftProduct.put(productPack.getSpvId(), temp);// 添加
										}

										balance = balance - per;
									}
								}
							}
						} else if (productScope == ProductScope.MULTI) {
							if (CollectionUtils.isNotEmpty(masterProduct)) {

								if (CollectionUtils.isNotEmpty(campaignResult.getParticipatingPacks())
										&& campaignResult.getParticipatingPacks().iterator().next() != null) {

									Collection<ProductPackVO> gifts = giftProduct
											.get(campaignResult.getParticipatingPacks().iterator().next().getSpvId());
									if (CollectionUtils.isNotEmpty(gifts)) {

										gifts.addAll(additionalPackVOs);
										giftProduct.put(
												campaignResult.getParticipatingPacks().iterator().next().getSpvId(),
												gifts);
									} else {
										giftProduct.put(
												campaignResult.getParticipatingPacks().iterator().next().getSpvId(),
												additionalPackVOs);
									}

								}

							}
						} else if (productScope == ProductScope.GLOBAL) {
							if (CollectionUtils.isNotEmpty(masterProduct)) {

								// 添加
								if (CollectionUtils.isNotEmpty(campaignResult.getParticipatingPacks())
										&& campaignResult.getParticipatingPacks().iterator().next() != null) {

									Collection<ProductPackVO> gifts = giftProduct
											.get(campaignResult.getParticipatingPacks().iterator().next().getSpvId());
									if (CollectionUtils.isNotEmpty(gifts)) {

										gifts.addAll(additionalPackVOs);
										giftProduct.put(
												campaignResult.getParticipatingPacks().iterator().next().getSpvId(),
												gifts);
									} else {
										giftProduct.put(
												campaignResult.getParticipatingPacks().iterator().next().getSpvId(),
												additionalPackVOs);
									}
								}

							}
						}
						/** 加一个逻辑 给官网下单使用,把赠品放进去 end */
					} else if (discountType == DiscountType.CHEAPEN_OTHER) {// 加价购：丢到后面加价购框框里。
						additionalPackVOs = handleAddiblePacks(productPacks, changeAddiblePacks,
								campaignResult.getCampaign());
						addiblePacks.addAll(additionalPackVOs);
					}
				} // for
			}

			// 直接引用 app的代码 逻辑 保持一直 end
			// 这里做最后的拼接操作
			// Map<ProductPack, OrderProductPackVO> map =
			// getOrderProductPackNew(member, accessWay, opChannel,
			// priceResult);
			List<OrderProductPackVO> validPackVos = getOrderProductPackNew(member, accessWay, opChannel, priceResult);

			/** 把 赠品 放入到 商品中 */
			for (OrderProductPackVO productPackVO : validPackVos) {
				if (null != productPackVO && productPackVO.getSpv() != null) {
					Collection<ProductPackVO> productPacks = giftProduct.get(productPackVO.getSpv().getId());
					if (CollectionUtils.isNotEmpty(productPacks)) {

						// 转换成我要的vo
						productPackVO.setGifts(convertProductPack(productPacks));
						// 移除赠品，防止出现相现的spvId
						giftProduct.remove(productPackVO.getSpv().getId());
					}
				}
			}

			List<Long> spvIds = Lists.newArrayList();

			List<String> prodIds = Lists.newArrayList();
			Map<Long, PsSpvVO> spvMap = new HashMap<>();

			Map<String, PsProductVO> prodMap = new HashMap<>();

			if (CollectionUtils.isNotEmpty(addiblePacks)) {
				for (ProductPack pack : addiblePacks) {
					spvIds.add(pack.getSpvId());
					prodIds.add(String.valueOf(pack.getProductId()));
				}
			}

			if (CollectionUtils.isNotEmpty(interestPacks) && member != null) {
				for (ProductPack pack : interestPacks) {
					spvIds.add(pack.getSpvId());
					prodIds.add(String.valueOf(pack.getProductId()));
				}
			}

			// 如果存在赠品，没有活动时进行处理
			if (!changeGiftPackFlg && giftPacks.size() > 0) {
				for (ProductPack pack : giftPacks) {
					spvIds.add(pack.getSpvId());
					prodIds.add(String.valueOf(pack.getProductId()));
				}
			}

			if (CollectionUtils.isNotEmpty(spvIds)) {
				spvMap.putAll(mcPsSpvService.mapBySpvIdsWithStock(spvIds, opChannel.getCode()));
			}

			if (CollectionUtils.isNotEmpty(prodIds)) {
				PsProductCond cond = new PsProductCond();
				cond.setChannelCode(opChannel.getCode());
				cond.setIds(prodIds);
				cond.setPagenum(Integer.MAX_VALUE);
				cond.setChannelCode(opChannel.getCode());
				List<PsProductVO> products = mcPsProductService.findByCond(cond, true);
				if (CollectionUtils.isNotEmpty(products)) {

					for (PsProductVO prod : products) {
						prodMap.put(prod.getId(), prod);
					}

				}

			}

			if (CollectionUtils.isNotEmpty(addiblePacks)) {
				// 加价购商品包
				Map<ProductPack, OrderProductPackVO> addiblePackMap = getAddibleOrderProductPackNew(addiblePacks,
						member, accessWay, opChannel, spvMap, prodMap);
				Collection<OrderProductPackVO> addiblePackVo = addiblePackMap.values();
				for (OrderProductPackVO productPackVo : addiblePackVo) {
					SpvVO spvVo = productPackVo.getSpv();
					if (null != productPackVo && null != spvVo) {
						CartProductPack pack = spvAddiblePackMap.get(spvVo.getId());
						if (null != pack) {
							productPackVo.setId(pack.getId());
							productPackVo.setCount(pack.getCount());
							validPackVos.add(productPackVo);
						}
					}
				}

			}

			if (CollectionUtils.isNotEmpty(interestPacks) && member != null) {
				// 权益商品包
				Map<ProductPack, OrderProductPackVO> interestPackMap = getAddibleOrderProductPackNew(interestPacks,
						member, accessWay, opChannel, spvMap, prodMap);
				Collection<OrderProductPackVO> interestPackVo = interestPackMap.values();
				for (OrderProductPackVO productPackVo : interestPackVo) {
					SpvVO spvVo = productPackVo.getSpv();
					if (null != productPackVo && null != spvVo) {
						CartProductPack pack = spvBenefitPackMap.get(spvVo.getId());
						if (null != pack) {
							productPackVo.setId(pack.getId());
							productPackVo.setCount(pack.getCount());
							validPackVos.add(productPackVo);
						}
					}
				}

			}

			// 如果存在赠品，没有活动时进行处理
			if (!changeGiftPackFlg && giftPacks.size() > 0) {

				// 赠品商品包
				Map<ProductPack, OrderProductPackVO> giftPackMap = getAddibleOrderProductPackNew(giftPacks, member,
						accessWay, opChannel, spvMap, prodMap);
				Collection<OrderProductPackVO> interestPackVo = giftPackMap.values();
				for (OrderProductPackVO productPackVo : interestPackVo) {
					SpvVO spvVo = productPackVo.getSpv();
					if (null != productPackVo && null != spvVo) {
						CartProductPack pack = spvGiftPackMap.get(spvVo.getId());
						if (null != pack) {
							productPackVo.setId(pack.getId());
							productPackVo.setCount(pack.getCount());
							validPackVos.add(productPackVo);
						}
					}
				}

			}

			OrderCampaignVO.setPacks(validPackVos);
		}
		return OrderCampaignVO;
	}

	/**
	 * 操作赠品商品包（修改赠品规格：即修改spv）
	 * 
	 * @param additionalPacks
	 * @param changeGiftPacks
	 */
	private List<ProductPackVO> handleGiftPacks(Collection<ProductPack> additionalPacks,
			List<CartProductPack> changeGiftPacks, Campaign campaign) {
		List<ProductPackVO> rt = Lists.newArrayList();
		if (CollectionUtils.isNotEmpty(additionalPacks)) {
			for (ProductPack productPack : additionalPacks) {
				// for (int i = 0; i < productPack.getCount(); i++) {
				ProductPackVO newPack = new ProductPackVO();
				BeanUtils.copyProperties(productPack, newPack);
				newPack.setCount(productPack.getCount());
				newPack.setCampaign(campaign);
				Iterator<CartProductPack> iterator = changeGiftPacks.iterator();
				while (iterator.hasNext()) {
					CartProductPack changePack = iterator.next();
					if (newPack.getProductId().equals(changePack.getProductId())) {
						newPack.setSpv(changePack.getSpv());
						newPack.setSpvId(changePack.getSpvId());
						iterator.remove();
						break;
					}
				}
				rt.add(newPack);
			}
			// }
		}
		return rt;
	}

	/**
	 * 操作换购商品包（修改换购规格：即修改spv）
	 *
	 * @param additionalPacks
	 * @param changePacks
	 * @return
	 */
	private Collection<ProductPackVO> handleAddiblePacks(Collection<ProductPack> additionalPacks,
			List<CartProductPack> changePacks, Campaign campaign) {

		List<ProductPackVO> rt = Lists.newArrayList();
		if (CollectionUtils.isNotEmpty(additionalPacks)) {
			for (ProductPack productPack : additionalPacks) {

				ProductPackVO productPackVO = new ProductPackVO();
				BeanUtils.copyProperties(productPack, productPackVO);
				productPackVO.setCampaign(campaign);
				rt.add(productPackVO);
				Iterator<CartProductPack> iterator = changePacks.iterator();
				while (iterator.hasNext()) {
					CartProductPack changePack = iterator.next();
					if (productPack.getProductId().equals(changePack.getProductId())) {
						productPack.setSpv(changePack.getSpv());
						productPack.setSpvId(changePack.getSpvId());
						productPack.setCount(changePack.getCount());
						iterator.remove();
						break;
					}
				}
			}
		}
		return rt;
	}

	/**
	 * 转换
	 *
	 * @param productPacks
	 * @return
	 */
	public List<OrderProductPackVO> convertProductPack(Collection<ProductPackVO> productPacks) {
		List<OrderProductPackVO> productPackVOs = new ArrayList<>();
		if (CollectionUtils.isNotEmpty(productPacks)) {
			for (ProductPackVO productPack : productPacks) {
				OrderProductPackVO productPackVO = new OrderProductPackVO();
				productPackVO.setId(productPack.getId());
				productPackVO.setSource(CartPackSource.valueOf(productPack.getSource().name()));
				productPackVO.setCount(productPack.getCount());
				productPackVO.setCampaign(productPack.getCampaign());
				SpvVO spvVO = new SpvVO();
				spvVO.setId(productPack.getSpvId());
				spvVO.setRawPrice(BigDecimal.ZERO);
				spvVO.setPrice(BigDecimal.ZERO);
				PsSpvVO spv = mcPsSpvService.findBySpvId(productPack.getSpvId());
				List<String> skuCodes = new ArrayList<>();
				if (spv != null) {
					// 组合产品，会有多个sku
					if (spv.getCombined()) {

						if (!CollectionUtils.isEmpty(spv.getSkuCombinationList())) {

							for (PsSkuCombinationVO psVO : spv.getSkuCombinationList()) {
								skuCodes.add(psVO.getSubSkuCode());
							}

						}

					} else {
						skuCodes.add(spv.getSkuCode());

					}

					spvVO.setSkuCodes(skuCodes);
				}

				productPackVO.setSpv(spvVO);
				productPackVOs.add(productPackVO);
			}
		}
		return productPackVOs;
	}

	private Map<ProductPack, BigDecimal> getMergedPacksMap(Map<ProductPack, BigDecimal> packPrice) {
		Map<ProductPack, BigDecimal> rt = Maps.newHashMap();
		Boolean flag = null;
		ProductPack tempPack = null;
		BigDecimal tempPrice = null;
		ProductPack pack = null;
		BigDecimal price = null;
		for (Entry<ProductPack, BigDecimal> entry : packPrice.entrySet()) {
			tempPack = entry.getKey();
			tempPrice = entry.getValue();
			flag = true;
			for (Entry<ProductPack, BigDecimal> each : rt.entrySet()) {
				pack = each.getKey();
				price = each.getValue();
				if (pack.getProductId().equals(tempPack.getProductId()) && price.equals(tempPrice)
						&& pack.getSpv().getSpvId().equals(tempPack.getSpv().getSpvId())) {
					flag = false;
					pack.setCount(pack.getCount() + tempPack.getCount());
					break;
				}
			}
			if (flag) {
				rt.put(tempPack, tempPrice);
			}
		}
		return rt;
	}

	/**
	 * 批量根据商品包获取订单商品包，并组成map
	 *
	 * @param member
	 * @param accessWay
	 * @param channel
	 * @param priceResult
	 * @return
	 */
	// @Deprecated
	// public Map<ProductPack, OrderProductPackVO> getOrderProductPack(MemberVO
	// member, AccessWay accessWay, OpChannelVO opChannel, PriceResult
	// priceResult) {
	// Map<ProductPack, OrderProductPackVO> map = Maps.newHashMap();
	// if (priceResult != null &&
	// CollectionUtils.isNotEmpty(priceResult.getSteps())) {
	// PriceStep lastStep =
	// priceResult.getSteps().get(priceResult.getSteps().size() - 1); //
	// 最后一步价格计算
	// Map<ProductPack, BigDecimal> finalPriceMap =
	// lastStep.getFinalPackPrice();
	// if (finalPriceMap != null) {
	// finalPriceMap = getMergedPacksMap(finalPriceMap);
	// PsSpvVO psSpvVO = null;
	// for (Map.Entry<ProductPack, BigDecimal> entry : finalPriceMap.entrySet())
	// {
	// CartProductPack pack = (CartProductPack) entry.getKey();
	// psSpvVO = mcPsSpvService.findWithSkuAndStockBySpvId(pack.getSpvId(),
	// opChannel.getCode());
	// BigDecimal discount = entry.getValue();
	// SpvVO spvVO = spvAdapter.getSpvWithoutDiscount(psSpvVO, member,
	// opChannel);
	// OrderProductPackVO productPackVO = new OrderProductPackVO();
	// productPackVO.setId(pack.getId());
	// productPackVO.setCount(pack.getCount());
	// productPackVO.setSource(pack.getSource());
	// productPackVO.setCustomizeList(pack.getCustomizeList());
	// productPackVO.setCustomizePrice(pack.getCustomizePrice());
	// spvVO.setPrice(discount);
	//
	// productPackVO.setSpv(spvVO);
	// map.put(pack, productPackVO);
	// }
	// }
	// }
	//
	// return map;
	// }

	/**
	 * 批量根据商品包获取订单商品包，并组成map
	 *
	 * @param member
	 * @param accessWay
	 * @param opChannel
	 * @param priceResult
	 * @return
	 */
	public List<OrderProductPackVO> getOrderProductPackNew(MemberVO member, AccessWayEnum accessWay,
			OpChannelVO opChannel, PriceResult priceResult) {
		List<OrderProductPackVO> list = Lists.newArrayList();
		if (priceResult != null && CollectionUtils.isNotEmpty(priceResult.getSteps())) {
			PriceStep lastStep = priceResult.getSteps().get(priceResult.getSteps().size() - 1); // 最后一步价格计算
			Map<ProductPack, BigDecimal> finalPriceMap = lastStep.getFinalPackPrice();
			if (finalPriceMap != null) {
				finalPriceMap = getMergedPacksMap(finalPriceMap);

				List<Long> spvIds = new ArrayList<>();
				List<String> prodIds = new ArrayList<>();
				for (Map.Entry<ProductPack, BigDecimal> entry : finalPriceMap.entrySet()) {
					CartProductPack pack = (CartProductPack) entry.getKey();
					spvIds.add(pack.getSpvId());
					prodIds.add(String.valueOf(pack.getProductId()));

				}

				PsProductCond cond = new PsProductCond();
				cond.setChannelCode(opChannel.getCode());
				cond.setIds(prodIds);
				cond.setPagenum(Integer.MAX_VALUE);
				cond.setChannelCode(opChannel.getCode());
				List<PsProductVO> products = mcPsProductService.findByCond(cond, true);
				List<PsSpvVO> spvs = mcPsSpvService.findBySpvIdsWithStock(spvIds, opChannel.getCode());

				Map<Long, SpvVO> spvMap = spvAdapter.getSpvWithoutDiscountNew(spvs, products, member, opChannel, null);
				SpvVO spvVO = new SpvVO();
				for (Map.Entry<ProductPack, BigDecimal> entry : finalPriceMap.entrySet()) {
					CartProductPack pack = (CartProductPack) entry.getKey();
					BigDecimal discount = entry.getValue();
					spvVO = new SpvVO();
					BeanUtils.copyProperties(spvMap.get(pack.getSpv().getSpvId()), spvVO);
					OrderProductPackVO productPackVO = new OrderProductPackVO();
					productPackVO.setId(pack.getId());
					productPackVO.setCount(pack.getCount());
					productPackVO.setSource(CartPackSource.valueOf(pack.getSource().name()));
					productPackVO.setCustomizeList(pack.getCustomizeList());
					productPackVO.setCustomizePrice(pack.getCustomizePrice());
					spvVO.setPrice(discount);

					productPackVO.setSpv(spvVO);
					list.add(productPackVO);
				}
			}
		}

		return list;
	}

	/**
	 * 批量根据额外商品包获取订单商品包，并组成map
	 *
	 * @param packs
	 * @param member
	 * @param accessWay
	 * @param channel
	 * @return
	 */
	// @Deprecated
	// public Map<ProductPack, OrderProductPackVO>
	// getAddibleOrderProductPack(List<? extends ProductPackVO> packs, MemberVO
	// member, AccessWay accessWay, OpChannelVO opChannel) {
	// Map<ProductPack, OrderProductPackVO> map = Maps.newHashMap();
	// Map<Long, PsSpvVO> idSpvMap =
	// Maps.newHashMapWithExpectedSize(packs.size());
	// List<Long> spvIds = Lists.newArrayList();
	// for (ProductPack pack : packs) {
	// spvIds.add(pack.getSpvId());
	// }
	// List<PsSpvVO> spvs = mcPsSpvService.findBySpvIdsWithStock(spvIds,
	// opChannel.getCode());
	// for (PsSpvVO spv : spvs) {
	// idSpvMap.put(spv.getSpvId(), spv);
	// }
	// Map<Long, SpvVO> spvMap = spvAdapter.getSpvWithoutDiscount(spvs, member,
	// opChannel);
	//
	// for (ProductPackVO pack : packs) {
	// OrderProductPackVO productPackVO = new OrderProductPackVO();
	// productPackVO.setId(pack.getId());
	// productPackVO.setCount(pack.getCount());
	// productPackVO.setSource(pack.getSource());
	// PsSpvVO spv = idSpvMap.get(pack.getSpvId());
	// SpvVO spvVo = spvMap.get(spv.getSpvId());
	// spvVo.setPrice(pack.getFactProductPrice());
	// productPackVO.setSpv(spvVo);
	// productPackVO.setSourceBindVal(pack.getSourceBindVal());
	// productPackVO.setCampaign(pack.getCampaign());
	// map.put(pack, productPackVO);
	// }
	// return map;
	// }

	/**
	 * 批量根据额外商品包获取订单商品包，并组成map
	 *
	 * @param packs
	 * @param member
	 * @param accessWay
	 * @param opChannel
	 * @return
	 */
	public Map<ProductPack, OrderProductPackVO> getAddibleOrderProductPackNew(List<? extends ProductPackVO> packs,
			MemberVO member, AccessWayEnum accessWay, OpChannelVO opChannel, Map<Long, PsSpvVO> spvMap,
			Map<String, PsProductVO> prodMap) {
		Map<ProductPack, OrderProductPackVO> map = Maps.newHashMap();
		// Map<Long, PsSpvVO> idSpvMap =
		// Maps.newHashMapWithExpectedSize(packs.size());

		List<PsSpvVO> spvs = new ArrayList<>();
		for (ProductPack pack : packs) {
			spvs.add(spvMap.get(pack.getSpvId()));
		}
		// List<PsSpvVO> spvs = mcPsSpvService.findBySpvIdsWithStock(spvIds,
		// opChannel.getCode());

		Map<Long, SpvVO> spvMap2 = spvAdapter.getSpvWithoutDiscountNew2(spvs, member, opChannel, prodMap);

		for (ProductPackVO pack : packs) {
			OrderProductPackVO productPackVO = new OrderProductPackVO();
			productPackVO.setId(pack.getId());
			productPackVO.setCount(pack.getCount());
			productPackVO.setSource(CartPackSource.valueOf(pack.getSource().name()));
			// PsSpvVO spv = idSpvMap.get(pack.getSpvId());
			SpvVO spvVo = spvMap2.get(pack.getSpvId());
			spvVo.setPrice(pack.getFactProductPrice());
			productPackVO.setSpv(spvVo);
			productPackVO.setSourceBindVal(pack.getSourceBindVal());
			productPackVO.setCampaign(pack.getCampaign());
			map.put(pack, productPackVO);
		}
		return map;
	}

	/***
	 * 普通商品放在一个单独的包裹 1 合并包裹逻辑 为了保证主品和赠品同时发货、下述情况系统将自动将主品和赠品进行包裹的处理 ①
	 * 主品（现货）+赠品（现货） 包裹发货仓：[WH020600010102]元电路 – 官网渠道销售仓 ② 主品（预售）+赠品（现货） 自动合并包裹
	 * 包裹发货仓：[WH0206000101881]元电路 – 线上预售总仓 预计发货时间：预售品的计划发货时间 ③ 主品（现货）+赠品（预售）
	 * 赠品单独拆除包裹 包裹发货仓：[WH0206000101881]元电路 – 线上预售总仓 赠品包裹包裹预计发货时间：预售品的计划发货时间 ④
	 * 主品（预售）+赠品（预售） a)主品预售预计发货时间<赠品预售预计发货时间: 拆 两个包裹 包裹预计发货时间：各自预售的预计发货时间
	 * 包裹发货仓：[WH0206000101881]元电路 – 线上预售总仓 b)主品预售预计发货时间>赠品预售预计发货时间: 合并包裹
	 * 包裹发货仓：[WH0206000101881]元电路 – 线上预售总仓 包裹预计发货时间：主品预售预计发货时间
	 * <p/>
	 * /*** 判断是否需要拆分包裹，
	 *
	 * @param opChannel
	 * @return
	 */

	/***
	 * 普通商品放在一个单独的包裹 1 合并包裹逻辑 为了保证主品和赠品同时发货、下述情况系统将自动将主品和赠品进行包裹的处理 ①
	 * 主品（现货）+赠品（现货） 包裹发货仓：[WH020600010102]元电路 – 官网渠道销售仓 ② 主品（预售）+赠品（现货） 自动合并包裹
	 * 包裹发货仓：[WH0206000101881]元电路 – 线上预售总仓 预计发货时间：预售品的计划发货时间 ③ 主品（现货）+赠品（预售）
	 * 赠品单独拆除包裹 包裹发货仓：[WH0206000101881]元电路 – 线上预售总仓 赠品包裹包裹预计发货时间：预售品的计划发货时间 ④
	 * 主品（预售）+赠品（预售） a)主品预售预计发货时间<赠品预售预计发货时间: 拆 两个包裹 包裹预计发货时间：各自预售的预计发货时间
	 * 包裹发货仓：[WH0206000101881]元电路 – 线上预售总仓 b)主品预售预计发货时间>赠品预售预计发货时间: 合并包裹
	 * 包裹发货仓：[WH0206000101881]元电路 – 线上预售总仓 包裹预计发货时间：主品预售预计发货时间
	 * <p/>
	 * /*** 判断是否需要拆分包裹， 新增海淘拆包裹逻辑1.个人按800标准，bc按2000标准
	 *
	 * @param opChannel
	 * @return
	 */

	/***
	 * 普通商品放在一个单独的包裹 1 合并包裹逻辑 为了保证主品和赠品同时发货、下述情况系统将自动将主品和赠品进行包裹的处理 ①
	 * 主品（现货）+赠品（现货） 包裹发货仓：[WH020600010102]元电路 – 官网渠道销售仓 ② 主品（预售）+赠品（现货） 自动合并包裹
	 * 包裹发货仓：[WH0206000101881]元电路 – 线上预售总仓 预计发货时间：预售品的计划发货时间 ③ 主品（现货）+赠品（预售）
	 * 赠品单独拆除包裹 包裹发货仓：[WH0206000101881]元电路 – 线上预售总仓 赠品包裹包裹预计发货时间：预售品的计划发货时间 ④
	 * 主品（预售）+赠品（预售） a)主品预售预计发货时间<赠品预售预计发货时间: 拆 两个包裹 包裹预计发货时间：各自预售的预计发货时间
	 * 包裹发货仓：[WH0206000101881]元电路 – 线上预售总仓 b)主品预售预计发货时间>赠品预售预计发货时间: 合并包裹
	 * 包裹发货仓：[WH0206000101881]元电路 – 线上预售总仓 包裹预计发货时间：主品预售预计发货时间
	 * <p/>
	 * /*** 判断是否需要拆分包裹， 新增海淘拆包裹逻辑1.个人按800标准，bc按2000标准
	 *
	 * @param opChannel
	 * @return
	 */
	public List<OpSoPackageVO> splitPackage2(final OpSalesOrderVO opSalesOrderVO, final OpChannelVO opChannel,
			Map<String, SPresaleVO> sPresaleMap, Map<String, SPresaleSaleInvVO> sPresaleSaleInvMap,
			OpSoPackageVO opSoPackage) {

		final BigDecimal crossfinalFee = BigDecimal.valueOf(800);
		final BigDecimal crossfinalFeeBC = BigDecimal.valueOf(500000);

		// 海淘2000块标准拆单
		List<OpSoPackageSkuVO> crossSaleSkusBC = null;

		BigDecimal crossSkuFeeBC = BigDecimal.ZERO;

		OpSoPackageSkuVO skuVOspitBC = null;

		boolean giftboolBC = false;

		// 海淘800块标准拆单
		List<OpSoPackageSkuVO> crossSaleSkus = null;

		BigDecimal crossSkuFee = BigDecimal.ZERO;

		OpSoPackageSkuVO skuVOspit = null;

		boolean giftbool = false;

		// 海淘总费用
		BigDecimal crossPackageTotalFee = BigDecimal.ZERO;
		// 海淘BC总费用
		BigDecimal crossPackageTotalFeeBC = BigDecimal.ZERO;

		// 袋子用的临时变量
		boolean hasBag = false;
		List<Integer> hasBagSkus = new ArrayList<>();

		final List<OpSoPackageVO> allPackageVOs = new ArrayList<>();// 所有的包裹集合

		// 海淘订单中非海淘赠品
		List<OpSoPackageSkuVO> notCrossGifts = new ArrayList<>();
		List<OpSoPackageSkuVO> preSaleSkus = new ArrayList<>();// 预售的商品集合

		List<Integer> preSaleExpressTypes = new ArrayList<>();

		final List<OpSoPackageSkuVO> defaultPackageSkuVOs = new ArrayList<>(2);// 默认包裹的sku集合

		List<OpSoPackageSkuVO> crossSalePackageSkus = new ArrayList<>();// 海淘默认包裹的sku集合

		List<OpSoPackageSkuVO> crossSalePackageSkusBC = new ArrayList<>();// 海淘默认包裹的sku集合

		List<OpSoPackageSkuVO> GroupCrossSalePackageSkus = new ArrayList<>();// 组合商品海淘默认包裹的sku集合

		List<OpSoPackageSkuVO> GroupCrossSalePackageSkusBC = new ArrayList<>();// 组合商品海淘默认包裹的sku集合

		List<OpSoPackageSkuVO> jitSalePackageSkus = new ArrayList<>();// 来单制作商品海淘默认包裹的sku集合

		List<OpSoPackageSkuVO> jitSalePackageSkusBC = new ArrayList<>();// 来单制作商品海淘默认包裹的sku集合

		List<OpSoPackageSkuVO> virtualPackageSkus = new ArrayList<>();// 虚拟商品包

		// 海淘包裹集
		final List<List<OpSoPackageSkuVO>> crossSalePackages = new ArrayList<>();

		// 海淘BC包裹集
		final List<List<OpSoPackageSkuVO>> crossSalePackagesBC = new ArrayList<>();

		List<OpSoPackageVO> isJitPackageList = new ArrayList<>();// 来单制作商品包裹集

		List<OpSoPackageVO> daixiaoPackageList = new ArrayList<>();// 代销商品包裹集

		final List<WhAllotRcdVO> whAllotList = new ArrayList<>(2);// 待调拨列表

		Map<String, OpSoPackageVO> customizeMap = new HashMap<String, OpSoPackageVO>();

		// --一般是从正常销售仓
		// 调拨到预售仓

		// final List<OpSoPackageVO> sourcesPackages =
		// opSalesOrderVO.getOpSoPackageVOs();// 初始包裹集合
		// 原始订单中 包裹集合只有一个
		if (opSoPackage == null) {
			// 原始订单中，包裹数量不等于1
			throw new ChannelException(ErrorCode.PARAMS_ILLEGAL.getCode(), ErrorCode.PARAMS_ILLEGAL.getMesage());
		}

		final OpSoPackageVO sourcePackageVO = opSoPackage;// 默认的包裹对象
		final List<OpSoPackageSkuVO> sourcePackageSkus = sourcePackageVO.getOpSoPackageSkuVOs();// 为拆包裹之前
		// 原始包裹中的sku集合
		if (!CollectionUtils.isNotEmpty(sourcePackageSkus)) {
			// 原始订单包裹中商品为空
			throw new ChannelException(ErrorCode.PARAMS_ILLEGAL.getCode(), ErrorCode.PARAMS_ILLEGAL.getMesage());
		}

		List<String> skuCodes = new ArrayList<>();
		for (OpSoPackageSkuVO sku : sourcePackageSkus) {

			skuCodes.add(sku.getSkuCode());

		}

		List<OpSoPackageSkuVO> noneGiftPackageSkuVOs = getAllNoneGiftPackageSkuVOs(opChannel, sourcePackageSkus);
		final List<OpSoPackageSkuVO> noneGiftPackageSkuVOsBak = getAllNoneGiftPackageSkuVOs(opChannel,
				sourcePackageSkus);
		final List<OpSoPackageSkuVO> giftPackageSkuVOs = getAllGiftPackageSkuVOs(opChannel, sourcePackageSkus);

		OpSoPackageDeliveryInfoVO opSoPackageDeliveryInfoVO = sourcePackageVO.getOpSoPackageDeliveryInfoVO();

		try {
			Collections.sort(noneGiftPackageSkuVOs, new Comparator<OpSoPackageSkuVO>() {

				public int compare(OpSoPackageSkuVO o1, OpSoPackageSkuVO o2) {

					BigDecimal a = o1.getUnitAmountAfterDiscount().multiply(BigDecimal.valueOf(o1.getQuantity()));
					BigDecimal b = o2.getUnitAmountAfterDiscount().multiply(BigDecimal.valueOf(o2.getQuantity()));

					// 升序
					return a.compareTo(b);

					// 降序
					// return b.compareTo(a);
				}
			});
		} catch (Exception e) {
			noneGiftPackageSkuVOs = noneGiftPackageSkuVOsBak;
		}

		// ztq 20160831 鲜花拆包裹 start
		List<OpSoPackageSkuVO> flowerPackageSkus = new ArrayList<>();// 海淘默认包裹的sku集合
		// ztq 20160831 鲜花拆包裹 end

		// 提出商品的赠品
		Map<String, List<OpSoPackageSkuVO>> giftMap = new HashMap<>();
		for (OpSoPackageSkuVO skuVO : noneGiftPackageSkuVOs) {

			if (CollectionUtils.isNotEmpty(skuVO.getGifts())) {
				giftMap.put(skuVO.getSkuCode(), skuVO.getGifts());
			}
		}

		for (final OpSoPackageSkuVO skuVO : noneGiftPackageSkuVOs) {

			// 虚拟商品
			if (skuVO.getWhetherVirtual() != null && skuVO.getWhetherVirtual() == 1) {

				virtualPackageSkus.add(skuVO);

				if (CollectionUtils.isNotEmpty(skuVO.getGifts())) {

					for (OpSoPackageSkuVO giftSkuVO : skuVO.getGifts()) {
						// 虚拟商品
						if (giftSkuVO.getWhetherVirtual() != null && giftSkuVO.getWhetherVirtual() == 1) {

							virtualPackageSkus.add(giftSkuVO);

						} else {

							defaultPackageSkuVOs.add(giftSkuVO);

						}
					}

				}

				// 海淘商品拆包裹 start
			} else if (skuVO.getCrossBorderFlag() != null
					&& (skuVO.getCrossBorderFlag() == OrderCreateVO.CROSS_BOARDER_FLAG_IS_OVERSEA
							|| skuVO.getCrossBorderFlag() == OrderCreateVO.CROSS_BOARDER_FLAG_IS_OVERSEA_3)) {

				// 海淘组合商品的情况
				if (skuVO.getProductId() != null && skuVO.getProductId() > 0) {

					// 1:BC
					if (skuVO.getClearanceWay() != null && skuVO.getClearanceWay() == 1) {
						GroupCrossSalePackageSkusBC.add(skuVO);
					} else {
						GroupCrossSalePackageSkus.add(skuVO);
					}

				} else {

					// 如果是来单制作商品单独放一个包裹
					if (skuVO.getIsJit() != null && skuVO.getIsJit() == 1) {

						if (skuVO.getClearanceWay() != null && skuVO.getClearanceWay() == 1) {
							jitSalePackageSkusBC.add(skuVO);
						} else {
							jitSalePackageSkus.add(skuVO);
						}

					} else {

						// 判断sku是不是BC海淘模式
						if (skuVO.getClearanceWay() != null && skuVO.getClearanceWay() == 1) {
							BigDecimal skuFee = skuVO.getUnitAmountAfterDiscount()
									.multiply(BigDecimal.valueOf(skuVO.getQuantity()));
							// 判断价格是否大于2000
							if (skuFee.compareTo(crossfinalFeeBC) < 0) {

								if (skuFee.add(crossPackageTotalFeeBC).compareTo(crossfinalFeeBC) < 0) {
									crossSalePackageSkusBC.add(skuVO);
									// 计算海淘商品总价格
									crossPackageTotalFeeBC = crossPackageTotalFeeBC
											.add(skuVO.getUnitAmountAfterDiscount()
													.multiply(BigDecimal.valueOf(skuVO.getQuantity())));
								} else {
									crossSalePackagesBC.add(crossSalePackageSkusBC);
									crossSalePackageSkusBC = new ArrayList<>();
									crossSalePackageSkusBC.add(skuVO);
									crossPackageTotalFeeBC = skuFee;
								}

							} else {

								// 当同一商品购买多件时
								if (skuVO.getQuantity() != null && skuVO.getQuantity() > 1) {

									// 商品单价大于2000时
									if (skuVO.getUnitAmountAfterDiscount().compareTo(crossfinalFeeBC) >= 0) {

										for (int i = 0; i < skuVO.getQuantity(); i++) {
											crossSaleSkusBC = new ArrayList<>();

											if (i == 0) {
												// 判断当前商品是否有赠品.如果有赠品，则判断赠品是否是预售
												List<OpSoPackageSkuVO> gifts = giftMap.get(skuVO.getSkuCode());

												if (CollectionUtils.isNotEmpty(gifts)) {
													giftMap.remove(skuVO.getSkuCode());
													for (OpSoPackageSkuVO giftSkuVO : gifts) {

														// 虚拟商品
														if (giftSkuVO.getWhetherVirtual() != null
																&& giftSkuVO.getWhetherVirtual() == 1) {

															virtualPackageSkus.add(giftSkuVO);
															continue;

														}

														// 如果带赠品，但是主品不预售，赠品也不预售，则赠品和主品在一个包裹
														if (!isPresale(sPresaleMap, sPresaleSaleInvMap, giftSkuVO,
																opChannel, opSalesOrderVO)) {

															if (giftSkuVO.getCrossBorderFlag() == null
																	|| giftSkuVO.getCrossBorderFlag() == 0) {
																notCrossGifts.add(giftSkuVO);
															} else {
																crossSaleSkusBC.add(giftSkuVO);

															}

														} else {
															// 如果带赠品，但是主品不预售，赠品预售，则赠品在单独的包裹
															preSaleSkus.add(giftSkuVO);
															preSaleExpressTypes.add(giftSkuVO.getExpressType());
														}
													}

												}

											}

											skuVOspitBC = new OpSoPackageSkuVO();
											BeanUtils.copyProperties(skuVO, skuVOspitBC);
											skuVOspitBC.setQuantity(1);
											crossSaleSkusBC.add(skuVOspitBC);
											crossSalePackagesBC.add(crossSaleSkusBC);

										}

									} else {

										int count = 0;
										for (int i = 0; i < skuVO.getQuantity(); i++) {
											// 判断赠品
											if (i == 0) {
												crossSaleSkusBC = new ArrayList<>();
												giftboolBC = true;
												// 判断当前商品是否有赠品.如果有赠品，则判断赠品是否是预售
												List<OpSoPackageSkuVO> gifts = giftMap.get(skuVO.getSkuCode());

												if (CollectionUtils.isNotEmpty(gifts)) {
													giftMap.remove(skuVO.getSkuCode());
													for (OpSoPackageSkuVO giftSkuVO : gifts) {

														// 虚拟商品
														if (giftSkuVO.getWhetherVirtual() != null
																&& giftSkuVO.getWhetherVirtual() == 1) {

															virtualPackageSkus.add(giftSkuVO);
															continue;

														}

														// 如果带赠品，但是主品不预售，赠品也不预售，则赠品和主品在一个包裹
														if (!isPresale(sPresaleMap, sPresaleSaleInvMap, giftSkuVO,
																opChannel, opSalesOrderVO)) {

															if (giftSkuVO.getCrossBorderFlag() == null
																	|| giftSkuVO.getCrossBorderFlag() == 0) {
																notCrossGifts.add(giftSkuVO);
															} else {
																crossSaleSkusBC.add(giftSkuVO);

															}

														} else {
															// //
															// 如果带赠品，但是主品不预售，赠品预售，则赠品在单独的包裹
															preSaleSkus.add(giftSkuVO);
															preSaleExpressTypes.add(giftSkuVO.getExpressType());
														}
													}
												}
											}

											count++;
											crossSkuFeeBC = skuVO.getUnitAmountAfterDiscount()
													.multiply(BigDecimal.valueOf(count));

											// 大于2000时生成一个包裹
											if (crossSkuFeeBC.compareTo(crossfinalFeeBC) >= 0) {
												if (!giftboolBC) {
													crossSaleSkusBC = new ArrayList<>();
												}

												skuVOspitBC = new OpSoPackageSkuVO();
												BeanUtils.copyProperties(skuVO, skuVOspitBC);
												skuVOspitBC.setQuantity(count - 1);
												crossSaleSkusBC.add(skuVOspitBC);
												crossSalePackagesBC.add(crossSaleSkusBC);
												giftboolBC = false;
												count = 0;
												i = i - 1;
											} else {
												// 最后一个商品
												if (i == skuVO.getQuantity() - 1) {
													if (!giftboolBC) {
														crossSaleSkusBC = new ArrayList<>();
													}
													crossSaleSkusBC = new ArrayList<>();
													skuVOspitBC = new OpSoPackageSkuVO();
													BeanUtils.copyProperties(skuVO, skuVOspitBC);
													skuVOspitBC.setQuantity(count);
													crossSaleSkusBC.add(skuVOspitBC);
													crossSalePackagesBC.add(crossSaleSkusBC);
													giftboolBC = false;

												}
											}

										}
									}

								} else {
									crossSaleSkusBC = new ArrayList<>();
									crossSaleSkusBC.add(skuVO);
									crossSalePackagesBC.add(crossSaleSkusBC);

								}

							}

							// 判断当前商品是否有赠品.如果有赠品，则判断赠品是否是预售
							List<OpSoPackageSkuVO> gifts = giftMap.get(skuVO.getSkuCode());

							if (CollectionUtils.isNotEmpty(gifts)) {
								giftMap.remove(skuVO.getSkuCode());
								for (OpSoPackageSkuVO giftSkuVO : gifts) {

									// 虚拟商品
									if (giftSkuVO.getWhetherVirtual() != null && giftSkuVO.getWhetherVirtual() == 1) {

										virtualPackageSkus.add(giftSkuVO);
										continue;

									}
									// 如果带赠品，但是主品不预售，赠品也不预售，则赠品和主品在一个包裹
									if (!isPresale(sPresaleMap, sPresaleSaleInvMap, giftSkuVO, opChannel,
											opSalesOrderVO)) {

										if (giftSkuVO.getCrossBorderFlag() == null
												|| giftSkuVO.getCrossBorderFlag() == 0) {
											notCrossGifts.add(giftSkuVO);
										} else {
											crossSalePackageSkusBC.add(giftSkuVO);

										}
									} else {
										// 如果带赠品，但是主品不预售，赠品预售，则赠品在单独的包裹
										preSaleSkus.add(giftSkuVO);
										preSaleExpressTypes.add(giftSkuVO.getExpressType());
									}
								}

							}

						} else {
							BigDecimal skuFee = skuVO.getUnitAmountAfterDiscount()
									.multiply(BigDecimal.valueOf(skuVO.getQuantity()));
							// 判断价格是否大于800
							if (skuFee.compareTo(crossfinalFee) < 0) {

								if (skuFee.add(crossPackageTotalFee).compareTo(crossfinalFee) < 0) {
									crossSalePackageSkus.add(skuVO);
									// 计算海淘商品总价格
									crossPackageTotalFee = crossPackageTotalFee.add(skuVO.getUnitAmountAfterDiscount()
											.multiply(BigDecimal.valueOf(skuVO.getQuantity())));
								} else {
									crossSalePackages.add(crossSalePackageSkus);

									crossSalePackageSkus = new ArrayList<>();
									crossSalePackageSkus.add(skuVO);
									crossPackageTotalFee = skuFee;
								}

							} else {

								// 当同一商品购买多件时
								if (skuVO.getQuantity() != null && skuVO.getQuantity() > 1) {

									// 商品单价大于1000时
									if (skuVO.getUnitAmountAfterDiscount().compareTo(crossfinalFee) >= 0) {

										for (int i = 0; i < skuVO.getQuantity(); i++) {
											crossSaleSkus = new ArrayList<>();

											if (i == 0) {
												// 判断当前商品是否有赠品.如果有赠品，则判断赠品是否是预售
												List<OpSoPackageSkuVO> gifts = giftMap.get(skuVO.getSkuCode());

												if (CollectionUtils.isNotEmpty(gifts)) {
													giftMap.remove(skuVO.getSkuCode());
													for (OpSoPackageSkuVO giftSkuVO : gifts) {

														// 虚拟商品
														if (giftSkuVO.getWhetherVirtual() != null
																&& giftSkuVO.getWhetherVirtual() == 1) {

															virtualPackageSkus.add(giftSkuVO);
															continue;

														}
														// 如果带赠品，但是主品不预售，赠品也不预售，则赠品和主品在一个包裹
														if (!isPresale(sPresaleMap, sPresaleSaleInvMap, giftSkuVO,
																opChannel, opSalesOrderVO)) {

															if (giftSkuVO.getCrossBorderFlag() == null
																	|| giftSkuVO.getCrossBorderFlag() == 0) {
																notCrossGifts.add(giftSkuVO);
															} else {
																crossSaleSkus.add(giftSkuVO);

															}

														} else {
															// //
															// 如果带赠品，但是主品不预售，赠品预售，则赠品在单独的包裹
															preSaleSkus.add(giftSkuVO);
															preSaleExpressTypes.add(giftSkuVO.getExpressType());
														}
													}
												}
											}

											skuVOspit = new OpSoPackageSkuVO();
											BeanUtils.copyProperties(skuVO, skuVOspit);
											skuVOspit.setQuantity(1);
											crossSaleSkus.add(skuVOspit);
											crossSalePackages.add(crossSaleSkus);

										}

									} else {

										int count = 0;
										for (int i = 0; i < skuVO.getQuantity(); i++) {
											// 判断赠品
											if (i == 0) {
												crossSaleSkus = new ArrayList<>();
												giftbool = true;
												// 判断当前商品是否有赠品.如果有赠品，则判断赠品是否是预售
												List<OpSoPackageSkuVO> gifts = giftMap.get(skuVO.getSkuCode());

												if (CollectionUtils.isNotEmpty(gifts)) {
													giftMap.remove(skuVO.getSkuCode());
													for (OpSoPackageSkuVO giftSkuVO : gifts) {
														// 虚拟商品
														if (giftSkuVO.getWhetherVirtual() != null
																&& giftSkuVO.getWhetherVirtual() == 1) {

															virtualPackageSkus.add(giftSkuVO);
															continue;

														}
														// 如果带赠品，但是主品不预售，赠品也不预售，则赠品和主品在一个包裹
														if (!isPresale(sPresaleMap, sPresaleSaleInvMap, giftSkuVO,
																opChannel, opSalesOrderVO)) {

															if (giftSkuVO.getCrossBorderFlag() == null
																	|| giftSkuVO.getCrossBorderFlag() == 0) {
																notCrossGifts.add(giftSkuVO);
															} else {
																crossSaleSkus.add(giftSkuVO);

															}

														} else {
															// 如果带赠品，但是主品不预售，赠品预售，则赠品在单独的包裹
															preSaleSkus.add(giftSkuVO);
															preSaleExpressTypes.add(giftSkuVO.getExpressType());
														}
													}
												}
											}

											count++;
											crossSkuFee = skuVO.getUnitAmountAfterDiscount()
													.multiply(BigDecimal.valueOf(count));

											// 大于800时生成一个包裹
											if (crossSkuFee.compareTo(crossfinalFee) >= 0) {
												if (!giftbool) {
													crossSaleSkus = new ArrayList<>();
												}

												skuVOspit = new OpSoPackageSkuVO();
												BeanUtils.copyProperties(skuVO, skuVOspit);
												skuVOspit.setQuantity(count - 1);
												crossSaleSkus.add(skuVOspit);
												crossSalePackages.add(crossSaleSkus);
												giftbool = false;
												count = 0;
												i = i - 1;
											} else {
												// 最后一个商品
												if (i == skuVO.getQuantity() - 1) {
													if (!giftbool) {
														crossSaleSkus = new ArrayList<>();
													}
													crossSaleSkus = new ArrayList<>();
													skuVOspit = new OpSoPackageSkuVO();
													BeanUtils.copyProperties(skuVO, skuVOspit);
													skuVOspit.setQuantity(count);
													crossSaleSkus.add(skuVOspit);
													crossSalePackages.add(crossSaleSkus);
													giftbool = false;

												}
											}

										}
									}

								} else {
									crossSaleSkus = new ArrayList<>();
									crossSaleSkus.add(skuVO);
									crossSalePackages.add(crossSaleSkus);

								}

							}

							// 判断当前商品是否有赠品.如果有赠品，则判断赠品是否是预售
							List<OpSoPackageSkuVO> gifts = giftMap.get(skuVO.getSkuCode());

							if (CollectionUtils.isNotEmpty(gifts)) {
								giftMap.remove(skuVO.getSkuCode());
								for (OpSoPackageSkuVO giftSkuVO : gifts) {
									// 虚拟商品
									if (giftSkuVO.getWhetherVirtual() != null && giftSkuVO.getWhetherVirtual() == 1) {

										virtualPackageSkus.add(giftSkuVO);
										continue;

									}
									// 如果带赠品，但是主品不预售，赠品也不预售，则赠品和主品在一个包裹
									if (!isPresale(sPresaleMap, sPresaleSaleInvMap, giftSkuVO, opChannel,
											opSalesOrderVO)) {

										if (giftSkuVO.getCrossBorderFlag() == null
												|| giftSkuVO.getCrossBorderFlag() == 0) {
											notCrossGifts.add(giftSkuVO);
										} else {
											crossSalePackageSkus.add(giftSkuVO);

										}
									} else {
										// 如果带赠品，但是主品不预售，赠品预售，则赠品在单独的包裹
										preSaleSkus.add(giftSkuVO);
										preSaleExpressTypes.add(giftSkuVO.getExpressType());
									}
								}
							}

						}

					}

				}

				continue;

				// 新定制商品
			} else {

				// 101170953 ,且城市 in ('北京','天津','石家庄'),则该SKU单独拆包裹(原有用不拆单商品逻辑不变)
				if ("101170953".equals(skuVO.getSkuCode())) {
					if (opSoPackageDeliveryInfoVO != null && opSoPackageDeliveryInfoVO.getDistrictId() != null) {

						CommDistrictVO district = commAddressService.findDistrictById(opSoPackageDeliveryInfoVO.getDistrictId().intValue());

						if (district != null && district.getCityId() != null) {

							// '北京','天津','石家庄'
							if (district.getCityId().intValue() == 19 || district.getCityId().intValue() == 226
									|| district.getCityId().intValue() == 83) {

								List<OpSoPackageSkuVO> packageSkus = new ArrayList<>();
								packageSkus.add(skuVO);
								OpSoPackageVO packageVO = new OpSoPackageVO();

								BeanUtils.copyProperties(sourcePackageVO, packageVO);
								packageVO.setOpSoPackageSkuVOs(packageSkus);
								packageVO.setPackageType(6);
								packageVO.getOpSoPackageDeliveryInfoVO().setExpressType(skuVO.getExpressType());
								isJitPackageList.add(packageVO);

								// 如果存在赠品
								if (CollectionUtils.isNotEmpty(skuVO.getGifts())) {

									defaultPackageSkuVOs.addAll(skuVO.getGifts());
								}

								continue;

							}

						}

					}

				}

				if (StringUtils.isNotBlank(skuVO.getCustomizeType())) {

					// 记录配方定制商品的预计发货日期
					Date planedDeliveryDate = poInstance.setRedisCustomizeTypeVO(opSalesOrderVO, skuVO);
					skuVO.setDeliveryDate(planedDeliveryDate);
					if (skuVO.getDeliveryPeriod() > 0) {
						planedDeliveryDate = DateUtil.addDay(planedDeliveryDate, skuVO.getDeliveryPeriod());
					}

					packageIsJitNotCateId(skuVO, opChannel, sourcePackageVO, preSaleSkus, giftPackageSkuVOs,
							isJitPackageList, defaultPackageSkuVOs, hasBagSkus, preSaleExpressTypes, planedDeliveryDate,
							sPresaleMap, sPresaleSaleInvMap, opSalesOrderVO, virtualPackageSkus);

				} else if (skuVO.getWhetherConsignment() != null && skuVO.getWhetherConsignment() == 1
						&& skuVO.getIsJit() != null && skuVO.getIsJit() == 1) {
					if (ConstUtil.bagSkus.contains(skuVO.getSkuCode())) {
						hasBag = true;
					}

					packageWhetherConsignmentAndIsjit(skuVO, opChannel, sourcePackageVO, opSoPackageDeliveryInfoVO,
							preSaleSkus, giftPackageSkuVOs, daixiaoPackageList, defaultPackageSkuVOs, hasBagSkus,
							preSaleExpressTypes, sPresaleMap, sPresaleSaleInvMap, opSalesOrderVO, virtualPackageSkus);
					// }else if(skuVO.getIsJit()!=null && skuVO.getIsJit()==1 &&
					// !skuVO.getCategoryId().equals(ConstUtil.flowerCategoryId)
					// &&
					// !ConstUtil.isJitNotCateId.contains(skuVO.getCategoryId())
					// &&
					// !ConstUtil.immortalFlower.contains(skuVO.getSkuCode())){
					// 如果是定制商品
				} else if (CollectionUtils.isNotEmpty(skuVO.getCustomizeList())) {

					packageIsCustomize(skuVO, opChannel, sourcePackageVO, preSaleSkus, giftPackageSkuVOs,
							isJitPackageList, defaultPackageSkuVOs, hasBagSkus, preSaleExpressTypes, customizeMap,
							sPresaleMap, sPresaleSaleInvMap, opSalesOrderVO, virtualPackageSkus);

				} else if (skuVO.getWhetherLogistics() != null && skuVO.getWhetherLogistics() == 1) {

					packageIsBigFurniture(skuVO, opChannel, sourcePackageVO, preSaleSkus, giftPackageSkuVOs,
							isJitPackageList, defaultPackageSkuVOs, hasBagSkus, preSaleExpressTypes, null, sPresaleMap,
							sPresaleSaleInvMap, opSalesOrderVO, virtualPackageSkus);

				} else if (skuVO.getIsJit() != null && skuVO.getIsJit() == 1
						&& !ConstUtil.isJitNotCateId.contains(skuVO.getCategoryId())) {

					packageIsJitNotCateId(skuVO, opChannel, sourcePackageVO, preSaleSkus, giftPackageSkuVOs,
							isJitPackageList, defaultPackageSkuVOs, hasBagSkus, preSaleExpressTypes, null, sPresaleMap,
							sPresaleSaleInvMap, opSalesOrderVO, virtualPackageSkus);

				} else if (ConstUtil.flowerCateId.equals(skuVO.getCategoryId())) {

					Date planedDeliveryDate = sourcePackageVO.getPlanedDeliveryDate();

					packageIsJitNotCateId(skuVO, opChannel, sourcePackageVO, preSaleSkus, giftPackageSkuVOs,
							isJitPackageList, defaultPackageSkuVOs, hasBagSkus, preSaleExpressTypes, planedDeliveryDate,
							sPresaleMap, sPresaleSaleInvMap, opSalesOrderVO, virtualPackageSkus);

				} else {
					if (ConstUtil.bagSkus.contains(skuVO.getSkuCode())) {
						hasBag = true;
					}
					// 普通商品
					packageOrdinary(skuVO, opChannel, sourcePackageVO, opSoPackageDeliveryInfoVO, preSaleSkus,
							giftPackageSkuVOs, flowerPackageSkus, whAllotList, defaultPackageSkuVOs, hasBagSkus,
							preSaleExpressTypes, sPresaleMap, sPresaleSaleInvMap, opSalesOrderVO, virtualPackageSkus);
				}

			}

		}

		if (opSoPackageDeliveryInfoVO == null) {

			opSoPackageDeliveryInfoVO = new OpSoPackageDeliveryInfoVO();

		}
		int crossBorderFlag = OrderCreateVO.CROSS_BOARDER_FLAG_IS_OVERSEA;

		String dispatchWarehouseCode = sourcePackageVO.getDispatchWarehouseCode();

		if (opChannel.getChannelType() != null && opChannel.getChannelType() == 1) {

			// ChannelCrossBoarder channelCrossBoarder =
			// com.thebeastshop.pegasus.channelservice.util.ConstUtil.channelCrossBoarderMap
			// .get(opChannel.getCode());
			// if (channelCrossBoarder != null) {
			// crossBorderFlag = channelCrossBoarder.getCrossBoarderFlg();
			// dispatchWarehouseCode = channelCrossBoarder.getWarehouseCode();
			// } else {
			crossBorderFlag = OrderCreateVO.CROSS_BOARDER_FLAG_IS_OVERSEA_3;
			// opSalesOrderVO.setCrossBorderFlag(crossBorderFlag);
			// }

		}

		// 封装虚拟商品包
		if (CollectionUtils.isNotEmpty(virtualPackageSkus)) {

			OpSoPackageVO virtualSalePackage = new OpSoPackageVO();
			virtualSalePackage.setOpSoPackageSkuVOs(virtualPackageSkus);
			virtualSalePackage.setCardContent(sourcePackageVO.getCardContent());
			virtualSalePackage.setCardType(sourcePackageVO.getCardType());
			virtualSalePackage.setCardTo(sourcePackageVO.getCardTo());
			virtualSalePackage.setCardFrom(sourcePackageVO.getCardFrom());
			virtualSalePackage.setDeliveryType(0);
			virtualSalePackage.setPackageType(OpSoPackage.PACKAGE_TYPE_8);
			virtualSalePackage.setCrossBorderFlag(OrderCreateVO.CROSS_BOARDER_FLAG_NOT_OVERSEA);
			virtualSalePackage.setDispatchWarehouseCode(dispatchWarehouseCode);
			virtualSalePackage.setPlanedDeliveryDate(new Date());
			virtualSalePackage.setExpectReceiveDate(null);
			OpSoPackageDeliveryInfoVO packageDeliveryInfo = getPackageDeliveryInfo(opSoPackageDeliveryInfoVO);
			virtualSalePackage.setOpSoPackageDeliveryInfoVO(packageDeliveryInfo);
			allPackageVOs.add(virtualSalePackage);

		}

		// 海淘包裹
		if (CollectionUtils.isNotEmpty(crossSalePackageSkus)) {

			final OpSoPackageVO crossSalePackage = new OpSoPackageVO();
			crossSalePackage.setOpSoPackageSkuVOs(crossSalePackageSkus);
			crossSalePackage.setCardContent(sourcePackageVO.getCardContent());
			crossSalePackage.setCardType(sourcePackageVO.getCardType());
			crossSalePackage.setCardTo(sourcePackageVO.getCardTo());
			crossSalePackage.setCardFrom(sourcePackageVO.getCardFrom());
			crossSalePackage.setDeliveryType(sourcePackageVO.getDeliveryType());
			// 海淘包裹
			crossSalePackage.setCrossBorderFlag(crossBorderFlag);
			crossSalePackage.setClearanceWay((short) 2);
			crossSalePackage.setDispatchWarehouseCode(dispatchWarehouseCode);
			crossSalePackage.setPlanedDeliveryDate(sourcePackageVO.getPlanedDeliveryDate());

			OpSoPackageDeliveryInfoVO packageDeliveryInfo = getPackageDeliveryInfo(opSoPackageDeliveryInfoVO);
			// 海淘专用
			packageDeliveryInfo.setExpressType(OpSoPackageDeliveryInfo.EXPRESS_TYPE_ZT);
			crossSalePackage.setOpSoPackageDeliveryInfoVO(packageDeliveryInfo);
			allPackageVOs.add(crossSalePackage);
		}

		// 海淘包裹
		if (CollectionUtils.isNotEmpty(GroupCrossSalePackageSkus)) {

			final OpSoPackageVO crossSalePackage = new OpSoPackageVO();
			crossSalePackage.setOpSoPackageSkuVOs(GroupCrossSalePackageSkus);
			crossSalePackage.setCardContent(sourcePackageVO.getCardContent());
			crossSalePackage.setCardType(sourcePackageVO.getCardType());
			crossSalePackage.setCardTo(sourcePackageVO.getCardTo());
			crossSalePackage.setCardFrom(sourcePackageVO.getCardFrom());
			crossSalePackage.setDeliveryType(sourcePackageVO.getDeliveryType());
			// 海淘包裹
			crossSalePackage.setCrossBorderFlag(crossBorderFlag);
			crossSalePackage.setClearanceWay((short) 2);
			crossSalePackage.setDispatchWarehouseCode(dispatchWarehouseCode);
			crossSalePackage.setPlanedDeliveryDate(sourcePackageVO.getPlanedDeliveryDate());

			OpSoPackageDeliveryInfoVO packageDeliveryInfo = getPackageDeliveryInfo(opSoPackageDeliveryInfoVO);
			// 海淘专用
			packageDeliveryInfo.setExpressType(OpSoPackageDeliveryInfo.EXPRESS_TYPE_ZT);
			crossSalePackage.setOpSoPackageDeliveryInfoVO(packageDeliveryInfo);
			allPackageVOs.add(crossSalePackage);
		}

		// 海淘多个包裹的时候
		if (CollectionUtils.isNotEmpty(crossSalePackages)) {

			for (List<OpSoPackageSkuVO> list : crossSalePackages) {

				final OpSoPackageVO crossSalePackage = new OpSoPackageVO();
				crossSalePackage.setOpSoPackageSkuVOs(list);
				crossSalePackage.setCardContent(sourcePackageVO.getCardContent());
				crossSalePackage.setCardTo(sourcePackageVO.getCardTo());
				crossSalePackage.setCardFrom(sourcePackageVO.getCardFrom());
				crossSalePackage.setCardType(sourcePackageVO.getCardType());
				crossSalePackage.setDeliveryType(sourcePackageVO.getDeliveryType());
				// 海淘包裹
				crossSalePackage.setCrossBorderFlag(crossBorderFlag);
				crossSalePackage.setClearanceWay((short) 2);
				crossSalePackage.setDispatchWarehouseCode(dispatchWarehouseCode);
				crossSalePackage.setPlanedDeliveryDate(sourcePackageVO.getPlanedDeliveryDate());

				OpSoPackageDeliveryInfoVO packageDeliveryInfo = getPackageDeliveryInfo(opSoPackageDeliveryInfoVO);
				// 海淘专用
				packageDeliveryInfo.setExpressType(OpSoPackageDeliveryInfo.EXPRESS_TYPE_ZT);
				crossSalePackage.setOpSoPackageDeliveryInfoVO(packageDeliveryInfo);
				allPackageVOs.add(crossSalePackage);

			}

		}

		// 海淘包裹
		if (CollectionUtils.isNotEmpty(crossSalePackageSkusBC)) {
			logger.info("个人海淘多个包裹数量：" + crossSalePackagesBC.size());
			final OpSoPackageVO crossSalePackage = new OpSoPackageVO();
			crossSalePackage.setOpSoPackageSkuVOs(crossSalePackageSkusBC);
			crossSalePackage.setCardContent(sourcePackageVO.getCardContent());
			crossSalePackage.setCardTo(sourcePackageVO.getCardTo());
			crossSalePackage.setCardFrom(sourcePackageVO.getCardFrom());
			crossSalePackage.setCardType(sourcePackageVO.getCardType());
			crossSalePackage.setDeliveryType(sourcePackageVO.getDeliveryType());
			// 海淘包裹
			crossSalePackage.setCrossBorderFlag(crossBorderFlag);
			// 通关方式（0：未知，1：BC，2：个人）
			crossSalePackage.setClearanceWay((short) 1);
			crossSalePackage.setDispatchWarehouseCode(dispatchWarehouseCode);
			crossSalePackage.setPlanedDeliveryDate(sourcePackageVO.getPlanedDeliveryDate());

			OpSoPackageDeliveryInfoVO packageDeliveryInfo = getPackageDeliveryInfo(opSoPackageDeliveryInfoVO);
			// 海淘专用
			packageDeliveryInfo.setExpressType(OpSoPackageDeliveryInfo.EXPRESS_TYPE_ZT);
			crossSalePackage.setOpSoPackageDeliveryInfoVO(packageDeliveryInfo);
			allPackageVOs.add(crossSalePackage);
		}

		// 海淘包裹
		if (CollectionUtils.isNotEmpty(GroupCrossSalePackageSkusBC)) {
			logger.info("个人海淘多个包裹数量：" + crossSalePackagesBC.size());
			final OpSoPackageVO crossSalePackage = new OpSoPackageVO();
			crossSalePackage.setOpSoPackageSkuVOs(GroupCrossSalePackageSkusBC);
			crossSalePackage.setCardContent(sourcePackageVO.getCardContent());
			crossSalePackage.setCardTo(sourcePackageVO.getCardTo());
			crossSalePackage.setCardFrom(sourcePackageVO.getCardFrom());
			crossSalePackage.setCardType(sourcePackageVO.getCardType());
			crossSalePackage.setDeliveryType(sourcePackageVO.getDeliveryType());
			// 海淘包裹
			crossSalePackage.setCrossBorderFlag(crossBorderFlag);
			// 通关方式（0：未知，1：BC，2：个人）
			crossSalePackage.setClearanceWay((short) 1);
			crossSalePackage.setDispatchWarehouseCode(dispatchWarehouseCode);
			crossSalePackage.setPlanedDeliveryDate(sourcePackageVO.getPlanedDeliveryDate());

			OpSoPackageDeliveryInfoVO packageDeliveryInfo = getPackageDeliveryInfo(opSoPackageDeliveryInfoVO);
			// 海淘专用
			packageDeliveryInfo.setExpressType(OpSoPackageDeliveryInfo.EXPRESS_TYPE_ZT);
			crossSalePackage.setOpSoPackageDeliveryInfoVO(packageDeliveryInfo);
			allPackageVOs.add(crossSalePackage);
		}

		// BC海淘多个包裹的时候
		if (CollectionUtils.isNotEmpty(crossSalePackagesBC)) {

			logger.info("BC海淘多个包裹数量：" + crossSalePackagesBC.size());

			for (List<OpSoPackageSkuVO> list : crossSalePackagesBC) {

				final OpSoPackageVO crossSalePackage = new OpSoPackageVO();
				crossSalePackage.setOpSoPackageSkuVOs(list);
				crossSalePackage.setCardContent(sourcePackageVO.getCardContent());
				crossSalePackage.setCardTo(sourcePackageVO.getCardTo());
				crossSalePackage.setCardFrom(sourcePackageVO.getCardFrom());
				crossSalePackage.setCardType(sourcePackageVO.getCardType());
				crossSalePackage.setDeliveryType(sourcePackageVO.getDeliveryType());
				// 海淘包裹
				crossSalePackage.setCrossBorderFlag(crossBorderFlag);
				crossSalePackage.setClearanceWay((short) 1);
				crossSalePackage.setDispatchWarehouseCode(dispatchWarehouseCode);
				crossSalePackage.setPlanedDeliveryDate(sourcePackageVO.getPlanedDeliveryDate());

				OpSoPackageDeliveryInfoVO packageDeliveryInfo = getPackageDeliveryInfo(opSoPackageDeliveryInfoVO);
				// 海淘专用
				packageDeliveryInfo.setExpressType(OpSoPackageDeliveryInfo.EXPRESS_TYPE_ZT);
				crossSalePackage.setOpSoPackageDeliveryInfoVO(packageDeliveryInfo);
				allPackageVOs.add(crossSalePackage);

			}

		}

		// 海淘包裹
		if (CollectionUtils.isNotEmpty(jitSalePackageSkusBC)) {
			logger.info("个人海淘多个包裹数量：" + crossSalePackagesBC.size());
			final OpSoPackageVO crossSalePackage = new OpSoPackageVO();
			crossSalePackage.setOpSoPackageSkuVOs(jitSalePackageSkusBC);
			crossSalePackage.setCardContent(sourcePackageVO.getCardContent());
			crossSalePackage.setCardTo(sourcePackageVO.getCardTo());
			crossSalePackage.setCardFrom(sourcePackageVO.getCardFrom());
			crossSalePackage.setCardType(sourcePackageVO.getCardType());
			crossSalePackage.setDeliveryType(sourcePackageVO.getDeliveryType());
			// 海淘包裹
			crossSalePackage.setCrossBorderFlag(crossBorderFlag);
			// 通关方式（0：未知，1：BC，2：个人）
			crossSalePackage.setClearanceWay((short) 1);
			crossSalePackage.setDispatchWarehouseCode(dispatchWarehouseCode);
			crossSalePackage.setPlanedDeliveryDate(sourcePackageVO.getPlanedDeliveryDate());

			OpSoPackageDeliveryInfoVO packageDeliveryInfo = getPackageDeliveryInfo(opSoPackageDeliveryInfoVO);
			// 海淘专用
			packageDeliveryInfo.setExpressType(OpSoPackageDeliveryInfo.EXPRESS_TYPE_ZT);
			crossSalePackage.setOpSoPackageDeliveryInfoVO(packageDeliveryInfo);
			allPackageVOs.add(crossSalePackage);
		}

		// 海淘包裹
		if (CollectionUtils.isNotEmpty(jitSalePackageSkus)) {

			final OpSoPackageVO crossSalePackage = new OpSoPackageVO();
			crossSalePackage.setOpSoPackageSkuVOs(jitSalePackageSkus);
			crossSalePackage.setCardContent(sourcePackageVO.getCardContent());
			crossSalePackage.setCardType(sourcePackageVO.getCardType());
			crossSalePackage.setCardTo(sourcePackageVO.getCardTo());
			crossSalePackage.setCardFrom(sourcePackageVO.getCardFrom());
			crossSalePackage.setDeliveryType(sourcePackageVO.getDeliveryType());
			// 海淘包裹
			crossSalePackage.setCrossBorderFlag(crossBorderFlag);
			crossSalePackage.setClearanceWay((short) 2);
			crossSalePackage.setDispatchWarehouseCode(dispatchWarehouseCode);
			crossSalePackage.setPlanedDeliveryDate(sourcePackageVO.getPlanedDeliveryDate());

			OpSoPackageDeliveryInfoVO packageDeliveryInfo = getPackageDeliveryInfo(opSoPackageDeliveryInfoVO);
			// 海淘专用
			packageDeliveryInfo.setExpressType(OpSoPackageDeliveryInfo.EXPRESS_TYPE_ZT);
			crossSalePackage.setOpSoPackageDeliveryInfoVO(packageDeliveryInfo);
			allPackageVOs.add(crossSalePackage);
		}

		// 海淘订单中的非海淘赠品
		if (CollectionUtils.isNotEmpty(notCrossGifts)) {
			final OpSoPackageVO notCrossGiftsPackageVO = new OpSoPackageVO();

			BeanUtils.copyProperties(sourcePackageVO, notCrossGiftsPackageVO);

			notCrossGiftsPackageVO.setOpSoPackageSkuVOs(notCrossGifts);
			OpSoPackageDeliveryInfoVO packageDeliveryInfo = getPackageDeliveryInfo(opSoPackageDeliveryInfoVO);
			packageDeliveryInfo.setExpressType(OpSoPackageDeliveryInfo.EXPRESS_TYPE_SF_LAND);
			notCrossGiftsPackageVO.setOpSoPackageDeliveryInfoVO(packageDeliveryInfo);
			notCrossGiftsPackageVO.setPackageType(0);
			allPackageVOs.add(notCrossGiftsPackageVO);

		}

		// 代销商品
		if (CollectionUtils.isNotEmpty(daixiaoPackageList)) {

			logger.info("代销商品包裹数量：" + daixiaoPackageList.size());
			allPackageVOs.addAll(daixiaoPackageList);
		}

		// 来单制作商品
		if (CollectionUtils.isNotEmpty(isJitPackageList)) {

			logger.info("来单制作商品包裹数量：" + isJitPackageList.size());
			allPackageVOs.addAll(isJitPackageList);
		}
		// 定制商品包
		if (customizeMap.size() > 0) {
			allPackageVOs.addAll(customizeMap.values());
		}

		// 普通商品
		if (CollectionUtils.isNotEmpty(defaultPackageSkuVOs)) {
			Date planedDeliveryDate = null;

			if (OrderTypeEnum.ORDERTYPE_9.getCode() == opSalesOrderVO.getOrderTypeEnum().getCode()) {
				planedDeliveryDate = sourcePackageVO.getPlanedDeliveryDate();
			} else {
				Calendar c = Calendar.getInstance();

				int hour = c.get(Calendar.HOUR_OF_DAY);

				int minute = c.get(Calendar.MINUTE);

				if (hour > 16 || (hour == 16 && minute > 0)) {
					planedDeliveryDate = DateUtil.addDay(new Date(), 1);

				} else {
					planedDeliveryDate = new Date();
				}
			}

			logger.info("普通商品数量：" + defaultPackageSkuVOs.size());
			// 店送包裹
			List<OpSoPackageSkuVO> daixiaoShopPackges = new ArrayList<>();
			// 联邦包裹
			List<OpSoPackageSkuVO> daixiaoFedexPackages = new ArrayList<>();
			// 顺丰空运包裹
			List<OpSoPackageSkuVO> daixiaoSfAirPackages = new ArrayList<>();
			// 顺丰陆运包裹
			List<OpSoPackageSkuVO> daixiaoFfLandPackages = new ArrayList<>();
			// 圆通陆运包裹
			List<OpSoPackageSkuVO> daixiaoYtoPackages = new ArrayList<>();
			// 德邦陆运包裹
			List<OpSoPackageSkuVO> daixiaoDepponPackages = new ArrayList<>();
			// 自送包裹
			List<OpSoPackageSkuVO> daixiaoSelfPackages = new ArrayList<>();

			// 自送包裹
			List<OpSoPackageSkuVO> daixiaoZtPackages = new ArrayList<>();

			for (OpSoPackageSkuVO sku : defaultPackageSkuVOs) {
				// 如果没有快递类型设为顺风
				if (sku.getExpressType() == null) {
					daixiaoYtoPackages.add(sku);
					// 1店送
				} else if (sku.getExpressType() == OpSoPackageDeliveryInfo.EXPRESS_TYPE_SHOP) {
					daixiaoShopPackges.add(sku);
					// 2联邦
				} else if (sku.getExpressType() == OpSoPackageDeliveryInfo.EXPRESS_TYPE_FEDEX) {
					daixiaoFedexPackages.add(sku);
					// 3顺丰空运
				} else if (sku.getExpressType() == OpSoPackageDeliveryInfo.EXPRESS_TYPE_SF_AIR) {
					daixiaoSfAirPackages.add(sku);
					// 4顺丰陆运
				} else if (sku.getExpressType() == OpSoPackageDeliveryInfo.EXPRESS_TYPE_SF_LAND) {
					daixiaoFfLandPackages.add(sku);
					// 5圆通
				} else if (sku.getExpressType() == OpSoPackageDeliveryInfo.EXPRESS_TYPE_YTO) {
					daixiaoYtoPackages.add(sku);
					// 6德邦
				} else if (sku.getExpressType() == OpSoPackageDeliveryInfo.EXPRESS_TYPE_DEPPON) {
					daixiaoDepponPackages.add(sku);
					// 8自送
				} else if (sku.getExpressType() == OpSoPackageDeliveryInfo.EXPRESS_TYPE_SELF) {
					daixiaoSelfPackages.add(sku);

				} else if (sku.getExpressType() == OpSoPackageDeliveryInfo.EXPRESS_TYPE_ZT) {
					daixiaoZtPackages.add(sku);

				}

			}

			if (CollectionUtils.isNotEmpty(daixiaoShopPackges)) {

				OpSoPackageVO packageVO = new OpSoPackageVO();

				BeanUtils.copyProperties(sourcePackageVO, packageVO);

				packageVO.setOpSoPackageSkuVOs(daixiaoShopPackges);
				OpSoPackageDeliveryInfoVO packageDeliveryInfo = getPackageDeliveryInfo(opSoPackageDeliveryInfoVO);
				packageDeliveryInfo.setExpressType(OpSoPackageDeliveryInfo.EXPRESS_TYPE_SHOP);
				packageVO.setOpSoPackageDeliveryInfoVO(packageDeliveryInfo);

				allPackageVOs.add(packageVO);
			}

			if (CollectionUtils.isNotEmpty(daixiaoFedexPackages)) {

				OpSoPackageVO packageVO = new OpSoPackageVO();

				BeanUtils.copyProperties(sourcePackageVO, packageVO);

				packageVO.setOpSoPackageSkuVOs(daixiaoFedexPackages);
				OpSoPackageDeliveryInfoVO packageDeliveryInfo = getPackageDeliveryInfo(opSoPackageDeliveryInfoVO);
				packageDeliveryInfo.setExpressType(OpSoPackageDeliveryInfo.EXPRESS_TYPE_FEDEX);
				packageVO.setOpSoPackageDeliveryInfoVO(packageDeliveryInfo);
				allPackageVOs.add(packageVO);
			}

			if (CollectionUtils.isNotEmpty(daixiaoFfLandPackages)) {

				if (CollectionUtils.isNotEmpty(daixiaoSfAirPackages)) {
					daixiaoFfLandPackages.addAll(daixiaoSfAirPackages);
				}
				if (CollectionUtils.isNotEmpty(daixiaoZtPackages)) {
					daixiaoFfLandPackages.addAll(daixiaoZtPackages);
				}

				OpSoPackageVO packageVO = new OpSoPackageVO();

				BeanUtils.copyProperties(sourcePackageVO, packageVO);

				packageVO.setPlanedDeliveryDate(planedDeliveryDate);
				packageVO.setExpectReceiveDate(null);
				packageVO.setLimitDeliveryTimeDesc(null);
				packageVO.setOpSoPackageSkuVOs(daixiaoFfLandPackages);
				OpSoPackageDeliveryInfoVO packageDeliveryInfo = getPackageDeliveryInfo(opSoPackageDeliveryInfoVO);
				packageDeliveryInfo.setExpressType(OpSoPackageDeliveryInfo.EXPRESS_TYPE_SF_LAND);
				packageVO.setOpSoPackageDeliveryInfoVO(packageDeliveryInfo);
				allPackageVOs.add(packageVO);

			} else {

				if (CollectionUtils.isNotEmpty(daixiaoSfAirPackages)) {

					OpSoPackageVO packageVO = new OpSoPackageVO();

					BeanUtils.copyProperties(sourcePackageVO, packageVO);
					packageVO.setPlanedDeliveryDate(planedDeliveryDate);
					packageVO.setExpectReceiveDate(null);
					packageVO.setLimitDeliveryTimeDesc(null);
					packageVO.setOpSoPackageSkuVOs(daixiaoSfAirPackages);
					OpSoPackageDeliveryInfoVO packageDeliveryInfo = getPackageDeliveryInfo(opSoPackageDeliveryInfoVO);
					packageDeliveryInfo.setExpressType(OpSoPackageDeliveryInfo.EXPRESS_TYPE_SF_AIR);
					packageVO.setOpSoPackageDeliveryInfoVO(packageDeliveryInfo);
					allPackageVOs.add(packageVO);
				}
				if (CollectionUtils.isNotEmpty(daixiaoFfLandPackages)) {
					OpSoPackageVO packageVO = new OpSoPackageVO();

					BeanUtils.copyProperties(sourcePackageVO, packageVO);
					packageVO.setPlanedDeliveryDate(planedDeliveryDate);
					packageVO.setExpectReceiveDate(null);
					packageVO.setLimitDeliveryTimeDesc(null);
					packageVO.setOpSoPackageSkuVOs(daixiaoFfLandPackages);
					OpSoPackageDeliveryInfoVO packageDeliveryInfo = getPackageDeliveryInfo(opSoPackageDeliveryInfoVO);
					packageDeliveryInfo.setExpressType(OpSoPackageDeliveryInfo.EXPRESS_TYPE_SF_LAND);
					packageVO.setOpSoPackageDeliveryInfoVO(packageDeliveryInfo);
					allPackageVOs.add(packageVO);
				}

				if (CollectionUtils.isNotEmpty(daixiaoZtPackages)) {
					OpSoPackageVO packageVO = new OpSoPackageVO();

					BeanUtils.copyProperties(sourcePackageVO, packageVO);
					packageVO.setPlanedDeliveryDate(planedDeliveryDate);
					packageVO.setExpectReceiveDate(null);
					packageVO.setLimitDeliveryTimeDesc(null);
					packageVO.setOpSoPackageSkuVOs(daixiaoZtPackages);
					OpSoPackageDeliveryInfoVO packageDeliveryInfo = getPackageDeliveryInfo(opSoPackageDeliveryInfoVO);
					packageDeliveryInfo.setExpressType(OpSoPackageDeliveryInfo.EXPRESS_TYPE_ZT);
					packageVO.setOpSoPackageDeliveryInfoVO(packageDeliveryInfo);
					allPackageVOs.add(packageVO);
				}

			}

			if (CollectionUtils.isNotEmpty(daixiaoYtoPackages)) {
				OpSoPackageVO packageVO = new OpSoPackageVO();

				BeanUtils.copyProperties(sourcePackageVO, packageVO);
				packageVO.setPlanedDeliveryDate(planedDeliveryDate);
				packageVO.setExpectReceiveDate(null);
				packageVO.setLimitDeliveryTimeDesc(null);
				OpSoPackageDeliveryInfoVO packageDeliveryInfo = getPackageDeliveryInfo(opSoPackageDeliveryInfoVO);
				packageVO.setOpSoPackageSkuVOs(daixiaoYtoPackages);
				packageDeliveryInfo.setExpressType(OpSoPackageDeliveryInfo.EXPRESS_TYPE_YTO);
				packageVO.setOpSoPackageDeliveryInfoVO(packageDeliveryInfo);
				allPackageVOs.add(packageVO);
			}
			if (CollectionUtils.isNotEmpty(daixiaoDepponPackages)) {
				OpSoPackageVO packageVO = new OpSoPackageVO();

				BeanUtils.copyProperties(sourcePackageVO, packageVO);
				packageVO.setPlanedDeliveryDate(planedDeliveryDate);
				packageVO.setExpectReceiveDate(null);
				packageVO.setLimitDeliveryTimeDesc(null);
				packageVO.setOpSoPackageSkuVOs(daixiaoDepponPackages);
				OpSoPackageDeliveryInfoVO packageDeliveryInfo = getPackageDeliveryInfo(opSoPackageDeliveryInfoVO);
				packageDeliveryInfo.setExpressType(OpSoPackageDeliveryInfo.EXPRESS_TYPE_DEPPON);
				packageVO.setOpSoPackageDeliveryInfoVO(packageDeliveryInfo);

				allPackageVOs.add(packageVO);
			}
			if (CollectionUtils.isNotEmpty(daixiaoSelfPackages)) {

				OpSoPackageVO packageVO = new OpSoPackageVO();

				BeanUtils.copyProperties(sourcePackageVO, packageVO);
				packageVO.setPlanedDeliveryDate(planedDeliveryDate);
				packageVO.setExpectReceiveDate(null);
				packageVO.setLimitDeliveryTimeDesc(null);
				OpSoPackageDeliveryInfoVO packageDeliveryInfo = getPackageDeliveryInfo(opSoPackageDeliveryInfoVO);
				packageVO.setOpSoPackageSkuVOs(daixiaoSelfPackages);
				packageDeliveryInfo.setExpressType(OpSoPackageDeliveryInfo.EXPRESS_TYPE_SELF);
				packageVO.setOpSoPackageDeliveryInfoVO(packageDeliveryInfo);
				allPackageVOs.add(packageVO);
			}

		}
		if (CollectionUtils.isNotEmpty(preSaleSkus)) {
			logger.info("预售SKU数量：" + preSaleSkus.size());

			Map<String, List<OpSoPackageSkuVO>> maps = new HashMap<>();
			String key = "";

			for (OpSoPackageSkuVO pSaleSku : preSaleSkus) {

				if (OpProduct.EP_TYPE_Sf_AIR == pSaleSku.getExpressType()) {
					// 有空运有陆运，合起来变陆运
					if (preSaleExpressTypes.contains(OpProduct.EP_TYPE_Sf_AIR)
							&& preSaleExpressTypes.contains(OpProduct.EP_TYPE_Sf_LAND)) {
						pSaleSku.setExpressType(OpProduct.EP_TYPE_Sf_LAND);
					}
				}

				if (OpProduct.EP_TYPE_ZT == pSaleSku.getExpressType()) {
					// 有空运有陆运，合起来变陆运
					if (preSaleExpressTypes.contains(OpProduct.EP_TYPE_ZT)
							&& preSaleExpressTypes.contains(OpProduct.EP_TYPE_Sf_LAND)) {
						pSaleSku.setExpressType(OpProduct.EP_TYPE_Sf_LAND);
					}
				}

				key = pSaleSku.getExpressType() + pSaleSku.getsPresaleVO().getDispatchWarehouseCode()
						+ pSaleSku.getsPresaleVO().getPlanedDeliveryDateStr();
				List<OpSoPackageSkuVO> packSkus = maps.get(key);
				if (CollectionUtils.isNotEmpty(packSkus)) {
					packSkus.add(pSaleSku);
				} else {
					packSkus = new ArrayList<>();
					packSkus.add(pSaleSku);
					maps.put(key, packSkus);
				}

			}

			Set<String> keySet = maps.keySet();
			for (String keyStr : keySet) {
				logger.info("预售包裹数量：" + maps.values().size());
				List<OpSoPackageSkuVO> skus = maps.get(keyStr);

				final OpSoPackageVO preSalePackageVo = new OpSoPackageVO();// 预售的包裹
				preSalePackageVo.setCardContent(sourcePackageVO.getCardContent());
				preSalePackageVo.setCardTo(sourcePackageVO.getCardTo());
				preSalePackageVo.setCardFrom(sourcePackageVO.getCardFrom());
				preSalePackageVo.setCardType(sourcePackageVO.getCardType());
				preSalePackageVo.setDeliveryType(sourcePackageVO.getDeliveryType());

				preSalePackageVo.setDispatchWarehouseCode(skus.get(0).getsPresaleVO().getDispatchWarehouseCode());
				preSalePackageVo.setPlanedDeliveryDate(skus.get(0).getsPresaleVO().getPlanedDeliveryDate());

				OpSoPackageDeliveryInfoVO packageDeliveryInfo = getPackageDeliveryInfo(opSoPackageDeliveryInfoVO);
				String expressType = keyStr.substring(0, 1);
				packageDeliveryInfo.setExpressType(Integer.valueOf(expressType));

				// 预售的不设置
				preSalePackageVo.setOpSoPackageDeliveryInfoVO(packageDeliveryInfo);
				preSalePackageVo.setOpSoPackageSkuVOs(skus);
				preSalePackageVo.setPackageType(2);

				allPackageVOs.add(preSalePackageVo);
			}

		}

		// 如果是海淘产品，国内赠品跟袋子要分开
		if (opSalesOrderVO.getCrossBorderFlag() == null || opSalesOrderVO.getCrossBorderFlag() == 0) {
			// 订单中有袋子的时候
			if (hasBag || hasBagSkus.size() > 0) {
				// 处理袋子
				OpSoPackageVO bags = null;

				if (CollectionUtils.isNotEmpty(allPackageVOs) && allPackageVOs.size() > 1) {

					Boolean bool = true;

					Iterator<OpSoPackageVO> allPack = allPackageVOs.iterator();
					while (allPack.hasNext()) {
						OpSoPackageVO pack = allPack.next();
						bool = true;
						if (CollectionUtils.isNotEmpty(pack.getOpSoPackageSkuVOs())) {
							for (OpSoPackageSkuVO sku : pack.getOpSoPackageSkuVOs()) {
								if (!ConstUtil.bagSkus.contains(sku.getSkuCode())) {
									bool = false;
									break;
								}

							}

							// 袋子单独占用一个包裹的情况
							if (bool) {
								bags = pack;
								allPack.remove();
							}

						}

					}

					if (bags != null) {
						// 海淘订单
						if (opSalesOrderVO.getCrossBorderFlag() != null && opSalesOrderVO.getCrossBorderFlag() != 0) {
							allPackageVOs.add(bags);

						} else {

							// 多个包裹时，如果有预售的排除预售包裹
							if (allPackageVOs.size() > 1) {

								int count = 0;
								for (OpSoPackageVO pack : allPackageVOs) {
									if (pack.getPackageType() != OpSoPackage.PACKAGE_TYPE_2
											&& pack.getPackageType() != OpSoPackage.PACKAGE_TYPE_8) {

										pack.getOpSoPackageSkuVOs().addAll(bags.getOpSoPackageSkuVOs());
										break;

									}

									if (count == allPackageVOs.size() - 1) {
										if (pack.getPackageType() == OpSoPackage.PACKAGE_TYPE_2) {
											for (OpSoPackageSkuVO skuVO : bags.getOpSoPackageSkuVOs()) {
												final WhAllotRcdVO whAllotVO = new WhAllotRcdVO();
												whAllotVO.setPlanAmount(skuVO.getQuantity());
												whAllotVO.setSkuCode(skuVO.getSkuCode());
												whAllotVO.setSourceWarehouseCode(skuVO.getDispatchWarehouseCode());
												whAllotVO.setTargetWarehouseCode(pack.getDispatchWarehouseCode());
												whAllotList.add(whAllotVO);
											}

											pack.getOpSoPackageSkuVOs().addAll(bags.getOpSoPackageSkuVOs());
											// 鲜花包裹
										} else if (pack.getPackageType() == OpSoPackage.PACKAGE_TYPE_8) {

											logger.info("虚拟商品包");

										}

									}
									count++;
								}

							} else {
								List<OpSoPackageSkuVO> list = new ArrayList<>();
								// 是预售包裹需要调拨
								if (allPackageVOs.get(0).getPackageType() == OpSoPackage.PACKAGE_TYPE_2) {

									for (OpSoPackageSkuVO skuVO : bags.getOpSoPackageSkuVOs()) {
										final WhAllotRcdVO whAllotVO = new WhAllotRcdVO();
										whAllotVO.setPlanAmount(skuVO.getQuantity());
										whAllotVO.setSkuCode(skuVO.getSkuCode());
										whAllotVO.setSourceWarehouseCode(skuVO.getDispatchWarehouseCode());
										whAllotVO.setTargetWarehouseCode(
												allPackageVOs.get(0).getDispatchWarehouseCode());
										whAllotList.add(whAllotVO);
									}
									list.addAll(bags.getOpSoPackageSkuVOs());

								} else if (allPackageVOs.get(0).getPackageType() == OpSoPackage.PACKAGE_TYPE_8) {
									logger.info("虚拟包裹！");

								} else {
									list.addAll(bags.getOpSoPackageSkuVOs());
								}

								// 只剩一个时，直接放进去
								allPackageVOs.get(0).getOpSoPackageSkuVOs().addAll(list);
							}
						}
					}
				}
			}

		}

		// 设置订单对应的调拨
		if (CollectionUtils.isNotEmpty(whAllotList)) {
			opSalesOrderVO.setWhAllotList(whAllotList);
		}

		// 取得所有skucode。为取分类用
		List<String> psSkuVOs = new ArrayList<>();
		for (OpSoPackageVO vo : allPackageVOs) {
			for (OpSoPackageSkuVO skuVO : vo.getOpSoPackageSkuVOs()) {
				if (!psSkuVOs.contains(skuVO.getSkuCode())) {
					psSkuVOs.add(skuVO.getSkuCode());
				}

			}
		}
		if (CollectionUtils.isNotEmpty(psSkuVOs)) {
			Map<String, PcsSkuCategoryVO> categoryIdMap = mcPcsSkuCategoryService
					.findFirstCategoryIdBySkucodes(psSkuVOs);
			opSalesOrderVO.setCategoryIdMap(categoryIdMap);
		}

		return allPackageVOs;
	}

	/**
	 * 代销且是jit
	 *
	 * @param skuVO
	 * @param opChannel
	 * @param sourcePackageVO
	 * @param opSoPackageDeliveryInfoVO
	 * @param giftPackageSkuVOs
	 * @param daixiaoPackageList
	 * @param defaultPackageSkuVOs
	 */
	private void packageWhetherConsignmentAndIsjit(OpSoPackageSkuVO skuVO, final OpChannelVO opChannel,
			OpSoPackageVO sourcePackageVO, OpSoPackageDeliveryInfoVO opSoPackageDeliveryInfoVO,
			List<OpSoPackageSkuVO> preSaleSkus, List<OpSoPackageSkuVO> giftPackageSkuVOs,
			List<OpSoPackageVO> daixiaoPackageList, final List<OpSoPackageSkuVO> defaultPackageSkuVOs,
			List<Integer> hasBagSkus, List<Integer> preSaleExpressTypes, Map<String, SPresaleVO> sPresaleMap,
			Map<String, SPresaleSaleInvVO> sPresaleSaleInvMap, OpSalesOrderVO opSalesOrderVO,
			List<OpSoPackageSkuVO> virtualPackageSkus) {

		logger.info("属于代销，并且是isJit:sku=" + skuVO.getSkuCode());

		// 默认来单包裹
		Integer packageType = OpSoPackage.PACKAGE_TYPE_6;
		// 如果是鲜花类,设成鲜花包裹
		if (ConstUtil.flowerCateId.equals(skuVO.getCategoryId())
				|| ConstUtil.notSkuCodes.contains(skuVO.getSkuCode())) {
			packageType = OpSoPackage.PACKAGE_TYPE_3;
		}

		OpSoPackageVO daixiaoPackageVO = new OpSoPackageVO();
		List<OpSoPackageSkuVO> daixiaoPackages = new ArrayList<>();
		// 判断是否是预售
		if (isPresale(sPresaleMap, sPresaleSaleInvMap, skuVO, opChannel, opSalesOrderVO)) {
			logger.info("属于代销，并且是isJit也是预售:sku=" + skuVO.getSkuCode());
			// 判断当前商品是否有赠品.如果有赠品，则判断赠品是否是预售
			if (CollectionUtils.isNotEmpty(skuVO.getGifts())) {
				for (OpSoPackageSkuVO giftSkuVO : skuVO.getGifts()) {

					// 虚拟商品
					if (giftSkuVO.getWhetherVirtual() != null && giftSkuVO.getWhetherVirtual() == 1) {

						virtualPackageSkus.add(giftSkuVO);
						continue;

					}
					if (ConstUtil.bagSkus.contains(giftSkuVO.getSkuCode())) {
						giftSkuVO.setExpressType(skuVO.getExpressType());
						hasBagSkus.add(2);
					}
					// 判断赠品是否是预售
					if (isPresale(sPresaleMap, sPresaleSaleInvMap, giftSkuVO, opChannel, opSalesOrderVO)) {
						// 如果主品和赠品都是预售
						final Date mainSkuPlanedDate = skuVO.getsPresaleVO().getPlanedDeliveryDate();
						final Date giftSkuPlanedDate = giftSkuVO.getsPresaleVO().getPlanedDeliveryDate();
						if (mainSkuPlanedDate.before(giftSkuPlanedDate)) {
							// 主品预计发货时间早 赠品预计发货时间晚 拆成两单
							preSaleSkus.add(giftSkuVO);
							preSaleExpressTypes.add(giftSkuVO.getExpressType());
						} else {
							// 主品预计发货时间晚 赠品预计发货时间早 合在一个订单 预计发货时间是主品的发货时间
							giftSkuVO.setsPresaleVO(skuVO.getsPresaleVO());
							preSaleExpressTypes.add(giftSkuVO.getExpressType());
							// preSalePackageSkuVOs.add(giftSkuVO);
							preSaleSkus.add(giftSkuVO);
						}
					} else {

						// 设置跟主品一样的快递类型
						if (skuVO.getExpressType() == giftSkuVO.getExpressType()) {
							daixiaoPackages.add(giftSkuVO);
						} else {
							// 代销赠品
							if (giftSkuVO.getWhetherConsignment() != null && giftSkuVO.getWhetherConsignment() == 1) {

								List<OpSoPackageSkuVO> daixiaoGiftPackages = new ArrayList<>();
								daixiaoGiftPackages.add(giftSkuVO);
								OpSoPackageVO daixiaoGiftPackageVO = new OpSoPackageVO();

								BeanUtils.copyProperties(sourcePackageVO, daixiaoGiftPackageVO);
								daixiaoGiftPackageVO.setOpSoPackageSkuVOs(daixiaoGiftPackages);
								daixiaoGiftPackageVO.setPackageType(packageType);
								// daixiaoGiftPackageVO.getOpSoPackageDeliveryInfoVO()
								// .setExpressType(giftSkuVO.getExpressType());

								OpSoPackageDeliveryInfoVO packageDeliveryInfo = getPackageDeliveryInfo(
										daixiaoGiftPackageVO.getOpSoPackageDeliveryInfoVO());

								packageDeliveryInfo.setExpressType(giftSkuVO.getExpressType());
								daixiaoGiftPackageVO.setOpSoPackageDeliveryInfoVO(packageDeliveryInfo);
								daixiaoGiftPackageVO
										.setPlanedDeliveryDate(DateUtil.addDay(new Date(), skuVO.getDeliveryPeriod()));
								daixiaoPackageList.add(daixiaoGiftPackageVO);
							} else {

								defaultPackageSkuVOs.add(giftSkuVO);
							}
						}

					}
				}

			}
			preSaleSkus.add(skuVO);
			preSaleExpressTypes.add(skuVO.getExpressType());
		} else {

			BeanUtils.copyProperties(sourcePackageVO, daixiaoPackageVO);

			daixiaoPackages.add(skuVO);

			// 判断当前商品是否有赠品.如果有赠品，则判断赠品是否是预售
			if (CollectionUtils.isNotEmpty(skuVO.getGifts())) {

				for (OpSoPackageSkuVO giftSkuVO : skuVO.getGifts()) {

					// 虚拟商品
					if (giftSkuVO.getWhetherVirtual() != null && giftSkuVO.getWhetherVirtual() == 1) {

						virtualPackageSkus.add(giftSkuVO);
						continue;

					}
					if (ConstUtil.bagSkus.contains(giftSkuVO.getSkuCode())) {
						giftSkuVO.setExpressType(skuVO.getExpressType());
						hasBagSkus.add(daixiaoPackageVO.getPackageType());
					}
					if (isPresale(sPresaleMap, sPresaleSaleInvMap, giftSkuVO, opChannel, opSalesOrderVO)) {
						// 如果带赠品，但是主品不预售，赠品预售，则赠品在单独的包裹
						preSaleSkus.add(giftSkuVO);
						preSaleExpressTypes.add(giftSkuVO.getExpressType());
					} else {

						// 设置跟主品一样的快递类型
						if (skuVO.getExpressType() == giftSkuVO.getExpressType()) {
							daixiaoPackages.add(giftSkuVO);
						} else {
							// 代销赠品
							if (giftSkuVO.getWhetherConsignment() != null && giftSkuVO.getWhetherConsignment() == 1) {

								List<OpSoPackageSkuVO> daixiaoGiftPackages = new ArrayList<>();
								daixiaoGiftPackages.add(giftSkuVO);
								OpSoPackageVO daixiaoGiftPackageVO = new OpSoPackageVO();

								BeanUtils.copyProperties(sourcePackageVO, daixiaoGiftPackageVO);
								daixiaoGiftPackageVO.setOpSoPackageSkuVOs(daixiaoGiftPackages);
								daixiaoGiftPackageVO.setPackageType(packageType);
								daixiaoGiftPackageVO
										.setPlanedDeliveryDate(DateUtil.addDay(new Date(), skuVO.getDeliveryPeriod()));
								// daixiaoGiftPackageVO.getOpSoPackageDeliveryInfoVO()
								// .setExpressType(giftSkuVO.getExpressType());

								OpSoPackageDeliveryInfoVO packageDeliveryInfo = getPackageDeliveryInfo(
										daixiaoGiftPackageVO.getOpSoPackageDeliveryInfoVO());

								packageDeliveryInfo.setExpressType(giftSkuVO.getExpressType());
								daixiaoGiftPackageVO.setOpSoPackageDeliveryInfoVO(packageDeliveryInfo);
								daixiaoPackageList.add(daixiaoGiftPackageVO);
							} else {

								defaultPackageSkuVOs.add(giftSkuVO);
							}
						}
					}
				}
			}

			daixiaoPackageVO.setOpSoPackageSkuVOs(daixiaoPackages);
			daixiaoPackageVO.setPackageType(packageType);
			daixiaoPackageVO.setPlanedDeliveryDate(DateUtil.addDay(new Date(), skuVO.getDeliveryPeriod()));
			// daixiaoPackageVO.getOpSoPackageDeliveryInfoVO().setExpressType(skuVO.getExpressType());
			OpSoPackageDeliveryInfoVO packageDeliveryInfo = getPackageDeliveryInfo(
					daixiaoPackageVO.getOpSoPackageDeliveryInfoVO());

			packageDeliveryInfo.setExpressType(skuVO.getExpressType());
			daixiaoPackageVO.setOpSoPackageDeliveryInfoVO(packageDeliveryInfo);
			daixiaoPackageList.add(daixiaoPackageVO);
		}

	}

	private void packageOrdinary(OpSoPackageSkuVO skuVO, final OpChannelVO opChannel, OpSoPackageVO sourcePackageVO,
			OpSoPackageDeliveryInfoVO opSoPackageDeliveryInfoVO, List<OpSoPackageSkuVO> preSaleSkus,
			List<OpSoPackageSkuVO> giftPackageSkuVOs, List<OpSoPackageSkuVO> flowerPackageSkus,
			List<WhAllotRcdVO> whAllotList, List<OpSoPackageSkuVO> defaultPackageSkuVOs, List<Integer> hasBagSkus,
			List<Integer> preSaleExpressTypes, Map<String, SPresaleVO> sPresaleMap,
			Map<String, SPresaleSaleInvVO> sPresaleSaleInvMap, OpSalesOrderVO opSalesOrderVO,
			List<OpSoPackageSkuVO> virtualPackageSkus) {

		// 判断是否是预售
		if (isPresale(sPresaleMap, sPresaleSaleInvMap, skuVO, opChannel, opSalesOrderVO)) {
			logger.info("主品是预售：sku=" + skuVO.getSkuCode());

			// 判断当前商品是否有赠品.如果有赠品，则判断赠品是否是预售
			if (CollectionUtils.isNotEmpty(skuVO.getGifts())) {

				for (OpSoPackageSkuVO giftSkuVO : skuVO.getGifts()) {

					// 虚拟商品
					if (giftSkuVO.getWhetherVirtual() != null && giftSkuVO.getWhetherVirtual() == 1) {

						virtualPackageSkus.add(giftSkuVO);
						continue;

					}
					if (ConstUtil.bagSkus.contains(giftSkuVO.getSkuCode())) {
						giftSkuVO.setExpressType(skuVO.getExpressType());
						hasBagSkus.add(2);
					}
					// 判断赠品是否是预售
					if (isPresale(sPresaleMap, sPresaleSaleInvMap, giftSkuVO, opChannel, opSalesOrderVO)) {
						logger.info("赠品是预售：sku=" + giftSkuVO.getSkuCode());
						// 如果主品和赠品都是预售
						final Date mainSkuPlanedDate = skuVO.getsPresaleVO().getPlanedDeliveryDate();
						final Date giftSkuPlanedDate = giftSkuVO.getsPresaleVO().getPlanedDeliveryDate();
						if (mainSkuPlanedDate.before(giftSkuPlanedDate)) {

							preSaleSkus.add(giftSkuVO);
							preSaleExpressTypes.add(giftSkuVO.getExpressType());

						} else {
							// 主品预计发货时间晚 赠品预计发货时间早 合在一个订单 预计发货时间是主品的发货时间
							giftSkuVO.setsPresaleVO(skuVO.getsPresaleVO());
							preSaleSkus.add(giftSkuVO);
							preSaleExpressTypes.add(giftSkuVO.getExpressType());
						}
					} else {
						logger.info("主品是预售，赠品不是预售产生调拨：sku=" + giftSkuVO.getSkuCode());

						// 赠品不是预售，则将赠品和预售的主品放在一个包裹,同时将赠品产生一条调拨
						final WhAllotRcdVO whAllotVO = new WhAllotRcdVO();
						whAllotVO.setPlanAmount(giftSkuVO.getQuantity());
						whAllotVO.setSkuCode(giftSkuVO.getSkuCode());
						whAllotVO.setSourceWarehouseCode(giftSkuVO.getDispatchWarehouseCode());
						whAllotVO.setTargetWarehouseCode(skuVO.getDispatchWarehouseCode());
						whAllotList.add(whAllotVO);
						// preSalePackageSkuVOs.add(giftSkuVO);// 将赠品和主品放在一个包裹
						giftSkuVO.setsPresaleVO(skuVO.getsPresaleVO());
						preSaleSkus.add(giftSkuVO);
						preSaleExpressTypes.add(giftSkuVO.getExpressType());
					}

					// }
				}
			}
			// preSalePackageVOs.add(preSalePackageVo);
			preSaleSkus.add(skuVO);
			preSaleExpressTypes.add(skuVO.getExpressType());
		} else {
			Integer packageType = 0;
			logger.info("主品不是预售:sku=" + skuVO.getSkuCode());

			// 非赠品并且不是预售
			defaultPackageSkuVOs.add(skuVO);
			// }

			// 判断当前商品是否有赠品.如果有赠品，则判断赠品是否是预售
			if (CollectionUtils.isNotEmpty(skuVO.getGifts())) {

				for (OpSoPackageSkuVO giftSkuVO : skuVO.getGifts()) {

					// 虚拟商品
					if (giftSkuVO.getWhetherVirtual() != null && giftSkuVO.getWhetherVirtual() == 1) {

						virtualPackageSkus.add(giftSkuVO);
						continue;

					}
					if (ConstUtil.bagSkus.contains(giftSkuVO.getSkuCode())) {
						giftSkuVO.setExpressType(skuVO.getExpressType());
						hasBagSkus.add(packageType);
					}
					// if (isPresale(opChannel, giftSkuVO) &&
					// !ConstUtil.immortalFlower.contains(skuVO.getSkuCode())) {
					if (isPresale(sPresaleMap, sPresaleSaleInvMap, giftSkuVO, opChannel, opSalesOrderVO)) {
						logger.info("赠品是预售:sku=" + giftSkuVO.getSkuCode());
						// 如果带赠品，但是主品不预售，赠品预售，则赠品在单独的包裹
						preSaleSkus.add(giftSkuVO);
						preSaleExpressTypes.add(giftSkuVO.getExpressType());
					} else {
						logger.info("赠品不是预售:sku=" + giftSkuVO.getSkuCode());
						// 如果是鲜花，放入鲜花包裹
						// if
						// (ConstUtil.immortalFlower.contains(skuVO.getSkuCode()))
						// {
						// flowerPackageSkus.add(giftSkuVO);
						// } else {
						// 如果带赠品，但是主品不预售，赠品也不预售，则赠品和主平在一个包裹
						defaultPackageSkuVOs.add(giftSkuVO);
						// }
					}
				}
			}
		}

	}

	/**
	 * 是jit
	 *
	 * @param skuVO
	 * @param opChannel
	 * @param sourcePackageVO
	 * @param preSaleSkus
	 * @param giftPackageSkuVOs
	 * @param defaultPackageSkuVOs
	 */
	private void packageIsJitNotCateId(OpSoPackageSkuVO skuVO, final OpChannelVO opChannel,
			OpSoPackageVO sourcePackageVO, List<OpSoPackageSkuVO> preSaleSkus, List<OpSoPackageSkuVO> giftPackageSkuVOs,
			List<OpSoPackageVO> isJitPackageList, final List<OpSoPackageSkuVO> defaultPackageSkuVOs,
			List<Integer> hasBagSkus, List<Integer> preSaleExpressTypes, Date planedDeliveryDate,
			Map<String, SPresaleVO> sPresaleMap, Map<String, SPresaleSaleInvVO> sPresaleSaleInvMap,
			OpSalesOrderVO opSalesOrderVO, List<OpSoPackageSkuVO> virtualPackageSkus) {

		logger.info("是isJit:sku=" + skuVO.getSkuCode());
		// 默认来单包裹
		Integer packageType = OpSoPackage.PACKAGE_TYPE_6;
		// 如果是鲜花类,设成鲜花包裹
		if (ConstUtil.flowerCateId.equals(skuVO.getCategoryId())
				|| ConstUtil.notSkuCodes.contains(skuVO.getSkuCode())) {
			packageType = OpSoPackage.PACKAGE_TYPE_3;
		}

		OpSoPackageVO daixiaoPackageVO = new OpSoPackageVO();
		List<OpSoPackageSkuVO> daixiaoPackages = new ArrayList<>();
		// 判断是否是预售
		if (isPresale(sPresaleMap, sPresaleSaleInvMap, skuVO, opChannel, opSalesOrderVO)) {
			logger.info("是isJit也是预售:sku=" + skuVO.getSkuCode());

			// 判断当前商品是否有赠品.如果有赠品，则判断赠品是否是预售
			// final List<OpSoPackageSkuVO> giftSkuVOs =
			// getGiftSkuByMainSkuCodes(skuVO.getSkuCode(),
			// giftPackageSkuVOs);
			if (CollectionUtils.isNotEmpty(skuVO.getGifts())) {

				for (OpSoPackageSkuVO giftSkuVO : skuVO.getGifts()) {

					// 虚拟商品
					if (giftSkuVO.getWhetherVirtual() != null && giftSkuVO.getWhetherVirtual() == 1) {

						virtualPackageSkus.add(giftSkuVO);
						continue;

					}

					if (ConstUtil.bagSkus.contains(giftSkuVO.getSkuCode())) {
						giftSkuVO.setExpressType(skuVO.getExpressType());
						hasBagSkus.add(2);
					}
					// 判断赠品是否是预售
					if (isPresale(sPresaleMap, sPresaleSaleInvMap, giftSkuVO, opChannel, opSalesOrderVO)) {
						// 如果主品和赠品都是预售
						final Date mainSkuPlanedDate = skuVO.getsPresaleVO().getPlanedDeliveryDate();
						final Date giftSkuPlanedDate = giftSkuVO.getsPresaleVO().getPlanedDeliveryDate();
						if (mainSkuPlanedDate.before(giftSkuPlanedDate)) {
							// 主品预计发货时间早 赠品预计发货时间晚 拆成两单
							preSaleSkus.add(giftSkuVO);
							preSaleExpressTypes.add(giftSkuVO.getExpressType());
						} else {
							// 主品预计发货时间晚 赠品预计发货时间早 合在一个订单 预计发货时间是主品的发货时间
							giftSkuVO.setsPresaleVO(skuVO.getsPresaleVO());
							// preSalePackageSkuVOs.add(giftSkuVO);
							preSaleSkus.add(giftSkuVO);
							preSaleExpressTypes.add(giftSkuVO.getExpressType());
						}
					} else {

						// 设置跟主品一样的快递类型
						if (skuVO.getExpressType() == giftSkuVO.getExpressType()) {
							daixiaoPackages.add(giftSkuVO);
						} else {
							// 代销赠品
							if (giftSkuVO.getWhetherConsignment() != null && giftSkuVO.getWhetherConsignment() == 1) {

								List<OpSoPackageSkuVO> daixiaoGiftPackages = new ArrayList<>();
								daixiaoGiftPackages.add(giftSkuVO);
								OpSoPackageVO daixiaoGiftPackageVO = new OpSoPackageVO();

								BeanUtils.copyProperties(sourcePackageVO, daixiaoGiftPackageVO);
								daixiaoGiftPackageVO.setOpSoPackageSkuVOs(daixiaoGiftPackages);
								daixiaoGiftPackageVO.setPackageType(packageType);
								// daixiaoGiftPackageVO.getOpSoPackageDeliveryInfoVO()
								// .setExpressType(giftSkuVO.getExpressType());

								OpSoPackageDeliveryInfoVO packageDeliveryInfo = getPackageDeliveryInfo(
										daixiaoGiftPackageVO.getOpSoPackageDeliveryInfoVO());

								packageDeliveryInfo.setExpressType(giftSkuVO.getExpressType());
								daixiaoGiftPackageVO.setOpSoPackageDeliveryInfoVO(packageDeliveryInfo);

								if (planedDeliveryDate != null) {
									daixiaoGiftPackageVO.setPlanedDeliveryDate(planedDeliveryDate);
								} else {
									daixiaoGiftPackageVO.setPlanedDeliveryDate(
											DateUtil.addDay(new Date(), skuVO.getDeliveryPeriod()));
								}

								isJitPackageList.add(daixiaoGiftPackageVO);
							} else {

								defaultPackageSkuVOs.add(giftSkuVO);
							}
						}

					}
				}
			}
			// preSalePackageVo.setPackageType(2);
			preSaleSkus.add(skuVO);
			preSaleExpressTypes.add(skuVO.getExpressType());
		} else {

			BeanUtils.copyProperties(sourcePackageVO, daixiaoPackageVO);

			daixiaoPackages.add(skuVO);

			// 判断当前商品是否有赠品.如果有赠品，则判断赠品是否是预售
			// final List<OpSoPackageSkuVO> giftSkuVOs =
			// getGiftSkuByMainSkuCodes(skuVO.getSkuCode(),
			// giftPackageSkuVOs);
			if (CollectionUtils.isNotEmpty(skuVO.getGifts())) {

				for (OpSoPackageSkuVO giftSkuVO : skuVO.getGifts()) {

					// 虚拟商品
					if (giftSkuVO.getWhetherVirtual() != null && giftSkuVO.getWhetherVirtual() == 1) {

						virtualPackageSkus.add(giftSkuVO);
						continue;

					}
					if (ConstUtil.bagSkus.contains(giftSkuVO.getSkuCode())) {
						giftSkuVO.setExpressType(skuVO.getExpressType());
						hasBagSkus.add(daixiaoPackageVO.getPackageType());
					}
					if (isPresale(sPresaleMap, sPresaleSaleInvMap, giftSkuVO, opChannel, opSalesOrderVO)) {
						preSaleSkus.add(giftSkuVO);
						preSaleExpressTypes.add(giftSkuVO.getExpressType());
					} else {

						// 设置跟主品一样的快递类型
						if (skuVO.getExpressType() == giftSkuVO.getExpressType()) {
							daixiaoPackages.add(giftSkuVO);
						} else {
							// 代销赠品
							if (giftSkuVO.getWhetherConsignment() != null && giftSkuVO.getWhetherConsignment() == 1) {

								List<OpSoPackageSkuVO> daixiaoGiftPackages = new ArrayList<>();
								daixiaoGiftPackages.add(giftSkuVO);
								OpSoPackageVO daixiaoGiftPackageVO = new OpSoPackageVO();

								BeanUtils.copyProperties(sourcePackageVO, daixiaoGiftPackageVO);
								daixiaoGiftPackageVO.setOpSoPackageSkuVOs(daixiaoGiftPackages);
								daixiaoGiftPackageVO.setPackageType(packageType);

								OpSoPackageDeliveryInfoVO packageDeliveryInfo = getPackageDeliveryInfo(
										daixiaoGiftPackageVO.getOpSoPackageDeliveryInfoVO());

								packageDeliveryInfo.setExpressType(giftSkuVO.getExpressType());
								daixiaoGiftPackageVO.setOpSoPackageDeliveryInfoVO(packageDeliveryInfo);

								if (planedDeliveryDate != null) {
									daixiaoGiftPackageVO.setPlanedDeliveryDate(planedDeliveryDate);
								} else {
									daixiaoGiftPackageVO.setPlanedDeliveryDate(
											DateUtil.addDay(new Date(), skuVO.getDeliveryPeriod()));
								}
								isJitPackageList.add(daixiaoGiftPackageVO);
							} else {

								defaultPackageSkuVOs.add(giftSkuVO);
							}
						}
					}
				}
			}

			daixiaoPackageVO.setOpSoPackageSkuVOs(daixiaoPackages);
			daixiaoPackageVO.setPackageType(packageType);
			// daixiaoPackageVO.getOpSoPackageDeliveryInfoVO().setExpressType(skuVO.getExpressType());
			OpSoPackageDeliveryInfoVO packageDeliveryInfo = getPackageDeliveryInfo(
					daixiaoPackageVO.getOpSoPackageDeliveryInfoVO());

			packageDeliveryInfo.setExpressType(skuVO.getExpressType());
			daixiaoPackageVO.setOpSoPackageDeliveryInfoVO(packageDeliveryInfo);

			if (planedDeliveryDate != null) {
				daixiaoPackageVO.setPlanedDeliveryDate(planedDeliveryDate);
			} else {
				daixiaoPackageVO.setPlanedDeliveryDate(DateUtil.addDay(new Date(), skuVO.getDeliveryPeriod()));
			}
			isJitPackageList.add(daixiaoPackageVO);
		}

	}

	/**
	 * 是jit
	 *
	 * @param skuVO
	 * @param opChannel
	 * @param sourcePackageVO
	 * @param preSaleSkus
	 * @param giftPackageSkuVOs
	 * @param defaultPackageSkuVOs
	 */
	private void packageIsCustomize(OpSoPackageSkuVO skuVO, final OpChannelVO opChannel, OpSoPackageVO sourcePackageVO,
			List<OpSoPackageSkuVO> preSaleSkus, List<OpSoPackageSkuVO> giftPackageSkuVOs,
			List<OpSoPackageVO> isJitPackageList, final List<OpSoPackageSkuVO> defaultPackageSkuVOs,
			List<Integer> hasBagSkus, List<Integer> preSaleExpressTypes, Map<String, OpSoPackageVO> customizeMap,
			Map<String, SPresaleVO> sPresaleMap, Map<String, SPresaleSaleInvVO> sPresaleSaleInvMap,
			OpSalesOrderVO opSalesOrderVO, List<OpSoPackageSkuVO> virtualPackageSkus) {

		logger.info("是isJit:sku=" + skuVO.getSkuCode());
		OpSoPackageVO customizePackageVO = new OpSoPackageVO();
		List<OpSoPackageSkuVO> customizePackages = new ArrayList<>();
		// 判断是否是预售
		if (isPresale(sPresaleMap, sPresaleSaleInvMap, skuVO, opChannel, opSalesOrderVO)) {
			logger.info("是isJit也是预售:sku=" + skuVO.getSkuCode());

			// 判断当前商品是否有赠品.如果有赠品，则判断赠品是否是预售
			// final List<OpSoPackageSkuVO> giftSkuVOs =
			// getGiftSkuByMainSkuCodes(skuVO.getSkuCode(),
			// giftPackageSkuVOs);
			if (CollectionUtils.isNotEmpty(skuVO.getGifts())) {

				for (OpSoPackageSkuVO giftSkuVO : skuVO.getGifts()) {
					// 虚拟商品
					if (giftSkuVO.getWhetherVirtual() != null && giftSkuVO.getWhetherVirtual() == 1) {

						virtualPackageSkus.add(giftSkuVO);
						continue;

					}
					if (ConstUtil.bagSkus.contains(giftSkuVO.getSkuCode())) {
						giftSkuVO.setExpressType(skuVO.getExpressType());
						hasBagSkus.add(2);
					}
					// 判断赠品是否是预售
					if (isPresale(sPresaleMap, sPresaleSaleInvMap, giftSkuVO, opChannel, opSalesOrderVO)) {
						// 如果主品和赠品都是预售
						final Date mainSkuPlanedDate = skuVO.getsPresaleVO().getPlanedDeliveryDate();
						final Date giftSkuPlanedDate = giftSkuVO.getsPresaleVO().getPlanedDeliveryDate();
						if (mainSkuPlanedDate.before(giftSkuPlanedDate)) {
							// 主品预计发货时间早 赠品预计发货时间晚 拆成两单
							preSaleSkus.add(giftSkuVO);
							preSaleExpressTypes.add(giftSkuVO.getExpressType());
						} else {
							// 主品预计发货时间晚 赠品预计发货时间早 合在一个订单 预计发货时间是主品的发货时间
							giftSkuVO.setsPresaleVO(skuVO.getsPresaleVO());
							// preSalePackageSkuVOs.add(giftSkuVO);
							preSaleSkus.add(giftSkuVO);
							preSaleExpressTypes.add(giftSkuVO.getExpressType());
						}
					} else {

						// 设置跟主品一样的快递类型
						if (skuVO.getExpressType() == giftSkuVO.getExpressType()) {
							customizePackages.add(giftSkuVO);
						} else {
							// 代销赠品
							if (giftSkuVO.getWhetherConsignment() != null && giftSkuVO.getWhetherConsignment() == 1) {

								List<OpSoPackageSkuVO> daixiaoGiftPackages = new ArrayList<>();
								daixiaoGiftPackages.add(giftSkuVO);
								OpSoPackageVO daixiaoGiftPackageVO = new OpSoPackageVO();

								BeanUtils.copyProperties(sourcePackageVO, daixiaoGiftPackageVO);
								daixiaoGiftPackageVO.setOpSoPackageSkuVOs(daixiaoGiftPackages);
								daixiaoGiftPackageVO.setPackageType(OpSoPackage.PACKAGE_TYPE_5);
								// daixiaoGiftPackageVO.getOpSoPackageDeliveryInfoVO()
								// .setExpressType(giftSkuVO.getExpressType());

								OpSoPackageDeliveryInfoVO packageDeliveryInfo = getPackageDeliveryInfo(
										daixiaoGiftPackageVO.getOpSoPackageDeliveryInfoVO());

								packageDeliveryInfo.setExpressType(giftSkuVO.getExpressType());
								daixiaoGiftPackageVO.setOpSoPackageDeliveryInfoVO(packageDeliveryInfo);
								isJitPackageList.add(daixiaoGiftPackageVO);
							} else {

								defaultPackageSkuVOs.add(giftSkuVO);
							}
						}

					}
				}
			}
			// preSalePackageVo.setPackageType(2);
			preSaleSkus.add(skuVO);
			preSaleExpressTypes.add(skuVO.getExpressType());
		} else {

			BeanUtils.copyProperties(sourcePackageVO, customizePackageVO);

			customizePackages.add(skuVO);

			// 判断当前商品是否有赠品.如果有赠品，则判断赠品是否是预售
			// final List<OpSoPackageSkuVO> giftSkuVOs =
			// getGiftSkuByMainSkuCodes(skuVO.getSkuCode(),
			// giftPackageSkuVOs);
			if (CollectionUtils.isNotEmpty(skuVO.getGifts())) {

				for (OpSoPackageSkuVO giftSkuVO : skuVO.getGifts()) {
					// 虚拟商品
					if (giftSkuVO.getWhetherVirtual() != null && giftSkuVO.getWhetherVirtual() == 1) {

						virtualPackageSkus.add(giftSkuVO);
						continue;

					}
					if (ConstUtil.bagSkus.contains(giftSkuVO.getSkuCode())) {
						giftSkuVO.setExpressType(skuVO.getExpressType());
						hasBagSkus.add(5);
					}
					if (isPresale(sPresaleMap, sPresaleSaleInvMap, giftSkuVO, opChannel, opSalesOrderVO)) {
						preSaleSkus.add(giftSkuVO);
						preSaleExpressTypes.add(giftSkuVO.getExpressType());
					} else {

						// 设置跟主品一样的快递类型
						if (skuVO.getExpressType() == giftSkuVO.getExpressType()) {
							customizePackages.add(giftSkuVO);
						} else {
							// 代销赠品
							if (giftSkuVO.getWhetherConsignment() != null && giftSkuVO.getWhetherConsignment() == 1) {

								List<OpSoPackageSkuVO> daixiaoGiftPackages = new ArrayList<>();
								daixiaoGiftPackages.add(giftSkuVO);
								OpSoPackageVO daixiaoGiftPackageVO = new OpSoPackageVO();

								BeanUtils.copyProperties(sourcePackageVO, daixiaoGiftPackageVO);
								daixiaoGiftPackageVO.setOpSoPackageSkuVOs(daixiaoGiftPackages);
								daixiaoGiftPackageVO.setPackageType(OpSoPackage.PACKAGE_TYPE_5);
								// daixiaoGiftPackageVO.getOpSoPackageDeliveryInfoVO()
								// .setExpressType(giftSkuVO.getExpressType());

								OpSoPackageDeliveryInfoVO packageDeliveryInfo = getPackageDeliveryInfo(
										daixiaoGiftPackageVO.getOpSoPackageDeliveryInfoVO());

								packageDeliveryInfo.setExpressType(giftSkuVO.getExpressType());
								daixiaoGiftPackageVO.setOpSoPackageDeliveryInfoVO(packageDeliveryInfo);
								// 定制商品包，预计发货日期+7
								daixiaoGiftPackageVO
										.setPlanedDeliveryDate(DateUtil.addDay(new Date(), skuVO.getDeliveryPeriod()));
								isJitPackageList.add(daixiaoGiftPackageVO);
							} else {

								defaultPackageSkuVOs.add(giftSkuVO);
							}
						}
					}
				}
			}

			OpSoPackageVO customizePackageVO2 = customizeMap.get(skuVO.getSkuCode());
			if (customizePackageVO2 == null) {
				customizePackageVO.setOpSoPackageSkuVOs(customizePackages);
				customizePackageVO.setPackageType(OpSoPackage.PACKAGE_TYPE_5);
				// customizePackageVO.getOpSoPackageDeliveryInfoVO().setExpressType(skuVO.getExpressType());

				OpSoPackageDeliveryInfoVO packageDeliveryInfo = getPackageDeliveryInfo(
						customizePackageVO.getOpSoPackageDeliveryInfoVO());

				packageDeliveryInfo.setExpressType(skuVO.getExpressType());
				customizePackageVO.setOpSoPackageDeliveryInfoVO(packageDeliveryInfo);
				customizePackageVO.setPlanedDeliveryDate(DateUtil.addDay(new Date(), skuVO.getDeliveryPeriod()));
				customizeMap.put(skuVO.getSkuCode(), customizePackageVO);
			} else {
				customizePackageVO2.getOpSoPackageSkuVOs().addAll(customizePackages);
			}

		}

	}

	/**
	 * 是大家具商品时
	 *
	 * @param skuVO
	 * @param opChannel
	 * @param sourcePackageVO
	 * @param preSaleSkus
	 * @param giftPackageSkuVOs
	 * @param defaultPackageSkuVOs
	 */
	private void packageIsBigFurniture(OpSoPackageSkuVO skuVO, final OpChannelVO opChannel,
			OpSoPackageVO sourcePackageVO, List<OpSoPackageSkuVO> preSaleSkus, List<OpSoPackageSkuVO> giftPackageSkuVOs,
			List<OpSoPackageVO> isJitPackageList, final List<OpSoPackageSkuVO> defaultPackageSkuVOs,
			List<Integer> hasBagSkus, List<Integer> preSaleExpressTypes, Date planedDeliveryDate,
			Map<String, SPresaleVO> sPresaleMap, Map<String, SPresaleSaleInvVO> sPresaleSaleInvMap,
			OpSalesOrderVO opSalesOrderVO, List<OpSoPackageSkuVO> virtualPackageSkus) {

		logger.info("是BigFurniture:sku=" + skuVO.getSkuCode());
		// 默认来单包裹
		Integer packageType = OpSoPackage.PACKAGE_TYPE_7;

		// 大家具商品发货日期在加3天
		int bigFurnitureDays = 3;

		OpSoPackageVO isBigFurniturePackageVO = new OpSoPackageVO();
		List<OpSoPackageSkuVO> daixiaoPackages = new ArrayList<>();
		// 判断是否是预售
		if (isPresale(sPresaleMap, sPresaleSaleInvMap, skuVO, opChannel, opSalesOrderVO)) {
			logger.info("是BigFurniture也是预售:sku=" + skuVO.getSkuCode());
			// 如果主品和赠品都是预售
			Date mainSkuPlanedDate = skuVO.getsPresaleVO().getPlanedDeliveryDate();
			// 判断当前商品是否有赠品.如果有赠品，则判断赠品是否是预售
			if (CollectionUtils.isNotEmpty(skuVO.getGifts())) {

				for (OpSoPackageSkuVO giftSkuVO : skuVO.getGifts()) {

					// 虚拟商品
					if (giftSkuVO.getWhetherVirtual() != null && giftSkuVO.getWhetherVirtual() == 1) {

						virtualPackageSkus.add(giftSkuVO);
						continue;

					}
					if (ConstUtil.bagSkus.contains(giftSkuVO.getSkuCode())) {
						giftSkuVO.setExpressType(skuVO.getExpressType());
						hasBagSkus.add(2);
					}
					// 判断赠品是否是预售
					if (isPresale(sPresaleMap, sPresaleSaleInvMap, giftSkuVO, opChannel, opSalesOrderVO)) {

						final Date giftSkuPlanedDate = giftSkuVO.getsPresaleVO().getPlanedDeliveryDate();
						if (mainSkuPlanedDate.before(giftSkuPlanedDate)) {
							// 主品预计发货时间早 赠品预计发货时间晚 拆成两单
							preSaleSkus.add(giftSkuVO);
							preSaleExpressTypes.add(giftSkuVO.getExpressType());
						} else {
							// 主品预计发货时间晚 赠品预计发货时间早 合在一个订单 预计发货时间是主品的发货时间
							giftSkuVO.setsPresaleVO(skuVO.getsPresaleVO());
							// preSalePackageSkuVOs.add(giftSkuVO);
							preSaleSkus.add(giftSkuVO);
							preSaleExpressTypes.add(giftSkuVO.getExpressType());
						}
					} else {
						// 大家具赠品
						if (giftSkuVO.getWhetherLogistics() != null && giftSkuVO.getWhetherLogistics() == 1) {

							daixiaoPackages.add(giftSkuVO);
						} else if (giftSkuVO.getIsJit() != null && giftSkuVO.getIsJit() == 1) {

							List<OpSoPackageSkuVO> daixiaoGiftPackages = new ArrayList<>();
							daixiaoGiftPackages.add(giftSkuVO);
							OpSoPackageVO daixiaoGiftPackageVO = new OpSoPackageVO();

							BeanUtils.copyProperties(sourcePackageVO, daixiaoGiftPackageVO);
							daixiaoGiftPackageVO.setOpSoPackageSkuVOs(daixiaoGiftPackages);
							daixiaoGiftPackageVO.setPackageType(packageType);
							// daixiaoGiftPackageVO.getOpSoPackageDeliveryInfoVO()
							// .setExpressType(giftSkuVO.getExpressType());

							OpSoPackageDeliveryInfoVO packageDeliveryInfo = getPackageDeliveryInfo(
									daixiaoGiftPackageVO.getOpSoPackageDeliveryInfoVO());

							packageDeliveryInfo.setExpressType(giftSkuVO.getExpressType());
							daixiaoGiftPackageVO.setOpSoPackageDeliveryInfoVO(packageDeliveryInfo);
							if (planedDeliveryDate != null) {
								daixiaoGiftPackageVO.setPlanedDeliveryDate(DateUtil.addDay(planedDeliveryDate,
										skuVO.getDeliveryPeriod() + bigFurnitureDays));
							} else {
								daixiaoGiftPackageVO.setPlanedDeliveryDate(
										DateUtil.addDay(new Date(), skuVO.getDeliveryPeriod() + bigFurnitureDays));
							}

							isJitPackageList.add(daixiaoGiftPackageVO);

						} else {
							defaultPackageSkuVOs.add(giftSkuVO);
						}
					}

				}
			}

			BeanUtils.copyProperties(sourcePackageVO, isBigFurniturePackageVO);
			// preSaleSkus.add(skuVO);
			// preSaleExpressTypes.add(skuVO.getExpressType());
			List<OpSoPackageSkuVO> skus = new ArrayList<>();
			skus.add(skuVO);
			isBigFurniturePackageVO.setOpSoPackageSkuVOs(skus);

			isBigFurniturePackageVO.setPackageType(packageType);
			// isBigFurniturePackageVO.getOpSoPackageDeliveryInfoVO().setExpressType(skuVO.getExpressType());

			OpSoPackageDeliveryInfoVO packageDeliveryInfo = getPackageDeliveryInfo(
					isBigFurniturePackageVO.getOpSoPackageDeliveryInfoVO());

			packageDeliveryInfo.setExpressType(skuVO.getExpressType());
			isBigFurniturePackageVO.setOpSoPackageDeliveryInfoVO(packageDeliveryInfo);

			isBigFurniturePackageVO.setDispatchWarehouseCode(skus.get(0).getsPresaleVO().getDispatchWarehouseCode());
			isBigFurniturePackageVO.setPlanedDeliveryDate(skus.get(0).getsPresaleVO().getPlanedDeliveryDate());

			int deliveryPeriod = 0;
			if (skuVO.getIsJit() != null && skuVO.getIsJit() == 1) {
				deliveryPeriod = skuVO.getDeliveryPeriod();
			}

			// if (planedDeliveryDate != null) {
			// isBigFurniturePackageVO
			// .setPlanedDeliveryDate(DateUtil.addDay(planedDeliveryDate,
			// deliveryPeriod + bigFurnitureDays));
			// } else {
			// isBigFurniturePackageVO
			// .setPlanedDeliveryDate(DateUtil.addDay(new Date(), deliveryPeriod
			// + bigFurnitureDays));
			// }

			Date bigDate = null;
			if (planedDeliveryDate != null) {
				bigDate = DateUtil.addDay(planedDeliveryDate, deliveryPeriod + bigFurnitureDays);
			} else {
				bigDate = DateUtil.addDay(new Date(), deliveryPeriod + bigFurnitureDays);
			}

			if (mainSkuPlanedDate != null) {
				if (mainSkuPlanedDate.getTime() > bigDate.getTime()) {
					isBigFurniturePackageVO.setPlanedDeliveryDate(mainSkuPlanedDate);
				} else {
					isBigFurniturePackageVO.setPlanedDeliveryDate(bigDate);
				}
			} else {
				isBigFurniturePackageVO.setPlanedDeliveryDate(bigDate);
			}

			isJitPackageList.add(isBigFurniturePackageVO);
		} else {

			BeanUtils.copyProperties(sourcePackageVO, isBigFurniturePackageVO);

			daixiaoPackages.add(skuVO);

			// 判断当前商品是否有赠品.如果有赠品，则判断赠品是否是预售
			if (CollectionUtils.isNotEmpty(skuVO.getGifts())) {

				for (OpSoPackageSkuVO giftSkuVO : skuVO.getGifts()) {

					// 虚拟商品
					if (giftSkuVO.getWhetherVirtual() != null && giftSkuVO.getWhetherVirtual() == 1) {

						virtualPackageSkus.add(giftSkuVO);
						continue;

					}
					if (ConstUtil.bagSkus.contains(giftSkuVO.getSkuCode())) {
						giftSkuVO.setExpressType(skuVO.getExpressType());
						hasBagSkus.add(isBigFurniturePackageVO.getPackageType());
					}
					if (isPresale(sPresaleMap, sPresaleSaleInvMap, giftSkuVO, opChannel, opSalesOrderVO)) {
						preSaleSkus.add(giftSkuVO);
						preSaleExpressTypes.add(giftSkuVO.getExpressType());
					} else {

						// 大家具赠品
						if (giftSkuVO.getWhetherLogistics() != null && giftSkuVO.getWhetherLogistics() == 1) {

							daixiaoPackages.add(giftSkuVO);
						} else if (giftSkuVO.getIsJit() != null && giftSkuVO.getIsJit() == 1) {

							List<OpSoPackageSkuVO> daixiaoGiftPackages = new ArrayList<>();
							daixiaoGiftPackages.add(giftSkuVO);
							OpSoPackageVO daixiaoGiftPackageVO = new OpSoPackageVO();

							BeanUtils.copyProperties(sourcePackageVO, daixiaoGiftPackageVO);
							daixiaoGiftPackageVO.setOpSoPackageSkuVOs(daixiaoGiftPackages);
							daixiaoGiftPackageVO.setPackageType(packageType);
							// daixiaoGiftPackageVO.getOpSoPackageDeliveryInfoVO()
							// .setExpressType(giftSkuVO.getExpressType());

							OpSoPackageDeliveryInfoVO packageDeliveryInfo = getPackageDeliveryInfo(
									daixiaoGiftPackageVO.getOpSoPackageDeliveryInfoVO());

							packageDeliveryInfo.setExpressType(giftSkuVO.getExpressType());
							daixiaoGiftPackageVO.setOpSoPackageDeliveryInfoVO(packageDeliveryInfo);
							if (planedDeliveryDate != null) {
								daixiaoGiftPackageVO.setPlanedDeliveryDate(DateUtil.addDay(planedDeliveryDate,
										skuVO.getDeliveryPeriod() + bigFurnitureDays));
							} else {
								daixiaoGiftPackageVO.setPlanedDeliveryDate(
										DateUtil.addDay(new Date(), skuVO.getDeliveryPeriod() + bigFurnitureDays));
							}

							isJitPackageList.add(daixiaoGiftPackageVO);

						} else {
							defaultPackageSkuVOs.add(giftSkuVO);
						}
					}
				}
			}

			isBigFurniturePackageVO.setOpSoPackageSkuVOs(daixiaoPackages);
			isBigFurniturePackageVO.setPackageType(packageType);
			// isBigFurniturePackageVO.getOpSoPackageDeliveryInfoVO().setExpressType(skuVO.getExpressType());

			OpSoPackageDeliveryInfoVO packageDeliveryInfo = getPackageDeliveryInfo(
					isBigFurniturePackageVO.getOpSoPackageDeliveryInfoVO());

			packageDeliveryInfo.setExpressType(skuVO.getExpressType());
			isBigFurniturePackageVO.setOpSoPackageDeliveryInfoVO(packageDeliveryInfo);

			int deliveryPeriod = 0;
			if (skuVO.getIsJit() != null && skuVO.getIsJit() == 1) {
				deliveryPeriod = skuVO.getDeliveryPeriod();
			}

			if (planedDeliveryDate != null) {
				isBigFurniturePackageVO
						.setPlanedDeliveryDate(DateUtil.addDay(planedDeliveryDate, deliveryPeriod + bigFurnitureDays));
			} else {
				isBigFurniturePackageVO
						.setPlanedDeliveryDate(DateUtil.addDay(new Date(), deliveryPeriod + bigFurnitureDays));
			}
			isJitPackageList.add(isBigFurniturePackageVO);
		}

	}

	/***
	 * 查询出所有的非赠品，包含普通商品、已经买赠的主商品 (包含了预售)
	 *
	 * @param sourcePackageVOs
	 * @return
	 */
	private static List<OpSoPackageSkuVO> getAllNoneGiftPackageSkuVOs(final OpChannelVO opChannel,
			final List<OpSoPackageSkuVO> sourcePackageVOs) {
		final String warehouseCode = opChannel.getWarehouseForSales();
		final List<OpSoPackageSkuVO> noneGiftPackageSkuVOs = new ArrayList<>(2);// 默认包裹的sku集合
		for (final OpSoPackageSkuVO skuVO : sourcePackageVOs) {
			// 线下不排除赠品
			if (opChannel.getChannelType() == 1) {
				// if (StringUtils.isBlank(skuVO.getMainSkuCode())) {
				skuVO.setDispatchWarehouseCode(warehouseCode);// 冗余发货仓字段，调拨时使用
				noneGiftPackageSkuVOs.add(skuVO);
				// }
			} else {
				if (StringUtils.isBlank(skuVO.getMainSkuCode())) {
					skuVO.setDispatchWarehouseCode(warehouseCode);// 冗余发货仓字段，调拨时使用
					noneGiftPackageSkuVOs.add(skuVO);
				}
			}

		}
		return noneGiftPackageSkuVOs;
	}

	/***
	 * 查询出所有的赠品(包含预售的赠品)
	 *
	 * @param sourcePackageVOs
	 * @return
	 */
	private static List<OpSoPackageSkuVO> getAllGiftPackageSkuVOs(final OpChannelVO opChannel,
			final List<OpSoPackageSkuVO> sourcePackageVOs) {
		final List<OpSoPackageSkuVO> giftPackageSkuVOs = new ArrayList<>(2);// 默认包裹的sku集合
		for (final OpSoPackageSkuVO skuVO : sourcePackageVOs) {
			if (StringUtils.isNotBlank(skuVO.getMainSkuCode())) {
				skuVO.setIsGift(PegasusConstants.YES);
				skuVO.setDispatchWarehouseCode(opChannel.getWarehouseForSales());// 冗余发货仓字段，调拨时使用
				giftPackageSkuVOs.add(skuVO);
			}
		}
		return giftPackageSkuVOs;
	}

	/***
	 * 判断是否是预售，如果是预售
	 *
	 * @param skuVO
	 * @return
	 */
	// private boolean isPresale(final OpChannelVO opChannel, final
	// OpSoPackageSkuVO skuVO) {
	// boolean isPresale = false;
	// // final OpPresaleVO presaleVO =
	// // poInstance.findAvaliableBySkuCode(skuVO.getSkuCode());
	// SPresaleVO sPresaleVO = null;
	// if (opChannel.getChannelType() != null && opChannel.getChannelType() ==
	// 1) {
	// sPresaleVO = sPresaleService.findAvaliableBySkuCode(skuVO.getSkuCode(),
	// true);
	//
	// } else {
	// sPresaleVO = sPresaleService.findAvaliableBySkuCode(skuVO.getSkuCode(),
	// false);
	// }
	//
	// if (sPresaleVO != null) {
	// // 有预售。再判断物理库存是否可卖。
	// // 物理库存不足，则拆包裹，物理库存足够，则不拆包裹
	// // final WhInvVO whInvVO =
	// // pwiInstance.findCanUseQttBySkuCodeAndWarehouseCode(skuVO.getSkuCode(),
	// // opChannel.getWarehouseForSales());
	// // final Integer quantity = whInvVO.getCanUseInv();
	//
	// SPresaleSaleInvVO preSaleInvVO = null;
	// if (opChannel.getChannelType() != null && opChannel.getChannelType() ==
	// 1) {
	// preSaleInvVO = sPresaleService.findCanUseQttBySkuCode(skuVO.getSkuCode(),
	// OpPresaleVO.CHANNEL_TYPE_OFFLINE);
	// } else {
	// preSaleInvVO = sPresaleService.findCanUseQttBySkuCode(skuVO.getSkuCode(),
	// null);
	// }
	//
	// if (preSaleInvVO == null) {
	//
	// return isPresale;
	// }
	// final Integer preSaleQuantity = preSaleInvVO.getCanUseInv();
	// // if (skuVO.getQuantity() > quantity && skuVO.getQuantity() <=
	// // preSaleQuantity) {
	// if (skuVO.getQuantity() <= preSaleQuantity) {
	//
	// skuVO.setPresaleId(sPresaleVO.getId());
	// skuVO.setPresaleStatus(OpSoPackageSku.PRESALES_STATUS_WAIT);
	// skuVO.setDispatchWarehouseCode(sPresaleVO.getDispatchWarehouseCode());//
	// 冗余发货仓字段
	// skuVO.setsPresaleVO(sPresaleVO);// 冗余整个预售对象VO
	// isPresale = true;
	// } else if (skuVO.getQuantity() > preSaleQuantity) {
	// throw new ChannelException(ErrorCode.ITEM_OUTOF_QUANTITY.getCode(),
	// "预售" + ErrorCode.ITEM_OUTOF_QUANTITY.getMesage() + ": " +
	// skuVO.getSkuCode() + ": "
	// + skuVO.getNameCn());
	// }
	// }
	// return isPresale;
	// }

	/**
	 * 判断是否是预售，如果是预售
	 *
	 * @param skuVO
	 * @return
	 */
	// private boolean isPresale3(Map<String, SPresaleVO> spresaleMap,
	// Map<String, SPresaleSaleInvVO> sPresaleSaleInvMap,
	// Map<String, SSkuStockVO> sSkuStockVOMap, final OpSoPackageSkuVO skuVO,
	// final OpChannelVO opChannel,
	// Map<String, SSkuStockVO> headSkuStockVOMap) {
	// boolean isPresale = false;
	//
	// if (spresaleMap == null || spresaleMap.size() <= 0 || sPresaleSaleInvMap
	// == null
	// || sPresaleSaleInvMap.size() <= 0) {
	//
	// return isPresale;
	// }
	//
	// SPresaleVO sPresaleVO = spresaleMap.get(skuVO.getSkuCode());
	//
	// if (sPresaleVO != null) {
	//
	// // 有预售。再判断物理库存是否可卖。
	// // 物理库存不足，则拆包裹，物理库存足够，则不拆包裹
	// // final WhInvVO whInvVO =
	// // pwiInstance.findCanUseQttBySkuCodeAndWarehouseCode(skuVO.getSkuCode(),
	// // opChannel.getWarehouseForSales());
	// // final Integer quantity = whInvVO.getCanUseInv();
	// if (opChannel.getChannelType() != null && opChannel.getChannelType() ==
	// 1) {
	// SPresaleSaleInvVO sPresaleSaleInvVO =
	// sPresaleSaleInvMap.get(skuVO.getSkuCode());
	//
	// final Integer preSaleQuantity = sPresaleSaleInvVO.getCanUseInv();
	// SSkuStockVO sSkuStockVO = sSkuStockVOMap.get(skuVO.getSkuCode());
	//
	// int quantity = 0;
	//
	// if (sSkuStockVO != null && sSkuStockVO.getCanUseQuantity() != null) {
	// quantity = sSkuStockVO.getCanUseQuantity();
	// }
	// int stock = 0;
	// SSkuStockVO stockVO = headSkuStockVOMap.get(skuVO.getSkuCode());
	//
	// if (stockVO != null) {
	// stock = stockVO.getCanUseQuantity();
	// }
	//
	// if (skuVO.getQuantity() > quantity && skuVO.getQuantity() > stock
	// && skuVO.getQuantity() <= preSaleQuantity) {
	//
	// skuVO.setPresaleId(sPresaleVO.getId());
	// skuVO.setPresaleStatus(OpSoPackageSku.PRESALES_STATUS_WAIT);
	// skuVO.setDispatchWarehouseCode(sPresaleVO.getDispatchWarehouseCode());//
	// 冗余发货仓字段
	// skuVO.setsPresaleVO(sPresaleVO);// 冗余整个预售对象VO
	// isPresale = true;
	// } else if (skuVO.getQuantity() > quantity && skuVO.getQuantity() >
	// preSaleQuantity
	// && skuVO.getQuantity() > stock) {
	// throw new ChannelException(ErrorCode.ITEM_OUTOF_QUANTITY.getCode(),
	// "预售" + ErrorCode.ITEM_OUTOF_QUANTITY.getMesage() + ": " +
	// skuVO.getSkuCode() + ": "
	// + skuVO.getNameCn());
	// }
	//
	// } else {
	//
	// SPresaleSaleInvVO sPresaleSaleInvVO =
	// sPresaleSaleInvMap.get(skuVO.getSkuCode());
	//
	// final Integer preSaleQuantity = sPresaleSaleInvVO.getCanUseInv();
	// // if (skuVO.getQuantity() > quantity && skuVO.getQuantity() <=
	// // preSaleQuantity) {
	// if (skuVO.getQuantity() <= preSaleQuantity) {
	//
	// skuVO.setPresaleId(sPresaleVO.getId());
	// skuVO.setPresaleStatus(OpSoPackageSku.PRESALES_STATUS_WAIT);
	// skuVO.setDispatchWarehouseCode(sPresaleVO.getDispatchWarehouseCode());//
	// 冗余发货仓字段
	// skuVO.setsPresaleVO(sPresaleVO);// 冗余整个预售对象VO
	// isPresale = true;
	// } else if (skuVO.getQuantity() > preSaleQuantity) {
	// throw new ChannelException(ErrorCode.ITEM_OUTOF_QUANTITY.getCode(),
	// "预售" + ErrorCode.ITEM_OUTOF_QUANTITY.getMesage() + ": " +
	// skuVO.getSkuCode() + ": "
	// + skuVO.getNameCn());
	// }
	// }
	//
	// }
	//
	// return isPresale;
	// }

	/**
	 * 判断是否是预售，如果是预售
	 *
	 * @param skuVO
	 * @return
	 */
	private boolean isPresale(Map<String, SPresaleVO> spresaleMap, Map<String, SPresaleSaleInvVO> sPresaleSaleInvMap,
			final OpSoPackageSkuVO skuVO, final OpChannelVO opChannel, OpSalesOrderVO opSalesOrderVO) {
		boolean isPresale = false;

		// 组合商品不能是预售
		if (skuVO.isCombination()) {
			return false;
		}

		if (skuVO.getSourceId() != null && CartPackSource.BENEFIT.id.equals(skuVO.getSourceId())) {
			return false;
		}

		if (spresaleMap == null || spresaleMap.size() <= 0 || sPresaleSaleInvMap == null
				|| sPresaleSaleInvMap.size() <= 0) {

			return isPresale;
		}

		SPresaleVO sPresaleVO = spresaleMap.get(skuVO.getSkuCode());

		if (sPresaleVO != null) {

			// 有预售。再判断物理库存是否可卖。
			// 物理库存不足，则拆包裹，物理库存足够，则不拆包裹
			// final WhInvVO whInvVO =
			// pwiInstance.findCanUseQttBySkuCodeAndWarehouseCode(skuVO.getSkuCode(),
			// opChannel.getWarehouseForSales());
			// final Integer quantity = whInvVO.getCanUseInv();
			if (opChannel.getChannelType() != null && opChannel.getChannelType() == 1) {

				if (skuVO.getsPresaleVO() != null) {
					isPresale = true;
				}

				// if (opSalesOrderVO.getStockDistinguish() == 3) {
				// SPresaleSaleInvVO sPresaleSaleInvVO =
				// sPresaleSaleInvMap.get(skuVO.getSkuCode());
				//
				// final Integer preSaleQuantity =
				// sPresaleSaleInvVO.getCanUseInv();
				// // SSkuStockVO sSkuStockVO =
				// // sSkuStockVOMap.get(skuVO.getSkuCode());
				//
				// // int quantity = 0;
				// //
				// // if(sSkuStockVO!=null &&
				// // sSkuStockVO.getCanUseQuantity()!=null){
				// // quantity = sSkuStockVO.getCanUseQuantity();
				// // }
				// // int stock = 0;
				// // SSkuStockVO stockVO =
				// // headSkuStockVOMap.get(skuVO.getSkuCode());
				// //
				// // if(stockVO != null){
				// // stock = stockVO.getCanUseQuantity();
				// // }
				//
				// if (skuVO.getQuantity() <= preSaleQuantity) {
				//
				// skuVO.setPresaleId(sPresaleVO.getId());
				// skuVO.setPresaleStatus(OpSoPackageSku.PRESALES_STATUS_WAIT);
				// skuVO.setDispatchWarehouseCode(sPresaleVO.getDispatchWarehouseCode());//
				// 冗余发货仓字段
				// skuVO.setsPresaleVO(sPresaleVO);// 冗余整个预售对象VO
				// isPresale = true;
				// } else {
				// throw new
				// ChannelException(ErrorCode.ITEM_OUTOF_QUANTITY.getCode(),
				// "预售" + ErrorCode.ITEM_OUTOF_QUANTITY.getMesage() + ": " +
				// skuVO.getSkuCode() + ": "
				// + skuVO.getNameCn());
				// }
				// } else {
				//
				// return isPresale;
				// }

			} else {

				// 参团订单
				if (OrderTypeEnum.ORDERTYPE_10.getCode() == opSalesOrderVO.getOrderTypeEnum().getCode()) {

					if (opSalesOrderVO.getsGroupbuyParterOccupyDTO() != null) {
						List<String> skuCodeList = Lists.newArrayList(skuVO.getSkuCode());
						List<SGroupbuyStockVO> sGroupbuyStockVOList = groupbuyStockService.getGroupbuyStockByGroupbuyId(
								opSalesOrderVO.getsGroupbuyParterOccupyDTO().getGroupbuyInfo().getGroupbuyId(),
								skuCodeList);

						if (CollectionUtils.isNotEmpty(sGroupbuyStockVOList)) {

							if ("presale".equals(sGroupbuyStockVOList.get(0).getOccupyMode())) {

								skuVO.setPresaleId(sPresaleVO.getId());
								skuVO.setPresaleStatus(OpSoPackageSku.PRESALES_STATUS_WAIT);
								skuVO.setDispatchWarehouseCode(sPresaleVO.getDispatchWarehouseCode());// 冗余发货仓字段
								skuVO.setsPresaleVO(sPresaleVO);// 冗余整个预售对象VO
								isPresale = true;
							} else {
								return false;
							}

						}
					} else {

						skuVO.setPresaleId(sPresaleVO.getId());
						skuVO.setPresaleStatus(OpSoPackageSku.PRESALES_STATUS_WAIT);
						skuVO.setDispatchWarehouseCode(sPresaleVO.getDispatchWarehouseCode());// 冗余发货仓字段
						skuVO.setsPresaleVO(sPresaleVO);// 冗余整个预售对象VO
						isPresale = true;
					}

				} else {
					SPresaleSaleInvVO sPresaleSaleInvVO = sPresaleSaleInvMap.get(skuVO.getSkuCode());

					final Integer preSaleQuantity = sPresaleSaleInvVO.getCanUseInv();
					// if (skuVO.getQuantity() > quantity && skuVO.getQuantity()
					// <=
					// preSaleQuantity) {
					if (skuVO.getQuantity() <= preSaleQuantity) {

						skuVO.setPresaleId(sPresaleVO.getId());
						skuVO.setPresaleStatus(OpSoPackageSku.PRESALES_STATUS_WAIT);
						skuVO.setDispatchWarehouseCode(sPresaleVO.getDispatchWarehouseCode());// 冗余发货仓字段
						skuVO.setsPresaleVO(sPresaleVO);// 冗余整个预售对象VO
						isPresale = true;
					} else if (skuVO.getQuantity() > preSaleQuantity) {
						throw new ChannelException(ErrorCode.ITEM_OUTOF_QUANTITY.getCode(),
								"预售" + ErrorCode.ITEM_OUTOF_QUANTITY.getMesage() + ": " + skuVO.getSkuCode() + ": "
										+ skuVO.getNameCn());
					}
				}

			}

		}

		return isPresale;
	}

	// 取得生日折扣
	public BigDecimal birthdayDiscount(OpMemberVO memberVo) {
		BigDecimal discount = BigDecimal.ZERO;

		DateFormat df = new SimpleDateFormat("yyyy-MM-dd");
		String birthday = df.format(memberVo.getBirthday());
		Calendar now = Calendar.getInstance();
		int year = now.get(Calendar.YEAR);
		// 用户生日折扣
		if (memberVo.getBirthdayDiscountYear() != null && memberVo.getBirthdayDiscountYear() > 0) {

			if (year <= memberVo.getBirthdayDiscountYear()) {

				return discount;

			}

		}

		String dateStr = year + birthday.substring(4, birthday.length());
		Date date = null;
		try {
			date = df.parse(dateStr);
		} catch (ParseException e) {
			e.printStackTrace();
		}
		int days = daysOfTwo(now, date);
		int useday = 0;

		if (memberVo.getMemberLevel() == 0) {
			useday = 0;
			discount = BigDecimal.valueOf(0.95);
		} else if (memberVo.getMemberLevel() == 1) {
			useday = 7;
			discount = BigDecimal.valueOf(0.948);
		} else if (memberVo.getMemberLevel() == 2) {
			useday = 7;
			discount = BigDecimal.valueOf(0.945);
		} else if (memberVo.getMemberLevel() == 3) {
			useday = 7;
			discount = BigDecimal.valueOf(0.889);
		}

		if (days < 0 && useday < days) {
			discount = BigDecimal.ZERO;
		}

		return discount;
	}

	public int daysOfTwo(Calendar now, Date oDate) {

		int day1 = now.get(Calendar.DAY_OF_YEAR);

		now.setTime(oDate);

		int day2 = now.get(Calendar.DAY_OF_YEAR);

		return day1 - day2;

	}

	public OpSoPackageDeliveryInfoVO getPackageDeliveryInfo(OpSoPackageDeliveryInfoVO opSoPackageDeliveryInfoVO) {
		OpSoPackageDeliveryInfoVO packageDeliveryInfo = new OpSoPackageDeliveryInfoVO();
		packageDeliveryInfo.setAddress(opSoPackageDeliveryInfoVO.getAddress());
		packageDeliveryInfo.setCircuitDesc(opSoPackageDeliveryInfoVO.getCircuitDesc());
		packageDeliveryInfo.setCity(opSoPackageDeliveryInfoVO.getCity());
		packageDeliveryInfo.setCompanyName(opSoPackageDeliveryInfoVO.getCompanyName());
		packageDeliveryInfo.setDeliveryCode(opSoPackageDeliveryInfoVO.getDeliveryCode());
		packageDeliveryInfo.setDistrict(opSoPackageDeliveryInfoVO.getDistrict());
		packageDeliveryInfo.setDistrictId(opSoPackageDeliveryInfoVO.getDistrictId());
		// 海淘专用
		packageDeliveryInfo.setExpressType(opSoPackageDeliveryInfoVO.getExpressType());
		packageDeliveryInfo.setProvince(opSoPackageDeliveryInfoVO.getProvince());
		packageDeliveryInfo.setReceiver(opSoPackageDeliveryInfoVO.getReceiver());
		packageDeliveryInfo.setReceiverPhone(opSoPackageDeliveryInfoVO.getReceiverPhone());
		packageDeliveryInfo.setTitle(opSoPackageDeliveryInfoVO.getTitle());
		packageDeliveryInfo.setZipCode(opSoPackageDeliveryInfoVO.getZipCode());

		return packageDeliveryInfo;
	}

	public static Map<String, Long> spvMap = new HashMap<>();

	static {
		spvMap.put("705160090", 15507L);
		spvMap.put("781160672", 16999L);
		spvMap.put("781160682", 16998L);
		spvMap.put("781160692", 16997L);
		spvMap.put("781160702", 16996L);
		spvMap.put("905161240", 16995L);

	}

	/**
	 * 设置强制审单
	 */
	// private void setIsForceAudit(OpSalesOrderVO opSalesOrderVO,PsSkuVO
	// skuVO){
	//
	// //if ("CHN2018".equals(opSalesOrderVO.getChannelCode()) ||
	// opSalesOrderVO.getIsForceAudit() == null ||
	// opSalesOrderVO.getIsForceAudit() != 1) {
	//
	// if(skuVO.getCanCustomize() == null){
	// skuVO.setCanCustomize(0);
	// }
	// if (1 == skuVO.getIsJit() && skuVO.getWhetherConsignment() != null &&
	// skuVO.getWhetherConsignment() == 0 && skuVO.getCanCustomize()!= 1) {
	// opSalesOrderVO.setIsForceAudit(PegasusConstants.YES);
	// }
	//
	// //}
	//
	// // 官网/wap这里有3个高单价的永生花盒，因为scm配送方式选项里面没有“自送“并且我们订单不支持备注，
	// // 所以针对单价高于5000元的花盒，希望改为客服强制审单
	// if (ConstUtil.forceAuditSkus.contains(skuVO.getSkuCode())) {
	// opSalesOrderVO.setIsForceAudit(PegasusConstants.YES);
	// }
	//
	// // 如果是大家具需要强制审单
	// if(skuVO.getWhetherLogistics()!=null && skuVO.getWhetherLogistics()==1){
	// opSalesOrderVO.setIsForceAudit(PegasusConstants.YES);
	// }
	//
	// }

	/**
	 * 取所有的赠品pack
	 * 
	 * @param spvSteps
	 * @return
	 */
	public Map<Long, List<PrsCampaignVO>> getSpvCampaign(List<PrsSpvPriceStepVO> spvSteps, List<PrsPriceStepVO> steps,
			Map<Long, BigDecimal> birthdayDisMap, Map<Long, BigDecimal> couponDisMap,
			Map<Long, BigDecimal> couponDisMap2) {
		Map<Long, List<PrsCampaignVO>> campaignMap = new HashMap<Long, List<PrsCampaignVO>>();
		Map<Long, PrsCampaignVO> campaignList = new HashMap<Long, PrsCampaignVO>();
		if (CollectionUtils.isNotEmpty(steps)) {

			for (PrsPriceStepVO step : steps) {
				if (null != step.getCampaign()) {
					campaignList.put(step.getCampaign().getId(), step.getCampaign());
				}
			}
		}
		if (CollectionUtils.isNotEmpty(spvSteps)) {
			for (PrsSpvPriceStepVO spvStep : spvSteps) {
				List<PrsCampaignVO> camps = new ArrayList<PrsCampaignVO>();
				if (spvStep.getPriceType().equals(PrsPriceTypeEnum.CAMPAIGN)) {
					if (campaignMap.containsKey(spvStep.getSpvId())) {
						camps.addAll(campaignMap.get(spvStep.getSpvId()));
					}
					camps.add(campaignList.get(spvStep.getExtId()));
					campaignMap.put(spvStep.getSpvId(), camps);
				} else if (spvStep.getPriceType().equals(PrsPriceTypeEnum.COUPON)) {
					if (couponDisMap.get(spvStep.getSpvId()) == null) {
						couponDisMap.put(spvStep.getSpvId(), spvStep.getSpvSavedPrice());
					} else {
						couponDisMap2.put(spvStep.getSpvId(), spvStep.getSpvSavedPrice());
					}

				} else if (spvStep.getPriceType().equals(PrsPriceTypeEnum.BIRTHDAY)) {

					birthdayDisMap.put(spvStep.getSpvId(), spvStep.getSpvSavedPrice());
				}
			}
		}
		return campaignMap;
	}

	/**
	 * 取所有的赠品pack
	 *
	 * @param spvSteps
	 * @return
	 */
	public Map<String, PrsCampaignVO> getSpvCampaignVO(List<PrsSpvPriceStepVO> spvSteps, List<PrsPriceStepVO> steps,
			Map<Long, BigDecimal> birthdayDisMap, Map<Long, BigDecimal> couponDisMap,
			Map<Long, BigDecimal> couponDisMap2) {
		Map<String, PrsCampaignVO> campaignMap = new HashMap<String, PrsCampaignVO>();

		if (CollectionUtils.isNotEmpty(steps)) {

			for (PrsPriceStepVO step : steps) {
				if (null != step.getCampaign() && CollectionUtils.isNotEmpty(step.getAdditionalPackList())) {

					if (DiscountType.GIFT.getId().equals(step.getCampaign().getDiscountTypeId())) {
						for (PrsAdditionalPackVO bean : step.getAdditionalPackList()) {

							if (bean.getIsSingleScopeCampaign()) {
								if (CollectionUtils.isNotEmpty(bean.getBindSpvIds())) {
									String key = bean.getProductId() + ""
											+ step.getAdditionalPackList().get(0).getBindSpvIds().get(0);

									campaignMap.put(key, step.getCampaign());
								}
							} else {
								String key = bean.getProductId() + "";

								campaignMap.put(key, step.getCampaign());
							}

						}
					}

				}
			}
		}
		if (CollectionUtils.isNotEmpty(spvSteps)) {
			for (PrsSpvPriceStepVO spvStep : spvSteps) {
				// List<PrsCampaignVO> camps = new ArrayList<PrsCampaignVO>();
				if (spvStep.getPriceType().equals(PrsPriceTypeEnum.CAMPAIGN)) {
					// if (campaignMap.containsKey(spvStep.getSpvId())) {
					// camps.addAll(campaignMap.get(spvStep.getSpvId()));
					// }
					// //camps.add(campaignList.get(spvStep.getExtId()));
					// campaignMap.put(spvStep.getSpvId(), camps);
				} else if (spvStep.getPriceType().equals(PrsPriceTypeEnum.COUPON)) {
					if (couponDisMap.get(spvStep.getSpvId()) == null) {
						couponDisMap.put(spvStep.getSpvId(), spvStep.getSpvSavedPrice());
					} else {
						couponDisMap2.put(spvStep.getSpvId(), spvStep.getSpvSavedPrice());
					}

				} else if (spvStep.getPriceType().equals(PrsPriceTypeEnum.BIRTHDAY)) {

					birthdayDisMap.put(spvStep.getSpvId(), spvStep.getSpvSavedPrice());
				}
			}
		}
		return campaignMap;
	}

	private void spvPriceStepMap(List<PrsSpvPriceStepVO> spvSteps, Map<Long, PrsSpvPriceStepVO> pointSpvPriceStepMap,Map<Long, PrsSpvPriceStepVO> discountTypeSpvPriceStepMap) {

		if (CollectionUtils.isNotEmpty(spvSteps)) {

			for (PrsSpvPriceStepVO bean : spvSteps) {

				if (bean.getPoints() > 0) {
					pointSpvPriceStepMap.put(bean.getSpvId(), bean);
				}
				
				if(bean.getDiscountType() != null){
					discountTypeSpvPriceStepMap.put(bean.getSpvId(), bean);
				}

			}

		}

	}
}
