package com.thebeastshop.pegasus.channelservice.adapter;

import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import com.thebeastshop.member.vo.MemberAddressVO;
import com.thebeastshop.pegasus.channelservice.vo.address.AddressVO;

/***
 * 地址addapter。做接口之间参数转换
 * 
 * @author ztq
 *
 */
@Service("weixinaddressAdapter")
public class AddressAdapter {

	/***
	 * 外部地址转换为通用地址对象
	 * 
	 * @param addressVo
	 */
	public MemberAddressVO website2Common(AddressVO addressVo) {
		MemberAddressVO opMemberAddressVo = new MemberAddressVO();
		if (!StringUtils.isEmpty(addressVo.getStreet())
				&& !"null".equals(addressVo.getStreet())) {
			opMemberAddressVo.setAddress(addressVo.getStreet());
		}

		if (!StringUtils.isEmpty(addressVo.getCircuit())
				&& !"null".equals(addressVo.getCircuit())) {
			opMemberAddressVo.setCircuit(addressVo.getCircuit());
		}

		if (!StringUtils.isEmpty(addressVo.getCity())
				&& !"null".equals(addressVo.getCity())) {
			opMemberAddressVo.setCity(addressVo.getCity());
		}

		if (!StringUtils.isEmpty(addressVo.getCompanyName())
				&& !"null".equals(addressVo.getCompanyName())) {
			opMemberAddressVo.setCompanyName(addressVo.getCompanyName());
		}

		if (!StringUtils.isEmpty(addressVo.getDistrict())
				&& !"null".equals(addressVo.getDistrict())) {
			opMemberAddressVo.getDistrict().setName(addressVo.getDistrict());
		}

		if (!StringUtils.isEmpty(addressVo.getProvince())
				&& !"null".equals(addressVo.getProvince())) {
			opMemberAddressVo.setProvince(addressVo.getProvince());
		}

        // opMemberAddressVo.setId(addressVo.getId());

		opMemberAddressVo.getDistrict().setId(addressVo.getDistrictId());
		opMemberAddressVo.setDistrictId(addressVo.getDistrictId());

		opMemberAddressVo.setMemberId(addressVo.getMemberId());
		if (!StringUtils.isEmpty(addressVo.getZip())
				&& !"null".equals(addressVo.getZip())) {
			opMemberAddressVo.setZipCode(addressVo.getZip());
		}

		if (!StringUtils.isEmpty(addressVo.getName())
				&& !"null".equals(addressVo.getName())) {
			opMemberAddressVo.setReceiver(addressVo.getName());
		}

		if (!StringUtils.isEmpty(addressVo.getPhone())
				&& !"null".equals(addressVo.getPhone())) {
			opMemberAddressVo.setReceiverPhone(addressVo.getPhone());
		}

		opMemberAddressVo.setTitle(addressVo.getMagentoTitle());

		opMemberAddressVo.setId(addressVo.getId());
		return opMemberAddressVo;
	}

	/***
	 * 根据通用的address对象。封装成接口参数
	 * 
	 * @param opAddressVO
	 * @return
	 */
	public AddressVO common2website(MemberAddressVO opAddressVO) {
		AddressVO addressVo = new AddressVO();
		addressVo.setMagentoTitle(opAddressVO.getTitle());
		addressVo.setStreet(opAddressVO.getAddress());
		addressVo.setCircuit(opAddressVO.getCircuit());
		addressVo.setCity(opAddressVO.getCity());
		addressVo.setCityId(opAddressVO.getCityId());
		addressVo.setCompanyName(opAddressVO.getCompanyName());
		addressVo.setDistrict(opAddressVO.getDistrict().getName());
		addressVo.setProvince(opAddressVO.getProvince());
		addressVo.setId(opAddressVO.getId());
		addressVo.setName(opAddressVO.getReceiver());
		addressVo.setPhone(opAddressVO.getReceiverPhone());
		addressVo.setId(opAddressVO.getId());
		addressVo.setDistrictId(opAddressVO.getDistrict().getId());
		addressVo.setMemberId(opAddressVO.getMemberId());
		addressVo.setZip(opAddressVO.getZipCode());
		
		return addressVo;
	}
}
