/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.channelservice;

import java.io.Serializable;

import org.apache.commons.lang.StringUtils;

import com.thebeastshop.pegasus.channelservice.constants.ErrorCode;

/**
 * @author fs
 * @version $Id: JsonApiResult.java, v 0.1 2015-07-14 上午11:31
 */
public class JsonApiResult implements Serializable{
	
    /**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private Integer code;

	private String message;

	private Object data;
	
	
	public JsonApiResult(Integer code,String message ,Object data){
		this.code=code;
		if(StringUtils.isNotBlank(message)){
			this.message=message;
		}
		this.data=data;
	}
	
	public static JsonApiResult ofSuccessResult(String message,Object data){
		return new JsonApiResult(ErrorCode.OPERATION_OK.getCode(), message, data);
	}
	
	public static JsonApiResult ofSuccessResult(Object data){
		return new JsonApiResult(ErrorCode.OPERATION_OK.getCode(), ErrorCode.OPERATION_OK.getMesage(), data);
	}
	public static JsonApiResult ofErrorResult(Integer code,String message){
		return new JsonApiResult(code, message, null);
	}
	
	public Integer getCode() {
		return code;
	}

	public Object getData() {
		return data;
	}

	public String getMessage() {
		return message;
	}

	public void setCode(Integer code) {
		this.code = code;
	}

    public void setData(Object data) {
		this.data = data;
	}

    public void setMessage(String message) {
		this.message = message;
	}

}
