/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.es.dao;

import com.thebeastshop.es.annotation.EsDaoConfig;
import com.thebeastshop.es.dao.EsUtil;
import com.thebeastshop.es.dao.core.AbstractEsDao;
import com.thebeastshop.es.spring.ElasticsearchClientFactory;
import com.thebeastshop.scm.es.PsSkuVO;
import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.springframework.beans.factory.annotation.Autowired;

@EsDaoConfig(id="skuCode", type="pubsku")
public class SkuEsDao
extends AbstractEsDao<PsSkuVO> {
    @Autowired
    public SkuEsDao(ElasticsearchClientFactory elasticsearchClientFactory) {
        super(elasticsearchClientFactory);
    }

    public void updateSupplier(List<Map> supplierMapList) {
        if (CollectionUtils.isEmpty(supplierMapList)) {
            return;
        }
        this.log.info("updateSupplier size()=" + supplierMapList.size());
        BulkRequest bulkRequest = new BulkRequest();
        for (Map supplierMap : supplierMapList) {
            String id = MapUtils.getString((Map)supplierMap, (Object)"skuCode");
            UpdateRequest updateRequest = this.getUpdateRequest(id, supplierMap);
            bulkRequest.add(updateRequest);
        }
        EsUtil.bulk(this.client, bulkRequest, "SkuEsDao.updateSupplier.List<Map>", null);
    }

    public void updateCategory(List<Map> categoryMapList) {
        if (CollectionUtils.isEmpty(categoryMapList)) {
            return;
        }
        this.log.info("categoryMapList size()=" + categoryMapList.size());
        BulkRequest bulkRequest = new BulkRequest();
        for (Map brandMap : categoryMapList) {
            String id = MapUtils.getString((Map)brandMap, (Object)"skuCode");
            UpdateRequest updateRequest = this.getUpdateRequest(id, brandMap);
            bulkRequest.add(updateRequest);
        }
        EsUtil.bulk(this.client, bulkRequest, "SkuEsDao.updateCategory.List<Map>", null);
    }

    public void updateBrand(List<Map> brandList) {
        if (CollectionUtils.isEmpty(brandList)) {
            return;
        }
        this.log.info("brandList size()=" + brandList.size());
        BulkRequest bulkRequest = new BulkRequest();
        for (Map brandMap : brandList) {
            String id = MapUtils.getString((Map)brandMap, (Object)"skuCode");
            UpdateRequest updateRequest = this.getUpdateRequest(id, brandMap);
            bulkRequest.add(updateRequest);
        }
        EsUtil.bulk(this.client, bulkRequest, "SkuEsDao.updateBrand.List<Map>", null);
    }

    @Override
    public PsSkuVO toBean(Map<String, Object> sourceMap) {
        if (MapUtils.isEmpty(sourceMap)) {
            return null;
        }
        PsSkuVO skuVO = new PsSkuVO();
        skuVO.setId(MapUtils.getString(sourceMap, (Object)"id"));
        skuVO.setSkuId(Long.valueOf(MapUtils.getLongValue(sourceMap, (Object)"skuId")));
        skuVO.setSkuCode(MapUtils.getString(sourceMap, (Object)"skuCode"));
        skuVO.setSkuNameCN(MapUtils.getString(sourceMap, (Object)"skuNameCN"));
        skuVO.setIsJit(MapUtils.getInteger(sourceMap, (Object)"isJit"));
        skuVO.setCostPrice(new BigDecimal(MapUtils.getDoubleValue(sourceMap, (Object)"costPrice")));
        skuVO.setSalesPrice(MapUtils.getDouble(sourceMap, (Object)"salesPrice"));
        skuVO.setCategoryId(Long.valueOf(MapUtils.getLongValue(sourceMap, (Object)"categoryId")));
        skuVO.setCategoryName(MapUtils.getString(sourceMap, (Object)"categoryName"));
        skuVO.setBrandId(Long.valueOf(MapUtils.getLongValue(sourceMap, (Object)"brandId")));
        skuVO.setBrandName(MapUtils.getString(sourceMap, (Object)"brandName"));
        skuVO.setBrandNameCN(MapUtils.getString(sourceMap, (Object)"brandNameCN"));
        skuVO.setCanRemark(MapUtils.getInteger(sourceMap, (Object)"canRemark"));
        skuVO.setCrossBorderFlag(MapUtils.getInteger(sourceMap, (Object)"crossBorderFlag"));
        skuVO.setWeight(MapUtils.getString(sourceMap, (Object)"weight"));
        skuVO.setTaxNo(MapUtils.getString(sourceMap, (Object)"taxNo"));
        skuVO.setClearanceWay(MapUtils.getInteger(sourceMap, (Object)"clearanceWay"));
        skuVO.setUpdateTime(MapUtils.getString(sourceMap, (Object)"updateTime"));
        skuVO.setUpdateLong(MapUtils.getString(sourceMap, (Object)"updateLong"));
        return skuVO;
    }

    @Override
    public Map<String, Object> toMap(PsSkuVO vo) {
        LinkedHashMap<String, Object> sourceMap = new LinkedHashMap<String, Object>();
        sourceMap.put("id", vo.getId());
        sourceMap.put("skuId", vo.getSkuId());
        sourceMap.put("skuCode", vo.getSkuCode());
        sourceMap.put("skuName", vo.getSkuName());
        sourceMap.put("skuNameCN", vo.getSkuNameCN());
        sourceMap.put("isJit", vo.getIsJit());
        sourceMap.put("canCustomize", vo.getCanCustomize());
        sourceMap.put("customizationPrice", vo.getCustomizationPrice());
        sourceMap.put("costPrice", vo.getCostPrice());
        sourceMap.put("salesPrice", vo.getSalesPrice());
        sourceMap.put("categoryId", vo.getCategoryId());
        sourceMap.put("categoryName", vo.getCategoryName());
        sourceMap.put("brandId", vo.getBrandId());
        sourceMap.put("brandName", vo.getBrandName());
        sourceMap.put("brandNameCN", vo.getBrandNameCN());
        sourceMap.put("canRemark", vo.getCanRemark());
        sourceMap.put("crossBorderFlag", vo.getCrossBorderFlag());
        sourceMap.put("weight", vo.getWeight());
        sourceMap.put("taxNo", vo.getTaxNo());
        sourceMap.put("clearanceWay", vo.getClearanceWay());
        sourceMap.put("deliveryPeriod", vo.getDeliveryPeriod());
        sourceMap.put("prodNameCn", vo.getProdNameCn());
        sourceMap.put("customizeType", vo.getCustomizeType());
        sourceMap.put("whetherLogistics", vo.getWhetherLogistics());
        sourceMap.put("whetherVirtual", vo.getWhetherVirtual());
        sourceMap.put("flower", vo.getFlower() == null ? 0 : vo.getFlower());
        sourceMap.put("skuImg", vo.getSkuImg());
        sourceMap.put("installService", vo.getInstallService());
        sourceMap.put("bu", vo.getBu());
        if (vo.getSellOnLine() != null && vo.getSellOnLine() > 0) {
            sourceMap.put("sellOnLine", 0);
        } else {
            sourceMap.put("sellOnLine", 1);
        }
        sourceMap.put("customPrintTemplate", vo.getCustomPrintTemplate() == null ? 0 : vo.getCustomPrintTemplate());
        return sourceMap;
    }
}

