/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.es.dao;

import com.thebeastshop.es.annotation.EsDaoConfig;
import com.thebeastshop.es.dao.core.AbstractEsDao;
import com.thebeastshop.es.spring.ElasticsearchClientFactory;
import com.thebeastshop.scm.es.PcsSkuCategoryVO;
import com.thebeastshop.scm.es.PsCustomizeVO;
import com.thebeastshop.scm.es.PsSkuVO;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.springframework.beans.factory.annotation.Autowired;

@EsDaoConfig(id="skuCode", type="pubsku")
public class SkuEsDao
extends AbstractEsDao<PsSkuVO> {
    @Autowired
    public SkuEsDao(ElasticsearchClientFactory elasticsearchClientFactory) {
        super(elasticsearchClientFactory);
    }

    public void updateSupplier(List<Map> supplierMapList) {
        if (CollectionUtils.isEmpty(supplierMapList)) {
            return;
        }
        this.log.info("updateSupplier size()=" + supplierMapList.size());
        BulkRequestBuilder bulkRequest = this.client.prepareBulk();
        for (Map supplierMap : supplierMapList) {
            String id = MapUtils.getString((Map)supplierMap, (Object)"skuCode");
            UpdateRequest updateRequest = this.getUpdateRequest(id, supplierMap);
            bulkRequest.add(updateRequest);
        }
        boolean isFailures = ((BulkResponse)bulkRequest.execute().actionGet()).hasFailures();
        if (isFailures) {
            System.out.println("updateSupplier error Failures");
        } else {
            System.out.println("updateSupplier sucess");
        }
    }

    public void updateCategory(List<Map> categoryMapList) {
        if (CollectionUtils.isEmpty(categoryMapList)) {
            return;
        }
        this.log.info("categoryMapList size()=" + categoryMapList.size());
        BulkRequestBuilder bulkRequest = this.client.prepareBulk();
        for (Map brandMap : categoryMapList) {
            String id = MapUtils.getString((Map)brandMap, (Object)"skuCode");
            UpdateRequest updateRequest = this.getUpdateRequest(id, brandMap);
            bulkRequest.add(updateRequest);
        }
        boolean isFailures = ((BulkResponse)bulkRequest.execute().actionGet()).hasFailures();
        if (isFailures) {
            System.out.println("updateCategory error isFailures");
        } else {
            System.out.println("updateCategory success");
        }
    }

    public void updateBrand(List<Map> brandList) {
        if (CollectionUtils.isEmpty(brandList)) {
            return;
        }
        this.log.info("brandList size()=" + brandList.size());
        BulkRequestBuilder bulkRequest = this.client.prepareBulk();
        for (Map brandMap : brandList) {
            String id = MapUtils.getString((Map)brandMap, (Object)"skuCode");
            UpdateRequest updateRequest = this.getUpdateRequest(id, brandMap);
            bulkRequest.add(updateRequest);
        }
        boolean isFailures = ((BulkResponse)bulkRequest.execute().actionGet()).hasFailures();
        if (isFailures) {
            System.out.println("updateBrand error isFailures");
        } else {
            System.out.println("updateBrand success");
        }
    }

    @Override
    public PsSkuVO toBean(Map<String, Object> sourceMap) {
        if (MapUtils.isEmpty(sourceMap)) {
            return null;
        }
        PsSkuVO skuVO = new PsSkuVO();
        skuVO.setId(MapUtils.getString(sourceMap, (Object)"id"));
        skuVO.setSkuId(Long.valueOf(MapUtils.getLongValue(sourceMap, (Object)"skuId")));
        skuVO.setSkuCode(MapUtils.getString(sourceMap, (Object)"skuCode"));
        skuVO.setSkuName(MapUtils.getString(sourceMap, (Object)"skuName"));
        skuVO.setSkuNameCN(MapUtils.getString(sourceMap, (Object)"skuNameCN"));
        skuVO.setSkuType(MapUtils.getInteger(sourceMap, (Object)"skuType"));
        skuVO.setIsMadeBySelf(MapUtils.getInteger(sourceMap, (Object)"isMadeBySelf"));
        skuVO.setIsImported(MapUtils.getInteger(sourceMap, (Object)"isImported"));
        skuVO.setSkuCustomMadeCode(MapUtils.getString(sourceMap, (Object)"skuCustomMadeCode"));
        skuVO.setIsSkuCustomMade(MapUtils.getInteger(sourceMap, (Object)"isSkuCustomMade"));
        skuVO.setCombinedSkuRecipeCode(MapUtils.getString(sourceMap, (Object)"combinedSkuRecipeCode"));
        skuVO.setIsCombinedSkuRecipeCode(MapUtils.getInteger(sourceMap, (Object)"isCombinedSkuRecipeCode"));
        skuVO.setIsJit(MapUtils.getInteger(sourceMap, (Object)"isJit"));
        skuVO.setEan13(MapUtils.getString(sourceMap, (Object)"ean13"));
        skuVO.setBarcode(MapUtils.getString(sourceMap, (Object)"barcode"));
        skuVO.setCanPurchase(MapUtils.getInteger(sourceMap, (Object)"canPurchase"));
        skuVO.setCostPrice(new BigDecimal(MapUtils.getDoubleValue(sourceMap, (Object)"costPrice")));
        skuVO.setSalesPrice(MapUtils.getDouble(sourceMap, (Object)"salesPrice"));
        skuVO.setCategoryId(Long.valueOf(MapUtils.getLongValue(sourceMap, (Object)"categoryId")));
        skuVO.setCategoryName(MapUtils.getString(sourceMap, (Object)"categoryName"));
        skuVO.setBrandId(Long.valueOf(MapUtils.getLongValue(sourceMap, (Object)"brandId")));
        skuVO.setBrandName(MapUtils.getString(sourceMap, (Object)"brandName"));
        skuVO.setBrandNameCN(MapUtils.getString(sourceMap, (Object)"brandNameCN"));
        skuVO.setBrandCountryId(MapUtils.getLong(sourceMap, (Object)"brandCountryId"));
        skuVO.setBrandCountryName(MapUtils.getString(sourceMap, (Object)"brandCountryName"));
        skuVO.setPlaceOfOrigin(MapUtils.getString(sourceMap, (Object)"placeOfOrigin"));
        skuVO.setSupplierId(Long.valueOf(MapUtils.getLongValue(sourceMap, (Object)"supplierId")));
        skuVO.setSupplierName(MapUtils.getString(sourceMap, (Object)"supplierName"));
        skuVO.setSupplierNameCN(MapUtils.getString(sourceMap, (Object)"supplierNameCN"));
        skuVO.setSkuCategoryName(MapUtils.getString(sourceMap, (Object)"skuCategoryName"));
        skuVO.setCanRemark(MapUtils.getInteger(sourceMap, (Object)"canRemark"));
        skuVO.setPointDeductRule(MapUtils.getInteger(sourceMap, (Object)"pointDeductRule"));
        skuVO.setPointDeductPoint(new BigDecimal(MapUtils.getDoubleValue(sourceMap, (Object)"pointDeductPoint")));
        skuVO.setPointDuductPrice(new BigDecimal(MapUtils.getDoubleValue(sourceMap, (Object)"pointDuductPrice")));
        skuVO.setCrossBorderFlag(MapUtils.getInteger(sourceMap, (Object)"crossBorderFlag"));
        skuVO.setWeight(MapUtils.getString(sourceMap, (Object)"weight"));
        skuVO.setTaxNo(MapUtils.getString(sourceMap, (Object)"taxNo"));
        skuVO.setWhetherConsignment(Integer.valueOf(MapUtils.getIntValue(sourceMap, (Object)"whetherConsignment")));
        skuVO.setClearanceWay(MapUtils.getInteger(sourceMap, (Object)"clearanceWay"));
        skuVO.setUpdateTime(MapUtils.getString(sourceMap, (Object)"updateTime"));
        skuVO.setUpdateLong(MapUtils.getString(sourceMap, (Object)"updateLong"));
        skuVO.setFrontCategoryList(this.toListBean(sourceMap, "frontCategoryList", PcsSkuCategoryVO.class));
        return skuVO;
    }

    @Override
    public Map<String, Object> toMap(PsSkuVO vo) {
        LinkedHashMap<String, Object> sourceMap = new LinkedHashMap<String, Object>();
        sourceMap.put("id", vo.getId());
        sourceMap.put("skuId", vo.getSkuId());
        sourceMap.put("skuCode", vo.getSkuCode());
        sourceMap.put("skuName", vo.getSkuName());
        sourceMap.put("skuNameCN", vo.getSkuNameCN());
        sourceMap.put("skuType", vo.getSkuType());
        sourceMap.put("isMadeBySelf", vo.getIsMadeBySelf());
        sourceMap.put("isImported", vo.getIsImported());
        sourceMap.put("skuCustomMadeCode", vo.getSkuCustomMadeCode());
        sourceMap.put("isSkuCustomMade", StringUtils.isBlank((CharSequence)vo.getSkuCustomMadeCode()) ? 0 : 1);
        sourceMap.put("combinedSkuRecipeCode", vo.getCombinedSkuRecipeCode());
        sourceMap.put("isCombinedSkuRecipeCode", StringUtils.isBlank((CharSequence)vo.getCombinedSkuRecipeCode()) ? 0 : 1);
        sourceMap.put("isJit", vo.getIsJit());
        sourceMap.put("ean13", vo.getEan13());
        sourceMap.put("barcode", vo.getBarcode());
        sourceMap.put("canPurchase", vo.getCanPurchase());
        sourceMap.put("canCustomize", vo.getCanCustomize());
        sourceMap.put("customizationPrice", vo.getCustomizationPrice());
        sourceMap.put("costPrice", vo.getCostPrice());
        sourceMap.put("salesPrice", vo.getSalesPrice());
        sourceMap.put("categoryId", vo.getCategoryId());
        sourceMap.put("categoryName", vo.getCategoryName());
        sourceMap.put("brandId", vo.getBrandId());
        sourceMap.put("brandName", vo.getBrandName());
        sourceMap.put("brandNameCN", vo.getBrandNameCN());
        sourceMap.put("brandCountryId", vo.getBrandCountryId());
        sourceMap.put("brandCountryName", vo.getBrandCountryName());
        sourceMap.put("placeOfOrigin", vo.getPlaceOfOrigin());
        sourceMap.put("supplierId", vo.getSupplierId());
        sourceMap.put("supplierName", vo.getSupplierName());
        sourceMap.put("supplierNameCN", vo.getSupplierNameCN());
        sourceMap.put("skuCategoryName", vo.getSkuCategoryName());
        sourceMap.put("canRemark", vo.getCanRemark());
        sourceMap.put("pointDeductRule", vo.getPointDeductRule());
        sourceMap.put("pointDeductPoint", vo.getPointDeductPoint());
        sourceMap.put("pointDuductPrice", vo.getPointDuductPrice());
        sourceMap.put("crossBorderFlag", vo.getCrossBorderFlag());
        sourceMap.put("weight", vo.getWeight());
        sourceMap.put("taxNo", vo.getTaxNo());
        sourceMap.put("discountPrice", vo.getDiscountPrice());
        sourceMap.put("whetherConsignment", vo.getWhetherConsignment());
        sourceMap.put("clearanceWay", vo.getClearanceWay());
        sourceMap.put("frontCategoryList", this.toListMap(vo.getFrontCategoryList()));
        sourceMap.put("isMonthSend", vo.getIsMonthSend());
        sourceMap.put("monthSendDeliveryRule", vo.getMonthSendDeliveryRule());
        sourceMap.put("deliveryTimes", vo.getDeliveryTimes());
        sourceMap.put("canCustomizeSalesPrice", vo.getCanCustomizeSalesPrice());
        sourceMap.put("saleEndDate", vo.getSaleEndDate());
        sourceMap.put("skuStatus", vo.getSkuStatus());
        sourceMap.put("deliveryPeriod", vo.getDeliveryPeriod());
        sourceMap.put("prodNameCn", vo.getProdNameCn());
        sourceMap.put("newCustomizeType", vo.getCustomizeType());
        sourceMap.put("whetherLogistics", vo.getWhetherLogistics());
        sourceMap.put("whetherVirtual", vo.getWhetherVirtual());
        sourceMap.put("skuImg", vo.getSkuImg());
        sourceMap.put("installService", vo.getInstallService());
        sourceMap.put("bu", vo.getBu());
        PsCustomizeVO customizeVO = vo.getCustomize();
        if (customizeVO != null) {
            List customizeImageList;
            List wordElementList;
            HashMap<String, List<Map>> customizeMap = new HashMap<String, List<Map>>();
            List colorElementList = customizeVO.getColorElementList();
            if (colorElementList != null) {
                customizeMap.put("colorElementList", this.toListMap(colorElementList));
            }
            if ((wordElementList = customizeVO.getWordElementList()) != null) {
                customizeMap.put("wordElementList", this.toListMap(wordElementList));
            }
            if ((customizeImageList = customizeVO.getCustomizeImageList()) != null) {
                customizeMap.put("customizeImageList", this.toListMap(customizeImageList));
            }
            sourceMap.put("customize", customizeMap);
        }
        return sourceMap;
    }
}

