/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.bi.dataSource;

import com.thebeastshop.bi.dataSource.DataSourceEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;

public class DynamicDataSource
extends AbstractRoutingDataSource {
    private static final Logger logger = LoggerFactory.getLogger(DynamicDataSource.class);
    private static final ThreadLocal<String> contextHolder = new ThreadLocal();

    protected Object determineCurrentLookupKey() {
        String dataSource = DynamicDataSource.getDataSource();
        logger.info("\u5f53\u524d\u64cd\u4f5c\u4f7f\u7528\u7684\u6570\u636e\u6e90\uff1a{}", (Object)dataSource);
        return dataSource;
    }

    public static void setDataSource(String dataSource) {
        contextHolder.set(dataSource);
    }

    public static String getDataSource() {
        String dataSource = contextHolder.get();
        if (null == dataSource) {
            DynamicDataSource.setDataSource(DataSourceEnum.PGSQL.getDefault());
        }
        return contextHolder.get();
    }

    public static void clearDataSource() {
        contextHolder.remove();
    }
}

