/*
 * Decompiled with CFR 0.152.
 */
package com.beast.clog.agent.works;

import com.beast.clog.agent.config.LogConfig;
import com.beast.clog.common.utils.HostUtil;
import com.beast.clog.models.thrift.Chunk;
import com.beast.clog.models.thrift.Event;
import com.beast.clog.models.thrift.LogEvent;
import com.beast.clog.models.thrift.MetricEvent;
import com.beast.clog.models.thrift.Span;
import java.util.LinkedList;
import java.util.logging.Logger;
import org.apache.thrift.TBase;

public class ChunkBuilder {
    private static Logger logger = Logger.getLogger(ChunkBuilder.class.getName());
    private Chunk chunk = new Chunk();
    private int chunkSize;

    public ChunkBuilder() {
        this.chunk.setEnvGroup(LogConfig.getInstance().getEnvironmentGroup());
        this.chunk.setEnv(LogConfig.getInstance().getEnvironment());
        this.chunk.setHostIp(HostUtil.getHostIp());
        this.chunk.setHostName(HostUtil.getHostName());
        this.chunk.setAppId(LogConfig.getInstance().getAppId());
        this.chunk.setProcessId(0L);
        LinkedList logEventList = new LinkedList();
        LinkedList spanList = new LinkedList();
        LinkedList metricList = new LinkedList();
        LinkedList eventList = new LinkedList();
        this.chunk.setLogEvents(logEventList);
        this.chunk.setSpans(spanList);
        this.chunk.setMetrics(metricList);
        this.chunk.setEvents(eventList);
    }

    public void clear() {
        this.chunk.getLogEvents().clear();
        this.chunk.getSpans().clear();
        this.chunk.getMetrics().clear();
        this.chunk.getEvents().clear();
        this.chunkSize = 0;
    }

    public void putMsg(TBase base) {
        if (base instanceof LogEvent) {
            this.chunk.getLogEvents().add((LogEvent)base);
            ++this.chunkSize;
            return;
        }
        if (base instanceof Span) {
            this.chunk.getSpans().add((Span)base);
            ++this.chunkSize;
            return;
        }
        if (base instanceof MetricEvent) {
            this.chunk.getMetrics().add((MetricEvent)base);
            ++this.chunkSize;
            return;
        }
        if (base instanceof Event) {
            this.chunk.getEvents().add((Event)base);
            ++this.chunkSize;
            return;
        }
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public Chunk getChunk() {
        return this.chunk;
    }
}

