/*
 * Decompiled with CFR 0.152.
 */
package com.beast.clog.agent.spring.configuration;

import com.beast.clog.agent.spring.SpringTraceAopInterceptor;
import com.beast.clog.agent.spring.annotations.EnableTrace;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.aopalliance.aop.Advice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.Advisor;
import org.springframework.aop.Pointcut;
import org.springframework.aop.aspectj.AspectJExpressionPointcut;
import org.springframework.aop.support.ComposablePointcut;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportAware;
import org.springframework.context.annotation.Role;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

@Configuration
public class SimpleTraceConfiguration
implements ImportAware,
EnvironmentAware {
    private static final Logger log = LoggerFactory.getLogger(SimpleTraceConfiguration.class);
    private static boolean pretty = false;
    private static final String CONTROLLER_ADVICE_CLASS_NAME = "org.springframework.web.bind.annotation.ControllerAdvice";
    private static final String CONFIG_ADVICE_CLASS_NAME = "org.springframework.context.annotation.Configuration";
    protected AnnotationAttributes annotationAttributes;
    protected String configClassName;
    private Environment environment;

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void setImportMetadata(AnnotationMetadata importMetadata) {
        this.configClassName = importMetadata.getClassName();
        this.annotationAttributes = AnnotationAttributes.fromMap((Map)importMetadata.getAnnotationAttributes(EnableTrace.class.getName(), false));
        Assert.notNull((Object)this.annotationAttributes, (String)("@EnableTrace is not present on importing class " + importMetadata.getClassName()));
    }

    @Bean
    @Role(value=2)
    public Advisor packageTraceAdvisor() {
        ComposablePointcut resultPointcut = new ComposablePointcut();
        pretty = this.annotationAttributes.getBoolean("pretty");
        List<String> basePackages = this.findBasePackages();
        String pointcutExpression = this.makeExpression(basePackages);
        AspectJExpressionPointcut packagePointcut = new AspectJExpressionPointcut();
        log.info("Include package Pointcut expression : {}", (Object)pointcutExpression);
        packagePointcut.setExpression(pointcutExpression);
        resultPointcut.intersection((Pointcut)packagePointcut);
        String excludeAnnotation = this.buildExcludeAnnotation();
        log.info("Exclude Annotation Pointcut expression : {}", (Object)excludeAnnotation);
        AspectJExpressionPointcut basePointcut = new AspectJExpressionPointcut();
        basePointcut.setExpression(excludeAnnotation);
        resultPointcut.intersection((Pointcut)basePointcut);
        DefaultPointcutAdvisor pointcutAdvisor = new DefaultPointcutAdvisor((Pointcut)resultPointcut, (Advice)new SpringTraceAopInterceptor());
        pointcutAdvisor.setOrder(Integer.MAX_VALUE);
        return pointcutAdvisor;
    }

    String buildExcludeAnnotation() {
        ArrayList<String> excludeList = new ArrayList<String>();
        if (this.hasAnnotation(CONFIG_ADVICE_CLASS_NAME)) {
            excludeList.add(CONFIG_ADVICE_CLASS_NAME);
        }
        if (this.hasAnnotation(CONTROLLER_ADVICE_CLASS_NAME)) {
            excludeList.add(CONTROLLER_ADVICE_CLASS_NAME);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < excludeList.size(); ++i) {
            String annotationName = (String)excludeList.get(i);
            if (i > 0) {
                sb.append(" and ");
            }
            sb.append("!@within(").append(annotationName).append(")");
        }
        return sb.toString();
    }

    private boolean hasAnnotation(String annotationName) {
        try {
            Class<?> aClass = Class.forName(annotationName);
            if (aClass.isAnnotation()) {
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return false;
    }

    private List<String> findBasePackages() {
        ArrayList<String> basePackages = new ArrayList<String>();
        for (String pkg : this.annotationAttributes.getStringArray("value")) {
            if (!StringUtils.hasText((String)pkg)) continue;
            basePackages.add(pkg);
        }
        for (String pkg : this.annotationAttributes.getStringArray("basePackages")) {
            if (!StringUtils.hasText((String)pkg)) continue;
            basePackages.add(pkg);
        }
        for (Class clazz : this.annotationAttributes.getClassArray("basePackageClasses")) {
            basePackages.add(ClassUtils.getPackageName((Class)clazz));
        }
        if (basePackages.isEmpty()) {
            String defaultPackageName = ClassUtils.getPackageName((String)this.configClassName);
            basePackages.add(defaultPackageName);
            log.debug("Default package name : {}", (Object)defaultPackageName);
        }
        return basePackages;
    }

    private String makeExpression(List<String> basePackages) {
        Assert.notNull(basePackages);
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        int cnt = 0;
        for (String basePackage : basePackages) {
            if (!StringUtils.hasText((String)basePackage)) continue;
            sb.append(String.format("execution(* %s..*.*(..))", basePackage));
            if (basePackages.size() != ++cnt) {
                sb.append(" or ");
                continue;
            }
            sb.append(") ");
        }
        return sb.toString();
    }

    public static boolean isPretty() {
        return pretty;
    }
}

