/*
 * Decompiled with CFR 0.152.
 */
package com.beast.clog.agent.spring;

import com.beast.clog.agent.TagBuilder;
import com.beast.clog.agent.spring.TraceContext;
import com.beast.clog.agent.spring.Tracer;
import com.beast.clog.agent.spring.annotations.Trace;
import com.beast.clog.agent.spring.utils.PrettyFormat;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.springframework.aop.interceptor.CustomizableTraceInterceptor;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Controller;
import org.springframework.stereotype.Repository;
import org.springframework.stereotype.Service;
import org.springframework.util.ClassUtils;
import org.springframework.util.StopWatch;
import org.springframework.util.StringUtils;

public class SpringTraceAopInterceptor
extends CustomizableTraceInterceptor {
    private static final long serialVersionUID = 1L;
    public static final String ENTER_MESSAGE = "[$[targetType]] $[targetClassShortName].$[methodName]($[arguments])";
    public static final String EXIT_MESSAGE = "[$[targetType]] $[targetClassShortName].$[methodName]($[arguments]) [$[returnValueCustom]] $[invocationTime]ms.";
    public static final String EXCEPTION_MESSAGE = "[$[targetType]] $[targetClassShortName].$[methodName]($[arguments]) Exception! $[exception] $[invocationTime]ms.";
    private String exitMessage = "[$[targetType]] $[targetClassShortName].$[methodName]($[arguments]) [$[returnValueCustom]] $[invocationTime]ms.";
    private String exceptionMessage = "[$[targetType]] $[targetClassShortName].$[methodName]($[arguments]) Exception! $[exception] $[invocationTime]ms.";
    private static final Pattern PATTERN = Pattern.compile("\\$\\[\\p{Alpha}+\\]");
    public static final String PLACEHOLDER_RETURN_VALUE_CUSTOM = "$[returnValueCustom]";
    public static final String PLACEHOLDER_TARGET_TYPE = "$[targetType]";

    public void setExceptionMessage(String exceptionMessage) {
        this.exceptionMessage = exceptionMessage;
    }

    public void setExitMessage(String exitMessage) {
        this.exitMessage = exitMessage;
    }

    protected String replacePlaceholders(String message, MethodInvocation methodInvocation, Object returnValue, Throwable throwable, long invocationTime) {
        Matcher matcher = PATTERN.matcher(message);
        StringBuffer output = new StringBuffer();
        while (matcher.find()) {
            String match = matcher.group();
            if ("$[methodName]".equals(match)) {
                matcher.appendReplacement(output, Matcher.quoteReplacement(methodInvocation.getMethod().getName()));
                continue;
            }
            if (PLACEHOLDER_TARGET_TYPE.equals(match)) {
                String targetType = this.getTargetType(methodInvocation);
                matcher.appendReplacement(output, Matcher.quoteReplacement(targetType));
                continue;
            }
            if ("$[targetClassName]".equals(match)) {
                String className = this.getClassForLogging(methodInvocation.getThis()).getName();
                matcher.appendReplacement(output, Matcher.quoteReplacement(className));
                continue;
            }
            if ("$[targetClassShortName]".equals(match)) {
                String shortName = ClassUtils.getShortName((Class)this.getClassForLogging(methodInvocation.getThis()));
                matcher.appendReplacement(output, Matcher.quoteReplacement(shortName));
                continue;
            }
            if ("$[arguments]".equals(match)) {
                matcher.appendReplacement(output, Matcher.quoteReplacement(StringUtils.arrayToCommaDelimitedString((Object[])methodInvocation.getArguments())));
                continue;
            }
            if ("$[argumentTypes]".equals(match)) {
                this.appendArgumentTypes(methodInvocation, matcher, output);
                continue;
            }
            if (PLACEHOLDER_RETURN_VALUE_CUSTOM.equals(match)) {
                this.appendReturnValueCustom(methodInvocation, matcher, output, returnValue);
                continue;
            }
            if ("$[returnValue]".equals(match)) {
                this.appendReturnValue(methodInvocation, matcher, output, returnValue);
                continue;
            }
            if (throwable != null && "$[exception]".equals(match)) {
                matcher.appendReplacement(output, Matcher.quoteReplacement(throwable.toString()));
                continue;
            }
            if ("$[invocationTime]".equals(match)) {
                matcher.appendReplacement(output, Long.toString(invocationTime));
                continue;
            }
            throw new IllegalArgumentException("Unknown placeholder [" + match + "]");
        }
        matcher.appendTail(output);
        return output.toString();
    }

    private String getTargetType(MethodInvocation methodInvocation) {
        Class<?> targetType = methodInvocation.getThis().getClass();
        if (this.hasAnnotation(targetType, Controller.class)) {
            return "Controller";
        }
        if (this.hasAnnotation(targetType, Service.class)) {
            return "Service";
        }
        if (this.hasAnnotation(targetType, Repository.class)) {
            return "Repository";
        }
        if (this.hasAnnotation(targetType, Component.class)) {
            return "Component";
        }
        return "Trace";
    }

    private boolean hasAnnotation(Class<?> targetType, Class<? extends Annotation> annotationType) {
        return AnnotationUtils.findAnnotation(targetType, annotationType) != null;
    }

    private void appendArgumentTypes(MethodInvocation methodInvocation, Matcher matcher, StringBuffer output) {
        Class<?>[] argumentTypes = methodInvocation.getMethod().getParameterTypes();
        Object[] argumentTypeShortNames = new String[argumentTypes.length];
        for (int i = 0; i < argumentTypeShortNames.length; ++i) {
            argumentTypeShortNames[i] = ClassUtils.getShortName(argumentTypes[i]);
        }
        matcher.appendReplacement(output, Matcher.quoteReplacement(StringUtils.arrayToCommaDelimitedString((Object[])argumentTypeShortNames)));
    }

    private Map<String, String> getArguments(Object[] parameters) {
        try {
            if (parameters != null && parameters.length > 0) {
                TagBuilder builder = TagBuilder.create();
                for (int i = 0; i < parameters.length; ++i) {
                    builder.append("arg" + i, parameters[i].toString());
                }
                return builder.build();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private void appendReturnValue(MethodInvocation methodInvocation, Matcher matcher, StringBuffer output, Object returnValue) {
        if (methodInvocation.getMethod().getReturnType() == Void.TYPE) {
            matcher.appendReplacement(output, "void");
        } else if (returnValue == null) {
            matcher.appendReplacement(output, "null");
        } else {
            matcher.appendReplacement(output, Matcher.quoteReplacement(returnValue.toString()));
        }
    }

    private void appendReturnValueCustom(MethodInvocation methodInvocation, Matcher matcher, StringBuffer output, Object returnValue) {
        if (methodInvocation.getMethod().getReturnType() == Void.TYPE) {
            matcher.appendReplacement(output, "void");
        } else {
            matcher.appendReplacement(output, Matcher.quoteReplacement(PrettyFormat.toString(returnValue)));
        }
    }

    private boolean isTrace(MethodInvocation invocation) {
        if (invocation.getMethod().getAnnotation(Trace.class) != null) {
            return true;
        }
        return invocation.getThis().getClass().getAnnotation(Trace.class) != null;
    }

    protected Object invokeUnderTrace(MethodInvocation invocation, Log logger) throws Throwable {
        if (!this.isTrace(invocation)) {
            return invocation.proceed();
        }
        TraceContext context = TraceContext.create(invocation);
        Tracer tracer = new Tracer(context);
        String name = invocation.getMethod().getDeclaringClass().getName() + "." + invocation.getMethod().getName();
        StopWatch stopWatch = new StopWatch(name);
        Object returnValue = null;
        Map<String, String> tags = this.getArguments(invocation.getArguments());
        boolean exitThroughException = false;
        try {
            stopWatch.start(name);
            Object object = returnValue = invocation.proceed();
            return object;
        }
        catch (Throwable ex) {
            if (stopWatch.isRunning()) {
                stopWatch.stop();
            }
            exitThroughException = true;
            tracer.error(this.replacePlaceholders(this.exceptionMessage, invocation, null, ex, stopWatch.getTotalTimeMillis()), tags, ex);
            throw ex;
        }
        finally {
            if (!exitThroughException) {
                if (stopWatch.isRunning()) {
                    stopWatch.stop();
                }
                tracer.log(this.replacePlaceholders(this.exitMessage, invocation, returnValue, null, stopWatch.getTotalTimeMillis()), tags);
            }
            tracer.stop();
        }
    }

    protected boolean isLogEnabled(Log logger) {
        return logger.isInfoEnabled();
    }
}

