/*
 * Decompiled with CFR 0.152.
 */
package com.beast.clog.agent;

import com.beast.clog.agent.config.LogConfig;
import com.beast.clog.agent.works.ClogThreadFactory;
import com.beast.clog.agent.works.events.KafkaEvent;
import com.beast.clog.agent.works.events.MetricsEvent;
import com.beast.clog.agent.works.events.TBaseEvent;
import com.beast.clog.agent.works.handler.KafkaEventHandler;
import com.beast.clog.agent.works.handler.MetricsEventHandler;
import com.beast.clog.agent.works.handler.TBaseEventHandler;
import com.beast.clog.agent.works.producers.KafkaMessageProducer;
import com.beast.clog.agent.works.producers.MetricsEventProducer;
import com.beast.clog.agent.works.producers.TBaseEventProducer;
import com.beast.clog.common.utils.HostUtil;
import com.beast.clog.models.thrift.Chunk;
import com.lmax.disruptor.BatchEventProcessor;
import com.lmax.disruptor.BlockingWaitStrategy;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.Sequence;
import com.lmax.disruptor.SequenceBarrier;
import com.lmax.disruptor.WaitStrategy;
import java.util.LinkedList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AgentManager {
    private static AgentManager instance = new AgentManager();
    private static Logger logger = Logger.getLogger(AgentManager.class.getName());
    private static final int BASE_BUFFER_SIZE = 512;
    private static final int METRIC_BUFFER_SIZE = 512;
    private static final int KAFKA_BUFFER_SIZE = 256;
    private static final int NUM_EVENT_PROCESSORS = 3;
    private final ExecutorService executor = Executors.newFixedThreadPool(3, ClogThreadFactory.getInstance());
    private final RingBuffer<TBaseEvent> tbaseRingBuffer = RingBuffer.createMultiProducer(TBaseEvent.FACTORY, (int)512, (WaitStrategy)new BlockingWaitStrategy());
    private final RingBuffer<MetricsEvent> metricRingBuffer = RingBuffer.createMultiProducer(MetricsEvent.FACTORY, (int)512, (WaitStrategy)new BlockingWaitStrategy());
    private final RingBuffer<KafkaEvent> kafkaRingBuffer = RingBuffer.createMultiProducer(KafkaEvent.FACTORY, (int)256, (WaitStrategy)new BlockingWaitStrategy());
    private final SequenceBarrier tbaseSequenceBarrier = this.tbaseRingBuffer.newBarrier(new Sequence[0]);
    private final SequenceBarrier metricsSequenceBarrier = this.metricRingBuffer.newBarrier(new Sequence[0]);
    private final SequenceBarrier kafkaSequenceBarrier = this.kafkaRingBuffer.newBarrier(new Sequence[0]);
    private final TBaseEventProducer tbaseEventProducer = new TBaseEventProducer(this.tbaseRingBuffer);
    private final MetricsEventProducer metricsEventProducer = new MetricsEventProducer(this.metricRingBuffer);
    private final KafkaMessageProducer kafkaMessageProducer = new KafkaMessageProducer(this.kafkaRingBuffer);
    private final TBaseEventHandler tbaseEventHandler = new TBaseEventHandler(this.kafkaMessageProducer);
    private final MetricsEventHandler metricsEventHandler = new MetricsEventHandler(this.kafkaMessageProducer);
    private final KafkaEventHandler kafkaEventHandler = new KafkaEventHandler();
    private final BatchEventProcessor<TBaseEvent> tbaseBatchProcessor = new BatchEventProcessor(this.tbaseRingBuffer, this.tbaseSequenceBarrier, (EventHandler)this.tbaseEventHandler);
    private final BatchEventProcessor<MetricsEvent> metricsBatchProcessor = new BatchEventProcessor(this.metricRingBuffer, this.metricsSequenceBarrier, (EventHandler)this.metricsEventHandler);
    private final BatchEventProcessor<KafkaEvent> kafkaBatchProcessor = new BatchEventProcessor(this.kafkaRingBuffer, this.kafkaSequenceBarrier, (EventHandler)this.kafkaEventHandler);

    private AgentManager() {
        this.tbaseRingBuffer.addGatingSequences(new Sequence[]{this.tbaseBatchProcessor.getSequence()});
        this.metricRingBuffer.addGatingSequences(new Sequence[]{this.metricsBatchProcessor.getSequence()});
        this.kafkaRingBuffer.addGatingSequences(new Sequence[]{this.kafkaBatchProcessor.getSequence()});
        this.executor.submit((Runnable)this.tbaseBatchProcessor);
        this.executor.submit((Runnable)this.metricsBatchProcessor);
        this.executor.submit((Runnable)this.kafkaBatchProcessor);
        this.sendEnvironment();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                AgentManager.this.shutdown();
            }
        });
    }

    public static AgentManager getInstance() {
        return instance;
    }

    private void sendEnvironment() {
        if (LogConfig.getInstance().getEnvironmentGroup() == "local") {
            if (LogConfig.getInstance().isAppLocalLogEnabled()) {
                this.kafkaMessageProducer.setData("beast.clog.env", this.tbaseEventHandler.serializer(this.getEnvironmentChunk()));
            }
        } else {
            this.kafkaMessageProducer.setData("beast.clog.env", this.tbaseEventHandler.serializer(this.getEnvironmentChunk()));
        }
    }

    private Chunk getEnvironmentChunk() {
        Chunk chunk = new Chunk();
        chunk.setEnvGroup(LogConfig.getInstance().getEnvironmentGroup());
        chunk.setEnv(LogConfig.getInstance().getEnvironment());
        chunk.setHostIp(HostUtil.getHostIp());
        chunk.setHostName(HostUtil.getHostName());
        chunk.setAppId(LogConfig.getInstance().getAppId());
        chunk.setLogEvents(new LinkedList());
        chunk.setMetrics(new LinkedList());
        chunk.setSpans(new LinkedList());
        chunk.setEvents(new LinkedList());
        return chunk;
    }

    public TBaseEventProducer getMessageProducer() {
        return this.tbaseEventProducer;
    }

    public MetricsEventProducer getMetricsProducer() {
        return this.metricsEventProducer;
    }

    public void shutdown() {
        this.tbaseBatchProcessor.halt();
        this.metricsBatchProcessor.halt();
        this.kafkaBatchProcessor.halt();
        this.executor.shutdown();
        while (true) {
            if (this.executor.isTerminated()) break;
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {}
        }
        this.tbaseEventHandler.shutdown();
        this.metricsEventHandler.shutdown();
        this.kafkaEventHandler.shutdown();
        logger.log(Level.INFO, "clog agent has been shutdown");
    }

    public void shutdownNow() {
        this.tbaseBatchProcessor.halt();
        this.metricsBatchProcessor.halt();
        this.kafkaBatchProcessor.halt();
        this.executor.shutdown();
        this.tbaseEventHandler.shutdown();
        this.metricsEventHandler.shutdown();
        this.kafkaEventHandler.shutdown();
        logger.log(Level.INFO, "clog agent has been shutdown");
    }
}

