/*
 * Decompiled with CFR 0.152.
 */
package com.beast.clog.agent.works.producers;

import com.beast.clog.agent.Metrics;
import com.beast.clog.agent.works.events.TBaseEvent;
import com.lmax.disruptor.InsufficientCapacityException;
import com.lmax.disruptor.RingBuffer;
import org.apache.thrift.TBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TBaseEventProducer {
    private Logger logger = LoggerFactory.getLogger(TBaseEventProducer.class);
    private final RingBuffer<TBaseEvent> ringBuffer;

    public TBaseEventProducer(RingBuffer<TBaseEvent> ringBuffer) {
        this.ringBuffer = ringBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(TBase base) {
        int count = 0;
        try {
            long sequence;
            while (true) {
                try {
                    sequence = this.ringBuffer.tryNext();
                }
                catch (InsufficientCapacityException e) {
                    if (count > 200) {
                        throw new RuntimeException("CLog RingBuffer is Exhausted! RingBuffer\u5269\u4f59\u7a7a\u95f4\uff1a" + this.ringBuffer.remainingCapacity());
                    }
                    if (count > 50) {
                        this.logger.warn("RingBuffer\u5269\u4f59\u7a7a\u95f4: " + this.ringBuffer.remainingCapacity());
                        Thread.sleep(1L);
                    }
                    ++count;
                    continue;
                }
                break;
            }
            try {
                TBaseEvent event = (TBaseEvent)this.ringBuffer.get(sequence);
                event.setBase(base);
            }
            finally {
                this.ringBuffer.publish(sequence);
                Metrics.instance().getPutQueueCounter().incrementAndGet();
            }
            return;
        }
        catch (InterruptedException e) {
            this.logger.error("CLog Thread Error[" + Thread.currentThread().getName() + "]: " + e.getMessage());
            return;
        }
    }
}

