/*
 * Decompiled with CFR 0.152.
 */
package com.beast.clog.agent.trace;

import com.beast.clog.agent.trace.ITrace;
import com.beast.clog.agent.trace.impl.CLoggingTracer;
import com.beast.clog.common.utils.Strings;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class TraceManager {
    private static Map<String, ITrace> _tracers = new ConcurrentHashMap<String, ITrace>();

    private TraceManager() {
    }

    public static ITrace getTracer(Class<?> type) {
        if (type == null) {
            return TraceManager.getTracer("NoName");
        }
        return TraceManager.getTracer(type.getName());
    }

    public static ITrace getTracer(String name) {
        ITrace trace;
        String defaultName = name;
        if (Strings.isNullOrEmpty((String)name)) {
            defaultName = "defaultName";
        }
        if ((trace = _tracers.get(defaultName)) == null) {
            trace = new CLoggingTracer(defaultName);
            _tracers.put(defaultName, trace);
        }
        return trace;
    }
}

