/*
 * Decompiled with CFR 0.152.
 */
package com.beast.clog.agent.spring;

import com.beast.clog.agent.spring.ErrorLogType;
import com.beast.clog.agent.spring.TraceLogInfo;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.NamedThreadLocal;

public class TraceLogInfoThreadLocalManager {
    private static Logger log = LoggerFactory.getLogger(TraceLogInfoThreadLocalManager.class);
    private static ThreadLocal<TraceLogInfo> traceLogInfoThreadLocal = new NamedThreadLocal("Trace Log Info ThreadLocal");
    private static ErrorLogType errorLogType;

    public static void addLog(String message) {
        TraceLogInfoThreadLocalManager.getTraceLogInfo().getLogs().add(message);
    }

    public static List<String> getLogs() {
        return TraceLogInfoThreadLocalManager.getTraceLogInfo().getLogs();
    }

    public static TraceLogInfo getTraceLogInfo() {
        TraceLogInfoThreadLocalManager.initIfNull();
        return traceLogInfoThreadLocal.get();
    }

    public static void bindTraceLogInfo(TraceLogInfo traceLogInfo) {
        traceLogInfoThreadLocal.set(traceLogInfo);
    }

    private static void initIfNull() {
        if (traceLogInfoThreadLocal.get() == null) {
            traceLogInfoThreadLocal.set(new TraceLogInfo());
        }
    }

    public static void clear() {
        log.trace("clear");
        traceLogInfoThreadLocal.remove();
    }

    public static Throwable getException() {
        return TraceLogInfoThreadLocalManager.getTraceLogInfo().getException();
    }

    public static void setException(Throwable exception) {
        TraceLogInfoThreadLocalManager.getTraceLogInfo().setException(exception);
    }

    public static void startTime() {
        TraceLogInfoThreadLocalManager.getTraceLogInfo().setTime(System.currentTimeMillis());
    }

    public static long getTime() {
        return TraceLogInfoThreadLocalManager.getTraceLogInfo().getTime();
    }

    public static void addDepth() {
        TraceLogInfoThreadLocalManager.getTraceLogInfo().addDepth();
    }

    public static boolean isFirstDepth() {
        return TraceLogInfoThreadLocalManager.getDepth() == 1;
    }

    public static int getDepth() {
        return TraceLogInfoThreadLocalManager.getTraceLogInfo().getDepth();
    }

    public static void removeDepth() {
        TraceLogInfoThreadLocalManager.getTraceLogInfo().removeDepth();
    }

    public static void setErrorLogType(ErrorLogType errorLogType) {
        TraceLogInfoThreadLocalManager.getTraceLogInfo().setErrorLogType(errorLogType);
    }

    public static ErrorLogType getErrorLogType() {
        return TraceLogInfoThreadLocalManager.getTraceLogInfo().getErrorLogType();
    }
}

