/*
 * Decompiled with CFR 0.152.
 */
package com.beast.clog.agent.spring;

import com.beast.clog.agent.spring.TraceContext;
import com.beast.clog.agent.trace.ISpan;
import com.beast.clog.agent.trace.ITrace;
import com.beast.clog.agent.trace.TraceManager;
import com.beast.clog.models.thrift.LogLevel;
import java.util.Map;

public class Tracer {
    private TraceContext context;
    private ITrace trace;
    private ISpan span;
    private boolean isTrace;

    public Tracer(TraceContext context) {
        this.context = context;
        this.trace = TraceManager.getTracer(context.getTraceName());
        if (!this.trace.isTracing()) {
            this.isTrace = true;
        }
        this.span = this.trace.startSpan(context.getSpanName(), context.getServiceName(), context.getSpanType());
    }

    public void log(String message, Map<String, String> tags) {
        try {
            if (message == null) {
                return;
            }
            if (this.trace == null) {
                return;
            }
            if (tags == null || tags.isEmpty()) {
                this.trace.log(this.context.getLogType(), this.context.getLevel(), this.context.getTraceName(), message);
            } else {
                this.trace.log(this.context.getLogType(), this.context.getLevel(), this.context.getTraceName(), message, tags);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void error(String message, Map<String, String> tags, Throwable e) {
        try {
            if (this.trace == null) {
                return;
            }
            if (tags == null || tags.isEmpty()) {
                if (message == null) {
                    this.trace.log(this.context.getLogType(), LogLevel.ERROR, e);
                } else {
                    this.trace.log(this.context.getLogType(), LogLevel.ERROR, message, e);
                }
            } else if (message == null) {
                this.trace.log(this.context.getLogType(), LogLevel.ERROR, e, tags);
            } else {
                this.trace.log(this.context.getLogType(), LogLevel.ERROR, message, e, tags);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void stop() {
        if (this.span != null) {
            this.span.stop();
            this.span = null;
        }
        if (this.isTrace) {
            this.trace.clear();
        }
    }
}

