/*
 * Decompiled with CFR 0.152.
 */
package com.beast.clog.agent.trace.impl;

import com.beast.clog.agent.trace.ISampler;
import com.beast.clog.agent.trace.ISpan;
import com.beast.clog.agent.trace.ITrace;
import com.beast.clog.agent.trace.ITraceSender;
import com.beast.clog.agent.trace.impl.AlwaysSampler;
import com.beast.clog.agent.trace.impl.MilliSpan;
import com.beast.clog.agent.trace.impl.NullSpan;
import com.beast.clog.agent.trace.impl.RootMilliSpan;
import com.beast.clog.agent.utils.RandomUtil;
import com.beast.clog.common.utils.IdentityUtil;
import com.beast.clog.common.utils.Strings;
import com.beast.clog.models.thrift.LogEvent;
import com.beast.clog.models.thrift.LogLevel;
import com.beast.clog.models.thrift.LogType;
import com.beast.clog.models.thrift.Span;
import com.beast.clog.models.thrift.SpanType;
import java.util.Map;

public class CommonTracer
implements ITrace {
    private ITraceSender sender;
    private static final ThreadLocal<ISpan> currentSpan = new ThreadLocal();
    private static final long ROOT_SPAN_ID = 0L;
    private String name;

    public CommonTracer(String name) {
        this.name = Strings.isNullOrEmpty((String)name) ? "defaultTraceName" : name;
    }

    @Override
    public ISpan startSpan(String spanName, String serviceName, SpanType spanType, ISampler sampler) {
        if (!sampler.next()) {
            currentSpan.set(NullSpan.getInstance());
            return currentSpan.get();
        }
        ISpan parent = currentSpan.get();
        ISpan root = parent == null || parent instanceof NullSpan ? new RootMilliSpan(spanName, serviceName, RandomUtil.nextLong(), RandomUtil.nextLong(), 0L, spanType, this) : parent.createChild(spanName, serviceName, spanType, this);
        this.push(root);
        return root;
    }

    @Override
    public ISpan startSpan(String spanName, String serviceName, SpanType spanType) {
        return this.startSpan(spanName, serviceName, spanType, AlwaysSampler.getInstance());
    }

    @Override
    public boolean isTracing() {
        return currentSpan.get() != null && !(currentSpan.get() instanceof NullSpan);
    }

    private void push(ISpan span) {
        if (span != null) {
            currentSpan.set(span);
            LogEvent logEvent = new LogEvent();
            logEvent.setId(IdentityUtil.getUniqueID());
            logEvent.setLogType(this.spanToLogType(span.getSpanType()));
            logEvent.setTitle(span.getSpanType() + " Trace Span Start");
            logEvent.setMessage(span.getDescription());
            logEvent.setLogLevel(LogLevel.DEBUG);
            logEvent.setSource(this.name);
            logEvent.setThreadId(Thread.currentThread().getId());
            logEvent.setCreatedTime(System.currentTimeMillis());
            ((MilliSpan)span).addLogEvent(logEvent);
        }
    }

    private LogType spanToLogType(SpanType spanType) {
        if (spanType == SpanType.URL) {
            return LogType.URL;
        }
        if (spanType == SpanType.SQL) {
            return LogType.SQL;
        }
        if (spanType == SpanType.WEB_SERVICE) {
            return LogType.WEB_SERVICE;
        }
        if (spanType == SpanType.MEMCACHED) {
            return LogType.MEMCACHED;
        }
        return LogType.OTHER;
    }

    private boolean isOnParentPath(ISpan currSpan, ISpan span) {
        if (span == null) {
            return false;
        }
        int i = 0;
        while (currSpan != span && currSpan != null) {
            if (++i > 50) {
                this.log(LogType.OTHER, LogLevel.WARN, "possible unlimited loop in unfinished span handling.");
                break;
            }
            currSpan = currSpan.getParent();
        }
        return currSpan == span;
    }

    protected void pop(ISpan span) {
        if (span != null) {
            if (span != currentSpan.get()) {
                this.log(LogType.OTHER, LogLevel.WARN, "Stopped span: " + span + " was not the current span. current span is: " + currentSpan.get());
                if (this.isOnParentPath(currentSpan.get(), span)) {
                    while (currentSpan.get() != span) {
                        ISpan currSpan = currentSpan.get();
                        currSpan.getInnerSpan().setStopTime(System.currentTimeMillis());
                        currSpan.getInnerSpan().setUnfinished(true);
                        this.deliver(currSpan);
                        currentSpan.set(currSpan.getParent());
                    }
                }
            }
            LogEvent logEvent = new LogEvent();
            logEvent.setId(IdentityUtil.getUniqueID());
            logEvent.setLogType(this.spanToLogType(span.getSpanType()));
            logEvent.setTitle(span.getSpanType() + " Trace Span Stop");
            logEvent.setMessage(span.getDescription());
            logEvent.setLogLevel(LogLevel.DEBUG);
            logEvent.setSource(this.name);
            logEvent.setThreadId(Thread.currentThread().getId());
            logEvent.setCreatedTime(System.currentTimeMillis());
            ((MilliSpan)span).addLogEvent(logEvent);
            currentSpan.set(span.getParent());
            this.deliver(span);
        } else {
            currentSpan.set(null);
        }
    }

    @Override
    public void clear() {
        int i = 0;
        while (currentSpan.get() != null && !(currentSpan.get() instanceof NullSpan)) {
            if (++i > 50) {
                this.log(LogType.OTHER, LogLevel.WARN, "possible unlimited loop in unfinished span handling");
                break;
            }
            ISpan currSpan = currentSpan.get();
            currSpan.getInnerSpan().setStopTime(System.currentTimeMillis());
            currSpan.getInnerSpan().setUnfinished(true);
            this.deliver(currSpan);
            currentSpan.set(currSpan.getParent());
        }
        currentSpan.set(null);
    }

    @Override
    public ISpan continueSpan(String spanName, String serviceName, long traceId, long parentId, SpanType spanType) {
        RootMilliSpan rootSpan = new RootMilliSpan(spanName, serviceName, traceId, RandomUtil.nextLong(), parentId, spanType, this);
        this.push(rootSpan);
        return rootSpan;
    }

    @Override
    public ISpan getCurrentSpan() {
        return currentSpan.get();
    }

    @Override
    public void log(LogEvent logEvent) {
        if (logEvent.getId() <= 0L) {
            logEvent.setId(IdentityUtil.getUniqueID());
        }
        if (logEvent.getLogType() == null) {
            logEvent.setLogType(LogType.APP);
        }
        if (logEvent.getCreatedTime() <= 0L) {
            logEvent.setCreatedTime(System.currentTimeMillis());
        }
        if (logEvent.getThreadId() <= 0L) {
            logEvent.setThreadId(Thread.currentThread().getId());
        }
        if (Strings.isNullOrEmpty((String)logEvent.getTitle())) {
            logEvent.setTitle("NA");
        }
        if (Strings.isNullOrEmpty((String)logEvent.getMessage())) {
            logEvent.setMessage("NA");
        }
        if (Strings.isNullOrEmpty((String)logEvent.getSource())) {
            logEvent.setSource(this.name);
        }
        if (this.isTracing()) {
            Span innerSpan = currentSpan.get().getInnerSpan();
            logEvent.setTraceId(innerSpan.getTraceId());
            logEvent.setSpanId(innerSpan.getSpanId());
            ((MilliSpan)currentSpan.get()).addLogEvent(logEvent);
        } else {
            this.deliver(logEvent);
        }
    }

    private void deliver(ISpan span) {
        if (this.sender != null) {
            this.sender.send(span.getInnerSpan());
        }
    }

    private void deliver(LogEvent logEvent) {
        if (this.sender != null) {
            this.sender.send(logEvent);
        }
    }

    private void log(LogType type, String title, String message, LogLevel logLevel, Map<String, String> attrs) {
        LogEvent logEvent = new LogEvent();
        logEvent.setId(IdentityUtil.getUniqueID());
        logEvent.setLogType(type);
        logEvent.setTitle(title);
        logEvent.setMessage(message);
        logEvent.setSource(this.name);
        logEvent.setAttributes(attrs);
        logEvent.setLogLevel(logLevel);
        this.log(logEvent);
    }

    @Override
    public void log(LogType type, LogLevel level, String title, String message) {
        this.log(type, title, message, level, null);
    }

    @Override
    public void log(LogType type, LogLevel level, String title, Throwable t) {
        String msg = "NullThrowable";
        if (t != null) {
            msg = Strings.toString((Throwable)t);
        }
        this.log(type, title, msg, level, null);
    }

    @Override
    public void log(LogType type, LogLevel level, String title, String message, Map<String, String> attrs) {
        this.log(type, title, message, level, attrs);
    }

    @Override
    public void log(LogType type, LogLevel level, String message) {
        this.log(type, null, message, level, null);
    }

    @Override
    public void log(LogType type, LogLevel level, Throwable t) {
        String msg = "NullThrowable";
        if (t != null) {
            msg = Strings.toString((Throwable)t);
        }
        this.log(type, null, msg, level, null);
    }

    @Override
    public void log(LogType type, LogLevel level, String message, Map<String, String> attrs) {
        this.log(type, null, message, level, attrs);
    }

    public ITraceSender getSender() {
        return this.sender;
    }

    public void setSender(ITraceSender sender) {
        this.sender = sender;
    }

    @Override
    public void log(LogType type, LogLevel level, String title, Throwable throwable, Map<String, String> attrs) {
        String msg = "NullThrowable";
        if (throwable != null) {
            msg = Strings.toString((Throwable)throwable);
        }
        this.log(type, title, msg, level, attrs);
    }

    @Override
    public void log(LogType type, LogLevel level, Throwable throwable, Map<String, String> attrs) {
        String msg = "NullThrowable";
        if (throwable != null) {
            msg = Strings.toString((Throwable)throwable);
        }
        this.log(type, null, msg, level, attrs);
    }
}

