/*
 * Decompiled with CFR 0.152.
 */
package com.beast.clog.agent.spring.mybatis;

import com.beast.clog.agent.spring.TraceContext;
import com.beast.clog.agent.spring.Tracer;
import com.beast.clog.agent.spring.mybatis.SQLStatement;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.TypeHandlerRegistry;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class})})
public class MybatisInterceptor
implements Interceptor {
    public Object intercept(Invocation invocation) throws Throwable {
        TraceContext context = TraceContext.create(invocation);
        Tracer tracer = new Tracer(context);
        Object returnValue = null;
        SQLStatement sqlStatement = this.getSql(invocation);
        long start = System.currentTimeMillis();
        try {
            returnValue = invocation.proceed();
            sqlStatement.setTime(System.currentTimeMillis() - start);
            Object object = returnValue;
            return object;
        }
        catch (Throwable ex) {
            sqlStatement.setTime(System.currentTimeMillis() - start);
            tracer.error(sqlStatement.output(returnValue), sqlStatement.getParams(), ex);
            throw ex;
        }
        finally {
            sqlStatement.setTime(System.currentTimeMillis() - start);
            tracer.log(sqlStatement.output(returnValue), sqlStatement.getParams());
            tracer.stop();
        }
    }

    private SQLStatement getSql(Invocation invocation) {
        SQLStatement sqlStatement = new SQLStatement();
        try {
            Object parameter = null;
            if (invocation.getArgs().length > 1) {
                parameter = invocation.getArgs()[1];
            }
            MappedStatement mappedStatement = (MappedStatement)invocation.getArgs()[0];
            String sqlId = mappedStatement.getId();
            BoundSql boundSql = mappedStatement.getBoundSql(parameter);
            Configuration configuration = mappedStatement.getConfiguration();
            sqlStatement.setSqlId(sqlId);
            sqlStatement.setParams(new HashMap<String, String>());
            Object parameterObject = boundSql.getParameterObject();
            List parameterMappings = boundSql.getParameterMappings();
            String sql = boundSql.getSql().replaceAll("[\\s]+", " ");
            int index = 0;
            if (parameterMappings.size() > 0 && parameterObject != null) {
                TypeHandlerRegistry typeHandlerRegistry = configuration.getTypeHandlerRegistry();
                if (typeHandlerRegistry.hasTypeHandler(parameterObject.getClass())) {
                    String pv = MybatisInterceptor.getParameterValue(parameterObject);
                    sql = sql.replaceFirst("\\?", pv);
                    sqlStatement.getParams().put("param" + index++, pv);
                } else {
                    MetaObject metaObject = configuration.newMetaObject(parameterObject);
                    for (ParameterMapping parameterMapping : parameterMappings) {
                        String pv;
                        Object obj;
                        String propertyName = parameterMapping.getProperty();
                        if (metaObject.hasGetter(propertyName)) {
                            obj = metaObject.getValue(propertyName);
                            pv = MybatisInterceptor.getParameterValue(obj);
                            sql = sql.replaceFirst("\\?", pv);
                            sqlStatement.getParams().put("param" + index++, pv);
                            continue;
                        }
                        if (!boundSql.hasAdditionalParameter(propertyName)) continue;
                        obj = boundSql.getAdditionalParameter(propertyName);
                        pv = MybatisInterceptor.getParameterValue(obj);
                        sql = sql.replaceFirst("\\?", MybatisInterceptor.getParameterValue(obj));
                        sqlStatement.getParams().put("param" + index++, pv);
                    }
                }
            }
            sqlStatement.setSql(sql);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return sqlStatement;
    }

    private static String getParameterValue(Object obj) {
        String value;
        if (obj instanceof String) {
            value = "'" + obj.toString() + "'";
        } else if (obj instanceof Date) {
            DateFormat formatter = DateFormat.getDateTimeInstance(2, 2, Locale.CHINA);
            value = "'" + formatter.format(new Date()) + "'";
        } else {
            value = obj != null ? obj.toString() : "";
        }
        return value;
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }
}

