/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.parser.zk.util;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.io.file.FileNameUtil;
import cn.hutool.core.util.ReUtil;
import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.builder.LiteFlowNodeBuilder;
import com.yomahub.liteflow.builder.el.LiteFlowChainELBuilder;
import com.yomahub.liteflow.enums.NodeTypeEnum;
import com.yomahub.liteflow.flow.FlowBus;
import com.yomahub.liteflow.parser.zk.exception.ZkException;
import com.yomahub.liteflow.parser.zk.vo.ZkParserVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.recipes.cache.CuratorCache;
import org.apache.curator.framework.recipes.cache.CuratorCacheListener;
import org.apache.curator.retry.RetryNTimes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkParserHelper {
    private static final Logger LOG = LoggerFactory.getLogger(ZkParserHelper.class);
    private final ZkParserVO zkParserVO;
    private final CuratorFramework client;
    private final String CHAIN_XML_PATTERN = "<chain name=\"{}\">{}</chain>";
    private final String NODE_XML_PATTERN = "<nodes>{}</nodes>";
    private final String NODE_ITEM_XML_PATTERN = "<node id=\"{}\" name=\"{}\" type=\"{}\"><![CDATA[{}]]></node>";
    private final String XML_PATTERN = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><flow>{}{}</flow>";

    public ZkParserHelper(ZkParserVO zkParserVO) {
        this.zkParserVO = zkParserVO;
        try {
            CuratorFramework client = CuratorFrameworkFactory.newClient((String)zkParserVO.getConnectStr(), (RetryPolicy)new RetryNTimes(10, 5000));
            client.start();
            this.client = client;
        }
        catch (Exception e) {
            throw new ZkException(e.getMessage());
        }
    }

    public String getContent() {
        try {
            if (this.client.checkExists().forPath(this.zkParserVO.getChainPath()) == null) {
                throw new ZkException(StrUtil.format((CharSequence)"zk node[{}] is not exist", (Object[])new Object[]{this.zkParserVO.getChainPath()}));
            }
            List chainNameList = (List)this.client.getChildren().forPath(this.zkParserVO.getChainPath());
            if (CollectionUtil.isEmpty((Collection)chainNameList)) {
                throw new ZkException(StrUtil.format((CharSequence)"There are no chains in path [{}]", (Object[])new Object[]{this.zkParserVO.getChainPath()}));
            }
            ArrayList<String> chainItemContentList = new ArrayList<String>();
            for (String chainName : chainNameList) {
                String chainData = new String((byte[])this.client.getData().forPath(StrUtil.format((CharSequence)"{}/{}", (Object[])new Object[]{this.zkParserVO.getChainPath(), chainName})));
                chainItemContentList.add(StrUtil.format((CharSequence)"<chain name=\"{}\">{}</chain>", (Object[])new Object[]{chainName, chainData}));
            }
            String chainAllContent = CollUtil.join(chainItemContentList, (CharSequence)"");
            String scriptAllContent = "";
            if (this.hasScript()) {
                List scriptNodeValueList = (List)this.client.getChildren().forPath(this.zkParserVO.getScriptPath());
                ArrayList<String> scriptItemContentList = new ArrayList<String>();
                for (String scriptNodeValue : scriptNodeValueList) {
                    NodeSimpleVO nodeSimpleVO = this.convert(scriptNodeValue);
                    if (Objects.isNull(nodeSimpleVO)) {
                        throw new ZkException(StrUtil.format((CharSequence)"The name of the zk node is invalid:{}", (Object[])new Object[]{scriptNodeValue}));
                    }
                    String scriptData = new String((byte[])this.client.getData().forPath(StrUtil.format((CharSequence)"{}/{}", (Object[])new Object[]{this.zkParserVO.getScriptPath(), scriptNodeValue})));
                    scriptItemContentList.add(StrUtil.format((CharSequence)"<node id=\"{}\" name=\"{}\" type=\"{}\"><![CDATA[{}]]></node>", (Object[])new Object[]{nodeSimpleVO.getNodeId(), nodeSimpleVO.getName(), nodeSimpleVO.getType(), scriptData}));
                }
                scriptAllContent = StrUtil.format((CharSequence)"<nodes>{}</nodes>", (Object[])new Object[]{CollUtil.join(scriptItemContentList, (CharSequence)"")});
            }
            return StrUtil.format((CharSequence)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><flow>{}{}</flow>", (Object[])new Object[]{scriptAllContent, chainAllContent});
        }
        catch (Exception e) {
            throw new ZkException(e.getMessage());
        }
    }

    public boolean hasScript() {
        if (StrUtil.isBlank((CharSequence)this.zkParserVO.getScriptPath())) {
            return false;
        }
        try {
            if (this.client.checkExists().forPath(this.zkParserVO.getScriptPath()) == null) {
                return false;
            }
            List chainNameList = (List)this.client.getChildren().forPath(this.zkParserVO.getScriptPath());
            return !CollUtil.isEmpty((Collection)chainNameList);
        }
        catch (Exception e) {
            return false;
        }
    }

    public void listenZkNode() {
        CuratorCache cache1 = CuratorCache.build((CuratorFramework)this.client, (String)this.zkParserVO.getChainPath(), (CuratorCache.Options[])new CuratorCache.Options[0]);
        cache1.start();
        cache1.listenable().addListener((type, oldData, data) -> {
            String path = data.getPath();
            String value = new String(data.getData());
            if (StrUtil.isBlank((CharSequence)value)) {
                return;
            }
            if (ListUtil.toList((Object[])new CuratorCacheListener.Type[]{CuratorCacheListener.Type.NODE_CREATED, CuratorCacheListener.Type.NODE_CHANGED}).contains(type)) {
                LOG.info("starting reload flow config... {} path={} value={},", new Object[]{type.name(), path, value});
                String chainName = FileNameUtil.getName((String)path);
                LiteFlowChainELBuilder.createChain().setChainId(chainName).setEL(value).build();
            } else if (CuratorCacheListener.Type.NODE_DELETED.equals((Object)type)) {
                LOG.info("starting reload flow config... delete path={}", (Object)path);
                String chainName = FileNameUtil.getName((String)path);
                FlowBus.removeChain((String)chainName);
            }
        });
        if (StrUtil.isNotBlank((CharSequence)this.zkParserVO.getScriptPath())) {
            CuratorCache cache2 = CuratorCache.build((CuratorFramework)this.client, (String)this.zkParserVO.getScriptPath(), (CuratorCache.Options[])new CuratorCache.Options[0]);
            cache2.start();
            cache2.listenable().addListener((type, oldData, data) -> {
                String path = data.getPath();
                String value = new String(data.getData());
                if (StrUtil.isBlank((CharSequence)value)) {
                    return;
                }
                if (ListUtil.toList((Object[])new CuratorCacheListener.Type[]{CuratorCacheListener.Type.NODE_CREATED, CuratorCacheListener.Type.NODE_CHANGED}).contains(type)) {
                    LOG.info("starting reload flow config... {} path={} value={},", new Object[]{type.name(), path, value});
                    String scriptNodeValue = FileNameUtil.getName((String)path);
                    NodeSimpleVO nodeSimpleVO = this.convert(scriptNodeValue);
                    LiteFlowNodeBuilder.createScriptNode().setId(nodeSimpleVO.getNodeId()).setType(NodeTypeEnum.getEnumByCode((String)nodeSimpleVO.type)).setName(nodeSimpleVO.getName()).setScript(value).build();
                } else if (CuratorCacheListener.Type.NODE_DELETED.equals((Object)type)) {
                    LOG.info("starting reload flow config... delete path={}", (Object)path);
                    String scriptNodeValue = FileNameUtil.getName((String)path);
                    NodeSimpleVO nodeSimpleVO = this.convert(scriptNodeValue);
                    FlowBus.getNodeMap().remove(nodeSimpleVO.getNodeId());
                }
            });
        }
    }

    public NodeSimpleVO convert(String str) {
        List matchItemList = ReUtil.findAllGroup0((String)"(?<=[^:]:)[^:]+|[^:]+(?=:[^:])", (CharSequence)str);
        if (CollUtil.isEmpty((Collection)matchItemList)) {
            return null;
        }
        NodeSimpleVO nodeSimpleVO = new NodeSimpleVO();
        if (matchItemList.size() > 1) {
            nodeSimpleVO.setNodeId((String)matchItemList.get(0));
            nodeSimpleVO.setType((String)matchItemList.get(1));
        }
        if (matchItemList.size() > 2) {
            nodeSimpleVO.setName((String)matchItemList.get(2));
        }
        return nodeSimpleVO;
    }

    private static class NodeSimpleVO {
        private String nodeId;
        private String type;
        private String name = "";

        private NodeSimpleVO() {
        }

        public String getNodeId() {
            return this.nodeId;
        }

        public void setNodeId(String nodeId) {
            this.nodeId = nodeId;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

