/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.parser.zk;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.core.FlowInitHook;
import com.yomahub.liteflow.parser.el.ClassXmlFlowELParser;
import com.yomahub.liteflow.parser.zk.exception.ZkException;
import com.yomahub.liteflow.parser.zk.util.ZkParserHelper;
import com.yomahub.liteflow.parser.zk.vo.ZkParserVO;
import com.yomahub.liteflow.property.LiteflowConfig;
import com.yomahub.liteflow.property.LiteflowConfigGetter;
import com.yomahub.liteflow.util.JsonUtil;
import java.util.Map;
import java.util.Objects;

public class ZkXmlELParser
extends ClassXmlFlowELParser {
    private final ZkParserHelper zkParserHelper;

    public ZkXmlELParser() {
        LiteflowConfig liteflowConfig = LiteflowConfigGetter.get();
        try {
            ZkParserVO zkParserVO = null;
            if (MapUtil.isNotEmpty((Map)liteflowConfig.getRuleSourceExtDataMap())) {
                zkParserVO = (ZkParserVO)BeanUtil.toBean((Object)liteflowConfig.getRuleSourceExtDataMap(), ZkParserVO.class, (CopyOptions)CopyOptions.create());
            } else if (StrUtil.isNotBlank((CharSequence)liteflowConfig.getRuleSourceExtData())) {
                zkParserVO = (ZkParserVO)JsonUtil.parseObject((String)liteflowConfig.getRuleSourceExtData(), ZkParserVO.class);
            }
            if (Objects.isNull(zkParserVO)) {
                throw new ZkException("rule-source-ext-data is empty");
            }
            if (StrUtil.isBlank((CharSequence)zkParserVO.getChainPath())) {
                throw new ZkException("You must configure the chainPath property");
            }
            if (StrUtil.isBlank((CharSequence)zkParserVO.getConnectStr())) {
                throw new ZkException("zk connect string is empty");
            }
            this.zkParserHelper = new ZkParserHelper(zkParserVO);
        }
        catch (Exception e) {
            throw new ZkException(e.getMessage());
        }
    }

    public String parseCustom() {
        try {
            String content = this.zkParserHelper.getContent();
            FlowInitHook.addHook(() -> {
                this.zkParserHelper.listenZkNode();
                return true;
            });
            return content;
        }
        catch (Exception e) {
            throw new ZkException(e.getMessage());
        }
    }
}

