package com.thebeastshop.pegasus.merchandise.vo;

import java.util.Map;

import org.apache.commons.collections4.MapUtils;



public class PsBrandVO extends AbstractDomain {

	private Long brandId; //品牌
	private String brandName;
    private String brandNameCN;
    private Long brandCountryId;
    private String brandCountryName;
	private Long authLetter;
    
    public PsBrandVO() {}
    
    public PsBrandVO(Map map) {
    	this.brandId = MapUtils.getLong(map, "brandId");
    	this.brandName= MapUtils.getString(map, "brandName"); 
    	this.brandNameCN= MapUtils.getString(map, "brandNameCN");
    	this.brandCountryId= MapUtils.getLong(map, "brandCountryId");
    	this.brandCountryName= MapUtils.getString(map, "brandCountryName");
		this.authLetter= MapUtils.getLong(map, "authLetter");
    }
    
    public Long getBrandId() {
		return brandId;
	}
	public void setBrandId(Long brandId) {
		this.brandId = brandId;
	}
	public String getBrandName() {
		return brandName;
	}
	public void setBrandName(String brandName) {
		this.brandName = brandName;
	}
	public String getBrandNameCN() {
		return brandNameCN;
	}
	public void setBrandNameCN(String brandNameCN) {
		this.brandNameCN = brandNameCN;
	}
	public Long getBrandCountryId() {
		return brandCountryId;
	}
	public void setBrandCountryId(Long brandCountryId) {
		this.brandCountryId = brandCountryId;
	}
	public String getBrandCountryName() {
		return brandCountryName;
	}
	public void setBrandCountryName(String brandCountryName) {
		this.brandCountryName = brandCountryName;
	}

	public Long getAuthLetter() {
		return authLetter;
	}

	public void setAuthLetter(Long authLetter) {
		this.authLetter = authLetter;
	}

	/**
	 * 如果对象类型是User 的话 则返回true 去比较hashCode值
	 */
	@Override
	public boolean equals(Object obj) {
		if(obj == null) return false;
		if(this == obj) return true;
		if(obj instanceof PsBrandVO){
			PsBrandVO user =(PsBrandVO)obj;
//          if(user.id = this.id) return true; // 只比较id
			// 比较id 一致时才返回true 之后再去比较 hashCode
			if(user.brandId.longValue() == this.brandId.longValue()) return true;
		}
		return false;
	}



	/**
	 * 重写hashcode 方法，返回的hashCode 不一样才认定为不同的对象
	 */
	@Override
	public int hashCode() {
//      return id.hashCode(); // 只比较id，id一样就不添加进集合
		return brandId.hashCode();
	}
}
