/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.merchandise.service;


import com.thebeastshop.hotlink.annotation.Hotlink;
import com.thebeastshop.pegasus.merchandise.cond.PsMatchCampaignCond;
import com.thebeastshop.pegasus.merchandise.cond.PsSkuCond;
import com.thebeastshop.pegasus.merchandise.vo.PsSkuBaseVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSkuVO;

import java.util.List;
import java.util.Map;

/**
 * @Author: LK【kai.li@thebeastshop.com】
 * @Date: 2016/9/5 13:26
 */
public interface McPsSkuService {
    boolean create(PsSkuVO vo);
    boolean create(List<PsSkuVO> vos);

    boolean update(PsSkuVO vo);

    boolean update(List<PsSkuVO> vos);

    boolean deleteBySkuCode(String skuCode);

    List<PsSkuVO> findAll();

    List<PsSkuVO> findBySkuName(String name);

    PsSkuVO findBySkuCode(String code);

    PsSkuVO findBySkuCodeExist(String code);
    List<PsSkuVO> findBySkuCodesForEs(List<String> codes);
    @Hotlink
    List<PsSkuVO> findBySkuCodes(List<String> codes);

    List<PsSkuBaseVO> findBaseBySkuCodes(List<String> codes);

    List<PsSkuVO> findBySuppIds(List<Long> suppIds);
    List<PsSkuVO> findByBrandIds(List<Long> brandIds);
    List<PsSkuVO> findByCateIds(List<Long> cateIds);

    List<PsSkuVO> findByCond(PsSkuCond cond);


    List<PsSkuVO> findByCodeName(String codeName);
    List<PsSkuVO> findByCodeName(String codeName, Integer currpage, Integer pagenum);
    List<PsSkuVO> findSkuByCodeName(String codeName,Integer currpage,Integer pagenum);

    PsSkuVO findBySkuCode(String code, PsMatchCampaignCond cond);
    List<PsSkuVO> findBySkuName(String codeName, Integer currpage, Integer pagenum, PsMatchCampaignCond cond);

    /**
     * 通过code查找对应的sku信息
     *
     * @param codes  待查找code
     *
     * @return
     */
    Map<String, PsSkuVO> getBySkuCodes(List<String> codes);
}
