package com.thebeastshop.pegasus.merchandise.service;


import com.thebeastshop.pegasus.merchandise.cond.PcsWatermarkCond;
import com.thebeastshop.pegasus.merchandise.vo.PcsWatermarkVO;
import com.thebeastshop.pegasus.merchandise.vo.ProdSkuVO;
import com.thebeastshop.pegasus.merchandise.vo.ProductWatermarkVO;

import java.util.List;
import java.util.Map;

/**
 * @author gongjun
 * @since 2016-05-06
 */
public interface McPcsWatermarkService {

    Long addWatermark(PcsWatermarkVO watermarkVO);

    int updateWatermark(PcsWatermarkVO watermarkVO);

    int updateSkuWatrmarkByCodeList(String skuCode, List<String> codeList);
    
    int updateProdWatrmarkByCodeList(ProdSkuVO prod, List<String> watermarkCodeList, boolean isEmptyBeforeUpdate);

//    int saveOrUpdateSkuWatermark(PcsSkuWatermark skuWatermark);

    PcsWatermarkVO findWatermarkById(Long id);

    List<PcsWatermarkVO> queryWatermarkList(PcsWatermarkCond cond);
    
    List<ProdSkuVO> queryProdWatermarkList(PcsWatermarkCond cond);
    
    List<ProdSkuVO> querySkuListByProd(Long prodId);
    
    List<ProdSkuVO> queryProdListBySkuCode(String code);
    
	int deleteProdWatermarkByIds(List<String> idList);

//	int saveOrUpdateProdWatermark(ProdWatermark prodWatermark) throws OperationsException;

	List<ProdSkuVO> queryProdWatermarkListByParams(List<String> params);

	ProdSkuVO queryProductByProdId(Long prodId);

    /**
     * 通过 productcodes 查询  可以使用的水印 标签
     * @author lijing
     * @time 2016-09-10 20:11
     * @param productCodes
     * @return
     */
    Map<String,ProductWatermarkVO> seleckWatermarkByProductCodes(List<String> productCodes);

    int setProdWatermarkValidityByIds(Map<String, Object> params);

    @Deprecated
    public int checkProdWatermarkHasValid(String watermarkCode, String skuCode);

    public int checkProdWatermarkHasValidByProductCode(String watermarkCode, String productCode);

    //更新商品水印表
    void updateActiveWatermark();




}
