/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.merchandise.service;

import com.thebeastshop.common.Pagination;
import com.thebeastshop.common.ServiceResp;
import com.thebeastshop.hotlink.annotation.Hotlink;
import com.thebeastshop.pegasus.merchandise.vo.*;
import com.thebeastshop.pegasus.merchandise.cond.OpChannelCond;

import java.util.List;

/**
 * @Author: LK【kai.li@thebeastshop.com】
 * @Date: 2016/9/5 13:26
 */
public interface McOpChannelService {

    Long create(OpChannelVO channel);
    boolean update(OpChannelVO channel);
    boolean deleteById(Long id);

    OpChannelVO findById(Long id);

    OpChannelVO findById(Long id,boolean fetchServiceLine);

    boolean createChannelServiceLine(OpChannelServiceLineVO serviceLineVO);
    boolean batchCreateChannelServiceLine(List<OpChannelServiceLineVO> serviceLineVOs);
    boolean deleteChannelServiceLineByChannelCode(String channelCode);

    List<OpChannelServiceLineVO> listChannelServiceLineVOByCond(OpChannelCond serviceLineCond);

    /**
     * 根据条件查找渠道
     *
     * @param cond
     * @return 渠道列表
     */
    List<OpChannelVO> findChannelByCond(String cond);

    /**
     * 条件查询 渠道
     *
     * @param cond
     * @return
     */
    List<OpChannelVO> findByCriteria(OpChannelCond cond);

    Pagination<OpChannelVO> pageListChannelByCond(OpChannelCond cond);

    List<OpChannelVO> listChannelByCond(OpChannelCond cond);

    int countChannelVOByCond(OpChannelCond cond);

    /**
     * 根据编码查找
     *
     * @param code
     * @return
     */

    @Hotlink
    OpChannelVO findByCode(String code);

    List<OpChannelVO> findByCode(List<String> codes);

    /**
     * 所有渠道
     *
     * @return
     */
    List<OpChannelVO> findAll();

    List<OpChannelVO> findAllNew();
    /**
     * 所有鲜花店
     *
     * @return
     */
    List<OpChannelVO> selectAllFlowerShops();
    
    
    List<OpChannelVO> findChannelByType(int type);

    /**
     * 根据渠道类型查找所有记录
     *
     * @param type
     *
     * @return
     */
    List<ChannelSelectorVO> findByChannelType(Integer type);
    
    /**
     * 根据渠道类型查找所有记录并放置redis
     *
     * @param cond
     *
     * @return
     */
    List<OpChannelVO> getChannelCodeByTypeToRedis(OpChannelCond cond);

    List<OpChannelVO> getIPOSChannels();

    List<OpChannelVO> getIposChannels();

    Integer findChannelCityIdByCode(String channelCode);

    public void syncAllChannelToRedis();

    public void syncChannelToRedisByCond(OpChannelCond cond);

    public List<OpChannelVO> fetchOpChannelFromRedis();

    ServiceResp saveDeliveryHour(String channelCode,List<OpChannelDeliveryVO> listVO);
    List<OpChannelDeliveryVO> getDeliveryHour(String channelCode);
    List<OpChannelVO> listChannelByWarehouseForSales(String warehouseForSales);

    List<OpChannelQwAccountVO> listQwAccount(String channelCode);

    List<OpChannelQwAccountVO> listQwAccountByAccount(String account);

}
