/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.merchandise.service;

import com.thebeastshop.common.PageQueryResp;
import com.thebeastshop.pegasus.merchandise.cond.ActivityPageCond;
import com.thebeastshop.pegasus.merchandise.vo.*;

import java.util.List;
import java.util.Map;

/**
 * @Author: LK【kai.li@thebeastshop.com】
 * @Date: 2016/9/5 13:28
 */
public interface ActivityPageService{

    Long findByName(String pageName);

    Long getPageIdFromRedis(String pageName);

    List<ActivityPageVO> findActivityPageNmme();

    List<ProdCreatorVO> findActivityCreator();

    List<ActivityPageVO> findActivityPageNameHasSortPage();

    PageQueryResp<ActivityPageVO> listPage(ActivityPageCond cond);

    Boolean addActivityPageRule(ActivityPageRuleVO vo);

    Boolean insertOrUpdateActivityPage(List<RecommendVO> list);

    ActivityPageRuleVO findActivityPageById(Long id);

    Boolean deleteActivityPageById(Long id);

    Boolean batchAddActivityPageRule(List<ActivityPageRuleVO> ruleVOS);

    Boolean deleteByIds(List<Long> ids);

    List<Integer> findSuperiorFromHrmresourse(Integer id);

    ActivityPageVO findById(Long id);

    List<Map> getCityByNameOrCode(String value);

    String getGlobalConfigValueByKey(String key);

    List<Map> autoRecommendAutocomplete(String value);

    Map recommendAutoByProdCode(String prodCode);

    List<EditProductSkuInfoVo> findNoUserdByNameOrCode(String value);

    List<Map> getCodeAndNameByProductCode(String productCode);

    List<Map> listProdUpDown(Map params);

    List<Map> listProdUpDownApproval(Map params);

}
