package com.thebeastshop.pegasus.merchandise.enums;

import java.util.*;

/**
 * 安装服务枚举
 */
public enum  PcsSkuInstallServiceEnum {

  NOT_NEED_INSTALL((short)0, "无需安装"),
  SELF_INSTALL((short)1, "自行安装"),
  HELP_INSTALL((short) 2, "需要安装");

   private Short key;
   private String desc;

  PcsSkuInstallServiceEnum(Short key, String desc) {
    this.key = key;
    this.desc = desc;
  }

  public final static List<Map<String, Object>> listMapEnum() {
    List<Map<String, Object>> listMap = new ArrayList<Map<String, Object>>();
    for (PcsSkuInstallServiceEnum installServiceEnum : PcsSkuInstallServiceEnum.values()) {
      Map<String, Object> map = new HashMap<String, Object>();
      map.put("value", installServiceEnum.key);
      map.put("name", installServiceEnum.desc);
      listMap.add(map);
    }
    return listMap;
  }

  public final static List<PcsSkuInstallServiceEnum> getAll() {
   return Arrays.asList(PcsSkuInstallServiceEnum.values());
  }

  public static String  getDesc(Short key) {
    for (PcsSkuInstallServiceEnum pcsSkuInstallServiceEnum : PcsSkuInstallServiceEnum.values()) {
      if (pcsSkuInstallServiceEnum.key.equals(key)) {
        return pcsSkuInstallServiceEnum.desc;
      }
    }
    return  "";
  }

  public static Short  getKey(String desc) {
    for (PcsSkuInstallServiceEnum pcsSkuInstallServiceEnum : PcsSkuInstallServiceEnum.values()) {
      if (pcsSkuInstallServiceEnum.desc.equals(desc)) {
        return pcsSkuInstallServiceEnum.key;
      }
    }
    return  null;
  }

  public String getDesc() {
    return desc;
  }

  public void setDesc(String desc) {
    this.desc = desc;
  }

  public Short getKey() {
    return key;
  }

  public void setKey(Short key) {
    this.key = key;
  }
}
