package com.thebeastshop.pegasus.merchandise.enums;

import java.util.*;

/**
 * SKU所属海关类型枚举
 * @version V1.0
 * @Description
 * @author xh
 * @date 2019年1月16日
 */
public enum PcsSkuCustomsTypeEnum {
	
	GZ(1, "广州海关"),
	SZ(2, "深圳海关"),
	SH(3, "上海海关"),
	BJ(4, "北京海关");
	
	private Integer code;

    private String name;
    
    public static final List<PcsSkuCustomsTypeEnum> ALL = Collections.unmodifiableList(Arrays.asList(values()));
    
    PcsSkuCustomsTypeEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    public Integer getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

    public boolean equals(PcsSkuCustomsTypeEnum typeEnum) {
        if (typeEnum == null) return false;
        return code.equals(typeEnum.getCode());
    }

    public boolean equals(Integer code) {
        if (code == null) return false;
        return this.code.equals(code);
    }


    public final static List<Map<String, Object>> listMapEnum() {
        List<Map<String, Object>> listMap = new ArrayList<Map<String, Object>>();
        for (PcsSkuCustomsTypeEnum skuCustomsTypeEnum : PcsSkuCustomsTypeEnum.values()) {
            Map<String, Object> map = new HashMap<String, Object>();
            map.put("code", skuCustomsTypeEnum.code);
            map.put("name", skuCustomsTypeEnum.name);
            listMap.add(map);
        }
        return listMap;
    }


    public static PcsSkuCustomsTypeEnum getEnumByCode(Integer code) {
        for (PcsSkuCustomsTypeEnum e : PcsSkuCustomsTypeEnum.values()) {
            if (e.code == code) {
                return e;
            }
        }
        return null;
    }
    
    public static Integer getEnumByName(String name) {
        if (name == null) {
          return null;
        }
        for (PcsSkuCustomsTypeEnum e : PcsSkuCustomsTypeEnum.values()) {
          if (name.equals(e.name)) {
            return e.code;
          }
        }
        return null;
      }
}
