package com.thebeastshop.pegasus.merchandise.enums;

import java.util.*;

/**
 * SKU成本变更触发来源
 */
public enum PcsSkuCostChangeSourceEnum {

    GENERAL(1, "普通编辑"),
    RECIPE_MODIFY(2, "配方修改触发"),
    MATERIAL_PASSED(3, "耗材成本审批通过触发"),
    ;

    public final Integer type;
    public final String desc;

    public static final List<PcsSkuCostChangeSourceEnum> ALL = Collections.unmodifiableList(Arrays.asList(values()));

    PcsSkuCostChangeSourceEnum(final Integer status, final String desc) {
        this.type = status;
        this.desc = desc;
    }

    public final static List<Map<String, Object>> listMapEnum() {
        List<Map<String, Object>> listMap = new ArrayList<Map<String, Object>>();
        for (PcsSkuCostChangeSourceEnum pcsSkuSpecialVarietyEnum : PcsSkuCostChangeSourceEnum.values()) {
            Map<String, Object> map = new HashMap<String, Object>();
            map.put("type", pcsSkuSpecialVarietyEnum.type);
            map.put("desc", pcsSkuSpecialVarietyEnum.desc);
            listMap.add(map);
        }
        return listMap;
    }

    // 普通方法
    public static String getDesc(Integer status) {
        for (PcsSkuCostChangeSourceEnum c : ALL) {
            if (c.type == status) {
                return c.desc;
            }
        }
        return null;
    }

    public final static Integer getTypeByDesc(String desc) {
        Integer statusVal = null;
        for (PcsSkuCostChangeSourceEnum skuSpecialVarietyEnum : values()) {
            if (skuSpecialVarietyEnum.desc.equals(desc)) {
                statusVal = skuSpecialVarietyEnum.type;
                break;
            }
        }
        return statusVal;
    }

    public static PcsSkuCostChangeSourceEnum getEnumById(Integer id) {
        PcsSkuCostChangeSourceEnum[] values = PcsSkuCostChangeSourceEnum.values();
        for (PcsSkuCostChangeSourceEnum item : values) {
            if (item.getType().equals(id)) {
                return item;
            }
        }
        return null;
    }


    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

}
