package com.thebeastshop.pegasus.merchandise.enums;

import java.util.*;

/**
 * SKU通关方式
 */
public enum  PcsSkuClearanceWayEnum {
   NO(0, "否"),
   BC(1, "BC"),
   PERSONAL(2, "个人"),
   COMMON(3, "一般贸易"),
   EXPRESS(4, "快件");

   private Integer val;

   private String desc;

  PcsSkuClearanceWayEnum(Integer val, String desc) {
    this.val = val;
    this.desc = desc;
  }
  public final static List<PcsSkuClearanceWayEnum> ALL = Arrays.asList(PcsSkuClearanceWayEnum.values());


  public final static List<Map<String, Object>> listMap() {
    List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
    for (PcsSkuClearanceWayEnum clearanceWayEnum : ALL) {
      Map<String, Object> map = new HashMap<String, Object>();
      map.put("value", clearanceWayEnum.val);
      map.put("name", clearanceWayEnum.desc);
      list.add(map);
    }
    return list;
  }

  public  static Integer  isContainDesc(String desc) {
    for (PcsSkuClearanceWayEnum clearanceWayEnum : ALL) {
      if(clearanceWayEnum.desc.equals(desc)) {
        return clearanceWayEnum.val;
      }
    }
    return null;
  }

  public final static String getClearanceWayDesc(Integer val) {
    if (val == null) {
      return "";
    }
    for (PcsSkuClearanceWayEnum clearanceWayEnum : ALL) {
      if (val == clearanceWayEnum.val) {
        return clearanceWayEnum.desc;
      }
    }
    return  "";
  }

  public final static String[] arrayName() {
    int length = ALL.size();
    String[] result = new String[length];
    int arrayIndex = 0;
    for (PcsSkuClearanceWayEnum clearanceWayEnum : ALL) {
      result[arrayIndex] = clearanceWayEnum.desc;
      arrayIndex ++;
    }
    return result;
  }
  public Integer getVal() {
    return val;
  }

  public String getDesc() {
    return desc;
  }
}
