package com.thebeastshop.pegasus.merchandise.enums;

import java.util.*;

/**
 * SKU信息变更来源
 */
public enum PcsSkuChangeSourceEnum {

    PAGE_CREATE(1, 1,"页面创建"),
    PAGE_EDIT(2, 2,"页面编辑"),
    BATCH_CREATE(3,1, "批量创建"),
    BATCH_EDIT(4, 2, "批量编辑"),
    BATCH_SUBMIT(5, 2,"批量提交"),
    FLOWER_COURSE(6, 1, "花艺课"),
    FLOWER(7, 1,"鲜花SKU"),
    RECIPE_EDIT(8, 2,"配方修改"),
    IP_EDIT(9, 2,"修改IP"),
    AIR_CONTRABAND_EDIT(10, 2,"航空违禁品"),
    SAMPLE_QUANTITY_EDIT(11, 2,"留样数量"),
    ;

    public final Integer type;
    public final Integer changeSource;
    public final String desc;

    public static final List<PcsSkuChangeSourceEnum> ALL = Collections.unmodifiableList(Arrays.asList(values()));

    PcsSkuChangeSourceEnum(Integer changeSource, final Integer type, final String desc) {
        this.changeSource = changeSource;
        this.type = type;
        this.desc = desc;
    }

    public final static List<Map<String, Object>> listMapEnum() {
        List<Map<String, Object>> listMap = new ArrayList<Map<String, Object>>();
        for (PcsSkuChangeSourceEnum pcsSkuSpecialVarietyEnum : PcsSkuChangeSourceEnum.values()) {
            Map<String, Object> map = new HashMap<String, Object>();
            map.put("type", pcsSkuSpecialVarietyEnum.type);
            map.put("desc", pcsSkuSpecialVarietyEnum.desc);
            listMap.add(map);
        }
        return listMap;
    }

    // 普通方法
    public static String getDesc(Integer status) {
        for (PcsSkuChangeSourceEnum c : ALL) {
            if (c.type == status) {
                return c.desc;
            }
        }
        return null;
    }

    public final static Integer getTypeByDesc(String desc) {
        Integer statusVal = null;
        for (PcsSkuChangeSourceEnum skuSpecialVarietyEnum : values()) {
            if (skuSpecialVarietyEnum.desc.equals(desc)) {
                statusVal = skuSpecialVarietyEnum.type;
                break;
            }
        }
        return statusVal;
    }

    public static PcsSkuChangeSourceEnum getEnumByChangeSource(Integer id) {
        PcsSkuChangeSourceEnum[] values = PcsSkuChangeSourceEnum.values();
        for (PcsSkuChangeSourceEnum item : values) {
            if (item.changeSource.equals(id)) {
                return item;
            }
        }
        return null;
    }


    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getChangeSource() {
        return changeSource;
    }
}
