package com.thebeastshop.pegasus.merchandise.vo;

import com.thebeastshop.pegasus.merchandise.enums.PcsSkuSpecialVarietyEnum;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 *
 * @author gongjun
 * @since 2016-10-13
 */
public class PsSpvVO implements Serializable {

    private Long spvId;
    /**
     * 组合原价
     */
    private BigDecimal originalPrice;
    /**
     * 售价
     */
    private BigDecimal salesPrice;



    /**
     * PRODUCT ID
     */
    private Long productId;
    /**
     * PRODUCT编码
     */
    private String productCode;
    /**
     * PRODUCT名称
     */
    private String productName;
    /**
     * 成本价
     */
    private BigDecimal costPrice;
    /**
     * 是否组合
     */
    private Boolean combined;

    /**
     * 对应属性值JSON字符串
     */
//    private String attrs;

    /**
     * SPV对应属性值对
     */
    private List<PsAttributeValuePairVO> attributeValuePairList;

    /**
     * SPV对应属性值 [AttrId -> AttrValueId]
     */
//    private Map<Long, Long> attrValues;

    /**
     * 最小起售数
     */
    private Integer minAmount;

    /**
     * 单品SKU CODE
     */
    private String skuCode;
    private String barCode;

    /**
     * 单品SKU
     */
    private PsSkuVO skuVO;

    /**
     * SKU组合列表
     */
    private List<PsSkuCombinationVO> skuCombinationList;

    /**
     * 预告活动价格
     */
    private BigDecimal advancePrice;
    /**
     * SKU维度活动列表
     */
    private List<PsCampaignVO> campaignList = new ArrayList<>();
    //transient
    private List<EsCampaignVO> esCampaignList = new ArrayList<>();

    /**
     * 预告活动
     */
    private List<PsCampaignVO> advanceCampaignList = new ArrayList<>();
    //transient
    private List<EsCampaignVO> esAdvanceCampaignList = new ArrayList<>();



    private Boolean isNewMember = false;//是否是新人专享

    /**
     * 非组合商品后端主类目编号
     */
    private Long categoryId;

    private String bu;

    private Integer customPrintTemplate;//0:不支持 1:吊牌定制

    private String spvImg;

    /**
     * 是否来单
     */
    private Boolean isJit;

    private PcsSkuSpecialVarietyEnum pcsSkuSpecialVarietyEnum;

    public Long getSpvId() {
        return spvId;
    }

    public void setSpvId(Long spvId) {
        this.spvId = spvId;
    }

    public BigDecimal getSalesPrice() {
        return salesPrice;
    }

    public void setSalesPrice(BigDecimal salesPrice) {
        this.salesPrice = salesPrice;
    }


    public Long getProductId() {
        return productId;
    }

    public void setProductId(Long productId) {
        this.productId = productId;
    }

    public String getProductCode() {
        return productCode;
    }

    public void setProductCode(String productCode) {
        this.productCode = productCode;
    }

    public String getProductName() {
        return productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public BigDecimal getCostPrice() {
        return costPrice;
    }

    public void setCostPrice(BigDecimal costPrice) {
        this.costPrice = costPrice;
    }

    public Boolean getCombined() {
        return combined;
    }

    public void setCombined(Boolean combined) {
        this.combined = combined;
    }



    public List<PsAttributeValuePairVO> getAttributeValuePairList() {
        return attributeValuePairList;
    }

    public void setAttributeValuePairList(List<PsAttributeValuePairVO> attributeValuePairList) {
        this.attributeValuePairList = attributeValuePairList;
    }



    public Integer getMinAmount() {
        return minAmount;
    }

    public void setMinAmount(Integer minAmount) {
        this.minAmount = minAmount;
    }

    public String getSkuCode() {
        return skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    public String getBarCode() {
        return barCode;
    }

    public void setBarCode(String barCode) {
        this.barCode = barCode;
    }

    public PsSkuVO getSkuVO() {
        return skuVO;
    }

    public void setSkuVO(PsSkuVO skuVO) {
        this.skuVO = skuVO;
    }

    public List<PsSkuCombinationVO> getSkuCombinationList() {
        return skuCombinationList;
    }

    public void setSkuCombinationList(List<PsSkuCombinationVO> skuCombinationList) {
        this.skuCombinationList = skuCombinationList;
    }

    public BigDecimal getAdvancePrice() {
        return advancePrice;
    }

    public void setAdvancePrice(BigDecimal advancePrice) {
        this.advancePrice = advancePrice;
    }

    public List<PsCampaignVO> getCampaignList() {
        return campaignList;
    }

    public void setCampaignList(List<PsCampaignVO> campaignList) {
        this.campaignList = campaignList;
    }

    public List<PsCampaignVO> getAdvanceCampaignList() {
        return advanceCampaignList;
    }

    public void setAdvanceCampaignList(List<PsCampaignVO> advanceCampaignList) {
        this.advanceCampaignList = advanceCampaignList;
    }

    public List<EsCampaignVO> getEsCampaignList() {
        return esCampaignList;
    }

    public void setEsCampaignList(List<EsCampaignVO> esCampaignList) {
        this.esCampaignList = esCampaignList;
    }

    public List<EsCampaignVO> getEsAdvanceCampaignList() {
        return esAdvanceCampaignList;
    }

    public void setEsAdvanceCampaignList(List<EsCampaignVO> esAdvanceCampaignList) {
        this.esAdvanceCampaignList = esAdvanceCampaignList;
    }


    public Long getCategoryId() {
        return categoryId;
    }

    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }

    public BigDecimal getOriginalPrice() {
        return originalPrice;
    }

    public void setOriginalPrice(BigDecimal originalPrice) {
        this.originalPrice = originalPrice;
    }

    public Integer getCustomPrintTemplate() {
        return customPrintTemplate;
    }

    public void setCustomPrintTemplate(Integer customPrintTemplate) {
        this.customPrintTemplate = customPrintTemplate;
    }



    public String getBu() {
        return bu;
    }

    public void setBu(String bu) {
        this.bu = bu;
    }



    public String getSpvImg() {
        return spvImg;
    }

    public void setSpvImg(String spvImg) {
        this.spvImg = spvImg;
    }

    public Boolean getIsNewMember() {
        return isNewMember;
    }

    public void setIsNewMember(Boolean isNewMember) {
        this.isNewMember = isNewMember;
    }

    public Boolean getIsJit() {
        return isJit;
    }

    public void setIsJit(Boolean isJit) {
        this.isJit = isJit;
    }

    public PcsSkuSpecialVarietyEnum getPcsSkuSpecialVarietyEnum() {
        return pcsSkuSpecialVarietyEnum;
    }

    public void setPcsSkuSpecialVarietyEnum(PcsSkuSpecialVarietyEnum pcsSkuSpecialVarietyEnum) {
        this.pcsSkuSpecialVarietyEnum = pcsSkuSpecialVarietyEnum;
    }
}
