/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.merchandise.service;


import com.thebeastshop.pegasus.merchandise.cond.OpLabelCond;
import com.thebeastshop.pegasus.merchandise.vo.OpLabelVO;

import java.util.List;

/**  
 * @Author: LK【kai.li@thebeastshop.com】
 * @Date: 2016/12/29 14:08
 */
public interface McOpLabelService {

    /**
     * 根据类目code查找标签
     *
     * @param cond
     * @return
     */
    List<OpLabelVO> findByCondCategory(OpLabelCond cond);

    /**
     * 根据id集合查找品牌
     *
     * @param cond
     * @return
     */
    List<OpLabelVO> findByIds(OpLabelCond cond);

    /**
     * 根据父标签id查找同一父ID下的所有标签ID集合
     *
     * @param ids
     * @return
     */
    List<String> findParentIdAndSelfByLabelId(List<String> ids);
}
