package com.thebeastshop.pegasus.merchandise.constants;

import java.util.HashMap;
import java.util.Map;
/**
 * SKU资质审批状态
 * @author Administrator
 *
 */
public class PcsSkuQualifyConstants{
    /**
	 * 
	 */
	private static final long serialVersionUID = -61330318941577139L;
	
	/** sku审批状态######################*/
	/**
	 * 未提交 1
	 */
	public static final Integer AUDIT_STATUS_WAIT_SUBMIT = 1;
	
	/**
	 * 待进口部初审 2
	 */
	public static final Integer AUDIT_STATUS_WAIT_IMPORTDEP_FIRST_AUDIT = 2;
	
	/**
	 * 待QA初审 3
	 */
	public static final Integer AUDIT_STATUS_WAIT_QA_FIRST_AUDIT = 3;
	
	/**
	 * QA初审通过 4
	 */
	public static final Integer AUDIT_STATUS_QA_FIRST_AUDIT_PASS = 4;
	
	/**
	 * 待QA终审 5
	 */
	public static final Integer AUDIT_STATUS_WAIT_QA_FINAL_AUDIT = 5;
	
	/**
	 * 驳回 6 驳回
	 */
	public static final Integer AUDIT_STATUS_REJECT = 6;
	
	/**
	 * 通过(需后补) 7
	 */
	public static final Integer AUDIT_STATUS_PASS_ISPOSTMEETING = 7;
	
	/**
	 * 通过 8
	 */
	public static final Integer AUDIT_STATUS_PASS = 8;
	
	/** sku审批流程######################*/
	/**
	 * 待提交审核 1
	 */
	public static final Integer FLOW_TREND_SUBMIT_DOC = 1;
	
	/**
	 * 待进口部初审 2
	 */
	public static final Integer FLOW_TREND_IMPORTDEP_FIRST_AUDIT = 2;
	
	/**
	 * 待QA初审 3
	 */
	public static final Integer FLOW_TREND_QA_FIRST_AUDIT = 3;
	
	/**
	 * 待QA终审 5
	 */
	public static final Integer FLOW_TREND_QA_FINAL_AUDIT = 5;
	
	/**
	 * 待下采购单 9 [自进口初审通过、非自进口终审通过、非进口终审通过]
	 */
	public static final Integer FLOW_TREND_AWAIT_CREATE_PURCHASE = 9;
	
	/**
	 * 待进口部上传文件 10 [流程9 代替]
	 */
	// public static final Integer FLOW_TREND_IMPORTDEP_SUBMIT_DOC = 10;
	
	/**
	 * 通过 11 [结束]
	 */
	// public static final Integer FLOW_TREND_ONLINE_SUBMIT_SELL = 11;
	/**
	 * 通过(需后补) 7
	 */
	// public static final Integer FLOW_TREND_PASS_ISPOSTMEETING = 7;
	
	
	/**
	 * 通过 8
	 */
	public static final Integer FLOW_TREND_PASS = 8;
	
	
	/** sku审批操作######################*/
	/**
	 * 审批驳回0
	 */
	public static final Integer AUDIT_OPERATION_TYPE_REJECT = 0;
	
	/**
	 * 审批通过
	 */
	public static final Integer AUDIT_OPERATION_TYPE_PASS = 1;
	
	/** sku进口类型######################*/
	/**
	 * sku进口类型 非进口 0
	 */
	public static final Integer AUDIT_IMPORT__TYPE_NOT_IMPORTED = 0;
	
	/**
	 * sku进口类型 非自进口 1
	 */
	public static final Integer AUDIT_IMPORT__TYPE_OTHER_IMPORTED = 1;
	
	/**
	 * sku进口类型 自进口 2
	 */
	public static final Integer AUDIT_IMPORT__TYPE_OWN_IMPORTED = 2;
	
	/**
	 * sku审批文件是否需要后补 1
	 */
	public static final Integer AUDIT_IS_POST_MEETING = 1;
	
	/**
	 * 所属审批类型 3  [见审批记录表 approval_record type]
	 */
	public static final Integer AUDIT_TYPE = 3;
	
	/** sku自进口单证审批状态######################start*/
	/**
	 * sku自进口单证审批状态
	 */
	// 自进口单证‘通过’
	public static final Integer AUDIT_STATUS_OWN_IMPORT_DOC_PASS = 9;
	// 自进口单证‘驳回’
	public static final Integer AUDIT_STATUS_OWN_IMPORT_DOC_REJECT = 10;
	/** sku自进口单证审批状态######################end*/
	
	
	/**审批结果############################################start*/
	/**
	 * 证件完整 1
	 */
	public static final Integer AUDIT_DECISION_DOC_FULL = 1;
	/**
	 * 证件缺失 2
	 */
	public static final Integer AUDIT_DECISION_DOC_DEFICIENCY = 2;
	/**
	 * 买手后补 3
	 */
	public static final Integer AUDIT_DECISION_POST_MEETING = 3;
	/**
	 * QA后补 4
	 */
	public static final Integer AUDIT_DECISION_QA_POST_MEETING = 4;
	/**
	 * 放行不补 5
	 */
	public static final Integer AUDIT_DECISION_NOT_POST_MEETING = 5;
	/**审批结果############################################end*/
	
	
	/**资质文件############################################start*/
	/**
	 * 工业产品生产许可证 1
	 */
	public static final Integer QUALIFY_DOC_TYPE_1 = 1;
	/**
	 * 珠宝鉴定证书 2
	 */
	public static final Integer QUALIFY_DOC_TYPE_2 = 2;
	/**
	 * CCC强制认证证书 3
	 */
	public static final Integer QUALIFY_DOC_TYPE_3 = 3;
	/**
	 * 农药登记证 4
	 */
	public static final Integer QUALIFY_DOC_TYPE_4 = 4;
	/**
	 * 涉水产品卫生许可证 (卫水字) 5
	 */
	public static final Integer QUALIFY_DOC_TYPE_5 = 5;
	/**
	 * 检测报告 6
	 */
	public static final Integer QUALIFY_DOC_TYPE_6 = 6;
	/**
	 * 中文标签 7
	 */
	public static final Integer QUALIFY_DOC_TYPE_7 = 7;

    /**
	 * 产品使用说明书 8
	 */
	public static final Integer QUALIFY_DOC_TYPE_8 = 8;
	/**资质文件############################################end*/
	
	
	/**进口单证############################################start*/
	/**
	 * 报关单 1
	 */
	public static final Integer IMPORT_DOC_TYPE_1 = 1;
	/**
	 * 入境货物检验检疫证明 2
	 */
	public static final Integer IMPORT_DOC_TYPE_2 = 2;
	/**
	 * 通关单 3
	 */
	public static final Integer IMPORT_DOC_TYPE_3 = 3;
	/**进口单证############################################end*/
	
	/**风险等级############################################start*/
	/**
	 * 高 1
	 */
	public static final Integer RISK_LEVEL_HIGH = 1;
	/**
	 * 中 2
	 */
	public static final Integer RISK_LEVEL_MIDDLE = 2;
	/**
	 * 底 3
	 */
	public static final Integer RISK_LEVEL_FUNDUS = 3;
	/**
	 * 无风险 4
	 */
	public static final Integer RISK_LEVEL_NO = 4;
	/**风险等级############################################end*/
	
	
	/** sku审批状态列表############################################start*/
	/**
	 * 自进口审批状态列表
	 */
	public static Map<Integer,Integer> ownImportedFlowTrend;
	
	/**
	 * 非自进口审批状态列表
	 */
	public static Map<Integer,Integer> otherImportedFlowTrend;
	
	/**
	 * 非进口审批状态列表
	 */
	public static Map<Integer,Integer> notImportedFlowTrend;
	
	/**
	 * SKU进口单证类型
	 */
	public static Map<Integer,String> qualifyDocTypes;
	
	/**
	 * SKU资质文件类型
	 */
	public static Map<Integer,String> importDocTypes;
	
	/**
	 * 风险等级
	 */
	public static Map<Integer,String> riskLevelMap;
	
	/**
	 * 审批结果
	 */
	public static Map<Integer,String> auditDecisionMap;
	
	/** sku审批状态列表############################################end*/
	
	/**
	 * 自进口审批状态流程列表
	 * @param isPass 通过/驳回
	 * @return
	 */
	public static Map<Integer,Integer> getOwnImportedFlowTrend(boolean isPass){
		ownImportedFlowTrend = new HashMap<Integer,Integer>();
		ownImportedFlowTrend.put(FLOW_TREND_SUBMIT_DOC, FLOW_TREND_IMPORTDEP_FIRST_AUDIT);
		if (isPass){
			ownImportedFlowTrend.put(FLOW_TREND_IMPORTDEP_FIRST_AUDIT, FLOW_TREND_QA_FIRST_AUDIT);
			ownImportedFlowTrend.put(FLOW_TREND_QA_FIRST_AUDIT, FLOW_TREND_AWAIT_CREATE_PURCHASE);
		}else{
			ownImportedFlowTrend.put(FLOW_TREND_IMPORTDEP_FIRST_AUDIT, FLOW_TREND_SUBMIT_DOC);
			ownImportedFlowTrend.put(FLOW_TREND_QA_FIRST_AUDIT, FLOW_TREND_SUBMIT_DOC);
		}
		//ownImportedFlowTrend.put(FLOW_TREND_AWAIT_CREATE_PURCHASE, FLOW_TREND_IMPORTDEP_SUBMIT_DOC);
		//ownImportedFlowTrend.put(FLOW_TREND_IMPORTDEP_SUBMIT_DOC, FLOW_TREND_QA_FINAL_AUDIT);
		ownImportedFlowTrend.put(FLOW_TREND_AWAIT_CREATE_PURCHASE, FLOW_TREND_QA_FINAL_AUDIT);
		if (isPass){
			ownImportedFlowTrend.put(FLOW_TREND_QA_FINAL_AUDIT, FLOW_TREND_PASS);
		}else{
			ownImportedFlowTrend.put(FLOW_TREND_QA_FINAL_AUDIT, FLOW_TREND_AWAIT_CREATE_PURCHASE);
		}
		return ownImportedFlowTrend;
	}
	
	/**
	 * 非自进口审批状态列表
	 * @param isPass 通过/驳回
	 * @return
	 */
	public static Map<Integer,Integer> getOtherImportedFlowTrend(boolean isPass,boolean isPostMeeting){
		otherImportedFlowTrend = new HashMap<Integer,Integer>();
		otherImportedFlowTrend.put(FLOW_TREND_SUBMIT_DOC, FLOW_TREND_IMPORTDEP_FIRST_AUDIT);
		if (isPass){
			otherImportedFlowTrend.put(FLOW_TREND_IMPORTDEP_FIRST_AUDIT, FLOW_TREND_QA_FINAL_AUDIT);
			//if (isPostMeeting){ // 通过需后补
			//	otherImportedFlowTrend.put(FLOW_TREND_QA_FINAL_AUDIT, FLOW_TREND_PASS_ISPOSTMEETING);
			//}else{
			//	otherImportedFlowTrend.put(FLOW_TREND_QA_FINAL_AUDIT, FLOW_TREND_AWAIT_CREATE_PURCHASE);
			//}
			otherImportedFlowTrend.put(FLOW_TREND_QA_FINAL_AUDIT, FLOW_TREND_AWAIT_CREATE_PURCHASE);
		}else{
			otherImportedFlowTrend.put(FLOW_TREND_IMPORTDEP_FIRST_AUDIT, FLOW_TREND_SUBMIT_DOC);
			otherImportedFlowTrend.put(FLOW_TREND_QA_FINAL_AUDIT, FLOW_TREND_SUBMIT_DOC);
		}
		//otherImportedFlowTrend.put(FLOW_TREND_AWAIT_CREATE_PURCHASE, FLOW_TREND_PASS);
		return otherImportedFlowTrend;
	}
	
	/**
	 * 非进口审批状态列表
	 * @param isPass 通过/驳回
	 * @return
	 */
	public static Map<Integer,Integer> getNotImportedFlowTrend(boolean isPass){
		notImportedFlowTrend = new HashMap<Integer,Integer>();
		notImportedFlowTrend.put(FLOW_TREND_SUBMIT_DOC, FLOW_TREND_QA_FINAL_AUDIT);
		if (isPass){
			notImportedFlowTrend.put(FLOW_TREND_QA_FINAL_AUDIT, FLOW_TREND_AWAIT_CREATE_PURCHASE);
		}else{
			notImportedFlowTrend.put(FLOW_TREND_QA_FINAL_AUDIT, FLOW_TREND_SUBMIT_DOC);
		}
		//notImportedFlowTrend.put(FLOW_TREND_AWAIT_CREATE_PURCHASE, FLOW_TREND_PASS);
		return notImportedFlowTrend;
	}

	public static Map<Integer, String> getQualifyDocTypes() {
		if (qualifyDocTypes != null){
			return qualifyDocTypes;
		}else{
			qualifyDocTypes = new HashMap<Integer,String>();
			qualifyDocTypes.put(QUALIFY_DOC_TYPE_1, "生产许可证");
			qualifyDocTypes.put(QUALIFY_DOC_TYPE_2, "珠宝鉴定证书");
			qualifyDocTypes.put(QUALIFY_DOC_TYPE_3, "CCC证书");
			qualifyDocTypes.put(QUALIFY_DOC_TYPE_4, "化妆品备案凭证");
			qualifyDocTypes.put(QUALIFY_DOC_TYPE_5, "卫生许可证");
			qualifyDocTypes.put(QUALIFY_DOC_TYPE_6, "检测报告");
			qualifyDocTypes.put(QUALIFY_DOC_TYPE_7, "有机产品认证证书");
			qualifyDocTypes.put(QUALIFY_DOC_TYPE_8, "产品使用说明书");
		}
		return qualifyDocTypes;
	}

	public static Map<Integer, String> getImportDocTypes() {
		if (importDocTypes != null){
			return importDocTypes;
		}else{
			importDocTypes = new HashMap<Integer,String>();
			importDocTypes.put(IMPORT_DOC_TYPE_1, "报关单");
			importDocTypes.put(IMPORT_DOC_TYPE_2, "入境货物检验检疫证明");
			importDocTypes.put(IMPORT_DOC_TYPE_3, "通关单");
		}
		return importDocTypes;
	}

	public static Map<Integer, String> getRiskLevelMap() {
		if (riskLevelMap != null){
			return riskLevelMap;
		}else{
			riskLevelMap = new HashMap<Integer,String>();
			riskLevelMap.put(RISK_LEVEL_HIGH, "高");
			riskLevelMap.put(RISK_LEVEL_MIDDLE, "中");
			riskLevelMap.put(RISK_LEVEL_FUNDUS, "底");
			riskLevelMap.put(RISK_LEVEL_NO, "无风险");
		}
		return riskLevelMap;
	}

	public static Map<Integer, String> getAuditDecisionMap() {
		if (auditDecisionMap != null){
			return auditDecisionMap;
		}else{
			auditDecisionMap = new HashMap<Integer,String>();
			auditDecisionMap.put(AUDIT_DECISION_DOC_FULL, "证件完整");
			auditDecisionMap.put(AUDIT_DECISION_DOC_DEFICIENCY, "证件缺失");
			auditDecisionMap.put(AUDIT_DECISION_POST_MEETING, "买手后补");
			auditDecisionMap.put(AUDIT_DECISION_QA_POST_MEETING, "QA后补");
			auditDecisionMap.put(AUDIT_DECISION_NOT_POST_MEETING, "放行不补");
		}
		return auditDecisionMap;
	}
	
}