/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.merchandise.enums;

import com.thebeastshop.common.enums.CodeEnum;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public enum SupplierKindEnum implements CodeEnum<Integer>
{
    NORMAL(1, "\u666e\u901a"),
    FLOWER(2, "\u9c9c\u82b1");

    private Integer code;
    private String name;
    private static final List<SupplierKindEnum> ALL;

    private SupplierKindEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    public static String getNameByCode(Integer code) {
        return ALL.stream().filter(item -> item.getCode().equals(code)).map(SupplierKindEnum::getName).findAny().orElse("");
    }

    public static SupplierKindEnum getEnumByCode(Integer code) {
        return ALL.stream().filter(item -> item.getCode().equals(code)).findAny().orElse(null);
    }

    public Integer getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    static {
        ALL = Collections.unmodifiableList(Arrays.asList(SupplierKindEnum.values()));
    }
}

