package com.thebeastshop.pegasus.merchandise.enums;

import java.util.Arrays;

/**
 * 供应商审核状态
 * -1驳回 0草稿 1品类经理审批 2财务审批 3审核完成
 */
public enum PcsSupplierOrderStatusEnum {

    /**
     * 供应商状态
     */
    REJECT(-1, "驳回"),
    DRAFT(0, "草稿"),
    /*MANAGER_AUDIT(1, "品类经理审批"),
    FINANCE_AUDIT(2, "财务审批"),*/
    AUDITING(1, "审核中"),
    AUDIT_COMPLETED(3, "审核完成")
    ;

    private Integer type;

    private String desc;

    PcsSupplierOrderStatusEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public static PcsSupplierOrderStatusEnum getEnumByType(Integer key){
        return Arrays.stream(PcsSupplierOrderStatusEnum.values()).filter(item->item.getType().equals(key))
                .findAny().orElse(null);
    }

    public static String getValueByKey(Integer key) {
        PcsSupplierOrderStatusEnum originEnum = getEnumByType(key);
        return originEnum == null ? "":originEnum.getDesc();
    }
}
