package com.thebeastshop.pegasus.component.coupon.domain.impl;

import java.io.IOException;
import java.util.Collection;
import java.util.Date;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.thebeastshop.pegasus.component.coupon.domain.CouponContent;
import com.thebeastshop.pegasus.component.coupon.enums.CouponSampleState;
import com.thebeastshop.pegasus.component.coupon.enums.CouponSendWay;
import com.thebeastshop.pegasus.component.coupon.enums.CouponType;
import com.thebeastshop.pegasus.component.coupon.enums.ProductScope;
import com.thebeastshop.support.AccessWay;
import com.thebeastshop.support.mark.State;
import com.thebeastshop.support.util.EnumUtil;
import org.apache.commons.collections.CollectionUtils;

/**
 * @author Liang Wenjian
 */
public class DefaultCouponSampleImpl extends CouponSampleTemplate {

	private Long id;
	private String name;
	private String title;
	private CouponType couponType;
	private String productDesc;
	private String couponContent;
	private int stateId;
	private Date createTime;
	private Date startTime;
	private Date expireTime;
	private String description;
	private String note;
	private Long creatorId;
	private Integer maxCount;
	private Integer balanceCount;
	private Integer maxPerMember;
	private CouponSendWay couponSendWay;
	private Collection<AccessWay> accessWays;
	private Collection<Long> categoryIds;
	private Collection<Long> productIds;
	private Collection<Long> excludeProductIds;
	private String couponCode;
	private String nickName;
	private ProductScope productScope;		//适用商品范围
	private Integer dateWay;
	private Integer dateNum;
	private Integer crossBorder;
	private Integer weekFlower;
	private Collection<String> offlineStoreIds;
	private Integer skipType;
	private String skipValue;

	public DefaultCouponSampleImpl() {
		super();
	}

	@Override
	public String getTitle() {
		return title;
	}

	@Override
	public CouponType getCouponType() {
		return couponType;
	}

	@Override
	public String getProductDesc() {
		return productDesc;
	}

	@Override
	public String getDescription() {
		return description;
	}

	@Override
	public Integer getMaxCount() {
		return maxCount;
	}

	@Override
	public Integer getBalanceCount() {
		return balanceCount;
	}

	@Override
	public Integer getMaxPerMember() {
		return maxPerMember;
	}

	@Override
	public Collection<AccessWay> getAccessWays() {
		return accessWays;
	}

	@Override
	public CouponSendWay getCouponSendWay() {
		return couponSendWay;
	}

	@Override
	public ProductScope getProductScope() {
		return productScope;
	}

	@Override
	public String getCouponContentJSON() {
		return couponContent;
	}

	@Override
	public CouponContent getCouponContent() {
		if (couponType == CouponType.CHEAPEN_LINE) {
			ObjectMapper mapper = new ObjectMapper();
			mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
			mapper.configure(DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES, false);
			try {
				FullCutPrice content = mapper.readValue(couponContent, FullCutPrice.class);
				return content;
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
		return null;
	}

	@Override
	public Collection<Long> getProductIds() {
		return productIds;
	}

	@Override
	public Collection<Long> getCategoryIds() {
		return categoryIds;
	}

	@Override
	public Collection<Long> getExcludeProductIds() {
		return excludeProductIds;
	}

	public String getCouponCode() {
		return couponCode;
	}

	public void setCouponCode(String couponCode) {
		this.couponCode = couponCode;
	}

	@Override
	public int getStateId() {
		return stateId;
	}

	@Override
	public Long getId() {
		return id;
	}

	@Override
	public Long getCreatorId() {
		return creatorId;
	}

	@Override
	public String getName() {
		return name;
	}

	@Override
	public Date getCreateTime() {
		return createTime;
	}

	@Override
	public Date getExpireTime() {
		return expireTime;
	}

	@Override
	public Date getStartTime() {
		return startTime;
	}

	@Override
	public String getNote() {
		return note;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public void setName(String name) {
		this.name = name;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public void setCouponType(CouponType couponType) {
		this.couponType = couponType;
	}

	public void setProductDesc(String productDesc) {
		this.productDesc = productDesc;
	}

	public void setCouponContent(String couponContent) {
		this.couponContent = couponContent;
	}

	public void setStateId(int stateId) {
		this.stateId = stateId;
	}

	public void setCreateTime(Date createTime) {
		this.createTime = createTime;
	}

	public void setStartTime(Date startTime) {
		this.startTime = startTime;
	}

	public void setExpireTime(Date expireTime) {
		this.expireTime = expireTime;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public void setNote(String note) {
		this.note = note;
	}

	public void setCreatorId(Long creatorId) {
		this.creatorId = creatorId;
	}

	public void setMaxCount(Integer maxCount) {
		this.maxCount = maxCount;
	}

	public void setMaxPerMember(Integer maxPerMember) {
		this.maxPerMember = maxPerMember;
	}

	public void setCouponSendWay(CouponSendWay couponSendWay) {
		this.couponSendWay = couponSendWay;
	}

	public void setAccessWays(Collection<AccessWay> accessWays) {
		this.accessWays = accessWays;
	}

	public void setProductIds(Collection<Long> productIds) {
		this.productIds = productIds;
	}

	public void setBalanceCount(Integer balanceCount) {
		this.balanceCount = balanceCount;
	}

	public void setCategoryIds(Collection<Long> categoryIds) {
		this.categoryIds = categoryIds;
	}

	public void setExcludeProductIds(Collection<Long> excludeProductIds) {
		this.excludeProductIds = excludeProductIds;
	}

	public void setProductScope(ProductScope productScope) {
		this.productScope = productScope;
	}

	public String getNickName() {
		return nickName;
	}

	public void setNickName(String nickName) {
		this.nickName = nickName;
	}

	public Integer getDateWay() {
		return dateWay;
	}

	public void setDateWay(Integer dateWay) {
		this.dateWay = dateWay;
	}

	public Integer getDateNum() {
		return dateNum;
	}

	public void setDateNum(Integer dateNum) {
		this.dateNum = dateNum;
	}

	public Integer getCrossBorder() {
		return crossBorder;
	}

	public void setCrossBorder(Integer crossBorder) {
		this.crossBorder = crossBorder;
	}

	public Integer getWeekFlower() {
		return weekFlower;
	}

	public void setWeekFlower(Integer weekFlower) {
		this.weekFlower = weekFlower;
	}

	@Override
	public State getState() {
		return EnumUtil.valueOf(getStateId(), CouponSampleState.class);
	}

	@Override
	public boolean isForAllProducts() {
		if (CollectionUtils.isEmpty(this.getProductIds()) && CollectionUtils.isEmpty(this.getCategoryIds())) {
			return true;
		} else {
			return false;
		}
	}

	@Override
	public boolean isExpired() {
		return expireTime.before(new Date());
	}

	@Override
	public Collection<String> getOfflineStoreIds() {
		return offlineStoreIds;
	}

	public void setOfflineStoreIds(Collection<String> offlineStoreIds) {
		this.offlineStoreIds = offlineStoreIds;
	}

	@Override
	public Integer getSkipType() {
		return skipType;
	}

	public void setSkipType(Integer skipType) {
		this.skipType = skipType;
	}

	@Override
	public String getSkipValue() {
		return skipValue;
	}

	public void setSkipValue(String skipValue) {
		this.skipValue = skipValue;
	}
}
