package com.thebeastshop.pegasus.component.coupon.dto;

import com.thebeastshop.common.BaseDO;

/**
 * @Author:GoodMan.Liang
 * @Date:2017/6/20
 * @Desc:ezr线上发券数据传输对象
 * */
public class OnlineGiveOutCouponDTO extends BaseDO {
    private String Brand;               //所属品牌编号
    private String OldCode;             //客户卡号针对会员发放券（本字段可能为空-粉丝会员）
    private String WxOpenID;            //微信卡号
    private String CoupNo;              //券号码
    private String CoupName;            //券显示名称
    private int CoupType;               //券类型1=品牌代金券2=品牌折扣券3=品牌促销券4=礼品券5=邀请券10=异业券
    private String PromotionCode;       //促销代号（只有 品牌促销券类型需要传递）
    private double CoupValue;           //券面额(小数点2位)
    private double PriceLimit;          //券使用门槛 0表示无门槛
    private String BegDate;             //有效开始日期(yyyy-MM-dd格式)
    private String EndDate;             //	有效结束日期(yyyy-MM-dd格式)
    private String Guide;               //使用说明
    private String ApplyType;           //组织类型全部用户 : BD 片区用户：PQ 店群用户：GP 门店用户：SH
    private String ApplyShops;          //适用门店编码列表为空表示不限制 多个门店使用逗号分隔

    public String getBrand() {
        return Brand;
    }

    public void setBrand(String brand) {
        Brand = brand;
    }

    public String getOldCode() {
        return OldCode;
    }

    public void setOldCode(String oldCode) {
        OldCode = oldCode;
    }

    public String getWxOpenID() {
        return WxOpenID;
    }

    public void setWxOpenID(String wxOpenID) {
        WxOpenID = wxOpenID;
    }

    public String getCoupNo() {
        return CoupNo;
    }

    public void setCoupNo(String coupNo) {
        CoupNo = coupNo;
    }

    public String getCoupName() {
        return CoupName;
    }

    public void setCoupName(String coupName) {
        CoupName = coupName;
    }

    public int getCoupType() {
        return CoupType;
    }

    public void setCoupType(int coupType) {
        CoupType = coupType;
    }

    public String getPromotionCode() {
        return PromotionCode;
    }

    public void setPromotionCode(String promotionCode) {
        PromotionCode = promotionCode;
    }

    public double getCoupValue() {
        return CoupValue;
    }

    public void setCoupValue(double coupValue) {
        CoupValue = coupValue;
    }

    public double getPriceLimit() {
        return PriceLimit;
    }

    public void setPriceLimit(double priceLimit) {
        PriceLimit = priceLimit;
    }

    public String getBegDate() {
        return BegDate;
    }

    public void setBegDate(String begDate) {
        BegDate = begDate;
    }

    public String getEndDate() {
        return EndDate;
    }

    public void setEndDate(String endDate) {
        EndDate = endDate;
    }

    public String getGuide() {
        return Guide;
    }

    public void setGuide(String guide) {
        Guide = guide;
    }

    public String getApplyType() {
        return ApplyType;
    }

    public void setApplyType(String applyType) {
        ApplyType = applyType;
    }

    public String getApplyShops() {
        return ApplyShops;
    }

    public void setApplyShops(String applyShops) {
        ApplyShops = applyShops;
    }
}
