package com.thebeastshop.pegasus.component.coupon.service.impl;

import com.thebeastshop.pegasus.component.coupon.condition.CouponCondition;
import com.thebeastshop.pegasus.component.coupon.condition.CouponSetCondition;
import com.thebeastshop.pegasus.component.coupon.dao.mapper.CouponSetEntityMapper;
import com.thebeastshop.pegasus.component.coupon.domain.Coupon;
import com.thebeastshop.pegasus.component.coupon.model.CouponSetEntity;
import com.thebeastshop.pegasus.component.coupon.service.BaseService;
import com.thebeastshop.pegasus.component.coupon.service.CouponService;
import com.thebeastshop.pegasus.component.coupon.service.CouponSetService;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * 
 * @author Paul-xiong
 *
 */
@Service
public class CouponSetServiceImpl extends BaseService implements CouponSetService {

	@Autowired
	private CouponSetEntityMapper couponSetEntityMapper;

	@Autowired
	private CouponService couponService;


	@Override
	public Boolean createCouponSet(CouponSetEntity domain) {
		int id = couponSetEntityMapper.insertSelective(domain);
		return id > 0 ? true :false;
	}

	@Override
	public Boolean updateCouponSet(CouponSetEntity domain) {
		int count = couponSetEntityMapper.updateByPrimaryKeySelective(domain);
		return count > 0 ? true :false;
	}

	@Override
	public List<CouponSetEntity> getCouponSetsByCondition(CouponSetCondition condition) {
		List<CouponSetEntity> entityList = couponSetEntityMapper.getCouponSetsByCondition(condition);
		return entityList;
	}

	@Override
	public List<Long> getCouponSampleIdsByCondition(CouponSetCondition condition) {
		List<CouponSetEntity> entityList = couponSetEntityMapper.getCouponSetsByCondition(condition);
		List<Long> list = new ArrayList<>();
		for(CouponSetEntity entity : entityList){
			String csId = entity.getCouponSampleId();
			String[] cSampleIds = csId.split(",");
			for (int i = 0; i < cSampleIds.length; i++) {
				list.add(Long.valueOf(cSampleIds[i]));
			}
		}
		return list;
	}

	@Override
	public Boolean isSendCouponSetByCondition(CouponSetCondition condition) {
		Long memberId = condition.getMemberId();
		List<CouponSetEntity> entityList = couponSetEntityMapper.getCouponSetsByCondition(condition);
		List<Long> list = new ArrayList<>();
		if(CollectionUtils.isNotEmpty(entityList)) {
			for (CouponSetEntity entity : entityList) {
				String csId = entity.getCouponSampleId();
				String[] cSampleIds = csId.split(",");
				for (int i = 0; i < cSampleIds.length; i++) {
					Long cSampleId = Long.valueOf(cSampleIds[i]);
					CouponCondition couponCondition = new CouponCondition();
					couponCondition.setOwnerId(memberId);
					couponCondition.setCouponSampleId(cSampleId);
					List<Coupon> coupons = couponService.getCouponsByCondition(couponCondition);
					Boolean flag = CollectionUtils.isNotEmpty(coupons) ? true : false;
					if (flag) return true;
				}
			}
		}
		return false;
	}
}
