/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.component.coupon.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.thebeastshop.pegasus.component.coupon.condition.CouponCodeExchangeCondition;
import com.thebeastshop.pegasus.component.coupon.condition.CouponCondition;
import com.thebeastshop.pegasus.component.coupon.condition.CouponSetCondition;
import com.thebeastshop.pegasus.component.coupon.dao.CouponDao;
import com.thebeastshop.pegasus.component.coupon.domain.Coupon;
import com.thebeastshop.pegasus.component.coupon.domain.CouponCodeExchange;
import com.thebeastshop.pegasus.component.coupon.domain.CouponCount;
import com.thebeastshop.pegasus.component.coupon.domain.CouponSample;
import com.thebeastshop.pegasus.component.coupon.domain.impl.CouponWrapper;
import com.thebeastshop.pegasus.component.coupon.domain.impl.DefaultCouponCodeImpl;
import com.thebeastshop.pegasus.component.coupon.domain.impl.DefaultCouponImpl;
import com.thebeastshop.pegasus.component.coupon.domain.impl.DefaultCouponSampleImpl;
import com.thebeastshop.pegasus.component.coupon.enums.CouponSampleState;
import com.thebeastshop.pegasus.component.coupon.model.CouponEntity;
import com.thebeastshop.pegasus.component.coupon.model.CouponMemberCount;
import com.thebeastshop.pegasus.component.coupon.model.VerificationCoupon;
import com.thebeastshop.pegasus.component.coupon.service.BaseService;
import com.thebeastshop.pegasus.component.coupon.service.CouponCodeExchangeService;
import com.thebeastshop.pegasus.component.coupon.service.CouponCodeService;
import com.thebeastshop.pegasus.component.coupon.service.CouponSampleService;
import com.thebeastshop.pegasus.component.coupon.service.CouponService;
import com.thebeastshop.pegasus.component.coupon.service.CouponSetService;
import com.thebeastshop.pegasus.component.coupon.util.ConnectionFactory;
import com.thebeastshop.pegasus.component.coupon.util.ConsJson;
import com.thebeastshop.pegasus.component.coupon.util.HttpKit;
import com.thebeastshop.pegasus.component.coupon.util.PropertyConfigurer;
import com.thebeastshop.support.exception.WrongArgException;
import com.thebeastshop.support.exception.WrongStateException;
import com.thebeastshop.support.vo.NameValuePair;
import java.sql.Connection;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CouponServiceImpl
extends BaseService
implements CouponService {
    private static final Logger logger = LoggerFactory.getLogger(CouponServiceImpl.class);
    @Autowired
    private CouponSampleService couponSampleService;
    @Autowired
    private CouponDao couponDao;
    @Autowired
    private PropertyConfigurer propertyConfigurer;
    @Autowired
    private CouponSetService couponSetService;
    @Autowired
    CouponCodeService couponCodeService;
    @Autowired
    CouponCodeExchangeService couponCodeExchangeService;

    @Override
    public Coupon getById(long id) {
        Coupon obj = this.couponDao.getById(id);
        if (obj == null) {
            throw new WrongArgException("\u4f18\u60e0\u5238\u6a21\u677f\u4e0d\u5b58\u5728", "id", (Object)id);
        }
        return obj;
    }

    @Override
    public List<Coupon> getCoupons(long ownerId) {
        return this.couponDao.getCoupons(ownerId);
    }

    @Override
    public List<Coupon> getCoupons(long ownerId, Long couponSampleId) {
        return this.couponDao.getCoupons(ownerId, couponSampleId);
    }

    @Override
    public List<Coupon> getUsableCoupons(long ownerId) {
        return this.couponDao.getUsableCoupons(ownerId);
    }

    @Override
    public List<Coupon> getExpiredCoupons(long ownerId) {
        return this.couponDao.getExpiredCoupons(ownerId);
    }

    @Override
    public List<Coupon> getUsedCoupons(long ownerId) {
        return this.couponDao.getUsedCoupons(ownerId);
    }

    @Override
    public List<Coupon> getCouponsByCondition(CouponCondition condition) {
        return this.couponDao.getCouponsByCondition(condition);
    }

    @Override
    public CouponCount queryCouponCount(CouponCondition condition) {
        return this.couponDao.countCouponByCondition(condition);
    }

    @Override
    public Coupon create(Coupon coupon) {
        return this.couponDao.create(coupon);
    }

    @Override
    public void invalid(Coupon coupon) {
        CouponWrapper<Coupon> couponImpl = new CouponWrapper<Coupon>(coupon){

            @Override
            public boolean isValid() {
                return false;
            }
        };
        this.update(couponImpl);
    }

    @Override
    @Transactional
    public Coupon send(CouponSample couponSample, long memberId) {
        if (couponSample == null) {
            throw new WrongArgException("\u53d1\u9001\u4f18\u60e0\u5238\u5931\u8d25", "couponSample", (Object)couponSample);
        }
        if (couponSample.getState() == null) {
            throw new WrongArgException("\u53d1\u9001\u4f18\u60e0\u5238\u5931\u8d25", "couponSample.state", (Object)couponSample.getState());
        }
        if (!CouponSampleState.ONLINE.getId().equals(couponSample.getState().getId())) {
            throw new WrongArgException("\u4f18\u60e0\u5238\u672a\u901a\u8fc7\u5ba1\u6279\u6216\u5df2\u5e9f\u5f03", new NameValuePair[0]);
        }
        if (couponSample.getBalanceCount() <= 0) {
            throw new WrongArgException("\u4f18\u60e0\u5238\u5df2\u53d1\u5b8c", new NameValuePair[0]);
        }
        Integer perMemberCount = this.getCouponsCount(memberId, couponSample.getId());
        if (perMemberCount >= couponSample.getMaxPerMember()) {
            throw new WrongStateException("\u83b7\u5f97" + couponSample.getName() + "\u7684\u4f18\u60e0\u5238\u5df2\u8fbe\u5230\u4e0a\u9650\u3002", "member{id=" + memberId + "}.coupons{couponSampleId=" + couponSample.getId() + "}.size", (Object)couponSample.getMaxPerMember());
        }
        DefaultCouponSampleImpl couponSampleImpl = (DefaultCouponSampleImpl)couponSample;
        boolean ret = this.couponSampleService.decBalanceCount(couponSampleImpl);
        if (!ret) {
            throw new WrongArgException("\u4f18\u60e0\u5238\u5df2\u53d1\u5b8c", new NameValuePair[0]);
        }
        DefaultCouponImpl coupon = new DefaultCouponImpl();
        coupon.setCouponSampleId(couponSample.getId());
        if (couponSample.getDateWay() != null && couponSample.getDateWay() == 2) {
            try {
                Date currDate = new Date();
                coupon.setStartTime(currDate);
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                String currDateStr = dateFormat.format(currDate);
                dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                Date date = dateFormat.parse(currDateStr + " 23:59:51");
                Calendar cal = Calendar.getInstance();
                cal.setTime(date);
                cal.add(5, couponSample.getDateNum());
                coupon.setExpireTime(cal.getTime());
            }
            catch (Exception e) {}
        } else {
            coupon.setStartTime(couponSample.getStartTime());
            coupon.setExpireTime(couponSample.getExpireTime());
        }
        coupon.setNote(couponSample.getNote());
        coupon.setOwnerId(memberId);
        coupon.setUsed(false);
        coupon.setValid(true);
        return this.create(coupon);
    }

    @Override
    @Transactional
    public CouponCodeExchange sendOffline(CouponSample couponSample, long memberId) {
        Coupon coupon = this.send(couponSample, memberId);
        String code = "";
        do {
            code = String.valueOf((int)(Math.random() * 9000.0) + 1000);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("csid", couponSample.getId());
            map.put("code", code);
        } while (this.couponCodeService.getValidByCode(code) != null);
        DefaultCouponCodeImpl couponCode = new DefaultCouponCodeImpl();
        couponCode.setCouponSampleId(couponSample.getId());
        couponCode.setCode(code);
        couponCode.setCreatorId(couponSample.getCreatorId());
        couponCode.setCreateTime(new Date());
        couponCode.setNote(couponSample.getNote());
        this.couponCodeService.create(couponCode);
        CouponCodeExchange createObj = new CouponCodeExchange();
        createObj.setCode(code);
        createObj.setCouponId(coupon.getId());
        createObj.setCouponSampleId(couponSample.getId());
        createObj.setOwnerId(memberId);
        return this.couponCodeExchangeService.create(createObj);
    }

    @Override
    @Transactional
    public Coupon checkOffline(String code, long memberId, String storeId) {
        if (StringUtils.isBlank((CharSequence)code)) {
            throw new WrongArgException("\u5151\u6362\u7801\u4e0d\u80fd\u4e3a\u7a7a", "code", (Object)code);
        }
        if (StringUtils.isBlank((CharSequence)storeId)) {
            throw new WrongArgException("\u5e97\u94fa\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a", "storeId", (Object)storeId);
        }
        CouponCodeExchangeCondition couponCodeExchangeCondition = new CouponCodeExchangeCondition();
        couponCodeExchangeCondition.setOwnerId(memberId);
        couponCodeExchangeCondition.setCode(code);
        List<CouponCodeExchange> couponCodeExchangeList = this.couponCodeExchangeService.getByCondition(couponCodeExchangeCondition);
        if (CollectionUtils.isEmpty(couponCodeExchangeList)) {
            throw new WrongArgException("\u5151\u6362\u7801\u4e0d\u5b58\u5728", "code", (Object)code);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("memberId", memberId);
        map.put("code", code);
        map.put("storeId", storeId);
        CouponEntity obj = this.selectValidByMap(map);
        if (obj == null) {
            throw new WrongArgException("\u8be5\u4f18\u60e0\u7801\u5df2\u7ecf\u88ab\u4f7f\u7528\u8fc7", "code", (Object)code);
        }
        String offlineStoreIds = obj.getOfflineStoreIds();
        if (offlineStoreIds != null && offlineStoreIds.contains(storeId)) {
            throw new WrongArgException("\u4f18\u60e0\u7801\u5728\u8be5\u7ebf\u4e0b\u95e8\u5e97\u4e0d\u80fd\u4f7f\u7528", "code", (Object)code);
        }
        CouponSample couponSample = this.couponSampleService.getById(obj.getCouponSampleId());
        if (!(couponSample.getDateWay() != null && couponSample.getDateWay() == 2 || CouponSampleState.ONLINE.equals(couponSample.getState()) && !couponSample.isExpired())) {
            throw new WrongArgException("\u5151\u6362\u7801\u5df2\u8fc7\u671f", "state", (Object)couponSample.getState());
        }
        CouponCodeExchangeCondition condition = new CouponCodeExchangeCondition();
        condition.setOwnerId(memberId);
        condition.setCouponSampleId(couponSample.getId());
        condition.setCode(code);
        List<CouponCodeExchange> exchanges = this.couponCodeExchangeService.getByCondition(condition);
        if (exchanges.size() >= couponSample.getMaxPerMember()) {
            throw new WrongArgException("\u4f18\u60e0\u5238\u8d85\u8fc7\u9650\u9886\u6570\u91cf", "code", (Object)code);
        }
        return this.getById(obj.getId());
    }

    @Override
    @Transactional
    public Boolean sendCheck(CouponSample couponSample, long memberId) {
        if (couponSample == null) {
            return false;
        }
        if (couponSample.getState() == null) {
            return false;
        }
        if (!CouponSampleState.ONLINE.getId().equals(couponSample.getState().getId())) {
            return false;
        }
        if (couponSample.getBalanceCount() <= 0) {
            return false;
        }
        Integer perMemberCount = this.getCouponsCount(memberId, couponSample.getId());
        if (perMemberCount >= couponSample.getMaxPerMember()) {
            return false;
        }
        DefaultCouponSampleImpl couponSampleImpl = (DefaultCouponSampleImpl)couponSample;
        boolean ret = this.couponSampleService.decBalanceCount(couponSampleImpl);
        if (!ret) {
            return false;
        }
        DefaultCouponImpl coupon = new DefaultCouponImpl();
        coupon.setCouponSampleId(couponSample.getId());
        coupon.setNote(couponSample.getNote());
        coupon.setOwnerId(memberId);
        if (couponSample.getDateWay() != null && couponSample.getDateWay() == 2) {
            try {
                Date currDate = new Date();
                coupon.setStartTime(currDate);
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                String currDateStr = dateFormat.format(currDate);
                dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                Date date = dateFormat.parse(currDateStr + " 23:59:51");
                Calendar cal = Calendar.getInstance();
                cal.setTime(date);
                cal.add(5, couponSample.getDateNum());
                coupon.setExpireTime(cal.getTime());
            }
            catch (Exception e) {}
        } else {
            coupon.setStartTime(couponSample.getStartTime());
            coupon.setExpireTime(couponSample.getExpireTime());
        }
        coupon.setUsed(false);
        coupon.setValid(true);
        this.create(coupon);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public Boolean sendCouponList(CouponSample couponSample, Collection<Long> memberIds) {
        if (couponSample == null) {
            throw new WrongArgException("\u53d1\u9001\u4f18\u60e0\u5238\u5931\u8d25", "couponSample", (Object)couponSample);
        }
        if (couponSample.getState() == null) {
            throw new WrongArgException("\u53d1\u9001\u4f18\u60e0\u5238\u5931\u8d25", "couponSample.state", (Object)couponSample.getState());
        }
        if (!CouponSampleState.ONLINE.getId().equals(couponSample.getState().getId())) {
            throw new WrongArgException("\u4f18\u60e0\u5238\u672a\u901a\u8fc7\u5ba1\u6279\u6216\u5df2\u5e9f\u5f03", new NameValuePair[0]);
        }
        if (couponSample.getBalanceCount() <= 0 || couponSample.getBalanceCount() < memberIds.size()) {
            throw new WrongArgException("\u4f18\u60e0\u5238\u4e0d\u8db3", new NameValuePair[0]);
        }
        ArrayList<DefaultCouponImpl> clist = new ArrayList<DefaultCouponImpl>();
        for (Long memberId : memberIds) {
            DefaultCouponImpl coupon = new DefaultCouponImpl();
            coupon.setCouponSampleId(couponSample.getId());
            coupon.setNote(couponSample.getNote());
            coupon.setOwnerId(memberId);
            if (couponSample.getDateWay() != null && couponSample.getDateWay() == 2) {
                try {
                    Date currDate = new Date();
                    coupon.setStartTime(currDate);
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                    String currDateStr = dateFormat.format(currDate);
                    dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    Date date = dateFormat.parse(currDateStr + " 23:59:51");
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(date);
                    cal.add(5, couponSample.getDateNum());
                    coupon.setExpireTime(cal.getTime());
                }
                catch (Exception e) {}
            } else {
                coupon.setStartTime(couponSample.getStartTime());
                coupon.setExpireTime(couponSample.getExpireTime());
            }
            coupon.setUsed(false);
            coupon.setValid(true);
            clist.add(coupon);
        }
        Long startTime = System.currentTimeMillis();
        Connection conn = null;
        Statement ps = null;
        try {
            conn = ConnectionFactory.getConnection(this.propertyConfigurer);
            conn.setAutoCommit(false);
            StringBuffer sb = new StringBuffer();
            sb.append("INSERT INTO COUPON (COUPON_SAMPLE_ID, OWNER_ID, IS_USED,").append(" IS_VALID, NOTE, START_TIME,EXPIRE_TIME, CREATE_TIME) ").append(" VALUES (?,?,?,?,?,?,?,?) ");
            int i1 = 1;
            int i2 = 2;
            int i3 = 3;
            int i4 = 4;
            int i5 = 5;
            int i6 = 6;
            int i7 = 7;
            int i8 = 8;
            ps = conn.prepareStatement(sb.toString());
            int batchSize = 1000;
            int count = 0;
            for (Coupon coupon : clist) {
                ps.setLong(i1, coupon.getCouponSampleId());
                ps.setLong(i2, coupon.getOwnerId());
                ps.setInt(i3, coupon.isUsed() ? 1 : 0);
                ps.setInt(i4, coupon.isValid() ? 1 : 0);
                ps.setString(i5, coupon.getNote());
                ps.setTimestamp(i6, new Timestamp(coupon.getStartTime() != null ? Long.valueOf(coupon.getStartTime().getTime()) : null));
                ps.setTimestamp(i7, new Timestamp(coupon.getExpireTime() != null ? Long.valueOf(coupon.getExpireTime().getTime()) : null));
                ps.setTimestamp(i8, new Timestamp(new Date().getTime()));
                ps.addBatch();
                if (++count % 1000 != 0) continue;
                ps.executeBatch();
                ps.clearBatch();
            }
            ps.executeBatch();
            conn.commit();
            DefaultCouponSampleImpl couponSampleImpl = (DefaultCouponSampleImpl)couponSample;
            couponSampleImpl.setBalanceCount(couponSample.getBalanceCount() - clist.size());
            boolean bl = this.couponSampleService.update(couponSampleImpl);
            Long endTime = System.currentTimeMillis();
            System.out.println("OK,\u7528\u65f6\uff1a" + (endTime - startTime) / 1000L);
            ps.close();
            conn.close();
            Boolean bl2 = true;
            return bl2;
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                conn.rollback();
            }
            catch (Exception e1) {
                System.out.println("\u6279\u5904\u7406\u53d1\u751f\u5f02\u5e38" + e.getMessage());
            }
            Boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception se2) {}
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception se) {
                se.printStackTrace();
            }
        }
    }

    @Override
    public Boolean update(Coupon obj) {
        return this.couponDao.update(obj);
    }

    @Override
    public void use(Coupon obj) {
        if (obj != null) {
            CouponWrapper<Coupon> coupon = new CouponWrapper<Coupon>(obj){

                @Override
                public boolean isUsed() {
                    return true;
                }
            };
            logger.info("\u6b63\u5728\u4f7f\u7528\u4f18\u60e0\u5238" + coupon.getId());
            if (this.update(coupon).booleanValue()) {
                try {
                    logger.info("\u4f18\u60e0\u5238" + coupon.getId() + "\u5df2\u7ecf\u4f7f\u7528\u8fc7\uff0c\u5c06\u901a\u8fc7ezr\u6838\u9500");
                    logger.info("\u5f00\u59cb\u6838\u9500id\u4e3a" + coupon.getId() + "\u7684\u4f18\u60e0\u5238");
                    String ezrCouponCode = this.couponDao.getEZRCouponCodeByCid(coupon.getId());
                    if (StringUtils.isNotEmpty((CharSequence)ezrCouponCode)) {
                        ConsJson consJson = new ConsJson();
                        VerificationCoupon vo = this.covertVerificationCouponForEzr(ezrCouponCode);
                        HashMap<String, String> buildParams = new HashMap<String, String>();
                        buildParams.put("Args", consJson.Object2Json(vo));
                        String jsonObj = HttpKit.post(this.propertyConfigurer.getEzrServiceUrl() + "/coupon/verificationCoupon", buildParams, "");
                        JSONObject res = JSONObject.parseObject((String)jsonObj);
                        if (res.getBoolean("Status").booleanValue()) {
                            logger.info("\u6838\u9500" + ezrCouponCode + "\u6210\u529f");
                        } else {
                            logger.error("\u6838\u9500" + ezrCouponCode + "\u5931\u8d25");
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.error("\u6838\u9500\u5238" + coupon.getId() + "\u62a5\u9519\u3002");
                }
            }
        }
    }

    private VerificationCoupon covertVerificationCouponForEzr(String ezrCouponCode) {
        VerificationCoupon vo = new VerificationCoupon();
        vo.setSalesNo("ezr0000011");
        vo.setShopCode("CHN2018");
        String[] couponNos = new String[]{ezrCouponCode};
        vo.setCouponNos(couponNos);
        return vo;
    }

    @Override
    public void use(Long couponId) {
        this.use(this.getById(couponId));
    }

    @Override
    public int getCouponsCount(long ownerId) {
        return this.getCoupons(ownerId).size();
    }

    @Override
    public int getCouponsCount(long ownerId, Long couponSampleId) {
        return this.getCoupons(ownerId, couponSampleId).size();
    }

    @Override
    public int getUsableCouponsCount(long ownerId) {
        return this.getUsableCoupons(ownerId).size();
    }

    @Override
    public int getExpiredCouponsCount(long ownerId) {
        return this.getExpiredCoupons(ownerId).size();
    }

    @Override
    public List<Coupon> getNotExpiredCoupons(long ownerId) {
        return this.couponDao.getNotExpiredCoupons(ownerId);
    }

    @Override
    public int getNotExpiredCouponsCount(long ownerId) {
        return this.getNotExpiredCoupons(ownerId).size();
    }

    @Override
    public int getUsedCouponsCount(long ownerId) {
        return this.getUsedCoupons(ownerId).size();
    }

    @Override
    public Collection<Coupon> create(Collection<Coupon> coupons) {
        ArrayList list = Lists.newArrayList();
        for (Coupon coupon : coupons) {
            list.add(this.create(coupon));
        }
        return list;
    }

    @Override
    public void invalid(Collection<Coupon> coupons) {
        for (Coupon coupon : coupons) {
            this.invalid(coupon);
        }
    }

    @Override
    @Transactional
    public Collection<Coupon> send(CouponSample couponSample, Collection<Long> memberIds) {
        ArrayList list = Lists.newArrayList();
        for (Long memberId : memberIds) {
            list.add(this.send(couponSample, memberId));
        }
        return list;
    }

    @Override
    @Transactional
    public Boolean sendCouponsToMemberIds(Collection<Long> ids, Collection<Long> memberIds) {
        CouponSetCondition condition = new CouponSetCondition();
        condition.setIds(ids);
        List<Long> couponSampleList = this.couponSetService.getCouponSampleIdsByCondition(condition);
        if (CollectionUtils.isNotEmpty(couponSampleList)) {
            for (Long couponSampleId : couponSampleList) {
                for (Long memberId : memberIds) {
                    CouponSample couponSample = this.couponSampleService.getById(couponSampleId);
                    this.sendCheck(couponSample, memberId);
                }
            }
        }
        return true;
    }

    @Override
    @Transactional
    public String getEZRCouponCodeByCid(Long couponId) {
        return this.couponDao.getEZRCouponCodeByCid(couponId);
    }

    @Override
    public Boolean mergeCoupon(Long mainId, Long subId) {
        Boolean result = this.couponDao.mergeCoupon(mainId, subId) > 0;
        if (result.booleanValue()) {
            logger.info("\u5408\u5e76\u4f1a\u5458\u7f16\u53f7\u4e3a" + subId + "\u7684\u4f18\u60e0\u5238\u5230\u7f16\u53f7\u4e3a:" + mainId + "\u7684\u4f1a\u5458\u8d26\u6237");
        }
        return result;
    }

    @Override
    public void unuse(Long couponId) {
        Coupon obj = this.getById(couponId);
        if (obj != null) {
            CouponWrapper<Coupon> coupon = new CouponWrapper<Coupon>(obj){

                @Override
                public boolean isUsed() {
                    return false;
                }
            };
            this.update(coupon);
        }
    }

    @Override
    public List<CouponMemberCount> getAllCouponsByExpireTime(Date expireTime, Integer currentPage, Integer pageSize) {
        return this.couponDao.getAllCouponsByExpireTime(expireTime, currentPage, pageSize);
    }

    @Override
    public CouponEntity selectValidByMap(Map<String, Object> map) {
        return this.couponDao.selectValidByMap(map);
    }
}

