/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.component.coupon.service.impl;

import com.google.common.collect.Lists;
import com.thebeastshop.pegasus.component.coupon.condition.CouponSampleThirdPartyCondition;
import com.thebeastshop.pegasus.component.coupon.dao.mapper.CouponCodeThirdPartyEntityMapper;
import com.thebeastshop.pegasus.component.coupon.dao.mapper.CouponSampleThirdPartyEntityMapper;
import com.thebeastshop.pegasus.component.coupon.model.CouponCodeThirdPartyEntity;
import com.thebeastshop.pegasus.component.coupon.model.CouponSampleThirdPartyEntity;
import com.thebeastshop.pegasus.component.coupon.service.BaseService;
import com.thebeastshop.pegasus.component.coupon.service.CouponSampleThirdPartyService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CouponSampleThirdPartyServiceImpl
extends BaseService
implements CouponSampleThirdPartyService {
    @Autowired
    private CouponSampleThirdPartyEntityMapper couponSampleThirdPartyEntityMapper;
    @Autowired
    private CouponCodeThirdPartyEntityMapper couponCodeThirdPartyEntityMapper;

    @Override
    @Transactional
    public Boolean createCouponSampleThirdParty(CouponSampleThirdPartyEntity domain, List<String> codes) {
        int id = this.couponSampleThirdPartyEntityMapper.insertSelective(domain);
        this.batchCouponCodes(domain, codes);
        return id > 0;
    }

    @Override
    @Transactional
    public Boolean updateCouponSampleThirdParty(CouponSampleThirdPartyEntity domain, List<String> codes) {
        CouponSampleThirdPartyEntity oldEntity = this.couponSampleThirdPartyEntityMapper.selectByPrimaryKey(domain.getId());
        if (CollectionUtils.isEmpty(codes)) {
            domain.setBalanceCount(oldEntity.getBalanceCount());
            domain.setMaxCount(oldEntity.getMaxCount());
            domain.setCreateUserId(oldEntity.getCreateUserId());
        } else {
            this.batchCouponCodes(domain, codes);
            Integer addSize = codes.size();
            domain.setBalanceCount(oldEntity.getBalanceCount() + addSize);
            domain.setMaxCount(oldEntity.getMaxCount() + addSize);
            domain.setCreateUserId(oldEntity.getCreateUserId());
        }
        int count = this.couponSampleThirdPartyEntityMapper.updateByPrimaryKeySelective(domain);
        return count > 0;
    }

    @Override
    public List<CouponSampleThirdPartyEntity> getCouponSampleThirdPartysByCondition(CouponSampleThirdPartyCondition condition) {
        List<CouponSampleThirdPartyEntity> entityList = this.couponSampleThirdPartyEntityMapper.getCouponSampleThirdPartysByCondition(condition);
        return entityList;
    }

    private void batchCouponCodes(CouponSampleThirdPartyEntity domain, List<String> codes) {
        if (CollectionUtils.isNotEmpty(codes)) {
            for (String code : codes) {
                CouponCodeThirdPartyEntity codeEntity = new CouponCodeThirdPartyEntity();
                codeEntity.setCode(code);
                codeEntity.setCstpId(domain.getId());
                codeEntity.setCreateUserId(domain.getCreateUserId());
                codeEntity.setCreateTime(new Date());
                codeEntity.setUpdateTime(new Date());
                codeEntity.setActive(true);
                codeEntity.setStatus(1);
                this.couponCodeThirdPartyEntityMapper.insertSelective(codeEntity);
            }
        }
    }

    @Override
    public CouponSampleThirdPartyEntity getCouponSampleThirdParty(Long id) {
        CouponSampleThirdPartyEntity couponSampleThirdPartyEntity = this.couponSampleThirdPartyEntityMapper.selectByPrimaryKey(id);
        return couponSampleThirdPartyEntity;
    }

    @Override
    public CouponSampleThirdPartyEntity getCouponSampleThirdPartyDetails(Long id) {
        CouponSampleThirdPartyEntity couponSampleThirdPartyEntity = this.couponSampleThirdPartyEntityMapper.selectByPrimaryKey(id);
        List<CouponCodeThirdPartyEntity> couponCodes = this.couponCodeThirdPartyEntityMapper.getCodeByCstpId(id);
        if (CollectionUtils.isNotEmpty(couponCodes)) {
            ArrayList codes = Lists.newArrayList();
            for (CouponCodeThirdPartyEntity couponCode : couponCodes) {
                codes.add(couponCode.getCode());
            }
            couponSampleThirdPartyEntity.setCodes(codes);
        }
        return couponSampleThirdPartyEntity;
    }

    @Override
    @Transactional
    public Boolean updateCouponSampleThirdParty(CouponSampleThirdPartyEntity domain) {
        int count = this.couponSampleThirdPartyEntityMapper.updateByPrimaryKeySelective(domain);
        return count > 0;
    }
}

