package com.thebeastshop.pegasus.component.coupon.service.impl;

import com.thebeastshop.pegasus.component.coupon.condition.CouponThirdPartyCondition;
import com.thebeastshop.pegasus.component.coupon.dao.mapper.CouponCodeThirdPartyEntityMapper;
import com.thebeastshop.pegasus.component.coupon.dao.mapper.CouponSampleThirdPartyEntityMapper;
import com.thebeastshop.pegasus.component.coupon.dao.mapper.CouponThirdPartyEntityMapper;
import com.thebeastshop.pegasus.component.coupon.model.CouponCodeThirdPartyEntity;
import com.thebeastshop.pegasus.component.coupon.model.CouponSampleThirdPartyEntity;
import com.thebeastshop.pegasus.component.coupon.model.CouponThirdPartyEntity;
import com.thebeastshop.pegasus.component.coupon.model.CouponThirdPartyEntityExample;
import com.thebeastshop.pegasus.component.coupon.service.BaseService;
import com.thebeastshop.pegasus.component.coupon.service.CouponCodeThirdPartyService;
import com.thebeastshop.pegasus.component.coupon.service.CouponSampleThirdPartyService;
import com.thebeastshop.pegasus.component.coupon.service.CouponThirdPartyService;
import com.thebeastshop.support.exception.WrongArgException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Random;

/**
 * 
 * @author Paul-xiong
 *
 */
@Service
public class CouponThirdPartyServiceImpl extends BaseService implements CouponThirdPartyService {

	@Autowired
	private CouponSampleThirdPartyService couponSampleThirdPartyService;

	@Autowired
	private CouponThirdPartyEntityMapper couponThirdPartyEntityMapper;

	@Autowired
	private CouponCodeThirdPartyService couponCodeThirdPartyService;

	@Autowired
	private CouponCodeThirdPartyEntityMapper couponCodeThirdPartyEntityMapper;

	@Autowired
	private CouponSampleThirdPartyEntityMapper couponSampleThirdPartyEntityMapper;

	@Transactional
	@Override
	public Boolean exchange(Long cstpId, Long memberId) {
		List<CouponCodeThirdPartyEntity> CouponCodeThirdPartyList =  couponCodeThirdPartyService.getValidByCstpId(cstpId);

		if(!CollectionUtils.isNotEmpty(CouponCodeThirdPartyList)){
			throw new WrongArgException("第三方券已经发完或者已过期", "cstpId", cstpId);
		}
		int index = Math.abs(new Random().nextInt(CouponCodeThirdPartyList.size()));
		CouponCodeThirdPartyEntity couponCodeThirdParty = CouponCodeThirdPartyList.get(index);
		String code = couponCodeThirdParty.getCode();

		if (StringUtils.isBlank(code)) {
			throw new WrongArgException("兑换码不能为空", "code", code);
		}
		// 校验优惠券口令是否有效
//		CouponCodeThirdPartyEntity couponCodeThirdParty = couponCodeThirdPartyService.getValidByCode(code, cstpId);
//		if (couponCodeThirdParty == null) {
//			throw new WrongArgException("兑换码不存在或者已过期", "code", code);
//		}

		CouponThirdPartyEntity couponThirdParty = getCoupon(code);
		if(couponThirdParty != null){
			throw new WrongArgException("兑换码已经被兑换过", "code", code);
		}

		CouponSampleThirdPartyEntity couponSampleThirdParty = this.couponSampleThirdPartyService.getCouponSampleThirdParty(couponCodeThirdParty.getCstpId());

		// 校验优惠券是否超过用户限领数量
		List<CouponThirdPartyEntity> couponThirdPartyEntitys = getCouponsByCstpId(cstpId, memberId);
		if (CollectionUtils.isNotEmpty(couponThirdPartyEntitys) && couponThirdPartyEntitys.size() >= couponSampleThirdParty.getMaxPerMember()) {
			throw new WrongArgException("优惠券超过限领数量", "code", code);
		}
		// 发送优惠券
		Boolean couponflag = send(couponSampleThirdParty, memberId, code);
		if(couponflag) {
			couponCodeThirdParty.setStatus(0);
			couponCodeThirdPartyEntityMapper.updateByPrimaryKeySelective(couponCodeThirdParty);
		}
		return couponflag;
	}

	@Override
	public List<CouponSampleThirdPartyEntity> getCoupons(Long memberId, Integer status) {
		List<CouponSampleThirdPartyEntity> couponSampleThirdPartyList = new ArrayList<>();
		if(status == 1){
			couponSampleThirdPartyList = couponSampleThirdPartyEntityMapper.selectUnUsedCouponCodeByMemberId(memberId);
		}else if(status == 2){
			couponSampleThirdPartyList = couponSampleThirdPartyEntityMapper.selectUsedCouponCodeByMemberId(memberId);
		}else if(status == 3){
			couponSampleThirdPartyList = couponSampleThirdPartyEntityMapper.selectExpiredCouponCodeByMemberId(memberId);
		}

		return couponSampleThirdPartyList;
	}

	@Transactional
	public Boolean send(CouponSampleThirdPartyEntity couponSampleThirdParty, Long memberId,String code) {
		if (couponSampleThirdParty == null) {
			throw new WrongArgException("发送第三方优惠券失败", "couponSampleThirdParty", couponSampleThirdParty);
		}
		// 检查剩余数量
		if (couponSampleThirdParty.getBalanceCount() <= 0) {
			throw new WrongArgException("第三方优惠券已发完");
		}
		// 检查每人最多获得的上限限制
//		Integer perMemberCount = this.getCouponsCount(memberId, couponSample.getId());
//		if (perMemberCount >= couponSample.getMaxPerMember()) {
//			throw new WrongStateException("获得" + couponSample.getName() + "的优惠券已达到上限。",
//					"member{id=" + memberId + "}.coupons{couponSampleId=" + couponSample.getId() + "}.size",
//					couponSample.getMaxPerMember());
//		}
		// 优惠券剩余数量减一
		couponSampleThirdParty.setBalanceCount(couponSampleThirdParty.getBalanceCount() - 1);
		boolean ret = this.couponSampleThirdPartyService.updateCouponSampleThirdParty(couponSampleThirdParty, null);
		if (!ret) {
			throw new WrongArgException("第三方优惠券已发完");
		}
		// 创建优惠券
		CouponThirdPartyEntity couponThirdPartyEntity = new CouponThirdPartyEntity();
		couponThirdPartyEntity.setCstpId(couponSampleThirdParty.getId());
		couponThirdPartyEntity.setStartTime(couponSampleThirdParty.getStartTime());
		couponThirdPartyEntity.setExpireTime(couponSampleThirdParty.getExpireTime());
		couponThirdPartyEntity.setNote(couponSampleThirdParty.getNote());
		couponThirdPartyEntity.setMemberId(memberId);
		couponThirdPartyEntity.setCode(code);
		couponThirdPartyEntity.setIsUsed(0);
		couponThirdPartyEntity.setIsValid(1);
		couponThirdPartyEntity.setActive(true);
		couponThirdPartyEntity.setCreateTime(new Date());
		couponThirdPartyEntity.setUpdateTime(new Date());
		couponThirdPartyEntity.setCreateUserId(couponSampleThirdParty.getCreateUserId());
		int count = couponThirdPartyEntityMapper.insertSelective(couponThirdPartyEntity);
		return count > 0 ? true : false;
	}

	public CouponThirdPartyEntity getCoupon(String code) {
		return couponThirdPartyEntityMapper.getCoupon(code);
	}

	public List<CouponThirdPartyEntity> getCouponsByCstpId(Long cstpId,Long memberId) {
		return couponThirdPartyEntityMapper.getCoupons(cstpId, memberId);
	}

	public List<CouponThirdPartyEntity> getThirdPartyCouponsByCond(CouponThirdPartyCondition cond) {
		return couponThirdPartyEntityMapper.getThirdPartyCouponsByCond(cond);
	}
}
