package com.thebeastshop.pegasus.component.coupon.enums;

import com.thebeastshop.support.mark.HasIdGetter.HasIntIdGetter;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 * 优惠券发放方式
 *
 * @author Liang Wenjian
 */
public enum CouponSendWay implements HasIntIdGetter {
	/**
	 * 直接发放给会员
	 */
	DISTRIBUTE(1, "系统派发/用户页面领取"),
	/**
	 * 生成优惠码，谁领都可以
	 */
	CODE(2, "优惠口令"),
	/**
	 * 会员自提。
	 */
	GET(3, "后台人工派发");

	public final int id;

	public final String name;

	public static final List<CouponSendWay> ALL = Collections.unmodifiableList(Arrays.asList(values()));

	CouponSendWay(int id, String name) {
		this.id = id;
		this.name = name;
	}

	@Override
	public Integer getId() {
		return id;
	}

	public String getName() {
		return name;
	}

	public static CouponSendWay valueOf(int id) {
		CouponSendWay value = DISTRIBUTE;
		if (id == DISTRIBUTE.id) {
			value = DISTRIBUTE;
		} else if (id == CODE.id) {
			value = CODE;
		} else if (id == GET.id) {
			value = GET;
		}
		return value;
	}
}
