package com.thebeastshop.pegasus.component.coupon.enums;

import com.thebeastshop.support.mark.HasIdGetter.HasIntIdGetter;
import com.thebeastshop.support.mark.HasName;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 * 审批级别
 *
 * Created by hafiz.zhang on 2016/7/6.
 */
public enum CouponApprovalLevel  implements HasIntIdGetter, HasName {

    FIRST_LEVEL(1, "第一级审批"),
    SECOND_LEVEL(2, "第二级审批");

    private final Integer id;
    private final String name;
    public static final List<CouponApprovalLevel> ALL = Collections.unmodifiableList(Arrays.asList(values()));

    private CouponApprovalLevel(Integer id, String name) {
        this.id = id;
        this.name = name;
    }

    @Override
    public Integer getId() {
        return id;
    }

    @Override
    public String getName() {
        return name;
    }
}
