package com.thebeastshop.pegasus.component.coupon.dao.impl;

import java.util.Date;
import java.util.List;

import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import com.google.common.collect.Lists;
import com.thebeastshop.pegasus.component.coupon.condition.CouponCodeExchangeCondition;
import com.thebeastshop.pegasus.component.coupon.dao.CouponCodeExchangeDao;
import com.thebeastshop.pegasus.component.coupon.dao.mapper.CouponCodeExchangeEntityMapper;
import com.thebeastshop.pegasus.component.coupon.domain.CouponCodeExchange;
import com.thebeastshop.pegasus.component.coupon.model.CouponCodeExchangeEntity;
import com.thebeastshop.pegasus.component.coupon.model.CouponCodeExchangeEntityExample;

/**
 * 
 * @author Paul-xiong
 *
 */
@Repository
public class CouponCodeExchangeDaoImpl implements CouponCodeExchangeDao {
	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private CouponCodeExchangeEntityMapper mapper;

	/**
	 * CouponCodeExchange to CouponCodeExchangeEntity
	 * 
	 * @param exchange
	 *            CouponCodeExchange对象
	 * @return
	 */
	private CouponCodeExchangeEntity domain2Entity(CouponCodeExchange exchange) {
		CouponCodeExchangeEntity entity = new CouponCodeExchangeEntity();
		entity.setCode(exchange.getCode());
		entity.setCouponId(exchange.getCouponId());
		entity.setCouponSampleId(exchange.getCouponSampleId());
		entity.setCreateTime(exchange.getCreateTime());
		entity.setId(exchange.getId());
		entity.setOwnerId(exchange.getOwnerId());
		return entity;
	}

	/**
	 * CouponCodeExchangeEntity to CouponCodeExchange
	 * 
	 * @param entity
	 *            CouponCodeExchangeEntity对象
	 * @return
	 */
	private CouponCodeExchange entity2Domain(CouponCodeExchangeEntity entity) {
		CouponCodeExchange exchange = new CouponCodeExchange();
		exchange.setCode(entity.getCode());
		exchange.setCouponId(entity.getCouponId());
		exchange.setCouponSampleId(entity.getCouponSampleId());
		exchange.setCreateTime(entity.getCreateTime());
		exchange.setId(entity.getId());
		exchange.setOwnerId(entity.getOwnerId());
		return exchange;
	}

	private List<CouponCodeExchange> entity2Domain(List<CouponCodeExchangeEntity> entities) {
		List<CouponCodeExchange> domains = Lists.newArrayList();
		for (CouponCodeExchangeEntity entity : entities) {
			domains.add(entity2Domain(entity));
		}
		return domains;
	}

	@Override
	public List<CouponCodeExchange> getByCondition(CouponCodeExchangeCondition condition) {
		CouponCodeExchangeEntityExample example = new CouponCodeExchangeEntityExample();
		condition.fillCriteria(example.createCriteria());
		List<CouponCodeExchangeEntity> entityList = this.mapper.selectByExample(example);
		return entity2Domain(entityList);
	}

	@Override
	public Boolean isUsedCodeByMemberId(CouponCodeExchangeCondition condition) {
		CouponCodeExchangeEntityExample example = new CouponCodeExchangeEntityExample();
		example.createCriteria().andCodeEqualTo(condition.getCode()).andCouponSampleIdEqualTo(condition.getCouponSampleId());
		List<CouponCodeExchangeEntity> entityList = this.mapper.selectByExample(example);
		if(CollectionUtils.isNotEmpty(entityList)){
			return true;
		}else{
			return false;
		}
	}

	@Override
	public CouponCodeExchange create(CouponCodeExchange exchange) {
		logger.info("Creating CouponCodeExchange: {}", exchange);

		CouponCodeExchangeEntity entity = this.domain2Entity(exchange);
		if (entity != null) {
			entity.setCreateTime(new Date());
			int count = this.mapper.insertSelective(entity);

			if (count > 0) {
				exchange = this.entity2Domain(entity);
				logger.info("Created CouponCodeExchange: {}", exchange);
				return exchange;
			}
		}

		return null;
	}

}
