package com.thebeastshop.pegasus.component.coupon.enums;

import com.thebeastshop.support.mark.HasIdGetter;
import com.thebeastshop.support.mark.HasName;
import com.thebeastshop.support.mark.State;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**  
 * @Author: LK【kai.li@thebeastshop.com】
 * @Date: 2017/6/23 16:50
 */
public enum CouponSampleSkipType implements HasIdGetter.HasIntIdGetter, HasName {
    WAIT_FOR_APPROVE(1, "默认列表"),
    APPROVING(2, "内容页ID"),
    APPROVE_NOT_PASS(3, "活动页Link");

    final Integer id;
    final String name;

    public static final List<CouponSampleSkipType> ALL = Collections.unmodifiableList(Arrays.asList(values()));


    CouponSampleSkipType(final Integer id, final String name) {
        this.id = id;
        this.name = name;
    }

    public static CouponSampleSkipType getEnumByCode(Integer code) {
        for (CouponSampleSkipType e : CouponSampleSkipType.values()) {
            if (e.getId().equals(code)) {
                return e;
            }
        }
        return null;
    }

    @Override
    public Integer getId() {
        return id;
    }

    @Override
    public String getName() {
        return name;
    }
}
