/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.component.coupon.service.impl;

import com.thebeastshop.pegasus.component.coupon.dao.CouponSampleDao;
import com.thebeastshop.pegasus.component.coupon.domain.ApprovalRecord;
import com.thebeastshop.pegasus.component.coupon.enums.ApprovalType;
import com.thebeastshop.pegasus.component.coupon.service.ApprovalRecordService;
import com.thebeastshop.pegasus.component.coupon.service.BaseService;
import com.thebeastshop.pegasus.component.coupon.service.CouponApprovalService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CouponApprovalServiceImpl
extends BaseService
implements CouponApprovalService {
    @Autowired
    private ApprovalRecordService approvalRecordService;
    @Autowired
    private CouponSampleDao couponSampleDao;

    @Override
    public ApprovalRecord create(ApprovalRecord domain) {
        return this.approvalRecordService.create(domain);
    }

    @Override
    public List<ApprovalRecord> getApprovalByPendingId(Long pendingId) {
        return this.approvalRecordService.listApprovalRecordByPendingId(pendingId, ApprovalType.COUPON.getId());
    }

    @Override
    @Transactional
    public Boolean agreePendingCouponSample(ApprovalRecord domain) {
        Integer result = 0;
        Integer level = 0;
        if (null != domain.getCouponApprovalLevel()) {
            level = domain.getCouponApprovalLevel().getId();
        }
        Long pendingId = domain.getPendingId();
        if (1 == level) {
            result = this.couponSampleDao.changeCouponSampleState(pendingId, 2);
        } else if (2 == level) {
            result = this.couponSampleDao.changeCouponSampleState(pendingId, 4);
        }
        if (result > 0) {
            ApprovalRecord newCouponApproval = this.approvalRecordService.create(domain);
            if (null == newCouponApproval || null == newCouponApproval.getId()) {
                this.logger.info("\u63d2\u5165\u4f18\u60e0\u5238\u5ba1\u6279\u8bb0\u5f55\u5931\u8d25");
                return false;
            }
            return true;
        }
        this.logger.info("\u4fee\u6539\u5ba1\u6279\u7b49\u7ea7\u4e3a\uff1a" + level + "\u7684\u4f18\u60e0\u5238\u6a21\u677f\u72b6\u6001\u5931\u8d25");
        return false;
    }

    @Override
    @Transactional
    public Boolean rejectPendingCouponSample(ApprovalRecord domain) {
        Long pendingId;
        Integer level = 0;
        if (null != domain.getCouponApprovalLevel()) {
            level = domain.getCouponApprovalLevel().getId();
        }
        if (this.couponSampleDao.changeCouponSampleState(pendingId = domain.getPendingId(), 3) > 0) {
            ApprovalRecord newCouponApproval = this.approvalRecordService.create(domain);
            if (null == newCouponApproval || null == newCouponApproval.getId()) {
                this.logger.info("\u63d2\u5165\u4f18\u60e0\u5238\u5ba1\u6279\u8bb0\u5f55\u5931\u8d25");
                return false;
            }
            return true;
        }
        this.logger.info("\u4fee\u6539\u5ba1\u6279\u7b49\u7ea7\u4e3a\uff1a" + level + "\u7684\u4f18\u60e0\u5238\u6a21\u677f\u72b6\u6001\u4e3a[\u5ba1\u6279\u4e0d\u901a\u8fc7]\u5931\u8d25");
        return false;
    }
}

