/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.component.coupon.service.impl;

import com.thebeastshop.pegasus.component.coupon.condition.CouponCodeExchangeCondition;
import com.thebeastshop.pegasus.component.coupon.dao.CouponCodeExchangeDao;
import com.thebeastshop.pegasus.component.coupon.domain.Coupon;
import com.thebeastshop.pegasus.component.coupon.domain.CouponCode;
import com.thebeastshop.pegasus.component.coupon.domain.CouponCodeExchange;
import com.thebeastshop.pegasus.component.coupon.domain.CouponSample;
import com.thebeastshop.pegasus.component.coupon.enums.CouponSampleState;
import com.thebeastshop.pegasus.component.coupon.service.BaseService;
import com.thebeastshop.pegasus.component.coupon.service.CouponCodeExchangeService;
import com.thebeastshop.pegasus.component.coupon.service.CouponCodeService;
import com.thebeastshop.pegasus.component.coupon.service.CouponSampleService;
import com.thebeastshop.pegasus.component.coupon.service.CouponService;
import com.thebeastshop.support.exception.WrongArgException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CouponCodeExchangeServiceImpl
extends BaseService
implements CouponCodeExchangeService {
    @Autowired
    private CouponSampleService couponSampleService;
    @Autowired
    private CouponService couponService;
    @Autowired
    private CouponCodeService couponCodeService;
    @Autowired
    private CouponCodeExchangeDao dao;

    @Override
    @Transactional
    public CouponCodeExchange exchange(CouponCodeExchange exchange) {
        String code = exchange.getCode();
        if (StringUtils.isBlank((String)code)) {
            throw new WrongArgException("\u5151\u6362\u7801\u4e0d\u80fd\u4e3a\u7a7a", "code", (Object)code);
        }
        CouponCode couponCode = this.couponCodeService.getValidByCode(code);
        if (couponCode == null) {
            throw new WrongArgException("\u5151\u6362\u7801\u4e0d\u5b58\u5728", "code", (Object)code);
        }
        CouponSample couponSample = this.couponSampleService.getById(couponCode.getCouponSampleId());
        if (!(couponSample.getDateWay() != null && couponSample.getDateWay() == 2 || CouponSampleState.ONLINE.equals(couponSample.getState()) && !couponSample.isExpired())) {
            throw new WrongArgException("\u5151\u6362\u7801\u5df2\u8fc7\u671f", "state", (Object)couponSample.getState());
        }
        CouponCodeExchangeCondition condition = new CouponCodeExchangeCondition();
        condition.setOwnerId(exchange.getOwnerId());
        condition.setCouponSampleId(couponCode.getCouponSampleId());
        List<CouponCodeExchange> exchanges = this.getByCondition(condition);
        if (exchanges.size() >= couponSample.getMaxPerMember()) {
            throw new WrongArgException("\u4f18\u60e0\u5238\u8d85\u8fc7\u9650\u9886\u6570\u91cf", "code", (Object)code);
        }
        if (couponSample.getNote() != null && "1".equals(couponSample.getNote())) {
            CouponCodeExchangeCondition condition2 = new CouponCodeExchangeCondition();
            condition2.setCode(code);
            condition2.setCouponSampleId(couponCode.getCouponSampleId());
            Boolean flag = this.dao.isUsedCodeByMemberId(condition2);
            if (flag.booleanValue()) {
                throw new WrongArgException("\u8be5\u5151\u6362\u7801\u53ea\u80fd\u7528\u4e00\u6b21", "code", (Object)code);
            }
        }
        Coupon coupon = this.couponService.send(couponSample, exchange.getOwnerId());
        CouponCodeExchange createObj = new CouponCodeExchange();
        createObj.setCode(code);
        createObj.setCouponId(coupon.getId());
        createObj.setCouponSampleId(couponSample.getId());
        createObj.setOwnerId(exchange.getOwnerId());
        return this.create(createObj);
    }

    @Override
    public List<CouponCodeExchange> getByCondition(CouponCodeExchangeCondition condition) {
        return this.dao.getByCondition(condition);
    }

    @Override
    public CouponCodeExchange create(CouponCodeExchange exchange) {
        return this.dao.create(exchange);
    }
}

