/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.component.coupon.service.impl;

import com.thebeastshop.pegasus.component.coupon.condition.CouponThirdPartyCondition;
import com.thebeastshop.pegasus.component.coupon.dao.mapper.CouponCodeThirdPartyEntityMapper;
import com.thebeastshop.pegasus.component.coupon.dao.mapper.CouponSampleThirdPartyEntityMapper;
import com.thebeastshop.pegasus.component.coupon.dao.mapper.CouponThirdPartyEntityMapper;
import com.thebeastshop.pegasus.component.coupon.model.CouponCodeThirdPartyEntity;
import com.thebeastshop.pegasus.component.coupon.model.CouponSampleThirdPartyEntity;
import com.thebeastshop.pegasus.component.coupon.model.CouponThirdPartyEntity;
import com.thebeastshop.pegasus.component.coupon.service.BaseService;
import com.thebeastshop.pegasus.component.coupon.service.CouponCodeThirdPartyService;
import com.thebeastshop.pegasus.component.coupon.service.CouponSampleThirdPartyService;
import com.thebeastshop.pegasus.component.coupon.service.CouponThirdPartyService;
import com.thebeastshop.support.exception.WrongArgException;
import com.thebeastshop.support.vo.NameValuePair;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Random;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CouponThirdPartyServiceImpl
extends BaseService
implements CouponThirdPartyService {
    @Autowired
    private CouponSampleThirdPartyService couponSampleThirdPartyService;
    @Autowired
    private CouponThirdPartyEntityMapper couponThirdPartyEntityMapper;
    @Autowired
    private CouponCodeThirdPartyService couponCodeThirdPartyService;
    @Autowired
    private CouponCodeThirdPartyEntityMapper couponCodeThirdPartyEntityMapper;
    @Autowired
    private CouponSampleThirdPartyEntityMapper couponSampleThirdPartyEntityMapper;

    @Override
    @Transactional
    public Boolean exchange(Long cstpId, Long memberId) {
        List<CouponCodeThirdPartyEntity> CouponCodeThirdPartyList = this.couponCodeThirdPartyService.getValidByCstpId(cstpId);
        if (!CollectionUtils.isNotEmpty(CouponCodeThirdPartyList)) {
            throw new WrongArgException("\u7b2c\u4e09\u65b9\u5238\u5df2\u7ecf\u53d1\u5b8c\u6216\u8005\u5df2\u8fc7\u671f", "cstpId", (Object)cstpId);
        }
        int index = Math.abs(new Random().nextInt(CouponCodeThirdPartyList.size()));
        CouponCodeThirdPartyEntity couponCodeThirdParty = CouponCodeThirdPartyList.get(index);
        String code = couponCodeThirdParty.getCode();
        if (StringUtils.isBlank((String)code)) {
            throw new WrongArgException("\u5151\u6362\u7801\u4e0d\u80fd\u4e3a\u7a7a", "code", (Object)code);
        }
        CouponThirdPartyEntity couponThirdParty = this.getCoupon(code);
        if (couponThirdParty != null) {
            throw new WrongArgException("\u5151\u6362\u7801\u5df2\u7ecf\u88ab\u5151\u6362\u8fc7", "code", (Object)code);
        }
        CouponSampleThirdPartyEntity couponSampleThirdParty = this.couponSampleThirdPartyService.getCouponSampleThirdParty(couponCodeThirdParty.getCstpId());
        List<CouponThirdPartyEntity> couponThirdPartyEntitys = this.getCouponsByCstpId(cstpId, memberId);
        if (CollectionUtils.isNotEmpty(couponThirdPartyEntitys) && couponThirdPartyEntitys.size() >= couponSampleThirdParty.getMaxPerMember()) {
            throw new WrongArgException("\u4f18\u60e0\u5238\u8d85\u8fc7\u9650\u9886\u6570\u91cf", "code", (Object)code);
        }
        Boolean couponflag = this.send(couponSampleThirdParty, memberId, code);
        if (couponflag.booleanValue()) {
            couponCodeThirdParty.setStatus(0);
            this.couponCodeThirdPartyEntityMapper.updateByPrimaryKeySelective(couponCodeThirdParty);
        }
        return couponflag;
    }

    @Override
    public List<CouponSampleThirdPartyEntity> getCoupons(Long memberId, Integer status) {
        List<Object> couponSampleThirdPartyList = new ArrayList();
        if (status == 1) {
            couponSampleThirdPartyList = this.couponSampleThirdPartyEntityMapper.selectUnUsedCouponCodeByMemberId(memberId);
        } else if (status == 2) {
            couponSampleThirdPartyList = this.couponSampleThirdPartyEntityMapper.selectUsedCouponCodeByMemberId(memberId);
        } else if (status == 3) {
            couponSampleThirdPartyList = this.couponSampleThirdPartyEntityMapper.selectExpiredCouponCodeByMemberId(memberId);
        }
        return couponSampleThirdPartyList;
    }

    @Transactional
    public Boolean send(CouponSampleThirdPartyEntity couponSampleThirdParty, Long memberId, String code) {
        if (couponSampleThirdParty == null) {
            throw new WrongArgException("\u53d1\u9001\u7b2c\u4e09\u65b9\u4f18\u60e0\u5238\u5931\u8d25", "couponSampleThirdParty", (Object)couponSampleThirdParty);
        }
        if (couponSampleThirdParty.getBalanceCount() <= 0) {
            throw new WrongArgException("\u7b2c\u4e09\u65b9\u4f18\u60e0\u5238\u5df2\u53d1\u5b8c", new NameValuePair[0]);
        }
        couponSampleThirdParty.setBalanceCount(couponSampleThirdParty.getBalanceCount() - 1);
        boolean ret = this.couponSampleThirdPartyService.updateCouponSampleThirdParty(couponSampleThirdParty, null);
        if (!ret) {
            throw new WrongArgException("\u7b2c\u4e09\u65b9\u4f18\u60e0\u5238\u5df2\u53d1\u5b8c", new NameValuePair[0]);
        }
        CouponThirdPartyEntity couponThirdPartyEntity = new CouponThirdPartyEntity();
        couponThirdPartyEntity.setCstpId(couponSampleThirdParty.getId());
        couponThirdPartyEntity.setStartTime(couponSampleThirdParty.getStartTime());
        couponThirdPartyEntity.setExpireTime(couponSampleThirdParty.getExpireTime());
        couponThirdPartyEntity.setNote(couponSampleThirdParty.getNote());
        couponThirdPartyEntity.setMemberId(memberId);
        couponThirdPartyEntity.setCode(code);
        couponThirdPartyEntity.setIsUsed(0);
        couponThirdPartyEntity.setIsValid(1);
        couponThirdPartyEntity.setActive(true);
        couponThirdPartyEntity.setCreateTime(new Date());
        couponThirdPartyEntity.setUpdateTime(new Date());
        couponThirdPartyEntity.setCreateUserId(couponSampleThirdParty.getCreateUserId());
        int count = this.couponThirdPartyEntityMapper.insertSelective(couponThirdPartyEntity);
        return count > 0;
    }

    public CouponThirdPartyEntity getCoupon(String code) {
        return this.couponThirdPartyEntityMapper.getCoupon(code);
    }

    @Override
    public List<CouponThirdPartyEntity> getCouponsByCstpId(Long cstpId, Long memberId) {
        return this.couponThirdPartyEntityMapper.getCoupons(cstpId, memberId);
    }

    @Override
    public List<CouponThirdPartyEntity> getThirdPartyCouponsByCond(CouponThirdPartyCondition cond) {
        return this.couponThirdPartyEntityMapper.getThirdPartyCouponsByCond(cond);
    }
}

