package com.thebeastshop.pegasus.component.coupon.service;

import com.thebeastshop.pegasus.component.coupon.condition.CouponThirdPartyCondition;
import com.thebeastshop.pegasus.component.coupon.model.CouponSampleThirdPartyEntity;
import com.thebeastshop.pegasus.component.coupon.model.CouponThirdPartyEntity;

import java.util.List;

/**  
 * @Author: LK【kai.li@thebeastshop.com】
 * @Date: 2017/3/17 14:25 
 */
public interface CouponThirdPartyService {

	/**
	 * 提交优惠码兑换第三方券
	 * @param cstpId
	 * @param memberId
	 * @return
	 */
	Boolean exchange(Long cstpId,Long memberId);

	/**
	 * 获取可用的优惠券列表
	 *
	 * @param memberId
	 * @param status(1:未使用;2:已使用;3:已过期)
	 * @return
	 */
	List<CouponSampleThirdPartyEntity> getCoupons(Long memberId,Integer status);

	/**
	 * 根据第三方模板获取优惠券领取列表
	 *
	 * @param cond
	 * @return
	 */
	List<CouponThirdPartyEntity> getThirdPartyCouponsByCond(CouponThirdPartyCondition cond);

	List<CouponThirdPartyEntity> getCouponsByCstpId(Long cstpId,Long memberId);

}
